/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.List;
import org.cyclos.entities.system.CustomBackgroundTask;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.QCustomBackgroundTask;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.CustomBackgroundTaskServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.system.scheduledtasks.CustomBackgroundTaskDTO;
import org.cyclos.model.system.scheduledtasks.CustomBackgroundTaskData;
import org.cyclos.model.system.scheduledtasks.CustomBackgroundTaskVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomBackgroundTaskServiceImpl
extends CRUDServiceImpl<CustomBackgroundTask, QCustomBackgroundTask, CustomBackgroundTaskDTO, CustomBackgroundTaskData, Void>
implements CustomBackgroundTaskServiceLocal {
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public CustomBackgroundTaskServiceImpl() {
        super(CustomBackgroundTask.class, QCustomBackgroundTask.customBackgroundTask, CustomBackgroundTaskDTO.class);
    }

    public List<CustomBackgroundTaskVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(CustomBackgroundTaskVO.class, this.listAll());
    }

    public List<CustomBackgroundTask> listAll() {
        return ((DBQuery)this.selectFrom(this.$).orderBy(((QCustomBackgroundTask)this.$).name.asc())).fetch();
    }

    @Override
    public CustomBackgroundTask newEntity(Void void_) {
        CustomBackgroundTask customBackgroundTask = new CustomBackgroundTask();
        customBackgroundTask.setVerboseLog(true);
        customBackgroundTask.setPriority(BackgroundTaskPriority.NORMAL);
        return customBackgroundTask;
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, CustomBackgroundTaskDTO customBackgroundTaskDTO) {
        property.required();
    }

    @Override
    protected CustomBackgroundTaskData getData(CustomBackgroundTask customBackgroundTask) {
        CustomBackgroundTaskData customBackgroundTaskData = new CustomBackgroundTaskData();
        customBackgroundTaskData.setDto((EntityDTO)((CustomBackgroundTaskDTO)this.toDTO(customBackgroundTask)));
        customBackgroundTaskData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.BACKGROUND_TASK)));
        return customBackgroundTaskData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomBackgroundTask)this.$).network());
    }

    @Override
    protected Validator resolveValidator(CustomBackgroundTaskDTO customBackgroundTaskDTO) {
        Validator validator = new Validator();
        validator.property((Property)CustomBackgroundTaskDTO.SCRIPT, SystemKeys.ScheduledTasks.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.BACKGROUND_TASK;
            }
        });
        return validator;
    }
}

