/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.ConfigurationImage;
import org.cyclos.entities.system.QConfigurationImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.BaseImageServiceImpl;
import org.cyclos.impl.system.ConfigurationImageCacheKey;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.utils.InputOutputProcessingHandler;
import org.cyclos.impl.utils.RichTextHandlerImpl;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.MapAccessorCacheValue;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.images.ConfigurationImagesListData;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.NewConfigurationImageParams;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationImageServiceImpl
extends BaseImageServiceImpl<ConfigurationImage, QConfigurationImage, NewConfigurationImageParams>
implements ConfigurationImageServiceLocal {
    private static final String IMAGE_VO_CACHE_KEY = "vo";
    private static final String CONTENT_CACHE_KEY = "content";
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    private Map<ConfigurationImageType, DefaultConfigurationImage> defaultImages = new WeakHashMap<ConfigurationImageType, DefaultConfigurationImage>();
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private InputOutputProcessingHandler inputOutputProcessingHandler;

    public ConfigurationImageServiceImpl() {
        super(ImageNature.CONFIGURATION, ConfigurationImage.class, QConfigurationImage.configurationImage);
    }

    @Override
    public ConfigurationImage find(Long l) {
        return (ConfigurationImage)this.rawEntityManagerHandler.find(ConfigurationImage.class, l);
    }

    public String getCurrentUrl(Configuration configuration, ConfigurationImageType configurationImageType) {
        SessionData sessionData = this.getSessionData();
        if (configuration == null) {
            configuration = sessionData.getConfiguration().getConfiguration();
        }
        ConfigurationImageVO configurationImageVO = this.getImageVO(new ConfigurationVO(configuration.getId()), configurationImageType);
        Long l = this.applicationHandler.getIdMask().apply(configuration.getId());
        String string = configurationImageVO.getLastModifiedInMillis();
        if (string == null) {
            string = this.initializationService.getResourceCacheKey();
        }
        return StringHelper.removeEnd((String)sessionData.getRequestData().getBaseUrl(), (String)"/") + RichTextHandlerImpl.URLTag.CURRENT_CONFIGURATION.path() + configurationImageType.name() + "?mod=" + string + (String)(l == null ? "" : "&configurationId=" + l);
    }

    public ConfigurationImageVO getImageVO(ConfigurationVO configurationVO, @NotNull ConfigurationImageType configurationImageType) throws FrameworkException {
        Configuration configuration = configurationVO == null ? null : (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        Map<String, Object> map = this.readCache(configuration, configurationImageType);
        return (ConfigurationImageVO)map.get(IMAGE_VO_CACHE_KEY);
    }

    public ConfigurationImagesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        ConfigurationImagesListData configurationImagesListData = new ConfigurationImagesListData();
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        configurationImagesListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        configurationImagesListData.setImages(this.list(configurationVO));
        return configurationImagesListData;
    }

    public String getUrl(Configuration configuration, ConfigurationImageType configurationImageType) {
        SessionData sessionData = this.getSessionData();
        if (configuration == null) {
            configuration = sessionData.getConfiguration().getConfiguration();
        }
        ConfigurationImageVO configurationImageVO = this.getImageVO(new ConfigurationVO(configuration.getId()), configurationImageType);
        configurationImageVO = (ConfigurationImageVO)this.inputOutputProcessingHandler.processToClient((Object)configurationImageVO, false).getFirst();
        return ServerImageHelper.getConfigurationImageUrl((RequestData)sessionData.getRequestData(), (ConfigurationImageVO)configurationImageVO, (String)this.initializationService.getResourceCacheKey());
    }

    public List<ConfigurationImageVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        ArrayList<ConfigurationImageVO> arrayList = new ArrayList<ConfigurationImageVO>();
        for (ConfigurationImageType configurationImageType : ConfigurationImageType.values()) {
            try {
                ConfigurationImageVO configurationImageVO = this.getImageVO(configurationVO, configurationImageType);
                arrayList.add(configurationImageVO);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public ConfigurationImageVO load(@NotNull Long l) throws FrameworkException {
        return (ConfigurationImageVO)this.conversionHandler.convert(ConfigurationImageVO.class, (Object)this.find(l));
    }

    @Override
    public ConfigurationImage newImage(NewConfigurationImageParams newConfigurationImageParams) {
        throw new UnsupportedOperationException("save() was overridden: this method is never invoked");
    }

    public SerializableInputStream readByConfigurationAndType(Long l, ConfigurationImageType configurationImageType) throws FrameworkException {
        Configuration configuration = l == null ? this.getConfiguration().getConfiguration() : (Configuration)this.rawEntityManagerHandler.find(Configuration.class, l);
        return this.getImageContent(configuration, configurationImageType);
    }

    public void removeByConfigurationAndType(ConfigurationVO configurationVO, ConfigurationImageType configurationImageType) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        ConfigurationImage configurationImage = this.findImage(configuration, configurationImageType, false);
        if (configurationImage == null) {
            throw new EntityNotFoundException();
        }
        configuration.getImages().remove(configurationImage);
        this.setImagesLastModified(configuration, new Date());
        this.cacheHandler.scheduleEvict(CacheType.CONFIGURATION_IMAGES, (Serializable)new ConfigurationImageCacheKey(configuration.getId(), configurationImageType));
        this.remove((IEntity)configurationImage);
    }

    public ConfigurationImageVO save(NewConfigurationImageParams newConfigurationImageParams, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        Configuration configuration = this.find(Configuration.class, newConfigurationImageParams.getConfigurationId());
        ConfigurationImageType configurationImageType = newConfigurationImageParams.getType();
        ConfigurationImage configurationImage = this.saveImageContent(configuration, configurationImageType, string, serializableInputStream, string2);
        return this.imageToVO(configuration, configurationImage);
    }

    public ConfigurationImage saveImageContent(Configuration configuration, ConfigurationImageType configurationImageType, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        boolean bl;
        ConfigurationImage configurationImage = this.findImage(configuration, configurationImageType, false);
        boolean bl2 = bl = configurationImage == null;
        if (configurationImage == null) {
            configurationImage = new ConfigurationImage();
            configurationImage.setConfiguration(configuration);
            configurationImage.setType(configurationImageType);
        }
        configurationImage.setName(string);
        this.setDataAndPersist(configurationImage, serializableInputStream, string2);
        if (bl) {
            configuration.getImages().add(configurationImage);
        }
        this.setImagesLastModified(configuration, new Date());
        this.cacheHandler.scheduleEvict(CacheType.CONFIGURATION_IMAGES, (Serializable)new ConfigurationImageCacheKey(configuration.getId(), configurationImageType));
        return configurationImage;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QConfigurationImage.configurationImage.configuration().network(), true);
    }

    private ConfigurationImage findImage(Configuration configuration, ConfigurationImageType configurationImageType, boolean bl) {
        ConfigurationImage configurationImage2;
        for (Configuration configuration2 = configuration; configuration2 != null; configuration2 = configuration2.getParent()) {
            for (ConfigurationImage configurationImage2 : configuration2.getImages()) {
                if (configurationImage2.getType() != configurationImageType) continue;
                return configurationImage2;
            }
            if (bl) continue;
            return null;
        }
        DefaultConfigurationImage defaultConfigurationImage = this.readDefaultImage(configurationImageType);
        configurationImage2 = new ConfigurationImage();
        configurationImage2.setType(configurationImageType);
        configurationImage2.setContentType(ServerImageHelper.ImageType.PNG.getContentType());
        configurationImage2.setDefaultImageContent(defaultConfigurationImage.bytes);
        configurationImage2.setLength(Integer.valueOf(defaultConfigurationImage.bytes.length));
        configurationImage2.setWidth(defaultConfigurationImage.bufferedImage.getWidth());
        configurationImage2.setHeight(defaultConfigurationImage.bufferedImage.getHeight());
        configurationImage2.setLastModified(new Date(defaultConfigurationImage.lastModified));
        return configurationImage2;
    }

    private SerializableInputStream getImageContent(Configuration configuration, ConfigurationImageType configurationImageType) throws FrameworkException {
        byte[] byArray = (byte[])this.readCache(configuration, configurationImageType).get(CONTENT_CACHE_KEY);
        return new SerializableInputStream(byArray);
    }

    private ConfigurationImageVO imageToVO(Configuration configuration, ConfigurationImage configurationImage) {
        Date date;
        ConfigurationImageVO configurationImageVO = (ConfigurationImageVO)this.conversionHandler.convert(ConfigurationImageVO.class, (Object)configurationImage);
        configurationImageVO.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        configurationImageVO.setDefiningConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configurationImage.getConfiguration()));
        Date date2 = date = configuration == null ? null : configuration.getImagesLastModified();
        if (date != null) {
            configurationImageVO.setLastModified(this.conversionHandler.toDateTime(date));
            configurationImageVO.setLastModifiedInMillis(String.valueOf(date.getTime()));
        }
        return configurationImageVO;
    }

    private Map<String, Object> readCache(Configuration configuration, ConfigurationImageType configurationImageType) {
        if (configuration == null) {
            configuration = this.getConfiguration().getConfiguration();
        }
        Configuration configuration2 = configuration;
        ConfigurationImageCacheKey configurationImageCacheKey = new ConfigurationImageCacheKey(configuration2.getId(), configurationImageType);
        MapAccessorCacheValue mapAccessorCacheValue = (MapAccessorCacheValue)this.cacheHandler.getCache(CacheType.CONFIGURATION_IMAGES).get((Serializable)configurationImageCacheKey, () -> {
            Future<Map> future = this.invokerHandler.getExecutorService().submit(() -> (Map)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY_TRANSACTION, transactionStatus -> {
                byte[] byArray;
                ConfigurationImage configurationImage = this.findImage(configuration2, configurationImageType, true);
                ConfigurationImageVO configurationImageVO = this.imageToVO(configuration2, configurationImage);
                if (configurationImage.isTransient()) {
                    byArray = configurationImage.getDefaultImageContent();
                } else {
                    SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)configurationImage);
                    try {
                        byArray = serializableInputStream.forceCopyToBytes();
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException);
                    }
                }
                return Map.of(IMAGE_VO_CACHE_KEY, configurationImageVO, CONTENT_CACHE_KEY, byArray);
            }));
            Map map = future.get();
            return AccessorCacheValue.create((Map)map);
        });
        return (Map)mapAccessorCacheValue.unwrap(this.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultConfigurationImage readDefaultImage(ConfigurationImageType configurationImageType) {
        DefaultConfigurationImage defaultConfigurationImage = this.defaultImages.get(configurationImageType);
        if (defaultConfigurationImage == null) {
            try {
                InputStream inputStream = ResourceHelper.openStream((String)("/configurationImages/" + configurationImageType.name() + ".png"));
                if (inputStream == null) {
                    throw new EntityNotFoundException();
                }
                defaultConfigurationImage = new DefaultConfigurationImage();
                defaultConfigurationImage.bytes = IOHelper.readBytesAndClose((InputStream)inputStream);
                try {
                    defaultConfigurationImage.bufferedImage = ImageIO.read(new ByteArrayInputStream(defaultConfigurationImage.bytes));
                }
                finally {
                    IOHelper.close((Closeable)inputStream);
                }
                defaultConfigurationImage.lastModified = System.currentTimeMillis();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            this.defaultImages.put(configurationImageType, defaultConfigurationImage);
        }
        return defaultConfigurationImage;
    }

    private void setImagesLastModified(Configuration configuration, Date date) {
        configuration.setImagesLastModified(date);
        for (Configuration configuration2 : configuration.getChildren()) {
            this.setImagesLastModified(configuration2, date);
        }
    }

    private static class DefaultConfigurationImage {
        private BufferedImage bufferedImage;
        private byte[] bytes;
        private long lastModified;

        private DefaultConfigurationImage() {
        }
    }
}

