/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.QChannelConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.PasswordTypeServiceLocal;
import org.cyclos.impl.access.PrincipalTypeContext;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.system.ChannelConfigurationServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.channels.IdentificationMethod;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationData;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationDataParams;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationVO;
import org.cyclos.model.system.channelconfigurations.CredentialsConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.PaymentPrincipalsConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.PinChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.RegistrationWithIdentityProviders;
import org.cyclos.model.system.channelconfigurations.SmsChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.SmsChannelConfigurationData;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelConfigurationServiceImpl
extends CRUDServiceImpl<ChannelConfiguration, QChannelConfiguration, ChannelConfigurationDTO, ChannelConfigurationData, ChannelConfigurationDataParams>
implements ChannelConfigurationServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{SmsChannelConfigurationDTO.PASSWORD};
    private static final BidiMap<Class<? extends ChannelConfiguration>, Class<? extends ChannelConfigurationDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private PasswordTypeServiceLocal passwordTypeService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private CyclosProperties cyclosProperties;

    public ChannelConfigurationServiceImpl() {
        super(ChannelConfiguration.class, QChannelConfiguration.channelConfiguration, ChannelConfigurationDTO.class);
    }

    public boolean canActivateTrustedDevice(Channel channel) {
        return this.isPinSupported(channel);
    }

    public boolean isDeviceSupported(CredentialUsage credentialUsage, Channel channel) {
        if (this.getCredentialAvailability(credentialUsage, channel) != Availability.DISABLED) {
            switch (credentialUsage) {
                case ACCESS: {
                    return false;
                }
                case CONFIRMATION: {
                    return !channel.isMobile();
                }
                case LOGIN_CONFIRMATION: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isUsedForAccess(PasswordType passwordType) throws FrameworkException {
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QChannelConfiguration)this.$).defined.isTrue(), ((QChannelConfiguration)this.$).enabled.isTrue(), ((QChannelConfiguration)this.$).accessPassword().eq((Object)passwordType)})).hasResults();
    }

    public List<ChannelConfigurationVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        List list = this.channelService.listAll();
        ArrayList<ChannelConfigurationVO> arrayList = new ArrayList<ChannelConfigurationVO>();
        for (Channel channel : list) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            if (configuration.isGlobal() && channel.isSms() || channelConfiguration == null || !channelConfiguration.isCanBeDefined()) continue;
            ChannelConfigurationVO channelConfigurationVO = new ChannelConfigurationVO();
            ChannelConfiguration channelConfiguration2 = configuration.getChannelConfiguration(channel);
            if (channelConfiguration2 != null) {
                channelConfigurationVO.setId(channelConfiguration2.getId());
                channelConfigurationVO.setDirect(true);
            } else {
                channelConfigurationVO.setId(channelConfiguration.getId());
            }
            channelConfigurationVO.setChannel((ChannelVO)this.conversionHandler.convert(ChannelVO.class, (Object)channel));
            channelConfigurationVO.setEnabled(channelConfiguration != null && channelConfiguration.isDefined() && channelConfiguration.isEnabled());
            arrayList.add(channelConfigurationVO);
        }
        return arrayList;
    }

    @Override
    public ChannelConfiguration newEntity(ChannelConfigurationDataParams channelConfigurationDataParams) {
        Channel channel = (Channel)this.conversionHandler.convert(Channel.class, (Object)channelConfigurationDataParams.getChannel());
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)channelConfigurationDataParams.getConfiguration());
        ChannelConfiguration channelConfiguration = (ChannelConfiguration)((DBQuery)this.from().where(new Predicate[]{((QChannelConfiguration)this.$).channel().eq((Object)channel), ((QChannelConfiguration)this.$).configuration().eq((Object)configuration)})).singleResult((Expression)this.$);
        if (channelConfiguration != null) {
            return channelConfiguration;
        }
        SmsChannelConfiguration smsChannelConfiguration = channel.isSms() ? new SmsChannelConfiguration() : new ChannelConfiguration();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("customOperations");
        for (PropertyDescriptor propertyDescriptor : InvocationContext.wrap((Object)smsChannelConfiguration).getPropertyDescriptors()) {
            if (!SmsOperationConfiguration.class.isAssignableFrom(propertyDescriptor.getPropertyType())) continue;
            hashSet.add(propertyDescriptor.getName());
        }
        ChannelConfiguration channelConfiguration2 = this.configurationHandler.getAccessor(configuration).getChannelConfiguration(channel);
        this.conversionHandler.fillExcluding((Object)channelConfiguration2, (Object)smsChannelConfiguration, hashSet.toArray());
        smsChannelConfiguration.setDefined(false);
        smsChannelConfiguration.setConfiguration(configuration);
        smsChannelConfiguration.setAllowLogin(true);
        if (smsChannelConfiguration.getLoginConfirmation() == null) {
            smsChannelConfiguration.setLoginConfirmation(new CredentialsConfiguration());
        }
        if (smsChannelConfiguration.getConfirmation() == null) {
            smsChannelConfiguration.setConfirmation(new CredentialsConfiguration());
        }
        if (smsChannelConfiguration.getPayment() == null) {
            smsChannelConfiguration.setPayment(new PaymentPrincipalsConfiguration());
        }
        if (smsChannelConfiguration.getPos() == null) {
            smsChannelConfiguration.setPos(new PaymentPrincipalsConfiguration());
        }
        return smsChannelConfiguration;
    }

    @Override
    public ChannelConfigurationDTO toDTO(ChannelConfiguration channelConfiguration) {
        ChannelConfigurationDTO channelConfigurationDTO = (ChannelConfigurationDTO)super.toDTO(channelConfiguration);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(channelConfiguration.getConfiguration());
        if (!configurationAccessor.isEmailUnique()) {
            this.removePrincipalType(ExistingBuiltInPrincipalType.EMAIL, channelConfigurationDTO.getPrincipalTypes());
            this.removePrincipalType(ExistingBuiltInPrincipalType.EMAIL, channelConfigurationDTO.getPayment().getPrincipalTypes());
            this.removePrincipalType(ExistingBuiltInPrincipalType.EMAIL, channelConfigurationDTO.getPos().getPrincipalTypes());
        }
        if (!configurationAccessor.isMobileUnique()) {
            this.removePrincipalType(ExistingBuiltInPrincipalType.MOBILE_PHONE, channelConfigurationDTO.getPrincipalTypes());
            this.removePrincipalType(ExistingBuiltInPrincipalType.MOBILE_PHONE, channelConfigurationDTO.getPayment().getPrincipalTypes());
            this.removePrincipalType(ExistingBuiltInPrincipalType.MOBILE_PHONE, channelConfigurationDTO.getPos().getPrincipalTypes());
        }
        if (this.isPinConfigurationEmpty(channelConfigurationDTO.getPinConfiguration())) {
            channelConfigurationDTO.setPinConfiguration(null);
        }
        return channelConfigurationDTO;
    }

    @Override
    public ChannelConfiguration toEntity(ChannelConfigurationDTO channelConfigurationDTO) {
        ChannelConfiguration channelConfiguration = (ChannelConfiguration)super.toEntity(channelConfigurationDTO);
        String string = channelConfigurationDTO.isUseIpWhitelist() ? channelConfigurationDTO.getIpWhitelist() : null;
        this.internetAddressListHandler.setInternetAddressList((SimpleEntity)channelConfiguration, (Path)((QChannelConfiguration)this.$).whitelist(), string);
        if (channelConfiguration instanceof SmsChannelConfiguration) {
            SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)channelConfiguration;
            SmsChannelConfigurationDTO smsChannelConfigurationDTO = (SmsChannelConfigurationDTO)channelConfigurationDTO;
            if (smsChannelConfigurationDTO.isPasswordSet()) {
                smsChannelConfiguration.setPassword(smsChannelConfigurationDTO.getPassword());
            }
        }
        return channelConfiguration;
    }

    @Override
    protected ChannelConfigurationData getData(ChannelConfiguration channelConfiguration) {
        boolean bl;
        SmsChannelConfiguration smsChannelConfiguration;
        ChannelConfigurationDTO channelConfigurationDTO;
        ChannelConfigurationData channelConfigurationData;
        SmsChannelConfigurationData smsChannelConfigurationData;
        SmsChannelConfiguration smsChannelConfiguration2;
        Channel channel = channelConfiguration.getChannel();
        Configuration configuration = channelConfiguration.getConfiguration();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        ChannelConfiguration channelConfiguration2 = configurationAccessor.getChannelConfiguration(channel);
        if (channelConfiguration2 == null) {
            throw new EntityNotFoundException(ChannelConfiguration.class);
        }
        this.entityManagerHandler.clear();
        if (channel.isSms()) {
            smsChannelConfiguration2 = (SmsChannelConfiguration)channelConfiguration;
            smsChannelConfigurationData = new SmsChannelConfigurationData();
            smsChannelConfigurationData.setMobileUnique(configurationAccessor.isMobileUnique());
            smsChannelConfigurationData.setInboundSmsUrl(configurationAccessor.getFullUrl() + "/sms");
            smsChannelConfigurationData.setOperations(this.conversionHandler.convertList(SmsOperationConfigurationVO.class, (Iterable)smsChannelConfiguration2.getOperations()));
            smsChannelConfigurationData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.INBOUND_SMS)));
            channelConfigurationData = smsChannelConfigurationData;
        } else {
            channelConfigurationData = new ChannelConfigurationData();
        }
        smsChannelConfiguration2 = configuration.getParent();
        smsChannelConfigurationData = null;
        ChannelConfiguration channelConfiguration3 = null;
        if (smsChannelConfiguration2 != null && (channelConfiguration3 = (smsChannelConfigurationData = this.configurationHandler.getAccessor((Configuration)smsChannelConfiguration2)).getChannelConfiguration(channel)) instanceof SmsChannelConfiguration) {
            channelConfigurationDTO = (SmsChannelConfigurationData)channelConfigurationData;
            smsChannelConfiguration = (SmsChannelConfiguration)channelConfiguration3;
            channelConfigurationDTO.setInheritedOperations(this.conversionHandler.convertList(SmsOperationConfigurationVO.class, (Iterable)smsChannelConfiguration.getOperations()));
        }
        if (channelConfiguration.isPersistent() && !channelConfiguration.isDefined() && smsChannelConfiguration2 != null) {
            channelConfigurationDTO = this.toDTO(smsChannelConfigurationData.getChannelConfiguration(channel));
            channelConfigurationDTO.setDefined(false);
            channelConfigurationDTO.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
            channelConfigurationDTO.setId(channelConfiguration.getId());
            channelConfigurationDTO.setVersion(channelConfiguration.getVersion());
        } else {
            channelConfigurationDTO = this.toDTO(channelConfiguration);
        }
        channelConfigurationData.setDto((EntityDTO)channelConfigurationDTO);
        this.setCredentialAvailabilities(channelConfigurationData, channel);
        channelConfigurationData.setPinSupported(this.isPinSupported(channel));
        channelConfigurationData.setCanActivateTrustedDevice(this.canActivateTrustedDevice(channel));
        channelConfigurationData.setCanBeUsedByTrustedSession(this.canBeUsedByTrustedSession(channel));
        channelConfigurationData.setCanDisable(!channel.isMain() || !configuration.isDefaultConfig());
        channelConfigurationData.setInherited(channelConfiguration3 == null ? null : this.toDTO(channelConfiguration3));
        channelConfigurationData.setStatefulChannel(channel.isStateful());
        channelConfigurationData.setDefaultPrincipalTypeAvailability(this.defaultPrincipalTypeAvailability(channel));
        channelConfigurationData.setDefaultPaymentPrincipalTypeAvailability(this.defaultPaymentPrincipalTypeAvailability(channel));
        channelConfigurationData.setHasIdentificationMethods(this.hasIdentificationMethods(channel));
        if (this.hasAccessPrincipalTypes(channel)) {
            channelConfigurationData.setAccessPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listForConfiguration(configurationAccessor, channel, PrincipalTypeContext.ACCESS)));
        }
        if (this.hasIdentityProviders(channel)) {
            channelConfigurationData.setIdentityProviders(this.identityProviderService.list());
        }
        if (this.hasPaymentPrincipalTypes(channel)) {
            channelConfigurationData.setPaymentPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listForConfiguration(configurationAccessor, channel, PrincipalTypeContext.PAYMENT)));
        }
        if (this.hasPosPrincipalTypes(channel)) {
            channelConfigurationData.setPosPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listForConfiguration(configurationAccessor, channel, PrincipalTypeContext.POS)));
        }
        if (channel.isPay() && (smsChannelConfiguration = configurationAccessor.getChannelConfiguration(this.channelService.getMobile())) != null && smsChannelConfiguration.isEnabled() && smsChannelConfiguration.getPinConfiguration() != null) {
            channelConfigurationData.setMobileAccessPasswordForPin((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)smsChannelConfiguration.getAccessPassword()));
        }
        channelConfigurationData.setPrincipalTypesAllowingQrCode(this.getPrincipalTypesAllowingQrCode(channel));
        boolean bl2 = channelConfigurationData.getAccessCredential() != Availability.DISABLED;
        boolean bl3 = channelConfigurationData.getConfirmationCredential() != Availability.DISABLED;
        boolean bl4 = bl = channelConfigurationData.getLoginConfirmationCredential() != Availability.DISABLED;
        if (bl2 || bl3 || bl) {
            List list = this.passwordTypeService.listAll();
            if (bl2) {
                ArrayList<PasswordTypeVO> arrayList = new ArrayList<PasswordTypeVO>();
                for (PasswordType passwordType : list) {
                    if (!passwordType.canBeUsedForAccess()) continue;
                    arrayList.add((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
                }
                channelConfigurationData.setAccessPasswordTypes(arrayList);
            }
            if (bl3 || bl) {
                channelConfigurationData.setConfirmationPasswordTypes(this.conversionHandler.convertList(PasswordTypeVO.class, (Iterable)list));
            }
        }
        channelConfigurationData.setHasIpWhitelist(this.hasIpWhitelist(channel));
        channelConfigurationData.setConfigurationAccessibleForLogin(configuration.isDefaultConfig() || configuration.isDefineRootUrl() || configuration.getPath() != null);
        return channelConfigurationData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(ChannelConfiguration channelConfiguration) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(ChannelConfigurationDTO channelConfigurationDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterRemove(ChannelConfiguration channelConfiguration) {
        this.evictCache(channelConfiguration);
    }

    @Override
    protected void onAfterSave(ChannelConfiguration channelConfiguration, ChannelConfiguration channelConfiguration2, Object object) {
        this.evictCache(channelConfiguration);
    }

    @Override
    protected Object onBeforeSave(ChannelConfiguration channelConfiguration, ChannelConfiguration channelConfiguration2) {
        boolean bl;
        SmsChannelConfiguration smsChannelConfiguration;
        Channel channel = channelConfiguration.getChannel();
        if (channel.isMain() && channelConfiguration.getConfiguration().isDefaultConfig()) {
            channelConfiguration.setEnabled(true);
        }
        if (!this.hasAccessPrincipalTypes(channel)) {
            channelConfiguration.setPrincipalTypes(null);
        }
        if (channel.isPay()) {
            if (!channelConfiguration.isAllowLogin()) {
                channelConfiguration.setPrincipalTypes(new HashSet());
                channelConfiguration.setDefaultPrincipalType(null);
                channelConfiguration.setAccessPassword(null);
                channelConfiguration.setLoginConfirmation(null);
            }
        } else {
            channelConfiguration.setAllowLogin(true);
        }
        boolean bl2 = this.hasIdentificationMethods(channel);
        this.onBeforeSavePaymentPrincipals(channelConfiguration.getPayment(), bl2, this.hasPaymentPrincipalTypes(channel));
        this.onBeforeSavePaymentPrincipals(channelConfiguration.getPos(), bl2, this.hasPosPrincipalTypes(channel));
        if (this.getCredentialAvailability(CredentialUsage.ACCESS, channel) == Availability.DISABLED) {
            channelConfiguration.setAccessPassword(null);
        }
        if (this.getCredentialAvailability(CredentialUsage.LOGIN_CONFIRMATION, channel) == Availability.DISABLED) {
            channelConfiguration.setLoginConfirmation(null);
        }
        if (this.getCredentialAvailability(CredentialUsage.CONFIRMATION, channel) == Availability.DISABLED) {
            channelConfiguration.setConfirmation(null);
            channelConfiguration.setConfirmationOncePerSession(false);
        } else if (!channel.isStateful()) {
            channelConfiguration.setConfirmationOncePerSession(false);
        }
        if (!this.hasIpWhitelist(channel)) {
            channelConfiguration.setWhitelist(null);
        }
        if (channelConfiguration instanceof SmsChannelConfiguration && (smsChannelConfiguration = (SmsChannelConfiguration)channelConfiguration).getScript() == null) {
            smsChannelConfiguration.setScriptParameters(null);
        }
        if (!(bl = this.canActivateTrustedDevice(channel))) {
            channelConfiguration.setRequireTrustedDeviceForLogin(false);
        }
        CredentialsConfiguration credentialsConfiguration = channelConfiguration.getLoginConfirmation();
        if (channel.isMobile() && credentialsConfiguration.isDevice()) {
            credentialsConfiguration.setDevice(false);
        }
        if (!credentialsConfiguration.isDevice()) {
            if (credentialsConfiguration.isDefined()) {
                channelConfiguration.setRequireTrustedDeviceForLogin(false);
                channelConfiguration.setSkipConfirmationForTrustedDevices(false);
            } else if (bl) {
                if (channelConfiguration.isRequireTrustedDeviceForLogin()) {
                    channelConfiguration.setSkipConfirmationForTrustedDevices(false);
                }
            } else if (!this.canBeUsedByTrustedSession(channel)) {
                channelConfiguration.setSkipConfirmationForTrustedDevices(false);
            }
        } else {
            channelConfiguration.setRequireTrustedDeviceForLogin(false);
            if (credentialsConfiguration.isDeviceOnly()) {
                channelConfiguration.setSkipConfirmationForTrustedDevices(false);
            }
        }
        CredentialsConfiguration credentialsConfiguration2 = channelConfiguration.getConfirmation();
        if (channel.isMobile() && credentialsConfiguration2.isDevice()) {
            credentialsConfiguration2.setDevice(false);
        }
        if (!credentialsConfiguration2.isDefined()) {
            channelConfiguration.setSkipConfirmationForTrustedDevices(false);
            channelConfiguration.setConfirmationOncePerSession(false);
        }
        if (!this.canActivateTrustedDevice(channel)) {
            channelConfiguration.setRequireAuthenticationForDeviceConfirmation(false);
        }
        if (CollectionHelper.isEmpty((Iterable)channelConfiguration.getIdentityProviders())) {
            channelConfiguration.setRegistrationWithIdentityProviders(RegistrationWithIdentityProviders.DISABLED);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(ChannelConfigurationDTO channelConfigurationDTO, ChannelConfiguration channelConfiguration) {
        channelConfiguration.getIdentityProviders().size();
        channelConfiguration.getPrincipalTypes().size();
        channelConfiguration.getPrincipalTypesAllowingQrCode().size();
        channelConfiguration.getPayment().getPrincipalTypes().size();
        channelConfiguration.getPos().getPrincipalTypes().size();
        InternetAddressList internetAddressList = channelConfiguration.getWhitelist();
        if (internetAddressList != null) {
            internetAddressList.getAddresses();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QChannelConfiguration)this.$).configuration().network());
    }

    @Override
    protected Validator resolveValidator(ChannelConfigurationDTO channelConfigurationDTO) {
        org.cyclos.impl.utils.validation.Property property;
        BuiltInPrincipalType builtInPrincipalType;
        ConfigurationAccessor configurationAccessor;
        BuiltInPrincipalType builtInPrincipalType2;
        Object object4;
        org.cyclos.impl.utils.validation.Property property2;
        boolean bl;
        ConfigurationAccessor configurationAccessor2;
        ChannelConfiguration channelConfiguration;
        Channel channel = this.resolveChannel(channelConfigurationDTO);
        Configuration configuration = this.resolveConfiguration(channelConfigurationDTO);
        Validator validator = new Validator();
        Supplier<org.cyclos.impl.utils.validation.Property> supplier = () -> validator.property((Property)ChannelConfigurationDTO.CHANNEL, SystemKeys.ChannelConfigurations.CHANNEL);
        if (channelConfigurationDTO.isTransient()) {
            supplier.get().required();
            validator.property((Property)ChannelConfigurationDTO.CONFIGURATION, SystemKeys.ChannelConfigurations.CONFIGURATION).required();
        }
        if (channel == null || configuration == null) {
            return validator;
        }
        Configuration configuration2 = configuration.getParent();
        if (configuration2 != null && (channelConfiguration = (configurationAccessor2 = this.configurationHandler.getAccessor(configuration2)).getChannelConfiguration(channel)) != null && channelConfiguration.isDefined() && !channelConfiguration.isEnabled() && channelConfiguration.isLocked()) {
            supplier.get().invalid();
            return validator;
        }
        boolean bl2 = channel.isSms();
        if (bl2 != (bl = channelConfigurationDTO instanceof SmsChannelConfigurationDTO)) {
            supplier.get().invalid();
            return validator;
        }
        if (!channelConfigurationDTO.isDefined() || !channelConfigurationDTO.isEnabled()) {
            return validator;
        }
        org.cyclos.impl.utils.validation.Property property3 = validator.property((Property)ChannelConfigurationDTO.USER_ACCESS, SystemKeys.ChannelConfigurations.USER_ACCESS).required();
        if (configuration.isDefaultConfig() && channel.isMain()) {
            property3.noneOf(new Object[]{UserChannelAccess.DEFAULT_DISABLED});
        }
        boolean bl3 = channel.isPay() && !channelConfigurationDTO.isAllowLogin();
        org.cyclos.impl.utils.validation.Property property4 = validator.property((Property)ChannelConfigurationDTO.PRINCIPAL_TYPES, SystemKeys.ChannelConfigurations.PRINCIPAL_TYPES);
        if (!bl3 && this.hasAccessPrincipalTypes(channel)) {
            property4.required();
            property4.entity(PrincipalType.class, (EntityValidation)new PrincipalTypeValidation(PrincipalTypeContext.ACCESS, configuration, channel));
            if (CollectionHelper.isNotEmpty((Iterable)channelConfigurationDTO.getPrincipalTypes())) {
                property4.add((object, object2, object3) -> {
                    if (channelConfigurationDTO.getPrincipalTypes().size() == 1 && channelConfigurationDTO.getPrincipalTypes().stream().map(principalTypeVO -> (PrincipalType)this.conversionHandler.convert(PrincipalType.class, principalTypeVO)).anyMatch(principalType -> principalType.getInternalName().equals(ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName()))) {
                        return new ValidationError(SystemKeys.ChannelConfigurations.PRINCIPAL_TYPES_ERROR_TRUSTED_DEVICE, new Object[]{this.principalTypeService.getTrustedDevice()});
                    }
                    return null;
                });
                property2 = validator.property((Property)ChannelConfigurationDTO.DEFAULT_PRINCIPAL_TYPE, SystemKeys.ChannelConfigurations.DEFAULT_PRINCIPAL_TYPE);
                property2.anyOf((Collection)channelConfigurationDTO.getPrincipalTypes()).noneOf((Collection)channelConfigurationDTO.getPrincipalTypes().stream().map(principalTypeVO -> (PrincipalType)this.conversionHandler.convert(PrincipalType.class, principalTypeVO)).filter(principalType -> principalType.getNature() == PrincipalTypeNature.ACCESS_CLIENT || principalType.getInternalName().equals(ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName())).collect(Collectors.toSet()));
                if (this.defaultPrincipalTypeAvailability(channel) == Availability.REQUIRED) {
                    property2.required();
                }
            }
        }
        property2 = validator.property((Property)ChannelConfigurationDTO.SESSION_TIMEOUT, SystemKeys.ChannelConfigurations.SESSION_TIMEOUT);
        if (this.cyclosProperties.getPurgeSessionsDays() > 0) {
            property2.positiveNonZero().maxInterval(this.cyclosProperties.getPurgeSessionsDays(), TimeField.DAYS);
        } else {
            property2.timeInterval();
        }
        validator.property((Property)ChannelConfigurationDTO.PRINCIPAL_TYPES_ALLOWING_QR_CODE, SystemKeys.ChannelConfigurations.SHOW_QR_CODE_FOR_USER_IDENTIFICATION_METHODS).anyOf(this.getPrincipalTypesAllowingQrCode(channel));
        boolean bl4 = this.hasIdentificationMethods(channel);
        Availability availability = this.defaultPaymentPrincipalTypeAvailability(channel);
        if (this.hasPaymentPrincipalTypes(channel)) {
            object4 = (PaymentPrincipalsConfigurationDTO)ObjectHelper.defaultValue((Object)channelConfigurationDTO.getPayment(), PaymentPrincipalsConfigurationDTO::new);
            boolean bl5 = channel.isEasyInvoice();
            validator.nested((Property)ChannelConfigurationDTO.PAYMENT, this.paymentPrincipalsValidator(PrincipalTypeContext.PAYMENT, SystemKeys.ChannelConfigurations.SECTION_PERFORM_PAYMENTS, configuration, channel, (PaymentPrincipalsConfigurationDTO)object4, bl4, bl5, availability));
        }
        if (this.hasPosPrincipalTypes(channel)) {
            object4 = (PaymentPrincipalsConfigurationDTO)ObjectHelper.defaultValue((Object)channelConfigurationDTO.getPos(), PaymentPrincipalsConfigurationDTO::new);
            validator.nested((Property)ChannelConfigurationDTO.POS, this.paymentPrincipalsValidator(PrincipalTypeContext.POS, SystemKeys.ChannelConfigurations.SECTION_RECEIVE_PAYMENTS, configuration, channel, (PaymentPrincipalsConfigurationDTO)object4, bl4, false, availability));
        }
        object4 = this.conversionHandler.convertSet(PrincipalType.class, (Iterable)channelConfigurationDTO.getPrincipalTypes());
        if (channel.isMain() && !object4.contains(builtInPrincipalType2 = this.principalTypeService.getUsername())) {
            property4.invalid(SystemKeys.ChannelConfigurations.ERROR_MAIN_NEEDS_USERNAME);
        }
        if (!(configurationAccessor = this.configurationHandler.getAccessor(configuration)).isEmailUnique() && object4.contains(builtInPrincipalType = this.principalTypeService.getEmail())) {
            property4.invalid();
        }
        if (!configurationAccessor.isMobileUnique() && object4.contains(builtInPrincipalType = this.principalTypeService.getMobilePhone())) {
            property4.invalid();
        }
        validator.property((Property)ChannelConfigurationDTO.IDENTITY_PROVIDERS, SystemKeys.ChannelConfigurations.IDENTITY_PROVIDERS).add((object, object2, object3) -> {
            CredentialsConfigurationDTO credentialsConfigurationDTO = (CredentialsConfigurationDTO)ObjectHelper.defaultValue((Object)channelConfigurationDTO.getLoginConfirmation(), CredentialsConfigurationDTO::new);
            boolean bl = credentialsConfigurationDTO.getPassword() != null || credentialsConfigurationDTO.isDevice() || credentialsConfigurationDTO.isTotp();
            boolean bl2 = CollectionHelper.isNotEmpty((Iterable)channelConfigurationDTO.getIdentityProviders());
            if (!bl && this.canActivateTrustedDevice(channel) && bl2 && channelConfigurationDTO.isRequireTrustedDeviceForLogin()) {
                return new ValidationError(SystemKeys.ChannelConfigurations.IDENTITY_PROVIDERS_ERROR_REQUIRED_TRUSTED_DEVICE);
            }
            return null;
        });
        if (!bl3) {
            builtInPrincipalType = this.getCredentialAvailability(CredentialUsage.ACCESS, channel);
            property = validator.property((Property)ChannelConfigurationDTO.ACCESS_PASSWORD, SystemKeys.ChannelConfigurations.ACCESS_PASSWORD);
            if (builtInPrincipalType != Availability.DISABLED) {
                final boolean bl6 = object4.size() == 1 && ((PrincipalType)CollectionHelper.first((Iterable)object4)).getNature() == PrincipalTypeNature.ACCESS_CLIENT;
                property.entity(PasswordType.class, (EntityValidation)new BaseEntityValidation<PasswordType>(){

                    protected boolean isValid(Object object, Object object2, PasswordType passwordType) {
                        return !bl6 && passwordType.canBeUsedForAccess();
                    }
                });
                if (!bl6 && builtInPrincipalType == Availability.REQUIRED) {
                    property.required();
                }
            } else if (channelConfigurationDTO.getAccessPassword() != null) {
                property.invalid();
            }
            Availability availability2 = this.getCredentialAvailability(CredentialUsage.LOGIN_CONFIRMATION, channel);
            validator.nested((Property)ChannelConfigurationDTO.LOGIN_CONFIRMATION, this.credentialsValidator((CredentialsConfigurationDTO)ObjectHelper.defaultValue((Object)channelConfigurationDTO.getLoginConfirmation(), CredentialsConfigurationDTO::new), SystemKeys.ChannelConfigurations.SECTION_LOGIN_CONFIRMATION, availability2, this.isDeviceSupported(CredentialUsage.LOGIN_CONFIRMATION, channel)));
        }
        builtInPrincipalType = this.getCredentialAvailability(CredentialUsage.CONFIRMATION, channel);
        validator.nested((Property)ChannelConfigurationDTO.CONFIGURATION, this.credentialsValidator((CredentialsConfigurationDTO)ObjectHelper.defaultValue((Object)channelConfigurationDTO.getConfirmation(), CredentialsConfigurationDTO::new), SystemKeys.ChannelConfigurations.SECTION_CONFIRMATION, (Availability)builtInPrincipalType, this.isDeviceSupported(CredentialUsage.CONFIRMATION, channel)));
        if (this.hasIpWhitelist(channel) && channelConfigurationDTO.isUseIpWhitelist()) {
            validator.property((Property)ChannelConfigurationDTO.IP_WHITELIST, SystemKeys.ChannelConfigurations.IP_WHITELIST).required().internetAddressList();
        }
        if (channel.isMobile()) {
            validator.property((Property)ChannelConfigurationDTO.TRUSTED_DEVICE_ON_STARTUP, SystemKeys.ChannelConfigurations.TRUSTED_DEVICE_ON_STARTUP).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9));
        }
        if (this.isPinSupported(channel)) {
            property = new Validator();
            property.property((Property)PinChannelConfigurationDTO.PIN_LENGTH, SystemKeys.ChannelConfigurations.DEVICE_PIN_LENGTH).required().greaterEquals((Comparable)Integer.valueOf(4));
            property.property((Property)PinChannelConfigurationDTO.MAX_PIN_TRIES, SystemKeys.ChannelConfigurations.DEVICE_PIN_MAX_TRIES).required().positiveIntegerNonZero();
            property.property((Property)PinChannelConfigurationDTO.PIN_EXPIRES_AFTER, SystemKeys.ChannelConfigurations.DEVICE_PIN_EXPIRES_AFTER).required().timeInterval();
            property.property((Property)PinChannelConfigurationDTO.DEVICE_PIN_ON_STARTUP, SystemKeys.ChannelConfigurations.DEVICE_PIN_ON_STARTUP).between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9));
            validator.nested((Property)ChannelConfigurationDTO.PIN_CONFIGURATION, (Validator)property);
        } else if (channelConfigurationDTO.getPinConfiguration() != null) {
            validator.property((Property)ChannelConfigurationDTO.PIN_CONFIGURATION, SystemKeys.ChannelConfigurations.DEVICE_PIN).invalid();
        }
        if (bl2) {
            property = (SmsChannelConfigurationDTO)channelConfigurationDTO;
            if (property.getScript() == null) {
                validator.property((Property)SmsChannelConfigurationDTO.MOBILE_NUMBER_SOURCE, SystemKeys.ChannelConfigurations.MOBILE_NUMBER_SOURCE).required();
                validator.property((Property)SmsChannelConfigurationDTO.SMS_MESSAGE_SOURCE, SystemKeys.ChannelConfigurations.SMS_MESSAGE_SOURCE).required();
            } else {
                validator.property((Property)SmsChannelConfigurationDTO.SCRIPT, SystemKeys.ChannelConfigurations.SCRIPT).entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                    protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                        return customScript.getType() == ScriptType.INBOUND_SMS;
                    }
                });
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends ChannelConfiguration>, Class<? extends ChannelConfigurationDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private boolean canBeUsedByTrustedSession(Channel channel) {
        return channel.isPay();
    }

    private Validator credentialsValidator(CredentialsConfigurationDTO credentialsConfigurationDTO, MessageKey messageKey, Availability availability, boolean bl) {
        Validator validator = new Validator();
        validator.setPropertyDisplayPrefix(this.message(messageKey, new Object[0]));
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)CredentialsConfigurationDTO.PASSWORD, SystemKeys.ChannelConfigurations.CREDENTIALS_PASSWORD);
        org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)CredentialsConfigurationDTO.DEVICE, SystemKeys.ChannelConfigurations.CREDENTIALS_DEVICE);
        org.cyclos.impl.utils.validation.Property property3 = validator.property((Property)CredentialsConfigurationDTO.TOTP, SystemKeys.ChannelConfigurations.CREDENTIALS_TOTP);
        switch (availability) {
            case DISABLED: {
                property.invalid();
                property2.anyOf(new Object[]{false});
                property3.anyOf(new Object[]{false});
                break;
            }
            case OPTIONAL: {
                if (bl) break;
                property2.anyOf(new Object[]{false});
                break;
            }
            case REQUIRED: {
                boolean bl2 = credentialsConfigurationDTO.getPassword() != null;
                boolean bl3 = bl && credentialsConfigurationDTO.isDevice();
                boolean bl4 = credentialsConfigurationDTO.isTotp();
                if (bl2 || bl3 || bl4) break;
                EnumSet<CredentialType> enumSet = EnumSet.complementOf(EnumSet.of(CredentialType.PIN));
                if (!bl) {
                    enumSet.remove(CredentialType.DEVICE);
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = enumSet.stream().map(arg_0 -> ((EnumMessageKeyResolver)CredentialType.resolverForChannelConfiguration()).resolveKey(arg_0)).collect(Collectors.toList());
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.ChannelConfigurations.ERROR_CREDENTIALS_REQUIRED, (Object[])objectArray));
            }
        }
        return validator;
    }

    private Availability defaultPaymentPrincipalTypeAvailability(Channel channel) {
        if (channel.isMain()) {
            return Availability.REQUIRED;
        }
        if (channel.isOidc() || channel.isEasyInvoice()) {
            return Availability.DISABLED;
        }
        return Availability.OPTIONAL;
    }

    private Availability defaultPrincipalTypeAvailability(Channel channel) {
        if (channel.isOidc() || channel.isEasyInvoice()) {
            return Availability.DISABLED;
        }
        return Availability.OPTIONAL;
    }

    private void evictCache(ChannelConfiguration channelConfiguration) {
        Long l = SimpleEntity.id((SimpleEntity)channelConfiguration.getChannel());
        Long l2 = SimpleEntity.id((SimpleEntity)channelConfiguration.getConfiguration());
        this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesConfiguration(l2));
        this.cacheHandler.schedulePartialEvict(CacheType.CHANNEL_CONFIGURATION, (SerializablePredicate & Serializable)channelConfigurationCacheKey -> channelConfigurationCacheKey.matches(l, l2));
    }

    private Availability getCredentialAvailability(CredentialUsage credentialUsage, Channel channel) {
        switch (credentialUsage) {
            case ACCESS: {
                return channel.isPos() ? Availability.DISABLED : Availability.REQUIRED;
            }
            case CONFIRMATION: {
                if (channel.isSms() || channel.isOidc()) {
                    return Availability.DISABLED;
                }
                return Availability.OPTIONAL;
            }
            case LOGIN_CONFIRMATION: {
                return channel.isStateful() && !channel.isMobile() && !channel.isPay() ? Availability.OPTIONAL : Availability.DISABLED;
            }
        }
        return Availability.DISABLED;
    }

    private List<PrincipalTypeVO> getPrincipalTypesAllowingQrCode(Channel channel) {
        List<PrincipalTypeVO> list = Collections.emptyList();
        if (this.hasQrCodeForPrincipalTypes(channel)) {
            return this.principalTypeService.list().stream().filter(principalTypeVO -> ObjectHelper.isNotOneOf((Object)principalTypeVO.getNature(), (Object[])new Object[]{PrincipalTypeNature.ACCESS_CLIENT, PrincipalTypeNature.NFC_TOKEN}) && !ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName().equals(principalTypeVO.getInternalName())).collect(Collectors.toList());
        }
        return list;
    }

    private boolean hasAccessPrincipalTypes(Channel channel) {
        return !channel.isPos() && !channel.isSms();
    }

    private boolean hasIdentificationMethods(Channel channel) {
        return channel.isMain() || channel.isService();
    }

    private boolean hasIdentityProviders(Channel channel) {
        return channel.isMain() || channel.isService();
    }

    private boolean hasIpWhitelist(Channel channel) {
        return !channel.isPos() && !channel.isOidc();
    }

    private boolean hasPaymentPrincipalTypes(Channel channel) {
        return channel.isMain() || channel.isService() || channel.isSms() || channel.isOidc() || channel.isEasyInvoice();
    }

    private boolean hasPosPrincipalTypes(Channel channel) {
        return channel.isMain() || channel.isService();
    }

    private boolean hasQrCodeForPrincipalTypes(Channel channel) {
        return channel.isService();
    }

    private boolean isPinConfigurationEmpty(PinChannelConfigurationDTO pinChannelConfigurationDTO) {
        return ObjectHelper.isEmpty((Object)pinChannelConfigurationDTO) || ObjectHelper.isEmpty((Object)pinChannelConfigurationDTO.getPinLength()) || ObjectHelper.isEmpty((Object)pinChannelConfigurationDTO.getMaxPinTries()) || ObjectHelper.isEmpty((Object)pinChannelConfigurationDTO.getPinExpiresAfter());
    }

    private boolean isPinSupported(Channel channel) {
        return channel.isService();
    }

    private void onBeforeSavePaymentPrincipals(PaymentPrincipalsConfiguration paymentPrincipalsConfiguration, boolean bl, boolean bl2) {
        if (!bl) {
            paymentPrincipalsConfiguration.setAutocomplete(false);
            paymentPrincipalsConfiguration.setContacts(false);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.PRINCIPAL_TYPE);
        }
        if (!bl2) {
            paymentPrincipalsConfiguration.setDefaultIdMethod(null);
            paymentPrincipalsConfiguration.setPrincipalTypes(null);
            paymentPrincipalsConfiguration.setDefaultPrincipalType(null);
        } else {
            IdentificationMethod identificationMethod;
            IdentificationMethod identificationMethod2 = identificationMethod = bl ? paymentPrincipalsConfiguration.getDefaultIdMethod() : IdentificationMethod.PRINCIPAL_TYPE;
            if (identificationMethod != IdentificationMethod.PRINCIPAL_TYPE || CollectionHelper.isEmpty((Iterable)paymentPrincipalsConfiguration.getPrincipalTypes())) {
                paymentPrincipalsConfiguration.setDefaultPrincipalType(null);
            }
            if (identificationMethod != null) {
                switch (identificationMethod) {
                    case AUTOCOMPLETE: {
                        if (paymentPrincipalsConfiguration.isAutocomplete()) break;
                        paymentPrincipalsConfiguration.setDefaultIdMethod(null);
                        break;
                    }
                    case CONTACTS: {
                        if (paymentPrincipalsConfiguration.isContacts()) break;
                        paymentPrincipalsConfiguration.setDefaultIdMethod(null);
                        break;
                    }
                    case PRINCIPAL_TYPE: {
                        if (!CollectionHelper.isEmpty((Iterable)paymentPrincipalsConfiguration.getPrincipalTypes()) && paymentPrincipalsConfiguration.getPrincipalTypes().contains(paymentPrincipalsConfiguration.getDefaultPrincipalType())) break;
                        paymentPrincipalsConfiguration.setDefaultIdMethod(null);
                    }
                }
            }
        }
    }

    private Validator paymentPrincipalsValidator(PrincipalTypeContext principalTypeContext, MessageKey messageKey, Configuration configuration, Channel channel, PaymentPrincipalsConfigurationDTO paymentPrincipalsConfigurationDTO, boolean bl, boolean bl2, Availability availability) {
        org.cyclos.impl.utils.validation.Property property;
        Validator validator = new Validator();
        validator.setPropertyDisplayPrefix(this.message(messageKey, new Object[0]));
        org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)PaymentPrincipalsConfigurationDTO.PRINCIPAL_TYPES, SystemKeys.ChannelConfigurations.PAYMENTS_PRINCIPAL_TYPES);
        property2.entity(PrincipalType.class, (EntityValidation)new PrincipalTypeValidation(principalTypeContext, configuration, channel));
        boolean bl3 = false;
        if (bl) {
            property = validator.property((Property)PaymentPrincipalsConfigurationDTO.DEFAULT_ID_METHOD, SystemKeys.ChannelConfigurations.PAYMENTS_DEFAULT_ID_METHOD);
            ArrayList<IdentificationMethod> arrayList = new ArrayList<IdentificationMethod>();
            if (paymentPrincipalsConfigurationDTO.isAutocomplete()) {
                arrayList.add(IdentificationMethod.AUTOCOMPLETE);
            }
            if (paymentPrincipalsConfigurationDTO.isContacts()) {
                arrayList.add(IdentificationMethod.CONTACTS);
            }
            if (CollectionHelper.isNotEmpty((Iterable)paymentPrincipalsConfigurationDTO.getPrincipalTypes())) {
                arrayList.add(IdentificationMethod.PRINCIPAL_TYPE);
            }
            if (CollectionHelper.isNotEmpty(arrayList)) {
                if (arrayList.size() > 1) {
                    property.required();
                }
                property.anyOf(arrayList);
            }
            if (property.getAccess().get((Object)paymentPrincipalsConfigurationDTO) == IdentificationMethod.PRINCIPAL_TYPE) {
                bl3 = true;
            }
        } else {
            bl3 = true;
        }
        if (bl3) {
            property = validator.property((Property)PaymentPrincipalsConfigurationDTO.DEFAULT_PRINCIPAL_TYPE, SystemKeys.ChannelConfigurations.PAYMENTS_DEFAULT_ID_METHOD);
            if (availability == Availability.REQUIRED) {
                property.required();
            }
            property.anyOf((Collection)CollectionHelper.orEmpty((Set)paymentPrincipalsConfigurationDTO.getPrincipalTypes()));
        }
        return validator;
    }

    private void removePrincipalType(ExistingBuiltInPrincipalType existingBuiltInPrincipalType, Collection<PrincipalTypeVO> collection) {
        collection.removeIf(principalTypeVO -> existingBuiltInPrincipalType.getInternalName().equals(principalTypeVO.getInternalName()));
    }

    private Channel resolveChannel(ChannelConfigurationDTO channelConfigurationDTO) {
        if (channelConfigurationDTO.isPersistent()) {
            return ((ChannelConfiguration)this.find(channelConfigurationDTO.getId())).getChannel();
        }
        return (Channel)this.conversionHandler.convert(Channel.class, (Object)channelConfigurationDTO.getChannel());
    }

    private Configuration resolveConfiguration(ChannelConfigurationDTO channelConfigurationDTO) {
        if (channelConfigurationDTO.isPersistent()) {
            return ((ChannelConfiguration)this.find(channelConfigurationDTO.getId())).getConfiguration();
        }
        return (Configuration)this.conversionHandler.convert(Configuration.class, (Object)channelConfigurationDTO.getConfiguration());
    }

    private void setCredentialAvailabilities(ChannelConfigurationData channelConfigurationData, Channel channel) {
        Set set;
        channelConfigurationData.setAccessCredential(this.getCredentialAvailability(CredentialUsage.ACCESS, channel));
        channelConfigurationData.setConfirmationCredential(this.getCredentialAvailability(CredentialUsage.CONFIRMATION, channel));
        channelConfigurationData.setLoginConfirmationCredential(this.getCredentialAvailability(CredentialUsage.LOGIN_CONFIRMATION, channel));
        if (channelConfigurationData.getConfirmationCredential() == Availability.DISABLED) {
            set = Collections.emptySet();
        } else {
            set = EnumSet.of(CredentialType.PASSWORD);
            if (this.isDeviceSupported(CredentialUsage.CONFIRMATION, channel)) {
                set.add(CredentialType.DEVICE);
            }
            if (!channel.isPay()) {
                set.add(CredentialType.TOTP);
            }
        }
        channelConfigurationData.setAllowedConfirmationCredentials(set);
    }

    static {
        SUBCLASS_MAPPINGS.put(SmsChannelConfiguration.class, SmsChannelConfigurationDTO.class);
        SUBCLASS_MAPPINGS.put(ChannelConfiguration.class, ChannelConfigurationDTO.class);
    }

    private final class PrincipalTypeValidation
    extends BaseEntityValidation<PrincipalType> {
        private final PrincipalTypeContext access;
        private final Configuration configuration;
        private final Channel channel;

        public PrincipalTypeValidation(PrincipalTypeContext principalTypeContext, Configuration configuration, Channel channel) {
            this.access = principalTypeContext;
            this.configuration = configuration;
            this.channel = channel;
        }

        protected boolean isValid(Object object, Object object2, PrincipalType principalType) {
            List list = ChannelConfigurationServiceImpl.this.principalTypeService.listForConfiguration(ChannelConfigurationServiceImpl.this.configurationHandler.getAccessor(this.configuration), this.channel, this.access);
            return list.contains(principalType);
        }
    }
}

