/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.google.code.kaptcha.GimpyEngine;
import com.google.code.kaptcha.impl.FishEyeGimpy;
import com.google.code.kaptcha.impl.ShadowGimpy;
import com.google.code.kaptcha.text.impl.DefaultWordRenderer;
import com.google.code.kaptcha.util.Config;
import com.google.code.kaptcha.util.Configurable;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.system.Captcha;
import org.cyclos.impl.system.CaptchaServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.RipplesGimpy;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.contentmanagement.themes.ThemeBackground;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.configurations.CaptchaEffect;
import org.cyclos.model.system.configurations.CaptchaProvider;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ColorHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CaptchaServiceImpl
extends BaseServiceImpl
implements CaptchaServiceLocal {
    private final char[] CHARS = "abcdefghjkmnpqrstuvwxyz23456789".toCharArray();
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ClusterHandler clusterHandler;
    private CaptchaProducer captchaProducer;
    private SharedStorage<String, Captcha> storage;
    @Autowired
    private RestTemplate restTemplate;
    private final URI RECAPTCHA_VERIFY = URI.create("https://www.google.com/recaptcha/api/siteverify");

    public String generate(String string) throws FrameworkException {
        if (StringHelper.isNotBlank((Object)string)) {
            this.remove(string);
        }
        Captcha captcha = new Captcha(this.captchaProducer.createText(), this.getRemoteAddress());
        String string2 = UUID.randomUUID().toString();
        this.storage.set((Object)string2, (Object)captcha);
        return string2;
    }

    public String getText(String string) throws FrameworkException {
        Captcha captcha = this.findEnsuringRemoteAddress(string);
        return captcha.getText();
    }

    @PostConstruct
    public void initialize() {
        Properties properties = new Properties();
        properties.setProperty("kaptcha.textproducer.font.names", "Serif, SansSerif, Monospaced");
        properties.setProperty("kaptcha.obscurificator.impl", ShadowGimpy.class.getName());
        Config config = new Config(properties){
            private Map<CaptchaEffect, GimpyEngine> effects;
            {
                this.effects = ImmutableMap.of((Object)CaptchaEffect.SHADOW, (Object)new ShadowGimpy(), (Object)CaptchaEffect.FISH_EYE, (Object)new FishEyeGimpy(), (Object)CaptchaEffect.WATER, (Object)((Object)new RipplesGimpy()));
                this.effects.values().forEach(gimpyEngine -> {
                    if (gimpyEngine instanceof Configurable) {
                        ((Configurable)gimpyEngine).setConfig((Config)this);
                    }
                });
            }

            public Color getNoiseColor() {
                return this.getTextProducerFontColor();
            }

            public GimpyEngine getObscurificatorImpl() {
                CaptchaEffect captchaEffect = (CaptchaEffect)ObjectHelper.defaultValue((Object)CaptchaServiceImpl.this.getConfiguration().getCaptchaConfiguration().getEffect(), (Object)CaptchaEffect.SHADOW);
                GimpyEngine gimpyEngine = this.effects.get(captchaEffect);
                if (gimpyEngine == null) {
                    throw new IllegalStateException("CAPTCHA effect not supported: " + String.valueOf(captchaEffect));
                }
                return gimpyEngine;
            }

            public int getTextProducerCharLength() {
                return (Integer)ObjectHelper.defaultValue((Object)CaptchaServiceImpl.this.getConfiguration().getCaptchaConfiguration().getTextLength(), (Object)6);
            }

            public char[] getTextProducerCharString() {
                return CaptchaServiceImpl.this.CHARS;
            }

            public Color getTextProducerFontColor() {
                try {
                    String string = CaptchaServiceImpl.this.getConfiguration().getCaptchaConfiguration().getTextColor();
                    int[] nArray = ColorHelper.parse((String)string);
                    return new Color(nArray[0], nArray[1], nArray[2]);
                }
                catch (Exception exception) {
                    return Color.BLACK;
                }
            }
        };
        this.captchaProducer = new CaptchaProducer(config);
        this.storage = this.clusterHandler.getSharedStorage(SharedStorageType.CAPTCHAS);
    }

    public boolean isValid(String string, String string2) throws FrameworkException {
        return this.getText(string).equalsIgnoreCase(string2);
    }

    public SerializableInputStream readImage(String string, BasicGroupVO basicGroupVO, DimensionsDTO dimensionsDTO) throws FrameworkException {
        String string2 = this.getText(string);
        BufferedImage bufferedImage = this.captchaProducer.createImage(string2, basicGroupVO, dimensionsDTO);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new UnexpectedDataAccessException((Throwable)exception);
        }
        return new SerializableInputStream(byteArrayOutputStream.toByteArray());
    }

    public void remove(String string) throws FrameworkException {
        InvocationContext.ensure().addTransactionEndListener(false, bl -> this.storage.remove((Object)string));
    }

    public void removeInternalCaptcha(CaptchaConfiguration captchaConfiguration, CaptchaResponseDTO captchaResponseDTO) {
        if (captchaConfiguration == null || captchaConfiguration.getProvider() != CaptchaProvider.INTERNAL || captchaResponseDTO == null) {
            return;
        }
        this.remove(captchaResponseDTO.getChallenge());
    }

    public boolean verify(CaptchaConfiguration captchaConfiguration, CaptchaResponseDTO captchaResponseDTO) {
        String string = captchaResponseDTO == null ? null : StringHelper.trimToNull((Object)captchaResponseDTO.getChallenge());
        String string2 = captchaResponseDTO == null ? null : StringHelper.trimToNull((Object)captchaResponseDTO.getResponse());
        CaptchaProvider captchaProvider = captchaConfiguration.getProvider();
        if (captchaProvider.hasChallenge() && string == null || string2 == null) {
            return false;
        }
        switch (captchaProvider) {
            case INTERNAL: {
                try {
                    return this.getText(captchaResponseDTO.getChallenge()).equals(captchaResponseDTO.getResponse());
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    break;
                }
            }
            case RECAPTCHA_V2: {
                return this.isRecaptchaResponseValid(captchaConfiguration, string2);
            }
        }
        return false;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private Captcha findEnsuringRemoteAddress(String string) {
        Captcha captcha = (Captcha)this.storage.get((Object)string);
        if (captcha == null || !this.cyclosProperties.isSessionsAnyAddress() && !Objects.equals(this.getRemoteAddress(), captcha.getRemoteAddress())) {
            throw new EntityNotFoundException(Captcha.class, string);
        }
        return captcha;
    }

    private boolean isRecaptchaResponseValid(CaptchaConfiguration captchaConfiguration, String string) {
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"secret", (Object)captchaConfiguration.getRecaptchaSecret());
        linkedMultiValueMap.add((Object)"response", (Object)string);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)httpHeaders);
        RecaptchaResponse recaptchaResponse = (RecaptchaResponse)this.restTemplate.postForObject(this.RECAPTCHA_VERIFY, (Object)httpEntity, RecaptchaResponse.class);
        if (recaptchaResponse.success) {
            return true;
        }
        if (CollectionHelper.containsAny(recaptchaResponse.getErrorCodes(), (Object[])new Object[]{"missing-input-secret", "invalid-input-secret"})) {
            throw new ValidationException(this.message(SystemKeys.Configurations.ERROR_REJECTED_RECAPTCHA_SECRET, new Object[0]));
        }
        return false;
    }

    private class CaptchaProducer {
        private Config config;

        public CaptchaProducer(Config config) {
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage createImage(String string, BasicGroupVO basicGroupVO, DimensionsDTO dimensionsDTO) {
            Object object;
            BufferedImage bufferedImage;
            ByteArrayInputStream byteArrayInputStream;
            BasicGroup basicGroup = (BasicGroup)CaptchaServiceImpl.this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
            ConfigurationAccessor configurationAccessor = basicGroup == null ? CaptchaServiceImpl.this.getSessionData().getConfiguration() : CaptchaServiceImpl.this.configurationHandler.getAccessor(basicGroup);
            Theme theme = CaptchaServiceImpl.this.getSessionData().getLoggedBasicUser() != null ? configurationAccessor.getUsersTheme() : configurationAccessor.getGuestsTheme();
            byte[] byArray = CaptchaServiceImpl.this.themeImageService.readImageContent(theme.getId(), ThemeImageType.BACKGROUND, ThemeBackground.CAPTCHA.name());
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    bufferedImage = ImageIO.read(byteArrayInputStream);
                }
                finally {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error trying to get background image");
            }
            byteArrayInputStream = this.config.getWordRendererImpl();
            if (dimensionsDTO != null) {
                object = configurationAccessor.getMaxImageDimensions();
                Dimension dimension = ServerImageHelper.rescaleKeepingProportions((Dimension)new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), (Dimension)new Dimension((Integer)ObjectHelper.defaultValue((Object)dimensionsDTO.getWidth(), (Object)0), (Integer)ObjectHelper.defaultValue((Object)dimensionsDTO.getHeight(), (Object)0)), (Dimension)new Dimension((Integer)ObjectHelper.defaultValue((Object)object.getWidth(), (Object)0), (Integer)ObjectHelper.defaultValue((Object)object.getHeight(), (Object)0)));
                int n = (int)dimension.getWidth();
                int n2 = (int)dimension.getHeight();
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                try {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                }
                finally {
                    graphics2D.dispose();
                }
                final double d = (double)n / (double)bufferedImage.getWidth();
                final Config config = new Config(this.config.getProperties()){

                    public int getTextProducerCharSpace() {
                        int n = super.getTextProducerCharSpace();
                        return (int)Math.max(2.0, (double)n * d);
                    }

                    public int getTextProducerFontSize() {
                        int n = super.getTextProducerFontSize();
                        return (int)Math.max(2.0, (double)n * d);
                    }
                };
                byteArrayInputStream = new DefaultWordRenderer(){
                    {
                        this.setConfig(config);
                    }
                };
                bufferedImage = bufferedImage2;
            }
            object = byteArrayInputStream.renderWord(string, bufferedImage.getWidth(), bufferedImage.getHeight());
            object = this.config.getObscurificatorImpl().getDistortedImage((BufferedImage)object);
            return this.combine((BufferedImage)object, bufferedImage);
        }

        public String createText() {
            return this.config.getTextProducerImpl().getText();
        }

        private BufferedImage combine(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            int n = bufferedImage2.getWidth();
            int n2 = bufferedImage2.getHeight();
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            return bufferedImage3;
        }
    }

    public static class RecaptchaResponse {
        private boolean success;
        private List<String> errorCodes;

        public List<String> getErrorCodes() {
            return this.errorCodes;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setErrorCodes(List<String> list) {
            this.errorCodes = list;
        }

        public void setSuccess(boolean bl) {
            this.success = bl;
        }
    }
}

