/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.List;
import java.util.Objects;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.QCustomFieldPossibleValue;
import org.cyclos.entities.system.QCustomFieldPossibleValueCategory;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldDTO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryDTO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueDTO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueData;
import org.cyclos.model.system.fields.CustomFieldPossibleValueDataParams;
import org.cyclos.model.system.fields.CustomFieldPossibleValueQuery;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseCustomFieldPossibleValueServiceImpl<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, A extends EntityPath<PV>>
extends CRUDServiceImpl<PV, A, CustomFieldPossibleValueDTO, CustomFieldPossibleValueData, CustomFieldPossibleValueDataParams>
implements BaseCustomFieldPossibleValueServiceLocal<CF, C, PV> {
    private final Class<CF> customFieldClass;
    private final Class<C> possibleValueCategoryClass;
    private final EntityPath<CF> fieldPath;
    private final NumberPath<Long> fieldIdPath;
    private final EntityPathBase<C> categoryPath;
    private final NumberPath<Long> categoryIdPath;
    private final BooleanPath defaultValuePath;
    private final NumberPath<Integer> orderPath;
    private final NumberPath<Integer> categoryOrderPath;
    @Autowired
    private BeanHandler beanHandler;

    public BaseCustomFieldPossibleValueServiceImpl(Class<CF> clazz, Class<PV> clazz2, A a) {
        super(clazz2, a, CustomFieldPossibleValueDTO.class);
        this.customFieldClass = clazz;
        this.possibleValueCategoryClass = ((CustomField)ClassHelper.instantiate(clazz)).getPossibleValueCategoryClass();
        this.fieldPath = (EntityPath)MethodHelper.invoke(a, (String)CustomFieldPossibleValueDTO.FIELD.getName(), (Object[])new Object[0]);
        this.fieldIdPath = (NumberPath)FieldHelper.get(this.fieldPath, (String)CustomFieldDTO.ID.getName());
        this.categoryPath = (EntityPathBase)MethodHelper.invoke(a, (String)CustomFieldPossibleValueDTO.CATEGORY.getName(), (Object[])new Object[0]);
        this.categoryIdPath = (NumberPath)FieldHelper.get(this.categoryPath, (String)CustomFieldPossibleValueCategoryDTO.ID.getName());
        this.categoryOrderPath = (NumberPath)FieldHelper.get(this.categoryPath, (String)PropertyHelper.getPropertyName((Path)QCustomFieldPossibleValueCategory.customFieldPossibleValueCategory.order));
        this.defaultValuePath = (BooleanPath)FieldHelper.get(a, (String)CustomFieldPossibleValueDTO.DEFAULT_VALUE.getName());
        this.orderPath = (NumberPath)FieldHelper.get(a, (String)PropertyHelper.getPropertyName((Path)QCustomFieldPossibleValue.customFieldPossibleValue.order));
    }

    public Class<CF> getCustomFieldClass() {
        return this.customFieldClass;
    }

    public Class<C> getPossibleValueCategoryClass() {
        return this.possibleValueCategoryClass;
    }

    public void insert(CustomFieldVO customFieldVO, CustomFieldPossibleValueCategoryVO customFieldPossibleValueCategoryVO, List<String> list) throws FrameworkException {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.getCustomFieldClass(), (Object)customFieldVO);
        CustomFieldPossibleValueCategory customFieldPossibleValueCategory = (CustomFieldPossibleValueCategory)this.conversionHandler.convert(this.getPossibleValueCategoryClass(), (Object)customFieldPossibleValueCategoryVO);
        if (customField == null || CollectionHelper.isEmpty(list) || customFieldPossibleValueCategory != null && !customField.equals((Object)customFieldPossibleValueCategory.getField())) {
            throw new ValidationException();
        }
        boolean bl = false;
        boolean bl2 = customField.getType() == CustomFieldType.SINGLE_SELECTION;
        for (String string : list) {
            CustomFieldPossibleValueDTO customFieldPossibleValueDTO = new CustomFieldPossibleValueDTO();
            customFieldPossibleValueDTO.setField(new CustomFieldVO(customField.getId()));
            customFieldPossibleValueDTO.setCategory(customFieldPossibleValueCategory == null ? null : new CustomFieldPossibleValueCategoryVO(customFieldPossibleValueCategory.getId()));
            List list2 = StringHelper.splitTrimming((String)string, (String)";");
            if (list2.isEmpty()) continue;
            if (list2.size() == 1) {
                customFieldPossibleValueDTO.setValue(string);
            } else {
                customFieldPossibleValueDTO.setValue((String)list2.get(0));
                if (list2.size() > 3) {
                    customFieldPossibleValueDTO.setInternalName((String)list2.get(1));
                    customFieldPossibleValueDTO.setDefaultValue(((String)list2.get(2)).equalsIgnoreCase("true"));
                    customFieldPossibleValueDTO.setDefaultOnSearch(((String)list2.get(3)).equalsIgnoreCase("true"));
                } else {
                    boolean bl3 = ((String)list2.get(1)).equalsIgnoreCase("true");
                    boolean bl4 = ((String)list2.get(1)).equalsIgnoreCase("false");
                    if (list2.size() == 2) {
                        if (bl3 || bl4) {
                            customFieldPossibleValueDTO.setDefaultValue(bl3);
                        } else {
                            customFieldPossibleValueDTO.setInternalName((String)list2.get(1));
                        }
                    } else if (list2.size() == 3) {
                        if (bl3 || bl4) {
                            customFieldPossibleValueDTO.setDefaultValue(bl3);
                            customFieldPossibleValueDTO.setDefaultOnSearch(((String)list2.get(2)).equalsIgnoreCase("true"));
                        } else {
                            customFieldPossibleValueDTO.setInternalName((String)list2.get(1));
                            customFieldPossibleValueDTO.setDefaultValue(((String)list2.get(2)).equalsIgnoreCase("true"));
                        }
                    }
                }
            }
            if (customFieldPossibleValueDTO.isDefaultValue() && bl2) {
                if (bl) {
                    throw new ValidationException(this.message(SystemKeys.Fields.POSSIBLE_VALUE_ERROR_MORE_THAN_ONE_DEFAULT, new Object[0]));
                }
                bl = true;
            }
            Long l = this.save(customFieldPossibleValueDTO);
            CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)this.find(customField.getPossibleValueClass(), l);
            customField.getPossibleValues().add(customFieldPossibleValue);
        }
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        boolean bl2;
        CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)this.find(l);
        Long l2 = customFieldPossibleValue.getCategory() != null ? customFieldPossibleValue.getCategory().getId() : null;
        List list = ((DBQuery)((DBQuery)this.from().where(new Predicate[]{l2 == null ? this.categoryPath.isNull() : this.categoryIdPath.eq((Object)l2), this.fieldIdPath.eq((Object)customFieldPossibleValue.getField().getId())})).orderBy(this.orderPath.asc())).list((Expression)this.$);
        int n = list.indexOf(customFieldPossibleValue);
        boolean bl3 = bl2 = bl && n < 1 || !bl && n >= list.size() - 1;
        if (!bl2) {
            CustomFieldPossibleValue customFieldPossibleValue2 = (CustomFieldPossibleValue)list.get(bl ? n - 1 : n + 1);
            int n2 = customFieldPossibleValue.getOrder();
            customFieldPossibleValue.setOrder(customFieldPossibleValue2.getOrder());
            customFieldPossibleValue2.setOrder(Integer.valueOf(n2));
        }
    }

    @Override
    public PV newEntity(CustomFieldPossibleValueDataParams customFieldPossibleValueDataParams) {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.customFieldClass, (Object)customFieldPossibleValueDataParams.getCustomField());
        if (!customField.getType().isEnumerated()) {
            throw new IllegalActionException();
        }
        CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)this.beanHandler.instantiate(this.getEntityClass());
        customFieldPossibleValue.setField(customField);
        CustomFieldPossibleValueCategory customFieldPossibleValueCategory = (CustomFieldPossibleValueCategory)this.conversionHandler.convert(this.possibleValueCategoryClass, (Object)customFieldPossibleValueDataParams.getCategory());
        if (customFieldPossibleValueCategory != null) {
            if (!customField.equals((Object)customFieldPossibleValueCategory.getField())) {
                throw new EntityNotFoundException();
            }
            customFieldPossibleValue.setCategory(customFieldPossibleValueCategory);
        }
        return (PV)customFieldPossibleValue;
    }

    public Page<CustomFieldPossibleValueVO> search(CustomFieldPossibleValueQuery customFieldPossibleValueQuery) throws FrameworkException {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.customFieldClass, (Object)customFieldPossibleValueQuery.getField());
        CustomFieldPossibleValueCategory customFieldPossibleValueCategory = (CustomFieldPossibleValueCategory)this.conversionHandler.convert(this.possibleValueCategoryClass, (Object)customFieldPossibleValueQuery.getCategory());
        return ((DBQuery)((DBQuery)this.from().where(new Predicate[]{customField == null ? this.entityMetadata.getIdPath().isNull() : this.fieldIdPath.eq((Object)customField.getId()), customFieldPossibleValueCategory == null ? this.entityMetadata.getIdPath().isNotNull() : this.categoryIdPath.eq((Object)customFieldPossibleValueCategory.getId())})).orderBy(new OrderSpecifier[]{this.categoryOrderPath.asc().nullsFirst(), this.orderPath.asc()})).page(CustomFieldPossibleValueVO.class, (QueryParameters)customFieldPossibleValueQuery, (Expression)this.$);
    }

    public abstract boolean showDefaultOnSearch();

    @Override
    protected CustomFieldPossibleValueData getData(PV PV) {
        CustomFieldPossibleValueData customFieldPossibleValueData = new CustomFieldPossibleValueData();
        customFieldPossibleValueData.setDto((EntityDTO)((CustomFieldPossibleValueDTO)this.toDTO(PV)));
        CustomField customField = PV.getField();
        customFieldPossibleValueData.setCategories(this.conversionHandler.convertList(CustomFieldPossibleValueCategoryVO.class, (Iterable)customField.getPossibleValueCategories()));
        customFieldPossibleValueData.setShowDefaultOnSearch(this.showDefaultOnSearch() && PV.isPersistent());
        return customFieldPossibleValueData;
    }

    @Override
    protected void onAfterSave(PV PV, PV PV2, Object object) {
        CustomField customField = PV.getField();
        if (PV2 == null) {
            customField.getPossibleValues().add(PV);
        }
        if (customField.getType() == CustomFieldType.SINGLE_SELECTION && PV.isDefaultValue()) {
            List list = ((DBQuery)this.from().where(new Predicate[]{this.entityMetadata.getIdPath().ne((Object)PV.getId()), this.defaultValuePath.isTrue(), this.fieldIdPath.eq((Object)customField.getId())})).list((Expression)this.$);
            for (CustomFieldPossibleValue customFieldPossibleValue : list) {
                customFieldPossibleValue.setDefaultValue(false);
            }
        }
    }

    @Override
    protected Object onBeforeSave(PV PV, PV PV2) {
        if (PV.isTransient() || !Objects.equals(PV.getCategory(), PV2.getCategory())) {
            CustomFieldPossibleValueCategory customFieldPossibleValueCategory = PV.getCategory();
            Integer n = (Integer)((DBQuery)this.from().where(new Predicate[]{customFieldPossibleValueCategory == null ? this.categoryPath.isNull() : this.categoryIdPath.eq((Object)customFieldPossibleValueCategory.getId()), this.fieldIdPath.eq((Object)PV.getField().getId())})).singleResult((Expression)this.orderPath.max());
            PV.setOrder(Integer.valueOf(n == null ? 0 : n + 1));
        }
        return null;
    }

    @Override
    protected Validator resolveValidator(CustomFieldPossibleValueDTO customFieldPossibleValueDTO) {
        Validator validator = new Validator();
        if (customFieldPossibleValueDTO.isTransient()) {
            validator.property((Property)CustomFieldPossibleValueDTO.FIELD, SystemKeys.Fields.POSSIBLE_VALUE_CUSTOM_FIELD).required();
        }
        validator.property((Property)CustomFieldPossibleValueDTO.VALUE, SystemKeys.Fields.POSSIBLE_VALUE_VALUE).required().maxLength(250).add((PropertyValidation)new BasePropertyValidation(){

            protected boolean isValid(Object object, Object object2, Object object3) {
                String string = StringHelper.trimToNull((Object)object3);
                return string == null || !string.contains("|");
            }
        });
        final CustomField customField = (CustomField)this.conversionHandler.convert(this.customFieldClass, (Object)customFieldPossibleValueDTO.getField());
        if (customField != null) {
            validator.property((Property)CustomFieldPossibleValueDTO.CATEGORY, SystemKeys.Fields.POSSIBLE_VALUE_CATEGORY).entity(customField.getPossibleValueCategoryClass(), (EntityValidation)new BaseEntityValidation<C>(){

                protected boolean isValid(Object object, Object object2, C c) {
                    return customField.equals((Object)c.getField());
                }
            });
        }
        return validator;
    }
}

