/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage.utils;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.CyclosPropertiesFactoryBean;
import org.cyclos.bootstrap.ServicesConfiguration;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.QTransactionCustomField;
import org.cyclos.entities.marketplace.QAdCustomField;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.users.QContactCustomField;
import org.cyclos.entities.users.QContactInfoField;
import org.cyclos.entities.users.QRecordCustomField;
import org.cyclos.entities.users.QUserCustomField;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.storage.SaveStoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.storage.StoredFileTransactionEndListener;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class StoredFileContentMigrator {
    public static final String MIGRATOR_VERSION = "202504171348";
    private static final String BATCH_SIZE_PROPERTY_NAME = "batch.size";
    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final int BATCH_SIZE = Integer.parseInt(System.getProperty("batch.size", String.valueOf(200)));
    private static final String JOBS_PROPERTY_NAME = "jobs";
    private static final int JOBS = Integer.parseInt(System.getProperty("jobs", String.valueOf(Runtime.getRuntime().availableProcessors())));
    private static final int ARGS_COUNT = 1;
    private static final String STORAGE_DIRECTORIES = "cyclos.storedFileContentManager.directories";
    private AnnotationConfigApplicationContext appCtx;
    private ExecutorService executor = Executors.newFixedThreadPool(JOBS);
    private RawEntityManagerHandler rawEntityManagerHandler;
    private StoredFileHandler storedFileHandler;
    private InvokerHandler invokerHandler;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private StoredFileContentManager currentStoredFileContentManager;
    private StoredFileContentManager newStoredFileContentManager;
    private String currentStoredFileContentManagerName;
    private String newStoredFileContentManagerName;
    private String storageDirectories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        StoredFileContentMigrator storedFileContentMigrator = new StoredFileContentMigrator();
        System.out.printf("%nStored file migrator utility version %s.%n", MIGRATOR_VERSION);
        boolean bl = true;
        try {
            storedFileContentMigrator.initialize(stringArray);
            storedFileContentMigrator.currentStoredFileContentManager.testConnection();
            storedFileContentMigrator.newStoredFileContentManager.testConnection();
            if (storedFileContentMigrator.confirm()) {
                boolean bl2;
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                System.out.printf("Starting migration with %d jobs and batch size %d%n", JOBS, BATCH_SIZE);
                MigrateResult migrateResult = new MigrateResult();
                int n = 0;
                do {
                    if (++n > 1 && migrateResult.hasErrors()) {
                        System.out.println("Retrying failed migrations");
                    }
                    MigrateResult migrateResult2 = storedFileContentMigrator.run();
                    bl2 = migrateResult2.migrated == 0 && (migrateResult2.failed.isEmpty() || migrateResult.failed.containsAll(migrateResult2.failed));
                    migrateResult = migrateResult2;
                } while (!bl2);
                bl = migrateResult.hasErrors();
                if (bl) {
                    if (migrateResult.failed.isEmpty()) {
                        System.out.println("Stopping migration because a general error has occurred");
                    } else {
                        System.out.printf("Stopping migration because all stored files were processed, but some of them resulted in error: %n%s%n", StringHelper.join((Collection)CollectionHelper.sort(migrateResult.failed), (String)", "));
                    }
                } else {
                    if (storedFileContentMigrator.currentStoredFileContentManager.supportStorageDirectories() && !storedFileContentMigrator.newStoredFileContentManager.supportStorageDirectories()) {
                        storedFileContentMigrator.resetStorageDirectory();
                    }
                    System.out.printf("Took %s%n", stopWatch);
                    System.out.printf("%nThe migration has finished sucessfully!%n%nIMPORTANT: %s", storedFileContentMigrator.getBottomHelp());
                }
            } else {
                System.out.println("The migration was canceled.");
            }
        }
        catch (Exception exception) {
            System.out.println("Error migrating file contents:");
            exception.printStackTrace();
        }
        finally {
            storedFileContentMigrator.finish(bl);
        }
    }

    private static String getCyclosPropertiesFileName(boolean bl) {
        String string = CyclosPropertiesFactoryBean.getCyclosPropertiesFileName("cyclos.properties");
        return bl ? StringUtils.removeStart((String)string, (String)"/") : string;
    }

    protected void migrate(StoredFile storedFile) {
        Object object = this.currentStoredFileContentManager.getMetadata(storedFile);
        if (object == null) {
            throw new IgnoredStoredFileException();
        }
        try (SerializableInputStream serializableInputStream = this.currentStoredFileContentManager.open(object);){
            String string = this.storedFileHandler.getStorageDirectory(storedFile);
            SaveStoredFileContentAction saveStoredFileContentAction = this.newStoredFileContentManager.store(string, serializableInputStream);
            this.newStoredFileContentManager.setMetadata(storedFile, saveStoredFileContentAction.metadata());
        }
        catch (IOException | StoredFileException throwable) {
            System.out.printf("WARN: Stored file with id %s had an invalid content and will be ignored%n", storedFile.getId());
        }
        this.currentStoredFileContentManager.remove(object);
    }

    private void addMigratedColumn() {
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                String string = "alter table stored_files add column migrated boolean";
                this.jdbcTemplate.execute(string);
                return null;
            });
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    private boolean confirm() {
        if (this.storageDirectories != null && !this.newStoredFileContentManager.supportStorageDirectories()) {
            System.out.printf("WARN: The new storage does not support storage directories but the '%s' property is%ndefined with the values: %s. They will be ignored!%n", STORAGE_DIRECTORIES, this.storageDirectories);
        } else if (this.storageDirectories == null && this.newStoredFileContentManager.supportStorageDirectories()) {
            System.out.printf("WARN: The new storage supports storage directories but the '%s' property is NOT defined.%nIgnore this message if you really do not want to store files in directories other than the default one.%n", STORAGE_DIRECTORIES);
        }
        System.out.printf("Confirm migrate from '%s' to '%s'? [Y/n] ", this.currentStoredFileContentManagerName, this.newStoredFileContentManagerName);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = bufferedReader.readLine();
            return StringUtils.isEmpty((CharSequence)string) || "y".equals(string.toLowerCase());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unknown I/O error asking for confirmation", iOException);
        }
    }

    private void finish(boolean bl) {
        if (!bl) {
            this.removeMigratedColumn();
        }
        this.executor.shutdown();
        if (this.appCtx != null) {
            this.appCtx.close();
        }
    }

    private String getBottomHelp() {
        String string = StoredFileContentMigrator.getCyclosPropertiesFileName(true);
        return String.format("PLEASE DO NOT FORGET TO CHANGE the value of the property '%s'%nin the '%s' file to the new storage%s.%n", "cyclos.storedFileContentManager", string, this.newStoredFileContentManagerName == null ? "" : ": " + this.newStoredFileContentManagerName);
    }

    private String getPropertyValue(String string, String string2) {
        if (string2.contains(string + " ") || string2.contains(string + "=")) {
            return StringUtils.removeStart((String)StringUtils.substringAfter((String)string2, (String)string).trim(), (String)"=").trim();
        }
        return null;
    }

    private String getPropertyValueIfNotDefined(String string, String string2, String string3, String string4, Supplier<String> supplier) {
        String string5 = this.getPropertyValue(string, string3);
        if (string5 != null) {
            if (string2 == null) {
                return string5;
            }
            throw new RuntimeException(String.format("The property %s is defined more than once in the file %s. %s", string, StringUtils.removeStart((String)string4, (String)"/"), supplier == null ? "" : supplier.get()));
        }
        return string2;
    }

    private void initialize(String[] stringArray) throws IOException {
        String string;
        Set set = CyclosProperties.getStoredFileContentManagers().keySet();
        Object object = null;
        if (stringArray.length == 0) {
            this.showHelp();
            System.exit(1);
        } else {
            if (stringArray.length != 1) {
                String string2 = StringUtils.join(set, (String)" | ");
                throw new RuntimeException(String.format("Invalid arguments count. Expected argument: %s | <fully-qualified-class-name>", string2));
            }
            string = StoredFileContentMigrator.getCyclosPropertiesFileName(false);
            try (Object object2 = this.getClass().getResourceAsStream(string);){
                if (object2 == null) {
                    throw new FileNotFoundException(string);
                }
                LineIterator lineIterator = IOUtils.lineIterator((InputStream)object2, (String)"utf-8");
                while (lineIterator.hasNext()) {
                    String string3 = lineIterator.nextLine().trim();
                    if (string3.startsWith("#")) continue;
                    this.currentStoredFileContentManagerName = this.getPropertyValueIfNotDefined("cyclos.storedFileContentManager", this.currentStoredFileContentManagerName, string3, string, () -> "It must be defined only once with the value of the current implementation from were the content will be migrated");
                    this.storageDirectories = this.getPropertyValueIfNotDefined(STORAGE_DIRECTORIES, this.storageDirectories, string3, string, null);
                }
            }
            this.newStoredFileContentManagerName = object2 = stringArray[0];
            object = set.contains(object2) ? (String)CyclosProperties.getStoredFileContentManagers().get(object2) : object2;
            if (StringHelper.isBlank((Object)this.currentStoredFileContentManagerName)) {
                System.out.printf("Missing property: '%s'. It must be configured with the value of the CURRENT storage.%n%n", "cyclos.storedFileContentManager");
                this.showHelp();
                System.exit(1);
            }
            if (this.currentStoredFileContentManagerName.equals(this.newStoredFileContentManagerName)) {
                System.out.printf("Cannot migrate from / to the same storage '%s'.%n%n", this.currentStoredFileContentManagerName);
                System.exit(1);
            }
        }
        System.setProperty("cyclos.db.managed", "false");
        System.setProperty("cyclos.maxRecurringTasks", "0");
        System.setProperty("cyclos.maxBackgroundTasks", "0");
        System.setProperty("cyclos.skipInitializations", "true");
        System.setProperty("cyclos.ignoreDatabaseLock", "true");
        System.setProperty("cyclos.skipStorageLocks", "true");
        this.appCtx = new AnnotationConfigApplicationContext();
        this.appCtx.register(new Class[]{BootstrapConfiguration.class, ServicesConfiguration.class});
        this.appCtx.refresh();
        string = (BeanHandler)this.appCtx.getBean(BeanHandler.class);
        try {
            this.newStoredFileContentManager = StoredFileContentManagerWrapper.wrap((StoredFileContentManager)string.getBean(StoredFileContentManager.class, (String)object));
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Invalid (or not properly configured) %s implementation: %s", StoredFileContentManager.class.getName(), object), exception);
        }
        this.rawEntityManagerHandler = (RawEntityManagerHandler)this.appCtx.getBean(RawEntityManagerHandler.class);
        this.invokerHandler = (InvokerHandler)this.appCtx.getBean(InvokerHandler.class);
        this.jdbcTemplate = (JdbcTemplate)this.appCtx.getBean(JdbcTemplate.class);
        this.transactionTemplate = (TransactionTemplate)this.appCtx.getBean(TransactionTemplate.class);
        this.storedFileHandler = (StoredFileHandler)this.appCtx.getBean(StoredFileHandler.class);
        this.currentStoredFileContentManager = StoredFileContentManagerWrapper.wrap((StoredFileContentManager)this.appCtx.getBean(StoredFileContentManager.class));
        this.initializeDbSchema();
    }

    private void initializeDbSchema() {
        this.addMigratedColumn();
    }

    private List<Long> listIds() {
        String string = "select id from stored_files where migrated is false or migrated is null";
        return this.jdbcTemplate.queryForList(string, Long.class);
    }

    private void removeMigratedColumn() {
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                String string = "alter table stored_files drop column migrated";
                this.jdbcTemplate.execute(string);
                return null;
            });
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    private void resetStorageDirectory() {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            this.rawEntityManagerHandler.update((EntityPath)QAdCustomField.adCustomField).setNull((Path)QAdCustomField.adCustomField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QContactCustomField.contactCustomField).setNull((Path)QContactCustomField.contactCustomField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QContactInfoField.contactInfoField).setNull((Path)QContactInfoField.contactInfoField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QRecordCustomField.recordCustomField).setNull((Path)QRecordCustomField.recordCustomField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QTransactionCustomField.transactionCustomField).setNull((Path)QTransactionCustomField.transactionCustomField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QUserCustomField.userCustomField).setNull((Path)QUserCustomField.userCustomField.storageDirectory).execute();
            this.rawEntityManagerHandler.update((EntityPath)QConfiguration.configuration).setNull((Path)QConfiguration.configuration.individualDocumentDirectory).execute();
            return null;
        });
    }

    private MigrateResult run() {
        List list = (List)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> this.listIds());
        MigrateResult migrateResult = new MigrateResult();
        if (!list.isEmpty()) {
            Object object;
            int n;
            int n2 = (int)Math.ceil((double)list.size() / (double)BATCH_SIZE);
            System.out.printf("Migrating %d stored files%n", list.size());
            ArrayList<Future<MigrateResult>> arrayList = new ArrayList<Future<MigrateResult>>(n2);
            for (n = 0; n < n2; ++n) {
                int n3 = n;
                int n4 = n * BATCH_SIZE;
                object = list.subList(n4, Math.min(list.size(), n4 + BATCH_SIZE));
                arrayList.add(this.executor.submit(() -> this.lambda$run$5(n3, n2, (List)object)));
            }
            for (n = 0; n < n2; ++n) {
                MigrateResult migrateResult2;
                Future future = (Future)arrayList.get(n);
                try {
                    migrateResult2 = (MigrateResult)future.get();
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof Exception) {
                        object = (Exception)exception.getCause();
                    }
                    System.out.printf("Error on batch %d: %s%n", n, object);
                    ((Throwable)object).printStackTrace();
                    migrateResult2 = new MigrateResult(true);
                }
                migrateResult.add(migrateResult2);
            }
        }
        return migrateResult;
    }

    private MigrateResult runBatch(int n, int n2, List<Long> list) {
        return (MigrateResult)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            String string = "select * from stored_files where migrated is false or migrated is null and id in (" + StringHelper.join((Collection)list, (String)",") + ")";
            List list2 = this.rawEntityManagerHandler.getEntityManager().createNativeQuery(string, StoredFile.class).getResultList();
            HashSet<Long> hashSet = new HashSet<Long>();
            HashSet hashSet2 = new HashSet();
            list2.forEach(storedFile -> {
                try {
                    this.migrate((StoredFile)storedFile);
                }
                catch (IgnoredStoredFileException ignoredStoredFileException) {
                    hashSet2.add(storedFile.getId());
                }
                catch (Exception exception) {
                    System.out.printf("Error migrating stored file with id %s: %s%n", storedFile.getId(), exception);
                    hashSet.add(storedFile.getId());
                }
            });
            List list3 = list2.stream().map(SimpleEntity::getId).filter(l -> !hashSet.contains(l)).collect(Collectors.toList());
            if (!list3.isEmpty()) {
                String string2 = "update stored_files set migrated = true where id in (" + StringHelper.join(list3, (String)",") + ")";
                this.jdbcTemplate.update(string2);
            }
            list3.removeAll(hashSet2);
            System.out.printf("Finished batch %d of %d with %d migrated and %d failed in %s%n", n + 1, n2, list3.size(), hashSet.size(), stopWatch);
            return new MigrateResult(list3.size(), hashSet);
        });
    }

    private void showHelp() {
        String string = StringUtils.join(CyclosProperties.getStoredFileContentManagers().keySet(), (String)" | ");
        System.out.printf("Usage (from the <TOMCAT_DIR>/webapps/<cyclos_dir> folder):%n    java [-D%s=<number_of_threads>] [-D%s=<rows_per_transaction>] -cp \"WEB-INF/classes:../../lib/*:WEB-INF/lib/*\" %s %s%n%n    where %s is: %s | <fully-qualified-class-name>(*)%n    (*) It must be an implementation of %s%n%n    The system property '%s' specifies how many parallel threads will be used. Default: %d%n    The system property '%s' specifies how many contents will be migrated per transaction. Default: %d%n%n", JOBS_PROPERTY_NAME, BATCH_SIZE_PROPERTY_NAME, StoredFileContentMigrator.class.getName(), "<new_storage>", "<new_storage>", string, StoredFileContentManager.class.getName(), JOBS_PROPERTY_NAME, JOBS, BATCH_SIZE_PROPERTY_NAME, 200);
        String string2 = StoredFileContentMigrator.getCyclosPropertiesFileName(true);
        System.out.printf("To run the migrator you must have configured in the '%s' file the required properties for both storages,%nthe current (to read the content from) and the new one to be used (to write the content to).%nThe property '%s' must be configured only once with the value of the CURRENT storage.%n%n* It is strongly recommended to CREATE A BACKUP of the database before start the migration.%n%n* After the migration has finished %s", string2, "cyclos.storedFileContentManager", this.getBottomHelp());
    }

    private /* synthetic */ MigrateResult lambda$run$5(int n, int n2, List list) throws Exception {
        return this.runBatch(n, n2, list);
    }

    private static class MigrateResult {
        private int migrated;
        private Set<Long> failed;
        boolean error;

        public MigrateResult() {
            this.migrated = 0;
            this.failed = new HashSet<Long>();
            this.error = false;
        }

        private MigrateResult(boolean bl) {
            this();
            this.error = bl;
        }

        private MigrateResult(int n, Set<Long> set) {
            this.migrated = n;
            this.failed = set;
        }

        private void add(MigrateResult migrateResult) {
            this.migrated += migrateResult.migrated;
            this.failed.addAll(migrateResult.failed);
            this.error |= migrateResult.error;
        }

        private boolean hasErrors() {
            return this.error || !this.failed.isEmpty();
        }
    }

    private class IgnoredStoredFileException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private IgnoredStoredFileException() {
        }
    }

    private static class StoredFileContentManagerWrapper
    implements StoredFileContentManager {
        private StoredFileContentManager target;

        private static StoredFileContentManager wrap(StoredFileContentManager storedFileContentManager) {
            return new StoredFileContentManagerWrapper(storedFileContentManager);
        }

        private StoredFileContentManagerWrapper(StoredFileContentManager storedFileContentManager) {
            this.target = storedFileContentManager;
        }

        public SaveStoredFileContentAction copy(String string, Object object) throws StoredFileException {
            throw new UnsupportedOperationException();
        }

        public String getKey(StoredFile storedFile) throws StoredFileException {
            return this.target.getKey(storedFile);
        }

        public Object getMetadata(StoredFile storedFile) throws StoredFileException {
            return this.target.getMetadata(storedFile);
        }

        public boolean isStoredOnDB() {
            return this.target.isStoredOnDB();
        }

        public SerializableInputStream open(Object object) throws StoredFileException {
            return this.target.open(object);
        }

        public StoredFileContentAction remove(Object object) throws StoredFileException {
            StoredFileContentAction storedFileContentAction = this.target.remove(object);
            StoredFileTransactionEndListener.addFor(storedFileContentAction);
            return storedFileContentAction;
        }

        public boolean requiresPersistentStoredFileToSetMetadata() {
            return this.target.requiresPersistentStoredFileToSetMetadata();
        }

        public void setMetadata(StoredFile storedFile, Object object) throws StoredFileException {
            this.target.setMetadata(storedFile, object);
        }

        public SaveStoredFileContentAction store(String string, SerializableInputStream serializableInputStream) throws StoredFileException {
            SaveStoredFileContentAction saveStoredFileContentAction = this.target.store(string, serializableInputStream);
            StoredFileTransactionEndListener.addFor((StoredFileContentAction)saveStoredFileContentAction);
            return saveStoredFileContentAction;
        }

        public boolean supportStorageDirectories() {
            return this.target.supportStorageDirectories();
        }

        public void testConnection() throws StoredFileException {
            this.target.testConnection();
        }
    }
}

