/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.storage;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.cyclos.entities.contentmanagement.DocumentFile;
import org.cyclos.entities.contentmanagement.UserDocument;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempFile;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.storage.StoredFileContentManager;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.storage.StoredFileTransactionEndListener;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.contentmanagement.documents.DocumentNature;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StoredFileHandlerImpl
extends BaseNetworkedHandlerImpl
implements StoredFileHandler {
    protected static final long TIMEOUT_MILLIS = 3600000L;
    @Autowired
    private StoredFileContentManager storedFileContentManager;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private ImageHandler imageHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    private Set<String> storageDirectories;
    private boolean nullMetadataMesgWasShown;

    public final void copy(StoredFile storedFile, StoredFile storedFile2) throws StoredFileException {
        this.copyOrMove(storedFile, storedFile2, false);
    }

    public BooleanExpression customFieldEquals(EntityPath<?> entityPath, CustomField<?, ?, ?> customField) {
        if (customField != null) {
            for (Method method : entityPath.getClass().getMethods()) {
                EntityPathBase entityPathBase;
                if (!EntityPathBase.class.isAssignableFrom(method.getReturnType()) || !(entityPathBase = (EntityPathBase)MethodHelper.invoke(entityPath, (String)method.getName(), (Object[])new Object[0])).getType().isInstance(customField)) continue;
                return entityPathBase.eq(customField);
            }
        }
        return null;
    }

    public final <T extends StoredFile> T find(Class<T> clazz, long l) throws EntityNotFoundException {
        return (T)((StoredFile)super.find(clazz, l));
    }

    public byte[] getBytes(StoredFile storedFile) throws StoredFileException, EntityNotFoundException {
        byte[] byArray;
        block8: {
            SerializableInputStream serializableInputStream = this.getContent(storedFile);
            try {
                byArray = IOUtils.toByteArray((InputStream)serializableInputStream);
                if (serializableInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serializableInputStream != null) {
                        try {
                            serializableInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new StoredFileException("Error reading bytes from input", (Throwable)iOException);
                }
            }
            serializableInputStream.close();
        }
        return byArray;
    }

    public SerializableInputStream getContent(StoredFile storedFile) throws StoredFileException, EntityNotFoundException {
        Object object;
        this.checkPersistent(storedFile);
        if (!SKIP_LOCK) {
            object = this.storedFileContentManager.getKey(storedFile);
            try {
                this.lockHandler.lock(LockType.STORED_FILE.key((String)object), 3600000L);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                throw new StoredFileException("Error waiting for content availability (key = " + (String)object + ")", (Throwable)lockAcquisitionException);
            }
        }
        if ((object = this.storedFileContentManager.getMetadata(storedFile)) == null) {
            this.showNullMetadataMessage();
            return new SerializableInputStream(new byte[0]);
        }
        return this.storedFileContentManager.open(object);
    }

    public Set<String> getStorageDirectories() {
        if (!this.storedFileContentManager.supportStorageDirectories()) {
            return Collections.emptySet();
        }
        if (this.storageDirectories == null) {
            this.storageDirectories = StoredFileHandler.getStorageDirectories((CyclosProperties)this.cyclosProperties);
        }
        return this.storageDirectories;
    }

    public String getStorageDirectory(StoredFile storedFile) {
        if (storedFile instanceof DocumentFile) {
            DocumentFile documentFile = (DocumentFile)storedFile;
            UserDocument userDocument = documentFile.getDocument().getNature() == DocumentNature.USER ? (UserDocument)documentFile.getDocument() : null;
            return userDocument == null ? null : this.configurationHandler.getAccessor((BasicUser)userDocument.getUser()).getIndividualDocumentDirectory();
        }
        if (storedFile instanceof CustomFieldValueFile) {
            return ((CustomFieldValueFile)storedFile).getCustomFieldValue().getField().getStorageDirectory();
        }
        if (storedFile instanceof CustomFieldValueImage) {
            return ((CustomFieldValueImage)storedFile).getCustomFieldValue().getField().getStorageDirectory();
        }
        if (storedFile instanceof TempImage) {
            CustomField customField = ((TempImage)storedFile).getCustomField();
            return customField == null ? null : customField.getStorageDirectory();
        }
        if (storedFile instanceof TempFile) {
            CustomField customField = ((TempFile)storedFile).getCustomField();
            return customField == null ? null : customField.getStorageDirectory();
        }
        return null;
    }

    @PostConstruct
    public void initialize() {
        this.storedFileContentManager.testConnection();
    }

    public boolean isStoredOnDB() {
        return this.storedFileContentManager.isStoredOnDB();
    }

    public final void move(StoredFile storedFile, StoredFile storedFile2) throws StoredFileException {
        this.copyOrMove(storedFile, storedFile2, true);
    }

    public final void remove(long l) throws StoredFileException, EntityNotFoundException {
        this.doRemove(this.find((Class<T>)StoredFile.class, l), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(StoredFile storedFile, SerializableInputStream serializableInputStream) throws StoredFileException {
        Object object;
        if (storedFile.isTransient()) {
            this.persist((IEntity)storedFile);
        } else {
            object = this.storedFileContentManager.getMetadata(storedFile);
            if (object != null) {
                StoredFileContentAction storedFileContentAction = this.storedFileContentManager.remove(object);
                StoredFileTransactionEndListener.addFor(storedFileContentAction);
            }
        }
        try {
            object = this.storedFileContentManager.store(this.getStorageDirectory(storedFile), serializableInputStream);
            StoredFileTransactionEndListener.addFor((StoredFileContentAction)object);
            this.storedFileContentManager.setMetadata(storedFile, object.metadata());
        }
        finally {
            IOHelper.close((Closeable)serializableInputStream);
        }
    }

    public StoredFileContentManager setStoredFileContentManager(StoredFileContentManager storedFileContentManager) {
        StoredFileContentManager storedFileContentManager2 = this.storedFileContentManager;
        this.storedFileContentManager = storedFileContentManager;
        return storedFileContentManager2;
    }

    public boolean supportStorageDirectories() {
        return this.storedFileContentManager.supportStorageDirectories();
    }

    private void checkPersistent(StoredFile storedFile) throws EntityNotFoundException {
        if (storedFile == null || storedFile.isTransient()) {
            throw new EntityNotFoundException(StoredFile.class);
        }
    }

    private void copyData(StoredFile storedFile, StoredFile storedFile2, boolean bl) {
        storedFile2.setContentType(storedFile.getContentType());
        storedFile2.setLastModified(storedFile.getLastModified());
        storedFile2.setLength(storedFile.getLength());
        storedFile2.setName(storedFile.getName());
        if (storedFile instanceof Image && storedFile2 instanceof Image) {
            Image image = (Image)storedFile;
            Image image2 = (Image)storedFile2;
            image2.setWidth(image.getWidth());
            image2.setHeight(image.getHeight());
            if (bl) {
                image2.setKey(image.getKey());
            } else if (image2.getKey() == null || image2.getKey().equals(image.getKey())) {
                image2.setKey(this.imageHandler.newKey());
            }
            image2.setConvertedToJpeg(image.isConvertedToJpeg());
        }
    }

    private void copyOrMove(StoredFile storedFile, StoredFile storedFile2, boolean bl) throws StoredFileException {
        Object object;
        Object object2;
        Object object3;
        this.checkPersistent(storedFile);
        this.copyData(storedFile, storedFile2, bl);
        String string = this.storedFileContentManager.getKey(storedFile);
        try {
            this.lockHandler.lock(LockType.STORED_FILE.key(string), 3600000L);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            throw new StoredFileException("Error waiting for content availability (key = " + string + ")", (Throwable)lockAcquisitionException);
        }
        if (bl) {
            object3 = this.storedFileContentManager.getMetadata(storedFile);
            this.remove((IEntity)storedFile);
        } else {
            object2 = this.storedFileContentManager.getMetadata(storedFile);
            object = this.storedFileContentManager.copy(this.getStorageDirectory(storedFile), object2);
            StoredFileTransactionEndListener.addFor((StoredFileContentAction)object);
            object3 = object.metadata();
        }
        object2 = () -> this.storedFileContentManager.setMetadata(storedFile2, object3);
        if (storedFile2.isTransient()) {
            boolean bl2 = this.storedFileContentManager.requiresPersistentStoredFileToSetMetadata();
            if (!bl2) {
                object2.run();
            } else {
                storedFile2.setMetadata(null);
            }
            this.persist((IEntity)storedFile2);
            if (bl2) {
                object2.run();
            }
        } else {
            object = this.storedFileContentManager.getMetadata(storedFile2);
            if (object != null) {
                StoredFileContentAction storedFileContentAction = this.storedFileContentManager.remove(object);
                StoredFileTransactionEndListener.addFor(storedFileContentAction);
            }
            object2.run();
        }
    }

    private void doRemove(StoredFile storedFile, Object object) throws StoredFileException, EntityNotFoundException {
        object = object == null ? this.storedFileContentManager.getMetadata(storedFile) : object;
        StoredFileContentAction storedFileContentAction = this.storedFileContentManager.remove(object);
        StoredFileTransactionEndListener.addFor(storedFileContentAction);
        this.remove((IEntity)storedFile);
    }

    private void showNullMetadataMessage() {
        if (this.nullMetadataMesgWasShown) {
            return;
        }
        this.getLogger().warn("Could not read the stored file content: null metadata. This could be caused because a misconfigured value for the property 'cyclos.storedFileContentManager'");
        this.nullMetadataMesgWasShown = true;
    }
}

