/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql.querydsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.search.SearchHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.sql.postgresql.fulltext.FullTextQuery;
import org.cyclos.impl.sql.postgresql.fulltext.FullTextQueryHelper;
import org.cyclos.impl.sql.postgresql.querydsl.TsQueryOperation;
import org.cyclos.impl.sql.postgresql.querydsl.TsQueryOperator;

public abstract class TsQueryExpression
extends SimpleExpression<TsQueryExpression> {
    private static final long serialVersionUID = 1L;

    public static TsQueryExpression of(String string) {
        FullTextQuery fullTextQuery = TsQueryExpression.toQuery(string);
        Expression<String> expression = TsQueryExpression.queryExpression(fullTextQuery.getQuery());
        return new TsQueryOperation(TsQueryOperator.TO_TSQUERY, expression);
    }

    public static FullTextQuery toQuery(String string) {
        NativeQueryHandler nativeQueryHandler = (NativeQueryHandler)InvocationContext.bean(NativeQueryHandler.class);
        SearchHandler searchHandler = nativeQueryHandler.getSearchHandler();
        FullTextQuery fullTextQuery = FullTextQueryHelper.parse(string, searchHandler.isPhraseSearchSupported());
        return fullTextQuery;
    }

    public static TsQueryExpression wrap(final Expression<TsQueryExpression> expression) {
        return new TsQueryExpression(expression){
            private static final long serialVersionUID = 1L;

            public <R, C> R accept(Visitor<R, C> visitor, C c) {
                return (R)expression.accept(visitor, c);
            }
        };
    }

    private static Expression<String> queryExpression(String string) {
        string = StringUtils.replace((String)string, (String)"''", (String)"'");
        return Expressions.constant((Object)string);
    }

    public TsQueryExpression(Expression<TsQueryExpression> expression) {
        super(expression);
    }
}

