/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql.postgresql;

import org.cyclos.CyclosVersion;
import org.cyclos.impl.sql.BaseDbLockHandlerImpl;
import org.cyclos.impl.sql.DbLock;
import org.cyclos.utils.CollectionHelper;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PostgresqlLockHandlerImpl
extends BaseDbLockHandlerImpl {
    public PostgresqlLockHandlerImpl(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public void keepalive(String string) {
        this.jdbcTemplate.update("update db_lock set updated_at = now(), host=?", new Object[]{string});
    }

    public void prepare() {
        this.jdbcTemplate.execute("create table if not exists db_lock ( id integer primary key, version integer not null, host varchar(255) not null, cyclos_version varchar(255) not null, updated_at timestamp with time zone not null)");
    }

    public void unlock() {
        this.jdbcTemplate.update("delete from db_lock");
    }

    @Override
    protected void create(String string) {
        this.jdbcTemplate.update(" insert into db_lock (id, version, host, cyclos_version, updated_at) values (1, 0, ?, ?, now())", new Object[]{string, CyclosVersion.get()});
    }

    @Override
    protected DbLock doRead() {
        return (DbLock)CollectionHelper.first((Iterable)this.jdbcTemplate.query(" select id, version, host, cyclos_version, updated_at, floor(extract(epoch from (now() - updated_at))) as seconds from db_lock", (RowMapper)new BeanPropertyRowMapper(DbLock.class)));
    }

    @Override
    protected boolean update(String string, int n) {
        return this.jdbcTemplate.update(" update db_lock set host = ?, version = version + 1, updated_at = now() where version = ?", new Object[]{string, n}) > 0;
    }
}

