/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.cyclos.entities.users.InviteToken;
import org.cyclos.entities.users.QInviteToken;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.InviteServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.EmailValidation;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.invite.SendInviteMessageDTO;
import org.cyclos.model.messaging.invite.SendInviteMessageData;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InviteServiceImpl
extends BaseServiceImpl
implements InviteServiceLocal {
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public SendInviteMessageData getSendData() {
        SendInviteMessageData sendInviteMessageData = new SendInviteMessageData();
        SendInviteMessageDTO sendInviteMessageDTO = new SendInviteMessageDTO();
        sendInviteMessageData.setBody(this.getBody(null));
        sendInviteMessageData.setSubject(this.getSubject());
        sendInviteMessageData.setMaxRecipients(this.getMaxRecipients());
        sendInviteMessageData.setDto(sendInviteMessageDTO);
        sendInviteMessageDTO.setAssignBroker(this.isBroker());
        return sendInviteMessageData;
    }

    public InviteToken inviteToken(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        QInviteToken qInviteToken = QInviteToken.inviteToken;
        return (InviteToken)((DBQuery)this.from(new EntityPath[]{qInviteToken}).where((Predicate)qInviteToken.token.eq((Object)string.trim()))).singleResult((Expression)qInviteToken);
    }

    public void send(SendInviteMessageDTO sendInviteMessageDTO) {
        this.validate(sendInviteMessageDTO);
        SessionData sessionData = this.getSessionData();
        HashSet hashSet = new HashSet(sendInviteMessageDTO.getToEmails());
        hashSet.forEach(string -> {
            InviteToken inviteToken = new InviteToken();
            inviteToken.setBy(sessionData.getLoggedBasicUser());
            inviteToken.setEmail(string);
            if (sessionData.isBroker() && sendInviteMessageDTO.isAssignBroker()) {
                inviteToken.setBroker(sessionData.getLoggedUser());
            }
            inviteToken.setToken(StringHelper.randomAlphanumeric((int)32));
            inviteToken.setDate(new Date());
            this.persist((IEntity)inviteToken);
            this.mailHandler.send(null, string, this.getSubject(), this.getBody(inviteToken), new FileInfo[0]);
        });
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QInviteToken.inviteToken.network());
    }

    private String getBody(InviteToken inviteToken) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        String string = configurationAccessor.getApplicationName();
        String string2 = configurationAccessor.getEmailName();
        String string3 = inviteToken == null ? this.linkGeneratorHandler.root(null) : this.linkGeneratorHandler.invite(inviteToken);
        String string4 = sessionData.isAdmin() ? this.message(MessageFormat.HTML, ContentManagementKeys.Emails.INVITE_EXTERNAL_USER_BODY_ADMIN, string, string3, string2) : this.message(MessageFormat.HTML, ContentManagementKeys.Emails.INVITE_EXTERNAL_USER_BODY_MEMBER, sessionData.getLoggedUser().getName(), string, string3, string2);
        return string4;
    }

    private int getMaxRecipients() {
        return this.getSessionData().getProducts().product().getMaxInvitationRecipients();
    }

    private String getSubject() {
        String string = this.getConfiguration().getApplicationName();
        MessageKey messageKey = ContentManagementKeys.Emails.INVITE_EXTERNAL_USER_SUBJECT;
        return this.message(messageKey, string);
    }

    private void validate(SendInviteMessageDTO sendInviteMessageDTO) {
        SessionData sessionData = this.getSessionData();
        Validator validator = new Validator();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)SendInviteMessageDTO.TO_EMAILS, MessagingKeys.Messages.TO_EMAILS).required().maxElements(this.getMaxRecipients());
        CollectionHelper.orEmpty((List)sendInviteMessageDTO.getToEmails()).forEach(string -> {
            UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
            userRegistrationDTO.setEmail(string);
            property.add((object, object2, object3) -> {
                if (!EmailValidation.isValid((String)string)) {
                    return new ValidationError(MessagingKeys.Invite.ERROR_EMAIL_INVALID, new Object[]{string});
                }
                if (this.basicUserService.uniqueEmailQuery(sessionData.getNetwork(), (BasicUserDTO)userRegistrationDTO).hasResults()) {
                    return new ValidationError(MessagingKeys.Invite.ERROR_EMAIL_USED, new Object[]{string});
                }
                return null;
            });
        });
        this.validate(validator, sendInviteMessageDTO, "sendInviteMessageDTO");
    }
}

