/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.QProductAdField;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicAdConverter
extends BaseEntityConverter<BasicAd> {
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private AdServiceLocal adService;

    public BasicAdConverter() {
        super(BasicAd.class);
    }

    @Override
    protected void fill(Object object, BasicAd basicAd, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof BasicAdDTO) {
            objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.STATUS);
            BasicAdDTO basicAdDTO = (BasicAdDTO)object;
            if (ObjectHelper.isOneOf((Object)basicAdDTO.getStatus(), (Object[])new Object[]{AdStatus.EXPIRED, AdStatus.SCHEDULED, AdStatus.DISABLED})) {
                basicAd.setStatus(AdStatus.ACTIVE);
            } else {
                basicAd.setStatus(basicAdDTO.getStatus());
            }
            User user = basicAd.getOwner();
            if (user == null) {
                user = (User)this.conversionHandler.convert(User.class, basicAdDTO.getOwner());
            }
            if (user != null) {
                List list = this.adCustomFieldService.listEnabled(user);
                SessionData sessionData = this.getSessionData();
                Set set = sessionData.isLoggedIn() && sessionData.getLoggedUser().equals((Object)user) ? sessionData.getProducts().member().getMyAdFields().keysSet((Path)QProductAdField.productAdField.manage) : sessionData.getProducts().userManagement().getUserAdFields().keysSet((Path)QProductAdField.productAdField.manage);
                this.customFieldValueHandler.setCustomValues((SimpleEntity)basicAd, (Collection)list, (Collection)set, (Collection)basicAdDTO.getCustomValues());
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.CUSTOM_VALUES);
            }
        }
        super.fill(object, basicAd, objectArray, conversionContext);
    }

    @Override
    protected BasicAd instantiate(Class<BasicAd> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        Long l = null;
        String string = null;
        User user = null;
        if (object instanceof AdWebShopVO) {
            AdWebShopVO adWebShopVO = (AdWebShopVO)object;
            l = adWebShopVO.getId();
            string = adWebShopVO.getProductNumber();
            user = (User)this.conversionHandler.convert(User.class, adWebShopVO.getOwner());
            if (user == null) {
                user = this.getSessionData().getLoggedUser();
            }
        } else if (object instanceof BasicAdVO) {
            l = ((BasicAdVO)object).getId();
        }
        if (l != null) {
            return this.find(clazz, l);
        }
        if (StringHelper.isNotBlank(string)) {
            return this.adService.findByOwnerAndNumber(user, string);
        }
        return super.instantiate(clazz, object, conversionContext);
    }
}

