/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.impl.logging.TaskLogParams;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public class LogFormatter
extends Formatter {
    public static final char SEPARATOR = '\t';
    private static final LogFormatter INSTANCE = new LogFormatter();

    public static String format(LogConfiguration logConfiguration, ServiceLogParams serviceLogParams) {
        StringBuilder stringBuilder = new StringBuilder();
        if (serviceLogParams.getError() != null) {
            stringBuilder.append("ERROR");
        } else {
            stringBuilder.append("SUCCESS");
        }
        stringBuilder.append('\t');
        stringBuilder.append(serviceLogParams.getChannel()).append('\t');
        stringBuilder.append(serviceLogParams.getRemoteAddress()).append('\t');
        if (serviceLogParams.getUserId() == null) {
            stringBuilder.append("GUEST");
        } else {
            stringBuilder.append(serviceLogParams.getUser());
        }
        stringBuilder.append('\t');
        stringBuilder.append(serviceLogParams.getService()).append('\t');
        stringBuilder.append(serviceLogParams.getMethod()).append('\t');
        if (logConfiguration.isLogServicesParameters() && serviceLogParams.getParametersJson() != null) {
            stringBuilder.append(serviceLogParams.getParametersJson());
        }
        stringBuilder.append('\t');
        if (logConfiguration.isLogServicesResults()) {
            String string = (String)ObjectHelper.defaultValue((Object)serviceLogParams.getResultJson(), (Object)serviceLogParams.getErrorJson());
            stringBuilder.append(StringHelper.trim((Object)string));
        }
        stringBuilder.append('\t');
        stringBuilder.append(serviceLogParams.getTimeTaken());
        return stringBuilder.toString();
    }

    public static String format(LogConfiguration logConfiguration, TaskLogParams taskLogParams) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(taskLogParams.getName()).append('\t');
        stringBuilder.append(ObjectHelper.defaultValue((Object)taskLogParams.getAffectedRecords(), (Object)"")).append('\t');
        stringBuilder.append(DateHelper.formatDuration((Long)taskLogParams.getTimeTaken()));
        return stringBuilder.toString();
    }

    public static LogFormatter getInstance() {
        return INSTANCE;
    }

    private LogFormatter() {
    }

    @Override
    public String format(LogRecord logRecord) {
        Instant instant = Instant.ofEpochMilli(logRecord.getMillis());
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime));
        stringBuilder.append('\t');
        Object[] objectArray = logRecord.getParameters();
        if (CollectionHelper.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                stringBuilder.append(object);
                stringBuilder.append('\t');
            }
        }
        stringBuilder.append(logRecord.getMessage());
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            stringBuilder.append('\n');
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuilder.append(stringWriter);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

