/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.SortedMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.CyclosVersion;
import org.cyclos.bootstrap.DataSourceProvider;
import org.cyclos.db.DatabaseHistory;
import org.cyclos.db.VersionScript;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.logging.BaseLogProvider;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.impl.logging.TaskLogParams;
import org.cyclos.impl.utils.jdbc.ScriptHelper;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseLogProvider
extends BaseLogProvider {
    private static final String SELECT_VERSION = "select version from logging_version";
    private static final String UPDATE_VERSION = "update logging_version set version = ?";
    private static final String INSERT_VERSION = "insert into logging_version (version) values (?)";
    private static final String INSERT_SERVICE = "insert into service_logs (  cyclos_version,  custom_ws_id,  service_name,  method_name,  success,  time_taken,  parameters,   result,   error,   error_stack_trace,   remote_address,   network_id,   network_name,   configuration_id,   configuration_name,   channel_id,   channel_name,   principal_type_id,   principal_type_name,   principal,   session_token,   user_id,   user_display,   group_id,   group_name)   values (?, ?, ?, ?, ?, ?, ?::json, ?::json, ?::json, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_TASK = "insert into task_logs (  cyclos_version,  name,  success,  affected_records,  time_taken,  error_stack_trace)   values (?, ?, ?, ?, ?, ?)";
    private static final Logger LOG = LogManager.getLogger(DatabaseLogProvider.class);
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private BeanHandler beanHandler;
    private Properties dataSourceProviderProperties;
    private DataSourceProvider dataSourceProvider;
    private DataSource dataSource;
    private JdbcTemplate jdbc;
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;

    @PreDestroy
    public void destroy() throws Exception {
        if (this.dataSourceProvider != null) {
            this.dataSourceProvider.destroy();
        }
    }

    @Override
    public String getLogOutput() {
        return "database: " + this.dataSourceProvider.getConnectionDetails(this.dataSourceProviderProperties);
    }

    @PostConstruct
    public void initialize() throws Exception {
        Class<?> clazz = Class.forName(this.cyclosProperties.getLogDataSourceProviderClass());
        this.dataSourceProvider = (DataSourceProvider)this.beanHandler.autowire(clazz);
        this.dataSourceProviderProperties = this.cyclosProperties.getLogDataSourceProviderProperties();
        this.dataSourceProvider.initialize(this.dataSourceProviderProperties);
        this.dataSource = this.dataSourceProvider.get();
        this.transactionManager = new DataSourceTransactionManager(this.dataSource);
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.jdbc = new JdbcTemplate(this.dataSource);
    }

    @Override
    public void invalidateLoggers(String string) {
    }

    public void onApplicationInitialization() {
        SortedMap<Integer, VersionScript> sortedMap = this.readVersionScripts();
        int n = sortedMap.firstKey();
        int n2 = this.readVersion();
        if (n2 == n) {
            LOG.info("Logging database is up-to-date (version " + n2 + ")");
        } else {
            if (n2 > n) {
                throw new IllegalStateException("Logging database has an invalid version: " + n2);
            }
            if (n2 < n) {
                while (++n2 <= n) {
                    VersionScript versionScript = (VersionScript)sortedMap.get(n2);
                    this.applyVersion(n2, versionScript);
                }
            }
        }
    }

    @Override
    protected void service(LogConfiguration logConfiguration, ServiceLogParams serviceLogParams) {
        try {
            this.transactionTemplate.execute(transactionStatus -> this.jdbc.update(INSERT_SERVICE, new Object[]{CyclosVersion.get(), serviceLogParams.getCustomWebServiceId(), serviceLogParams.getService(), serviceLogParams.getMethod(), serviceLogParams.getError() == null, serviceLogParams.getTimeTaken(), serviceLogParams.getParametersJson(), serviceLogParams.getResultJson(), serviceLogParams.getErrorJson(), serviceLogParams.getErrorStackTrace(), serviceLogParams.getRemoteAddress(), serviceLogParams.getNetworkId(), serviceLogParams.getNetwork(), serviceLogParams.getConfigurationId(), serviceLogParams.getConfiguration(), serviceLogParams.getChannelId(), serviceLogParams.getChannel(), serviceLogParams.getPrincipalTypeId(), serviceLogParams.getPrincipalType(), serviceLogParams.getPrincipal(), serviceLogParams.getSessionToken(), serviceLogParams.getUserId(), serviceLogParams.getUser(), serviceLogParams.getGroupId(), serviceLogParams.getGroup()}));
        }
        catch (Exception exception) {
            LOG.error("Error generating service log in database", (Throwable)exception);
        }
    }

    @Override
    protected void task(LogConfiguration logConfiguration, TaskLogParams taskLogParams) {
        try {
            this.transactionTemplate.execute(transactionStatus -> this.jdbc.update(INSERT_TASK, new Object[]{CyclosVersion.get(), taskLogParams.getName(), taskLogParams.getError() == null, taskLogParams.getAffectedRecords(), taskLogParams.getTimeTaken(), taskLogParams.getError() == null ? null : ExceptionUtils.getStackTrace((Throwable)taskLogParams.getError())}));
        }
        catch (Exception exception) {
            LOG.error("Error generating task log in database", (Throwable)exception);
        }
    }

    private void applyVersion(int n, VersionScript versionScript) {
        LOG.info("Upgrading logging to database version " + n);
        boolean bl = (Boolean)this.transactionTemplate.execute(transactionStatus -> ScriptHelper.runSilently(this.jdbc, String.valueOf(n), versionScript, true, this.cyclosProperties));
        if (bl) {
            LOG.warn("There were some errors while upgrading the logging database to version " + n + ". However, it is possible that the database is still consistent, depending on the statement (for example, a 'drop table' that failed because the table does not exist)");
        } else {
            LOG.info("Successfully upgraded the logging database to version " + n);
        }
        this.transactionTemplate.execute(transactionStatus -> {
            int n2 = this.jdbc.update(UPDATE_VERSION, new Object[]{n});
            if (n2 == 0) {
                this.jdbc.update(INSERT_VERSION, new Object[]{n});
            }
            return null;
        });
    }

    private int readVersion() {
        try {
            return (Integer)this.jdbc.queryForObject(SELECT_VERSION, Integer.class);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private SortedMap<Integer, VersionScript> readVersionScripts() {
        InputStream inputStream = DatabaseHistory.class.getResourceAsStream("/versions/logging");
        if (inputStream == null) {
            throw new IllegalStateException("No logging database versions file");
        }
        try {
            return VersionScript.readScripts(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error reading loggin database versions file", iOException);
        }
    }
}

