/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.locks;

import java.util.Date;
import java.util.function.Supplier;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEvent;
import org.cyclos.impl.system.ProfilingLockEvent;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.model.RetryException;
import org.cyclos.model.utils.TransactionLevel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LockHandlerImpl
implements LockHandler {
    private static final long TIMEOUT_MILLIS = 3000L;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;

    public void lock(LockKey lockKey) throws LockAcquisitionException {
        this.lock(lockKey, 3000L);
    }

    public void lock(LockKey lockKey, long l) throws LockAcquisitionException {
        if (l <= 0L) {
            if (this.tryLock(lockKey)) {
                return;
            }
            throw new LockAcquisitionException(lockKey.toString());
        }
        this.acquireAndHandleProfiling(lockKey, () -> {
            long l2 = System.currentTimeMillis() + l;
            AcquireResult acquireResult = AcquireResult.NOT_ACQUIRED;
            int n = 0;
            while (System.currentTimeMillis() < l2 && !(acquireResult = this.doTryLock(lockKey)).acquired()) {
                try {
                    Thread.sleep(Math.min(500, 100 * ++n));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (!acquireResult.acquired()) {
                throw new LockAcquisitionException(lockKey.toString());
            }
            return acquireResult;
        });
    }

    public boolean tryLock(LockKey lockKey) {
        return this.acquireAndHandleProfiling(lockKey, () -> this.doTryLock(lockKey));
    }

    private boolean acquireAndHandleProfiling(LockKey lockKey, Supplier<AcquireResult> supplier) {
        AcquireResult acquireResult;
        RequestContext requestContext = RequestContext.get();
        ProfilingEntry profilingEntry = requestContext == null ? null : requestContext.getProfilingEntry();
        ProfilingLockEvent profilingLockEvent = null;
        if (profilingEntry != null) {
            profilingLockEvent = new ProfilingLockEvent(lockKey.getLockType().toString(), lockKey.getId());
        }
        if ((acquireResult = supplier.get()) == AcquireResult.ACQUIRED && profilingLockEvent != null) {
            profilingLockEvent.setAcquiredAt(new Date());
            profilingEntry.addEvent((ProfilingEvent)profilingLockEvent);
        }
        return acquireResult.acquired();
    }

    private AcquireResult doTryLock(LockKey lockKey) {
        InvocationContext invocationContext = InvocationContext.ensure();
        if (invocationContext.hasLock(lockKey)) {
            return AcquireResult.ALREADY_ACQUIRED;
        }
        if (invocationContext.getTransactionLevel() == TransactionLevel.READ_ONLY) {
            throw new RetryException(TransactionLevel.READ_ONLY_TRANSACTION);
        }
        boolean bl = this.nativeQueryHandler.tryLock(lockKey);
        if (bl) {
            invocationContext.registerLock(lockKey);
        }
        return bl ? AcquireResult.ACQUIRED : AcquireResult.NOT_ACQUIRED;
    }

    private static enum AcquireResult {
        ACQUIRED,
        NOT_ACQUIRED,
        ALREADY_ACQUIRED;


        public boolean acquired() {
            return this == ACQUIRED || this == ALREADY_ACQUIRED;
        }
    }
}

