/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.contentmanagement.QTranslationMessage;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.AppI18nResourceBundle;
import org.cyclos.impl.contentmanagement.CyclosResourceBundle;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.CustomResourceBundleControl;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.contentmanagement.translations.CustomizedTranslation;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TranslationHandlerImpl
extends BaseNetworkedHandlerImpl
implements TranslationHandler,
ApplicationUpgradeInitializationListener {
    private Map<Pair<BuiltinLanguage, Module>, ResourceBundle> builtinResourceBundles = new ConcurrentHashMap<Pair<BuiltinLanguage, Module>, ResourceBundle>();
    private Map<Long, CyclosResourceBundle> bundlesByLanguage = new ConcurrentHashMap<Long, CyclosResourceBundle>();
    private CyclosResourceBundle originalEnglishBundle;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<Long, HashMap<String, CustomizedTranslation>> customizedKeysCache;
    @Autowired
    private JsonConverter jsonConverter;
    private Map<URL, AppI18nResourceBundle> appResourceBundles = new ConcurrentHashMap<URL, AppI18nResourceBundle>();

    private static void reloadBundles() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle.clearCache(classLoader);
        try {
            Map map = (Map)FieldHelper.get((Object)classLoader, (String)"resourceEntries");
            map.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResourceBundle getBuiltinResourceBundle(BuiltinLanguage builtinLanguage, Module module) {
        Pair pair = Pair.create((Object)builtinLanguage, (Object)module);
        if (this.cyclosProperties.isDevelopment()) {
            return (ResourceBundle)InvocationContext.ensure().getAttribute((Object)pair, () -> this.createBuiltinResourceBundle((Pair<BuiltinLanguage, Module>)pair));
        }
        return this.builtinResourceBundles.computeIfAbsent((Pair<BuiltinLanguage, Module>)pair, this::createBuiltinResourceBundle);
    }

    public Map<String, CustomizedTranslation> getCustomizedKeys(long l) {
        return (Map)this.customizedKeysCache.get((Serializable)Long.valueOf(l), () -> {
            HashMap hashMap = new HashMap();
            QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
            try (CloseableIterator closeableIterator = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qTranslationMessage}).select(new Expression[]{qTranslationMessage.key, qTranslationMessage.value, qTranslationMessage.sourceValue, qTranslationMessage.invalid}).where((Predicate)qTranslationMessage.language().id.eq((Object)l))).iterate();){
                closeableIterator.forEachRemaining(tuple -> {
                    CustomizedTranslation customizedTranslation = new CustomizedTranslation();
                    customizedTranslation.setValue((String)tuple.get((Expression)qTranslationMessage.value));
                    customizedTranslation.setInvalid(((Boolean)tuple.get((Expression)qTranslationMessage.invalid)).booleanValue());
                    customizedTranslation.setSourceValue((String)tuple.get((Expression)qTranslationMessage.sourceValue));
                    hashMap.put((String)tuple.get((Expression)qTranslationMessage.key), customizedTranslation);
                });
            }
            return hashMap;
        });
    }

    public CyclosResourceBundle getOriginalEnglishResourceBundle() {
        if (this.originalEnglishBundle == null) {
            this.originalEnglishBundle = this.createBundle(null, 0L, BuiltinLanguage.EN, false);
        }
        return this.originalEnglishBundle;
    }

    public CyclosResourceBundle getResourceBundle() {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        if (configurationAccessor == null) {
            return null;
        }
        Language language = configurationAccessor.getLanguage();
        return this.getResourceBundle(language);
    }

    public CyclosResourceBundle getResourceBundle(Language language) {
        if (this.cyclosProperties.isDevelopment()) {
            return (CyclosResourceBundle)InvocationContext.ensure().getAttribute((Object)("resourceBundle_" + language.getId()), () -> this.createBundle(language));
        }
        CyclosResourceBundle cyclosResourceBundle = this.bundlesByLanguage.get(language.getId());
        if (cyclosResourceBundle == null) {
            cyclosResourceBundle = this.createBundle(language);
            this.bundlesByLanguage.put(language.getId(), cyclosResourceBundle);
        }
        return cyclosResourceBundle;
    }

    @PostConstruct
    public void initialize() {
        this.customizedKeysCache = this.cacheHandler.getCache(CacheType.CUSTOMIZED_TRANSLATIONS);
    }

    @Override
    public String message(Language language, MessageKey messageKey, Object ... objectArray) {
        return this.message(this.getResourceBundle(language), messageKey, MessageFormat.NEW_LINE_TO_BR, objectArray);
    }

    @Override
    public String message(MessageFormat messageFormat, Language language, MessageKey messageKey, Object ... objectArray) {
        return this.message(this.getResourceBundle(language), messageKey, messageFormat, objectArray);
    }

    @Override
    public String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return this.message(this.getResourceBundle(), messageKey, messageFormat, objectArray);
    }

    @Override
    public String message(MessageKey messageKey, Object ... objectArray) {
        return this.message(MessageFormat.NEW_LINE_TO_BR, messageKey, objectArray);
    }

    public void onApplicationUpgradeInitialization() {
        this.invalidateCustomTranslations();
    }

    private ResourceBundle createBuiltinResourceBundle(Pair<BuiltinLanguage, Module> pair) {
        Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)((BuiltinLanguage)pair.getFirst()));
        Module module = (Module)pair.getSecond();
        if (module == Module.APP) {
            BiFunction<URL, AppI18nResourceBundle, AppI18nResourceBundle> biFunction = (uRL2, appI18nResourceBundle) -> this.cyclosProperties.isDevelopment() ? this.doCreateAppResourceBundle((URL)uRL2, (AppI18nResourceBundle)appI18nResourceBundle) : this.appResourceBundles.computeIfAbsent((URL)uRL2, uRL -> this.doCreateAppResourceBundle((URL)uRL, (AppI18nResourceBundle)appI18nResourceBundle));
            URL uRL = ResourceHelper.getResource((String)"/app-i18n/i18n.json");
            AppI18nResourceBundle appI18nResourceBundle2 = biFunction.apply(uRL, null);
            URL uRL3 = ResourceHelper.getResource((String)("/app-i18n/i18n." + locale.getLanguage() + "_" + locale.getCountry() + ".json"));
            if (uRL3 == null) {
                uRL3 = ResourceHelper.getResource((String)("/app-i18n/i18n." + locale.getLanguage() + ".json"));
            }
            if (uRL3 == null) {
                return appI18nResourceBundle2;
            }
            return (ResourceBundle)biFunction.apply(uRL3, appI18nResourceBundle2);
        }
        try {
            return ResourceBundle.getBundle("translations/translation-" + module.name(), locale, CustomResourceBundleControl.getInstance(this.cyclosProperties.isDevelopment()));
        }
        catch (MissingResourceException missingResourceException) {
            return NullResourceBundle.INSTANCE;
        }
    }

    private CyclosResourceBundle createBundle(CyclosResourceBundle cyclosResourceBundle, long l, BuiltinLanguage builtinLanguage, boolean bl) {
        CyclosResourceBundle cyclosResourceBundle2 = new CyclosResourceBundle(cyclosResourceBundle, l, builtinLanguage, (TranslationHandler)(bl ? this : null));
        for (Module module : Module.values()) {
            ResourceBundle resourceBundle = this.getBuiltinResourceBundle(builtinLanguage, module);
            cyclosResourceBundle2.addResourceBundle(module, resourceBundle);
        }
        return cyclosResourceBundle2;
    }

    private CyclosResourceBundle createBundle(Language language) {
        if (this.cyclosProperties.isDevelopment()) {
            TranslationHandlerImpl.reloadBundles();
        }
        CyclosResourceBundle cyclosResourceBundle = null;
        Language language2 = language.getParent();
        if (language2 != null) {
            cyclosResourceBundle = this.getResourceBundle(language2);
        }
        BuiltinLanguage builtinLanguage = language.getTemplate();
        CyclosResourceBundle cyclosResourceBundle2 = this.createBundle(cyclosResourceBundle, language.getId(), builtinLanguage, true);
        return cyclosResourceBundle2;
    }

    private AppI18nResourceBundle doCreateAppResourceBundle(URL uRL, AppI18nResourceBundle appI18nResourceBundle) {
        Map map = null;
        Throwable throwable = null;
        try {
            map = (Map)this.jsonConverter.readValue(uRL, Map.class);
        }
        catch (MismatchedInputException mismatchedInputException) {
            try {
                Object[] objectArray = (String[])this.jsonConverter.readValue(uRL, String[].class);
                if (CollectionHelper.isEmpty((Object[])objectArray)) {
                    map = Collections.emptyMap();
                }
                throwable = mismatchedInputException;
            }
            catch (Exception exception) {
                throwable = mismatchedInputException;
            }
        }
        catch (Exception exception) {
            throwable = exception;
        }
        if (throwable != null) {
            throw new IllegalStateException("Couldn't read the modern frontend i18n file at " + String.valueOf(uRL), throwable);
        }
        return new AppI18nResourceBundle(map, (ResourceBundle)appI18nResourceBundle);
    }

    private void generateTranslationsInvalidatedSystemAlert(long l, Set<String> set) {
        Language language = this.find(Language.class, l);
        String string = set.stream().collect(Collectors.joining(System.lineSeparator()));
        this.alertService.create(language.getNetwork(), SystemAlertType.CUSTOM_TRANSLATIONS_INVALIDATED, new Object[]{language.getName(), string});
    }

    private void invalidateCustomTranslations() {
        CyclosResourceBundle cyclosResourceBundle = this.getOriginalEnglishResourceBundle();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashMap hashMap = new HashMap();
        HashMap<Long, Set> hashMap2 = new HashMap<Long, Set>();
        QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
        try (CloseableIterator closeableIterator = this.from(new EntityPath[]{qTranslationMessage}).select(new Expression[]{qTranslationMessage.id, qTranslationMessage.languageId, qTranslationMessage.key, qTranslationMessage.sourceValue}).iterate();){
            closeableIterator.forEachRemaining(tuple -> {
                try {
                    String string = cyclosResourceBundle.getString((String)tuple.get((Expression)qTranslationMessage.key));
                    String string2 = (String)tuple.get((Expression)qTranslationMessage.sourceValue);
                    if ("_UNKNOWN_".equals(string2)) {
                        hashMap.put((Long)tuple.get((Expression)qTranslationMessage.id), string);
                    } else if (!string.equals(string2)) {
                        Set set3 = hashMap2.computeIfAbsent((Long)tuple.get((Expression)qTranslationMessage.languageId), l -> new TreeSet());
                        set3.add((String)tuple.get((Expression)qTranslationMessage.key));
                        hashSet2.add((Long)tuple.get((Expression)qTranslationMessage.id));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    Set set4 = hashMap2.computeIfAbsent((Long)tuple.get((Expression)qTranslationMessage.languageId), l -> new TreeSet());
                    set4.add((String)tuple.get((Expression)qTranslationMessage.key));
                    hashSet.add((Long)tuple.get((Expression)qTranslationMessage.id));
                }
            });
        }
        if (!hashSet.isEmpty()) {
            this.delete((EntityPath<?>)qTranslationMessage).where(new Predicate[]{qTranslationMessage.id.in(hashSet)}).execute();
        }
        if (!hashSet2.isEmpty()) {
            this.update((EntityPath<?>)qTranslationMessage).set((Path)qTranslationMessage.invalid, (Object)true).where(new Predicate[]{qTranslationMessage.id.in(hashSet2)}).execute();
        }
        if (!hashMap.isEmpty()) {
            hashMap.entrySet().stream().forEach(entry -> this.update((EntityPath<?>)qTranslationMessage).set((Path)qTranslationMessage.sourceValue, (Object)((String)entry.getValue())).where(new Predicate[]{qTranslationMessage.id.eq((Object)((Long)entry.getKey()))}).execute());
        }
        hashMap2.forEach(this::generateTranslationsInvalidatedSystemAlert);
    }

    private String message(CyclosResourceBundle cyclosResourceBundle, MessageKey messageKey, MessageFormat messageFormat, Object ... objectArray) {
        try {
            if (cyclosResourceBundle == null) {
                throw new MissingResourceException(null, null, null);
            }
            return cyclosResourceBundle.message(messageKey.fullKey(), messageFormat, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return "???" + String.valueOf(messageKey) + "???";
        }
    }

    private static class NullResourceBundle
    extends ResourceBundle {
        private static final NullResourceBundle INSTANCE = new NullResourceBundle();

        private NullResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        protected Object handleGetObject(String string) {
            return null;
        }
    }
}

