/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.QSystemImageCategory;
import org.cyclos.entities.contentmanagement.SystemImageCategory;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryDTO;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryData;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.products.AdminProductDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemImageCategoryServiceImpl
extends CRUDServiceImpl<SystemImageCategory, QSystemImageCategory, SystemImageCategoryDTO, SystemImageCategoryData, Void>
implements SystemImageCategoryServiceLocal {
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public SystemImageCategoryServiceImpl() {
        super(SystemImageCategory.class, QSystemImageCategory.systemImageCategory, SystemImageCategoryDTO.class);
    }

    public SystemImageCategory ensureDefaultImageCategory() {
        try {
            return (SystemImageCategory)((DBQuery)this.from().where((Predicate)((QSystemImageCategory)this.$).isDefault.isTrue())).requiredUniqueResult((Expression)this.$);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            SystemImageCategory systemImageCategory = new SystemImageCategory();
            systemImageCategory.setName(this.message(SystemKeys.Images.DEFAULT_CATEGORY_NAME, new Object[0]));
            systemImageCategory.setIsDefault(Boolean.valueOf(true));
            this.rawEntityManagerHandler.persist((IEntity)systemImageCategory);
            AdminProduct adminProduct = this.groupService.getSystemAdmins().getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_VIEW, (SimpleEntity)systemImageCategory);
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_MANAGE, (SimpleEntity)systemImageCategory);
            return systemImageCategory;
        }
    }

    public List<SystemImageCategoryVO> list() {
        return this.conversionHandler.convertList(SystemImageCategoryVO.class, this.listAll());
    }

    public List<SystemImageCategory> listAll() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QSystemImageCategory)this.$).order.asc())).list((Expression)this.$);
    }

    public List<SystemImageCategory> listManageable() throws FrameworkException {
        if (this.isSystem() || this.isGlobalAdmin()) {
            return this.listAll();
        }
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        return productsAccessor.admin().getSystemImageCategoriesManage();
    }

    public List<SystemImageCategory> listVisible() {
        if (this.isSystem() || this.isGlobalAdmin()) {
            return this.listAll();
        }
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        return productsAccessor.admin().getSystemImageCategoriesView();
    }

    @Override
    public SystemImageCategory newEntity(Void void_) {
        return new SystemImageCategory();
    }

    @Override
    protected void doRemove(SystemImageCategory systemImageCategory, boolean bl) {
        this.productService.removeAllRelationships((Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_VIEW, (SimpleEntity)systemImageCategory);
        this.productService.removeAllRelationships((Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_MANAGE, (SimpleEntity)systemImageCategory);
        super.doRemove(systemImageCategory, bl);
    }

    @Override
    protected SystemImageCategoryData getData(SystemImageCategory systemImageCategory) {
        SystemImageCategoryData systemImageCategoryData = new SystemImageCategoryData();
        systemImageCategoryData.setDto((EntityDTO)((SystemImageCategoryDTO)this.toDTO(systemImageCategory)));
        return systemImageCategoryData;
    }

    @Override
    protected void onAfterSave(SystemImageCategory systemImageCategory, SystemImageCategory systemImageCategory2, Object object) {
        if (systemImageCategory2 == null && this.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
            AdminProduct adminProduct = adminGroup.getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_VIEW, (SimpleEntity)systemImageCategory);
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_MANAGE, (SimpleEntity)systemImageCategory);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QSystemImageCategory)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(SystemImageCategoryDTO systemImageCategoryDTO) {
        Validator validator = new Validator();
        validator.property(SystemImageCategoryDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        return validator;
    }
}

