/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.banking.VoucherTransactionsVisibility;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VoucherVOConverter
extends EntityVOConverter<VoucherVO> {
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private VoucherServiceSecurity voucherServiceSecurity;

    public VoucherVOConverter() {
        super(VoucherVO.class);
    }

    @Override
    protected void fill(Object object, VoucherVO voucherVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof Voucher) {
            objectArray = ArrayUtils.add((Object[])objectArray, (Object)VoucherVO.TOKEN);
            Voucher voucher = (Voucher)object;
            super.fill((Object)voucher, voucherVO, objectArray, conversionContext);
            voucherVO.setToken(this.voucherService.formatToken(voucher));
            if (this.voucherServiceSecurity.getTransactionVisibility(voucher) == VoucherTransactionsVisibility.NONE) {
                voucherVO.setBalance(null);
            }
        } else {
            super.fill(object, voucherVO, objectArray, conversionContext);
        }
    }
}

