/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import org.cyclos.entities.banking.DRateCreationValueForTransferType;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.rates.DRateCreationValueForTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.GeneratedTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.utils.Pair;
import org.springframework.stereotype.Component;

@Component
public class TransferTypeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<TransferType, TransferTypeDTO> {
    public Class<TransferType> getEntityClass() {
        return TransferType.class;
    }

    public EntityLogType getType() {
        return EntityLogType.TRANSFER_TYPE;
    }

    @Override
    public Pair<Object, Object> getValues(TransferType transferType, TransferType transferType2, PropertyLogDescriptor<TransferTypeDTO> propertyLogDescriptor) {
        Pair<Object, Object> pair = new Pair<Object, Object>(null, null);
        if (transferType instanceof PaymentTransferType) {
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            PaymentTransferType paymentTransferType2 = (PaymentTransferType)transferType2;
            boolean bl = transferType2 != null;
            int n = (bl ? transferType2 : transferType).getCurrency().getPrecision();
            if (propertyLogDescriptor.getAccess().getPropertyName().equals(PaymentTransferTypeDTO.FIXED_AMOUNT.getName())) {
                if (paymentTransferType.isUseFixedAmount()) {
                    pair.setFirst((Object)this.getFormatter().format(paymentTransferType.getFixedAmount(), n));
                }
                if (bl && paymentTransferType2.isUseFixedAmount()) {
                    pair.setSecond((Object)this.getFormatter().format(paymentTransferType2.getFixedAmount(), n));
                }
            } else if (propertyLogDescriptor.getAccess().getPropertyName().equals(PaymentTransferTypeDTO.MIN_AMOUNT.getName())) {
                if (!paymentTransferType.isUseFixedAmount() && paymentTransferType.getMinAmount() != null) {
                    pair.setFirst((Object)this.getFormatter().format(paymentTransferType.getMinAmount(), n));
                }
                if (bl && !paymentTransferType2.isUseFixedAmount() && paymentTransferType2.getMinAmount() != null) {
                    pair.setSecond((Object)this.getFormatter().format(paymentTransferType2.getMinAmount(), n));
                }
            } else if (propertyLogDescriptor.getAccess().getPropertyName().equals(PaymentTransferTypeDTO.MAX_AMOUNT.getName())) {
                if (!paymentTransferType.isUseFixedAmount() && paymentTransferType.getMaxAmount() != null) {
                    pair.setFirst((Object)this.getFormatter().format(paymentTransferType.getMaxAmount(), n));
                }
                if (bl && !paymentTransferType2.isUseFixedAmount() && paymentTransferType2.getMaxAmount() != null) {
                    pair.setSecond((Object)this.getFormatter().format(paymentTransferType2.getMaxAmount(), n));
                }
            } else {
                pair = super.getValues(transferType, transferType2, propertyLogDescriptor);
            }
        } else {
            pair = super.getValues(transferType, transferType2, propertyLogDescriptor);
        }
        return pair;
    }

    public EntityLogDescriptor<? extends TransferTypeDTO> resolveLogDescriptor(TransferType transferType) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDTOType(transferType)).property(TransferTypeDTO.NAME, GeneralKeys.Ui.NAME).property(TransferTypeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(TransferTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)TransferTypeDTO.DISPLAY_TEMPLATE, BankingKeys.TransferTypes.DISPLAY_TEMPLATE).property((Property)TransferTypeDTO.STATUS_FLOWS, BankingKeys.TransferTypes.STATUS_FLOWS).property((Property)TransferTypeDTO.INITIAL_STATUSES, BankingKeys.TransferTypes.INITIAL_STATUSES).property((Property)TransferTypeDTO.DESCRIPTION_AVAILABILITY, BankingKeys.TransferTypes.DESCRIPTION_AVAILABILITY).property((Property)TransferTypeDTO.VALUE_FOR_EMPTY_DESCRIPTION, BankingKeys.TransferTypes.VALUE_FOR_EMPTY_DESCRIPTION).property((Property)TransferTypeDTO.IGNORE_ACCOUNT_LIMITS, BankingKeys.TransferTypes.IGNORE_ACCOUNT_LIMITS).property((Property)TransferTypeDTO.LOCK_FROM, BankingKeys.TransferTypes.LOCK_FROM).property((Property)TransferTypeDTO.LOCK_TO, BankingKeys.TransferTypes.LOCK_TO).property((Property)TransferTypeDTO.MAX_CHARGEBACK_TIME, BankingKeys.TransferTypes.MAX_CHARGEBACK_TIME).property((Property)TransferTypeDTO.NOTIFY_PAYMENT_RECEIVED, BankingKeys.TransferTypes.NOTIFY_PAYMENT_RECEIVED).property((Property)TransferTypeDTO.NATURE, BankingKeys.TransferTypes.NATURE).property((Property)TransferTypeDTO.DIRECTION, BankingKeys.TransferTypes.DIRECTION).property((Property)TransferTypeDTO.FROM, BankingKeys.TransferTypes.FROM).property((Property)TransferTypeDTO.TO, BankingKeys.TransferTypes.TO).property((PropertyAccess)new BeanPropertyAccess((Property)TransferTypeDTO.D_RATE_CREATION_VALUE){

            public Object get(Object object) {
                if (object instanceof TransferTypeDTO) {
                    DRateCreationValueForTransferTypeDTO dRateCreationValueForTransferTypeDTO = ((TransferTypeDTO)object).getDRateCreationValue();
                    return dRateCreationValueForTransferTypeDTO == null ? null : dRateCreationValueForTransferTypeDTO.getCreationValue();
                }
                DRateCreationValueForTransferType dRateCreationValueForTransferType = ((TransferType)object).getdRateCreationValue();
                return dRateCreationValueForTransferType == null ? null : dRateCreationValueForTransferType.getCreationValue();
            }
        }, BankingKeys.Rates.D_CREATION_VALUE_TRANSFER_TYPE);
        if (transferType instanceof PaymentTransferType) {
            entityLogDescriptor.cast().property((Property)PaymentTransferTypeDTO.ENABLED, BankingKeys.TransferTypes.ENABLED).property((Property)PaymentTransferTypeDTO.NOTIFY_PAYMENT_PERFORMED, BankingKeys.TransferTypes.NOTIFY_PAYMENT_PERFORMED).property((Property)PaymentTransferTypeDTO.CONFIRMATION_MESSAGE, BankingKeys.TransferTypes.CONFIRMATION_MESSAGE).property((Property)PaymentTransferTypeDTO.DEFAULT_PAYMENT_REQUEST_EXPIRATION_PERIOD, BankingKeys.TransferTypes.DEFAULT_PAYMENT_REQUEST_EXPIRATION_PERIOD).property((Property)PaymentTransferTypeDTO.HIDE_PAYMENT_REQUEST_EXPIRATION_DATE, BankingKeys.TransferTypes.HIDE_PAYMENT_REQUEST_EXPIRATION_DATE).property((Property)PaymentTransferTypeDTO.REQUIRES_AUTHORIZATION, BankingKeys.TransferTypes.REQUIRES_AUTHORIZATION).property((Property)PaymentTransferTypeDTO.SKIP_CONFIRMATION, BankingKeys.TransferTypes.SKIP_CONFIRMATION).property((Property)PaymentTransferTypeDTO.AUTHORIZATION_EXPIRATION_PERIOD, BankingKeys.TransferTypes.AUTHORIZATION_EXPIRATION_PERIOD).property((Property)PaymentTransferTypeDTO.ALLOW_FROM_CUSTOM_NAME, BankingKeys.TransferTypes.ALLOW_FROM_CUSTOM_NAME).property((Property)PaymentTransferTypeDTO.ALLOW_TO_CUSTOM_NAME, BankingKeys.TransferTypes.ALLOW_TO_CUSTOM_NAME).property((Property)PaymentTransferTypeDTO.FIXED_AMOUNT, BankingKeys.TransferTypes.FIXED_AMOUNT).property((Property)PaymentTransferTypeDTO.MIN_AMOUNT, BankingKeys.TransferTypes.MIN_AMOUNT).property((Property)PaymentTransferTypeDTO.MAX_AMOUNT, BankingKeys.TransferTypes.MAX_AMOUNT).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PINLESS), BankingKeys.TransferTypes.MAX_AMOUNT_PINLESS).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PINLESS_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PINLESS_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY), BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_PINLESS), BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_PINLESS).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_DAY_PINLESS_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PER_DAY_PINLESS_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_WEEK), BankingKeys.TransferTypes.MAX_AMOUNT_PER_WEEK).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_WEEK_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PER_WEEK_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_MONTH), BankingKeys.TransferTypes.MAX_AMOUNT_PER_MONTH).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_MONTH_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PER_MONTH_TRUSTED_DEVICES).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_YEAR), BankingKeys.TransferTypes.MAX_AMOUNT_PER_YEAR).property(this.toAmountAccess((Property<?, PaymentTransferTypeDTO>)PaymentTransferTypeDTO.MAX_AMOUNT_PER_YEAR_TRUSTED_DEVICES), BankingKeys.TransferTypes.MAX_AMOUNT_PER_YEAR_TRUSTED_DEVICES).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_DAY, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_DAY).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_DAY_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_DAY_TRUSTED_DEVICES).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_WEEK, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_WEEK).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_WEEK_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_WEEK_TRUSTED_DEVICES).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_MONTH, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_MONTH).property((Property)PaymentTransferTypeDTO.MAX_TRANSFERS_PER_MONTH_TRUSTED_DEVICES, BankingKeys.TransferTypes.MAX_TRANSFERS_PER_MONTH_TRUSTED_DEVICES).property((Property)PaymentTransferTypeDTO.MIN_TIME_BETWEEN_TRANSFERS, BankingKeys.TransferTypes.MIN_TIME_BETWEEN_TRANSFERS).property((Property)PaymentTransferTypeDTO.CHANNELS, BankingKeys.TransferTypes.CHANNELS).property((Property)PaymentTransferTypeDTO.PRINCIPAL_TYPES, BankingKeys.TransferTypes.PRINCIPAL_TYPES).property((Property)PaymentTransferTypeDTO.PRIORITY, BankingKeys.TransferTypes.PRIORITY).property((Property)PaymentTransferTypeDTO.RESTRICT_TO, BankingKeys.TransferTypes.RESTRICT_TO).property((Property)PaymentTransferTypeDTO.RESTRICT_TO_GROUPS, BankingKeys.TransferTypes.RESTRICT_TO_GROUPS).property((Property)PaymentTransferTypeDTO.RESTRICT_TO_USERS, BankingKeys.TransferTypes.RESTRICT_TO_USERS).property((Property)PaymentTransferTypeDTO.ALLOWS_RECURRING_PAYMENTS, BankingKeys.TransferTypes.ALLOWS_RECURRING_PAYMENTS).property((Property)PaymentTransferTypeDTO.SHOW_RECURRING_PAYMENTS_TO_RECEIVER, BankingKeys.TransferTypes.SHOW_RECURRING_PAYMENTS_TO_RECEIVER).property((Property)PaymentTransferTypeDTO.ALLOWS_SCHEDULED_PAYMENTS, BankingKeys.TransferTypes.ALLOWS_SCHEDULED_PAYMENTS).property((Property)PaymentTransferTypeDTO.MAX_INSTALLMENTS, BankingKeys.TransferTypes.MAX_INSTALLMENTS).property((Property)PaymentTransferTypeDTO.SHOW_SCHEDULED_PAYMENTS_TO_RECEIVER, BankingKeys.TransferTypes.SHOW_SCHEDULED_PAYMENTS_TO_RECEIVER).property((Property)PaymentTransferTypeDTO.RESERVE_TOTAL_AMOUNT_ON_SCHEDULED_PAYMENTS, BankingKeys.TransferTypes.RESERVE_TOTAL_AMOUNT_ON_SCHEDULED_PAYMENTS).property((Property)PaymentTransferTypeDTO.RESERVE_APPROVED_TICKET_AMOUNT, BankingKeys.TransferTypes.RESERVE_APPROVED_TICKET_AMOUNT).property((Property)PaymentTransferTypeDTO.REQUIRES_FEEDBACK, BankingKeys.TransferTypes.ENABLE_FEEDBACK).property((Property)PaymentTransferTypeDTO.FEEDBACK_SETTING, BankingKeys.TransferTypes.FEEDBACK_SETTING).property((Property)PaymentTransferTypeDTO.FEEDBACK_EXPIRATION_DAYS, BankingKeys.TransferTypes.FEEDBACK_EXPIRATION_DAYS).property((Property)PaymentTransferTypeDTO.FEEDBACK_REMINDER_DAYS, BankingKeys.TransferTypes.FEEDBACK_REMINDER_DAYS).property((Property)PaymentTransferTypeDTO.FEEDBACK_EXPIRATION_REMINDER_DAYS, BankingKeys.TransferTypes.FEEDBACK_EXPIRATION_REMINDER_DAYS).property((Property)PaymentTransferTypeDTO.MAX_DAYS_TO_CHANGE_FEEDBACK, BankingKeys.TransferTypes.MAX_DAYS_TO_CHANGE_FEEDBACK).property((Property)PaymentTransferTypeDTO.FEEDBACK_REPLY_EXPIRATION_DAYS, BankingKeys.TransferTypes.FEEDBACK_REPLY_EXPIRATION_DAYS).property((Property)PaymentTransferTypeDTO.DEFAULT_FEEDBACK_LEVEL, BankingKeys.TransferTypes.DEFAULT_FEEDBACK_LEVEL).property((Property)PaymentTransferTypeDTO.DEFAULT_FEEDBACK_COMMENTS, BankingKeys.TransferTypes.DEFAULT_FEEDBACK_COMMENTS).property((Property)PaymentTransferTypeDTO.MATURITY_HISTORY_SIZE, BankingKeys.TransferTypes.MATURITY_HISTORY_SIZE).property((Property)PaymentTransferTypeDTO.MATURITY_POLICY, BankingKeys.TransferTypes.MATURITY_POLICY).ignore((Property)PaymentTransferTypeDTO.USE_FIXED_AMOUNT).ignore((Property)PaymentTransferTypeDTO.FEEDBACK_ENABLED_SINCE);
        }
        return entityLogDescriptor;
    }

    @Override
    protected TransferType getEntityToViewLog(long l) {
        return this.hasPermission(Permission.ACCOUNT_CONFIGURATION_VIEW) ? this.find(TransferType.class, l) : null;
    }

    private Class<? extends TransferTypeDTO> resolveDTOType(TransferType transferType) {
        return transferType instanceof GeneratedTransferType ? GeneratedTransferTypeDTO.class : PaymentTransferTypeDTO.class;
    }

    private PropertyAccess toAmountAccess(Property<?, PaymentTransferTypeDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                if (super.get(object) == null) {
                    return null;
                }
                TransferType transferType = (TransferType)object;
                BigDecimal bigDecimal = (BigDecimal)super.get(object);
                return TransferTypeEntityLogHandlerImpl.this.getFormatter().format(bigDecimal, transferType.getCurrency().getPrecision());
            }
        };
    }
}

