/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.utils.notifications.EntityNotificationProcessingHandler;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionNotificationProcessingHandlerImpl
extends BaseGlobalHandlerImpl
implements EntityNotificationProcessingHandler<Transaction> {
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    private PaymentRequestServiceLocal paymentRequestService;
    @Autowired
    private PaymentServiceLocal paymentService;

    public NotificationProcessingEntityType<Transaction> getType() {
        return NotificationProcessingEntityType.TRANSACTION;
    }

    public List<Transaction> loadToNotify(List<Long> list) {
        QTransaction qTransaction = QTransaction.transaction1;
        return ((DBQuery)this.selectFrom(qTransaction).where((Predicate)qTransaction.id.in(list))).fetch();
    }

    public void process(Transaction transaction) {
        switch (transaction.getNature()) {
            case PAYMENT: {
                this.paymentService.notifyPaymentPerformed((Payment)transaction);
                break;
            }
            case RECURRING_PAYMENT: {
                this.recurringPaymentService.notifyPaymentPerformed((RecurringPayment)transaction);
                break;
            }
            case SCHEDULED_PAYMENT: {
                this.scheduledPaymentService.notifyPaymentPerformed((ScheduledPayment)transaction);
                break;
            }
            case PAYMENT_REQUEST: {
                this.paymentRequestService.notifyRequestSend((PaymentRequest)transaction);
                break;
            }
            default: {
                this.getLogger().warn("Unexpected transaction for notification processing: {}, id={}", (Object)transaction.getNature(), (Object)transaction.getId());
            }
        }
    }
}

