/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionVOConverter;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.model.Availability;
import org.cyclos.model.access.clients.AccessClientDetailedVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.BasePaymentVO;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionDetailedVOConverter<VO extends TransactionDetailedVO>
extends TransactionVOConverter<VO> {
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private TicketServiceLocal ticketService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private BasicUserServiceLocal basicUserServiceLocal;
    @Autowired
    private AccessClientServiceLocal accessClientService;
    @Autowired
    private DataTranslationHandler dataTranslationHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private TransactionServiceLocal transactionServiceLocal;

    public TransactionDetailedVOConverter() {
        this(TransactionDetailedVO.class);
    }

    public TransactionDetailedVOConverter(Class<VO> clazz) {
        super(clazz);
        this.registerMapping(Payment.class, PaymentVO.class);
        this.registerMapping(RecurringPayment.class, RecurringPaymentVO.class);
        this.registerMapping(ScheduledPayment.class, ScheduledPaymentVO.class);
        this.registerMapping(PaymentRequest.class, PaymentRequestVO.class);
        this.registerMapping(ExternalPayment.class, ExternalPaymentVO.class);
        this.registerMapping(Ticket.class, TicketVO.class);
    }

    @Override
    protected void fill(Object object, VO VO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        Object object2;
        Object object3;
        Object object4;
        BasicUser basicUser;
        Transaction transaction;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            CollectionUtils.addAll(arrayList, (Object[])objectArray);
        }
        arrayList.add(TransactionDetailedVO.CUSTOM_VALUES);
        arrayList.add(TransactionDetailedVO.BY);
        arrayList.add(BasePaymentVO.RECEIVED_BY);
        arrayList.add(TransactionDetailedVO.ACCESS_CLIENT);
        super.fill(object, VO, arrayList.toArray(), conversionContext);
        SessionData sessionData = this.getSessionData();
        if (object instanceof Transaction) {
            transaction = (Transaction)object;
            basicUser = transaction.getBy();
            if (basicUser != null) {
                object4 = null;
                if (basicUser.isOperator()) {
                    object4 = this.transactionServiceLocal.convertToOperatorVO((Operator)basicUser);
                } else if (basicUser.isAdmin() || sessionData.relatesTo(basicUser)) {
                    object4 = (BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, basicUser);
                    if (!this.basicUserServiceLocal.canViewProfile(basicUser)) {
                        object4.setId(null);
                    }
                }
                VO.setBy((BasicUserVO)object4);
            }
            VO.setAccessClient((AccessClientDetailedVO)this.conversionHandler.convert(AccessClientDetailedVO.class, this.getAccessClient(transaction)));
            object4 = new HashSet(this.transactionCustomFieldService.listVisible((AccountOwner)transaction.getFromOwner()));
            object4.addAll(this.transactionCustomFieldService.listVisible(transaction.getToOwner()));
            object3 = CollectionHelper.sort((Collection)object4);
            object2 = new ArrayList();
            Set set = transaction.getCustomValues();
            if (CollectionHelper.isNotEmpty((Iterable)object3) && CollectionHelper.isNotEmpty((Iterable)set)) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    TransactionCustomField transactionCustomField = (TransactionCustomField)iterator.next();
                    TransactionCustomFieldValue transactionCustomFieldValue = (TransactionCustomFieldValue)CustomFieldHelper.findValue((ICustomField)transactionCustomField, (Collection)transaction.getCustomValues());
                    if (transactionCustomFieldValue == null) continue;
                    CustomFieldValueVO customFieldValueVO = (CustomFieldValueVO)this.conversionHandler.convert(CustomFieldValueVO.class, transactionCustomFieldValue);
                    object2.add(customFieldValueVO);
                }
            }
            VO.setCustomValues((List)object2);
        }
        if (object instanceof BasePayment) {
            transaction = (BasePayment)object;
            basicUser = (BasePaymentVO)VO;
            object4 = transaction.getPaymentType();
            basicUser.setReceivedBy(this.transactionServiceLocal.convertToOperatorVO(transaction.getReceivedBy()));
            if (StringHelper.isBlank((Object)transaction.getDescription()) && object4.getDescriptionAvailability() != Availability.DISABLED) {
                basicUser.setDescription(this.dataTranslationHandler.getValue((BaseEntity)object4, QPaymentTransferType.paymentTransferType.valueForEmptyDescription));
            }
        }
        if (object instanceof ScheduledPayment) {
            transaction = (ScheduledPayment)object;
            if (transaction.getStatus() != ScheduledPaymentStatus.CANCELED) {
                basicUser = (ScheduledPaymentVO)VO;
                object4 = this.scheduledPaymentService.calculateDueAmount((ScheduledPayment)transaction);
                object3 = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, transaction.getCurrency());
                basicUser.setDueAmount(ModelHelper.currencyAmount((CurrencyVO)object3, (BigDecimal)object4));
            }
        } else if (object instanceof ExternalPayment) {
            transaction = (ExternalPayment)object;
            basicUser = transaction.getToPrincipalType();
            if (basicUser.getInternalName().equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                object4 = this.configurationHandler.getDefaultAccessor();
                object3 = this.phoneNumberHandler.parse(transaction.getToPrincipalValue(), (ConfigurationAccessor)object4);
                object2 = (ExternalPaymentVO)VO;
                object2.setToPrincipalValue(object3 == null ? transaction.getToPrincipalValue() : this.phoneNumberHandler.format((PhoneNumberDescriptor)object3, sessionData.getConfiguration()));
            }
        } else if (object instanceof Ticket) {
            transaction = (Ticket)object;
            basicUser = (TicketVO)VO;
            basicUser.setApproveUrl(this.ticketService.getApproveUrl((Ticket)transaction));
            if (transaction.getStatus() == TicketStatus.OPEN && transaction.getFromUser() != null && (object4 = this.profileFieldHandler.getPrincipal((BasicUser)transaction.getFromUser(), sessionData.getChannelAccessAccessor())) != null) {
                basicUser.setPayerPrincipal(object4.getPrincipal());
            }
        }
    }

    private AccessClient getAccessClient(Transaction transaction) {
        AccessClient accessClient = transaction.getAccessClient();
        if (accessClient != null && this.accessClientService.isVisible(accessClient)) {
            return accessClient;
        }
        return null;
    }
}

