/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QDirtyAccountBalance;
import org.cyclos.impl.banking.AccountLockKey;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanAccountBalancesRecurringTask
extends EntityBatchRecurringTask<Account> {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private LockHandler lockHandler;
    private Set<Long> lockFailed = new HashSet<Long>();

    public CleanAccountBalancesRecurringTask() {
        super(Account.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.CLEAN_ACCOUNT_BALANCES;
    }

    @Override
    protected void finish(Account account, Throwable throwable) throws Throwable {
        this.lockFailed.add(account.getId());
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QDirtyAccountBalance qDirtyAccountBalance = QDirtyAccountBalance.dirtyAccountBalance;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qDirtyAccountBalance}).distinct()).limit(200L)).where((Predicate)(this.lockFailed.isEmpty() ? qDirtyAccountBalance.account().id.isNotNull() : qDirtyAccountBalance.account().id.notIn(this.lockFailed)))).list((Expression)qDirtyAccountBalance.account().id);
    }

    @Override
    protected void onFinish() {
        this.lockFailed.clear();
    }

    @Override
    protected void process(Account account) throws Throwable {
        boolean bl = this.lockHandler.tryLock(AccountLockKey.of(account));
        if (bl) {
            NativeAccountStatus nativeAccountStatus = this.accountService.getNativeAccountStatus(account, null);
            this.accountService.updateBalance(account, nativeAccountStatus.getBalance(), nativeAccountStatus.getDirtyTransferIds());
        } else {
            this.lockFailed.add(account.getId());
        }
    }
}

