/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QAuthorizationLevel;
import org.cyclos.entities.banking.QAuthorizationRole;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.AuthorizationLevelServiceLocal;
import org.cyclos.impl.banking.AuthorizationRoleServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelDTO;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelData;
import org.cyclos.model.banking.authorizationlevels.AuthorizationLevelVO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationLevelServiceImpl
extends CRUDServiceImpl<AuthorizationLevel, QAuthorizationLevel, AuthorizationLevelDTO, AuthorizationLevelData, TransferTypeVO>
implements AuthorizationLevelServiceLocal {
    @Autowired
    private AuthorizationRoleServiceLocal authorizationRoleService;

    public AuthorizationLevelServiceImpl() {
        super(AuthorizationLevel.class, QAuthorizationLevel.authorizationLevel, AuthorizationLevelDTO.class);
    }

    public List<AuthorizationLevelVO> list(TransferTypeVO transferTypeVO) {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        if (transferType instanceof PaymentTransferType) {
            return ((DBQuery)((DBQuery)this.from().where((Predicate)((QAuthorizationLevel)this.$).transferType().eq((Object)((PaymentTransferType)transferType)))).orderBy(((QAuthorizationLevel)this.$).level.asc())).list(AuthorizationLevelVO.class, (Expression)this.$);
        }
        return Collections.emptyList();
    }

    public List<AuthorizationLevel> listByBroker() {
        return ((DBQuery)this.from().where((Predicate)((QAuthorizationLevel)this.$).broker.isTrue())).list((Expression)this.$);
    }

    public List<AuthorizationLevel> listByPayer() {
        return ((DBQuery)this.from().where((Predicate)((QAuthorizationLevel)this.$).payer.isTrue())).list((Expression)this.$);
    }

    public List<AuthorizationLevel> listByReceiver() {
        return ((DBQuery)this.from().where((Predicate)((QAuthorizationLevel)this.$).receiver.isTrue())).list((Expression)this.$);
    }

    public List<AuthorizationLevel> listByRoles(Set<AuthorizationRole> set) {
        if (CollectionHelper.isEmpty(set)) {
            return Collections.emptyList();
        }
        return ((DBQuery)this.from().where((Predicate)((QAuthorizationRole)((QAuthorizationLevel)this.$).roles.any()).in(set))).list((Expression)this.$);
    }

    @Override
    public AuthorizationLevel newEntity(TransferTypeVO transferTypeVO) {
        AuthorizationLevel authorizationLevel = new AuthorizationLevel();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        authorizationLevel.setTransferType(paymentTransferType);
        return authorizationLevel;
    }

    public void removeEmptyLevels() {
        DBQuery dBQuery = (DBQuery)this.from().where(new Predicate[]{((QAuthorizationLevel)this.$).broker.eq(Boolean.valueOf(false)), ((QAuthorizationLevel)this.$).payer.eq(Boolean.valueOf(false)), ((QAuthorizationLevel)this.$).receiver.eq(Boolean.valueOf(false)), ((QAuthorizationLevel)this.$).roles.isEmpty()});
        List list = dBQuery.list(AuthorizationLevel.class, (Expression)this.$);
        this.removeAll(list);
    }

    @Override
    protected AuthorizationLevelData getData(AuthorizationLevel authorizationLevel) {
        PaymentTransferType paymentTransferType = authorizationLevel.getTransferType();
        List list = paymentTransferType.getAuthorizationLevels();
        boolean bl = paymentTransferType.isFromUser();
        boolean bl2 = paymentTransferType.isToUser();
        boolean bl3 = paymentTransferType.isFromUser();
        for (AuthorizationLevel authorizationLevel2 : list) {
            if (authorizationLevel2.equals((Object)authorizationLevel)) continue;
            if (authorizationLevel2.isBroker()) {
                bl = false;
            }
            if (authorizationLevel2.isPayer()) {
                bl3 = false;
            }
            if (!authorizationLevel2.isReceiver()) continue;
            bl2 = false;
        }
        AuthorizationLevelData authorizationLevelData = new AuthorizationLevelData();
        authorizationLevelData.setDto((EntityDTO)((AuthorizationLevelDTO)this.toDTO(authorizationLevel)));
        authorizationLevelData.setAllowBroker(bl);
        authorizationLevelData.setAllowReceiver(bl2);
        authorizationLevelData.setAllowPayer(bl3);
        authorizationLevelData.setRoles(this.conversionHandler.convertList(AuthorizationRoleVO.class, (Iterable)this.authorizationRoleService.listAll()));
        authorizationLevelData.setFirst(list.size() == 0);
        authorizationLevelData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
        if (authorizationLevel.isTransient() && !authorizationLevelData.isAllowBroker() && !authorizationLevelData.isAllowPayer() && !authorizationLevelData.isAllowReceiver() && authorizationLevelData.getRoles().isEmpty()) {
            throw new IllegalActionException();
        }
        return authorizationLevelData;
    }

    @Override
    protected void onAfterRemove(AuthorizationLevel authorizationLevel) {
        List list = ((DBQuery)this.from().where((Predicate)((QAuthorizationLevel)this.$).transferType().eq((Object)authorizationLevel.getTransferType()))).list(AuthorizationLevel.class, (Expression)this.$);
        Collections.sort(list);
        int n = 1;
        for (AuthorizationLevel authorizationLevel2 : list) {
            authorizationLevel2.setLevel(Integer.valueOf(n));
            ++n;
        }
        this.flush();
    }

    @Override
    protected void onAfterSave(AuthorizationLevel authorizationLevel, AuthorizationLevel authorizationLevel2, Object object) {
        if (authorizationLevel2 == null) {
            PaymentTransferType paymentTransferType = authorizationLevel.getTransferType();
            paymentTransferType.getAuthorizationLevels().add(authorizationLevel);
        }
    }

    @Override
    protected void onBeforeRemove(AuthorizationLevel authorizationLevel) {
        AuthorizationLevel authorizationLevel2;
        if (authorizationLevel.getLevel() == 1 && authorizationLevel.isReceiver() && (authorizationLevel2 = this.getAuthorizationLevel(authorizationLevel.getTransferType(), 2)) != null && authorizationLevel2.isPayer()) {
            String string = this.message(BankingKeys.AuthorizationLevels.ERROR_LEVEL_CAN_NOT_BE_REMOVED, new Object[0]);
            ValidationResult validationResult = new ValidationResult(string);
            throw new ValidationException(validationResult);
        }
    }

    @Override
    protected Object onBeforeSave(AuthorizationLevel authorizationLevel, AuthorizationLevel authorizationLevel2) {
        if (authorizationLevel2 == null) {
            PaymentTransferType paymentTransferType = authorizationLevel.getTransferType();
            Integer n = paymentTransferType.getAuthorizationLevels().size();
            authorizationLevel.setLevel(Integer.valueOf(n + 1));
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(AuthorizationLevelDTO authorizationLevelDTO, AuthorizationLevel authorizationLevel) {
        authorizationLevel.getRoles().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAuthorizationLevel)this.$).transferType().from().currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(AuthorizationLevelDTO authorizationLevelDTO) {
        DecimalRangeDTO decimalRangeDTO;
        Validator validator = new Validator();
        validator.property((Property)AuthorizationLevelDTO.TRANSFER_TYPE, BankingKeys.AuthorizationLevels.TRANSFER_TYPE).required();
        if (!(authorizationLevelDTO.isBroker() || authorizationLevelDTO.isPayer() || authorizationLevelDTO.isReceiver())) {
            validator.property((Property)AuthorizationLevelDTO.ROLES, BankingKeys.AuthorizationLevels.ROLES).required();
        }
        if ((decimalRangeDTO = authorizationLevelDTO.getAmountRange()) != null && ObjectHelper.coalesce((Object[])new BigDecimal[]{decimalRangeDTO.getMax(), decimalRangeDTO.getMin()}) != null) {
            TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)authorizationLevelDTO.getTransferType());
            if (decimalRangeDTO.getMax() != null) {
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)NestedProperty.nested((Property)AuthorizationLevelDTO.AMOUNT_RANGE, (Property)DecimalRangeDTO.MAX), BankingKeys.AuthorizationLevels.LOWER_THAN_AMOUNT_VALUE).positiveNonZero((HasCurrency)transferType);
                if (decimalRangeDTO.getMin() != null) {
                    property.greaterThan((Comparable)decimalRangeDTO.getMin());
                }
            }
        }
        return validator;
    }

    private AuthorizationLevel getAuthorizationLevel(PaymentTransferType paymentTransferType, Integer n) {
        return (AuthorizationLevel)((DBQuery)((DBQuery)this.from().where(new Predicate[]{((QAuthorizationLevel)this.$).transferType().eq((Object)paymentTransferType), ((QAuthorizationLevel)this.$).level.eq((Object)n)})).orderBy(((QAuthorizationLevel)this.$).level.asc())).singleResult((Expression)this.$);
    }
}

