/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.contentmanagement.FrontendDashboardContent;
import org.cyclos.entities.contentmanagement.FrontendFooterContent;
import org.cyclos.entities.contentmanagement.FrontendHelpContent;
import org.cyclos.entities.contentmanagement.FrontendHomeContent;
import org.cyclos.entities.contentmanagement.QBaseStaticContent;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.impl.app.InternalFrontendServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.contentmanagement.BannerServiceLocal;
import org.cyclos.impl.contentmanagement.InternalUiServiceLocal;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.QuickAccessHandler;
import org.cyclos.impl.users.UserFrontendSettingsServiceLocal;
import org.cyclos.impl.users.UserQuickAccessServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.contentmanagement.contentitems.BannerDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.FrontendScreenSize;
import org.cyclos.model.contentmanagement.staticcontents.ContentVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendContentVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendDashboardContentVO;
import org.cyclos.model.contentmanagement.themes.ThemeDefinition;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeMapMarker;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.configurations.FrontendDashboardAccounts;
import org.cyclos.model.users.addresses.AdAddressResult;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.app.FrontendData;
import org.cyclos.server.model.app.FrontendHomeData;
import org.cyclos.server.model.app.FrontendIconVO;
import org.cyclos.server.model.app.WebManifestData;
import org.cyclos.server.model.app.WebManifestIconVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalFrontendServiceImpl
extends BaseServiceImpl
implements InternalFrontendServiceLocal {
    private static final int[] ICON_SIZES = new int[]{192, 160, 96, 64, 32, 16};
    private static final int[] APPLE_TOUCH_ICON_SIZES = new int[]{180, 192, 167, 152, 120, 76};
    private static final int[] WEB_MANIFEST_ANY_SIZES = new int[]{48, 72, 96, 144, 168, 192, 256, 512};
    private static final int[] WEB_MANIFEST_MASKABLE_SIZES = new int[]{192, 256, 512};
    private static final Set<PasswordStatus> PASSWORD_STATUS_NEEDING_ATTENTION = EnumSet.of(PasswordStatus.EXPIRED, PasswordStatus.RESET, PasswordStatus.PENDING, PasswordStatus.NEVER_CREATED);
    @Autowired
    private InternalUiServiceLocal internalUiService;
    @Autowired
    private BannerServiceLocal bannerService;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private UserFrontendSettingsServiceLocal userFrontendSettingsService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private ThemeServiceLocal themeService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationServiceLocal;
    @Autowired
    private UserQuickAccessServiceLocal userQuickAccessService;
    @Autowired
    private QuickAccessHandler quickAccessHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private TotpServiceLocal totpService;

    public String getApiDescriptorLastModified() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Date date = configurationAccessor.getApiDescriptorLastModified();
        return date == null ? null : String.valueOf(date.getTime());
    }

    public FrontendData getFrontendData(FrontendScreenSize frontendScreenSize) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Configuration configuration = configurationAccessor.getConfiguration();
        Theme theme = sessionData.isGuest() ? configurationAccessor.getGuestsTheme() : configurationAccessor.getUsersTheme();
        Theme theme2 = configurationAccessor.getAppTheme();
        FrontendData frontendData = new FrontendData();
        ConfigurationImageVO configurationImageVO = this.configurationImageService.getImageVO(new ConfigurationVO(configuration.getId()), ConfigurationImageType.APP_LOGO);
        frontendData.setLogo(configurationImageVO);
        frontendData.setMapMarker(this.themeImageService.getImageVO(theme.getId(), ThemeImageType.MAP_MARKER, ThemeMapMarker.REGULAR.name()));
        frontendData.setAltMapMarker(this.themeImageService.getImageVO(theme.getId(), ThemeImageType.MAP_MARKER, ThemeMapMarker.ALTERNATE.name()));
        ArrayList<FrontendIconVO> arrayList = new ArrayList<FrontendIconVO>();
        for (int n : ICON_SIZES) {
            arrayList.add(this.icon(configurationImageVO, n));
        }
        for (int n : APPLE_TOUCH_ICON_SIZES) {
            arrayList.add(this.appleTouchIcon(configurationImageVO, n));
        }
        arrayList.add(this.icon(configurationImageVO, null));
        frontendData.setIcons(arrayList);
        frontendData.setFrontend(this.userFrontendSettingsService.get().getFrontend());
        String string = this.dataTranslationHandler.getValue(configurationAccessor.getLanguage(), (BaseEntity)configurationAccessor.getFrontendHomeContent(), QBaseStaticContent.baseStaticContent.content);
        frontendData.setHasHomePage(StringHelper.isNotBlank((Object)string));
        FrontendHelpContent frontendHelpContent = configurationAccessor.getFrontendHelpContent();
        if (frontendHelpContent != null && frontendHelpContent.isEnabled()) {
            String string2 = this.dataTranslationHandler.getValue(configurationAccessor.getLanguage(), (BaseEntity)configurationAccessor.getFrontendHelpContent(), QBaseStaticContent.baseStaticContent.content);
            frontendData.setHasHelp(StringHelper.isNotBlank((Object)string2));
        }
        frontendData.setAllowFrontendSwitching(this.isAllowFrontendSwitching(sessionData.getLoggedBasicUser()));
        frontendData.setSvgIconNames((Set)this.initializationService.getSvgIconNames());
        frontendData.setExternalLoginUrl(configurationAccessor.getLoginUrl());
        frontendData.setAfterLogoutUrl(configurationAccessor.getLogoutUrl());
        frontendData.setLocales(LocaleHelper.localesStr());
        frontendData.setTitle(configurationAccessor.getFrontendTitle());
        frontendData.setMobileTitle(configurationAccessor.getFrontendMobileTitle());
        frontendData.setVoucherBuyingMenu(configurationAccessor.getVoucherBuyingMenu());
        frontendData.setMobileMenuTitle(configurationAccessor.getFrontendMobileMenuTitle());
        frontendData.setMobileLandingPage(configurationAccessor.getFrontendMobileLandingPage());
        frontendData.setMenuBar(configurationAccessor.isFrontendMenuBar());
        frontendData.setUiData(this.internalUiService.getData(null, false, null, null, null));
        if (frontendScreenSize == FrontendScreenSize.DESKTOP) {
            frontendData.setBanners(this.conversionHandler.convertList(BannerDetailedVO.class, (Iterable)this.bannerService.getFrontendBanners()));
            frontendData.getBanners().removeIf(bannerDetailedVO -> StringHelper.isBlank((Object)bannerDetailedVO.getContent()));
        }
        frontendData.setPages(this.menuEntryService.getMenu(Frontend.NEW));
        frontendData.setTopUpEnabled(this.voucherConfigurationServiceLocal.listVisible(sessionData.getLoggedUser()).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null));
        frontendData.setCanManageQuickAccess(sessionData.hasPermission(Permission.MY_QUICK_ACCESS_SETTINGS_ENABLE));
        frontendData.setDevelopment(this.cyclosProperties.isDevelopment());
        FrontendFooterContent frontendFooterContent = configurationAccessor.getFrontendFooterContent();
        frontendData.setFooter((ContentVO)this.conversionHandler.convert(ContentVO.class, (Object)frontendFooterContent));
        frontendData.setTheme((ThemeVO)this.conversionHandler.convert(ThemeVO.class, (Object)theme2));
        return frontendData;
    }

    public FrontendDashboardContentVO getHelp() {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        FrontendHelpContent frontendHelpContent = configurationAccessor.getFrontendHelpContent();
        if (!frontendHelpContent.isEnabled()) {
            return null;
        }
        return (FrontendDashboardContentVO)this.conversionHandler.convert(FrontendDashboardContentVO.class, (Object)frontendHelpContent);
    }

    public FrontendHomeData getHomeData(FrontendScreenSize frontendScreenSize) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        FrontendHomeData frontendHomeData = new FrontendHomeData();
        if (sessionData.isGuest()) {
            FrontendHomeContent frontendHomeContent = this.getSessionData().getConfiguration().getFrontendHomeContent();
            frontendHomeData.setGuestHomePage((FrontendContentVO)this.conversionHandler.convert(FrontendContentVO.class, (Object)frontendHomeContent));
        } else {
            FrontendDashboardContent frontendDashboardContent;
            User user = sessionData.getLoggedUser();
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            frontendHomeData.setQuickAccess(this.userQuickAccessService.listEnabled().stream().map(arg_0 -> ((QuickAccessHandler)this.quickAccessHandler).toRunnableDTO(arg_0)).collect(Collectors.toList()));
            if (frontendScreenSize != FrontendScreenSize.FEATURE && frontendScreenSize != FrontendScreenSize.MOBILE) {
                List list;
                frontendDashboardContent = (FrontendDashboardAccounts)ObjectHelper.defaultValue((Object)configurationAccessor.getFrontendDashboardAccounts(), (Object)FrontendDashboardAccounts.NONE);
                if (frontendDashboardContent != FrontendDashboardAccounts.NONE) {
                    list = this.accountService.listVisible(this.accountHandler.getAccountOwner());
                    list.removeIf(account -> {
                        OperatorGroupAccountAccess operatorGroupAccountAccess = this.operatorService.accountAccess(account);
                        return operatorGroupAccountAccess != null && operatorGroupAccountAccess != OperatorGroupAccountAccess.ALL_PAYMENTS;
                    });
                    frontendHomeData.setAccounts(new ArrayList(list.size()));
                    for (Account account2 : list) {
                        int n = list.size() == 1 || frontendDashboardContent == FrontendDashboardAccounts.INDIVIDUAL ? 3 : 0;
                        frontendHomeData.getAccounts().add(this.accountService.getFrontendDashbordAcccount(account2, n));
                    }
                    frontendHomeData.setMergeAccounts(Boolean.valueOf(frontendDashboardContent == FrontendDashboardAccounts.MERGED && list.size() > 1));
                }
                if (configurationAccessor.isFrontendDashboardUsers()) {
                    list = new UserQuery();
                    list.setSkipTotalCount(true);
                    list.setGroups(ModelHelper.toVOs(BasicGroupVO.class, (Collection)this.groupsHandler.menu().users().items()));
                    BasicProfileFieldValueForSearchDTO basicProfileFieldValueForSearchDTO = new BasicProfileFieldValueForSearchDTO();
                    basicProfileFieldValueForSearchDTO.setField(BasicProfileField.IMAGE);
                    basicProfileFieldValueForSearchDTO.setBooleanValue(Boolean.valueOf(true));
                    list.setProfileFields(Collections.singleton(basicProfileFieldValueForSearchDTO));
                    list.setAddressResult(UserAddressResult.NO_ADDRESSES);
                    list.setUserStatus(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED));
                    list.setIgnoreProfileFieldsInList(true);
                    list.setPageSize(6);
                    list.setOrderBy(UserOrderBy.CREATION_DATE);
                    frontendHomeData.setLatestUsers(this.userService.search((UserQuery)list).getPageItems());
                    frontendHomeData.setShowLatestUsers(true);
                }
                if (configurationAccessor.isFrontendDashboardAds()) {
                    list = new BasicAdQuery();
                    list.setSkipTotalCount(true);
                    list.setGroups(ModelHelper.toVOs(BasicGroupVO.class, (Collection)this.groupsHandler.ads().users().items()));
                    list.setHasImages(true);
                    list.setAddressResult(AdAddressResult.NO_ADDRESSES);
                    list.setStatuses(EnumSet.of(AdStatus.ACTIVE));
                    list.setPageSize(6);
                    list.setOrderBy(AdOrderBy.DATE);
                    if (sessionData.getNetwork() != null) {
                        frontendHomeData.setLatestAds(this.adService.search((BasicAdQuery)list).getPageItems());
                        frontendHomeData.setShowLatestAds(true);
                    }
                }
            }
            if (frontendScreenSize != FrontendScreenSize.FEATURE) {
                frontendDashboardContent = configurationAccessor.getFrontendDashboardContent();
                frontendHomeData.setDashboardContent((FrontendDashboardContentVO)this.conversionHandler.convert(FrontendDashboardContentVO.class, (Object)frontendDashboardContent));
            }
            if (Objects.equals(sessionData.getNetwork(), user.getNetwork())) {
                frontendHomeData.setPendingSecurityQuestion(Boolean.valueOf(this.passwordService.isPendingSecurityQuestion()));
                frontendHomeData.setPendingTotp(Boolean.valueOf(this.totpService.isPendingActivation((BasicUser)user)));
                frontendDashboardContent = this.passwordService.getData(new UserLocatorVO(user.getId()));
                frontendHomeData.setPasswordsNeedingAttention(frontendDashboardContent.getPasswords().stream().filter(passwordData -> CollectionHelper.containsAny((Collection)passwordData.getActions(), (Object[])new Object[]{PasswordAction.CHANGE, PasswordAction.ACTIVATE}) && PASSWORD_STATUS_NEEDING_ATTENTION.contains(passwordData.getStatus())).collect(Collectors.toList()));
            }
        }
        return frontendHomeData;
    }

    public WebManifestData getWebManifestData(boolean bl) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        String string = StringHelper.removeEnd((String)sessionData.getRequestData().getBaseUrl(), (String)"/");
        String string2 = string + "/ui/";
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Configuration configuration = configurationAccessor.getConfiguration();
        Theme theme = configurationAccessor.getAppTheme();
        WebManifestData webManifestData = new WebManifestData();
        webManifestData.setName(configurationAccessor.getFrontendTitle());
        webManifestData.setShortName(configurationAccessor.getFrontendMobileTitle());
        webManifestData.setThemeColor(this.themeService.getDefinition(theme, ThemeDefinition.APP_PRIMARY));
        webManifestData.setBackgroundColor("#f8f9fa");
        webManifestData.setDisplay("standalone");
        webManifestData.setScope(string2);
        webManifestData.setStartUrl(string2);
        webManifestData.setIcons(ListUtils.union(this.manifestIcons(configuration, ConfigurationImageType.APP_LOGO, WEB_MANIFEST_ANY_SIZES, "any"), this.manifestIcons(configuration, ConfigurationImageType.MASKABLE_LOGO, WEB_MANIFEST_MASKABLE_SIZES, "maskable")));
        return webManifestData;
    }

    public boolean isAllowFrontendSwitching(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor;
        if (basicUser == null) {
            SessionData sessionData = this.getSessionData();
            basicUser = sessionData.getLoggedBasicUser();
            configurationAccessor = sessionData.getConfiguration();
        } else {
            configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        }
        if (basicUser != null && (basicUser.isGlobalAdmin() || basicUser.isNetworkAdmin())) {
            return true;
        }
        return configurationAccessor.isAllowFrontendSwitching();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private FrontendIconVO appleTouchIcon(ConfigurationImageVO configurationImageVO, int n) {
        FrontendIconVO frontendIconVO = new FrontendIconVO();
        frontendIconVO.setRel("apple-touch-icon");
        frontendIconVO.setImage(configurationImageVO);
        frontendIconVO.setWidth(Integer.valueOf(n));
        frontendIconVO.setHeight(Integer.valueOf(n));
        return frontendIconVO;
    }

    private FrontendIconVO icon(ConfigurationImageVO configurationImageVO, Integer n) {
        FrontendIconVO frontendIconVO = new FrontendIconVO();
        frontendIconVO.setRel(n == null ? "shortcut icon" : "icon");
        frontendIconVO.setImage(configurationImageVO);
        if (n != null) {
            frontendIconVO.setWidth(n);
            frontendIconVO.setHeight(n);
        }
        return frontendIconVO;
    }

    private List<WebManifestIconVO> manifestIcons(Configuration configuration, ConfigurationImageType configurationImageType, int[] nArray, String string) {
        ConfigurationImageVO configurationImageVO = this.configurationImageService.getImageVO(new ConfigurationVO(configuration.getId()), configurationImageType);
        int n = configurationImageVO.getWidth();
        int n2 = configurationImageVO.getHeight();
        String string2 = this.configurationImageService.getUrl(configuration, configurationImageType);
        List<WebManifestIconVO> list = Arrays.stream(nArray).mapToObj(n3 -> {
            Object object = string2;
            if (n3 < n && n3 < n2) {
                object = (String)object + (((String)object).contains("?") ? "&" : "?") + "width=" + n3 + "&height=" + n3;
            }
            WebManifestIconVO webManifestIconVO = new WebManifestIconVO();
            webManifestIconVO.setType(configurationImageVO.getContentType());
            webManifestIconVO.setSizes(String.format("%dx%d", n3, n3));
            webManifestIconVO.setPurpose(string);
            webManifestIconVO.setSrc((String)object);
            return webManifestIconVO;
        }).collect(Collectors.toList());
        return list;
    }
}

