/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.bootstrap.CyclosPropertiesFactoryBean;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.BuiltinPrincipalTypeResolver;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.NFCTokenPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.QAccessClientPrincipalType;
import org.cyclos.entities.access.QCustomFieldPrincipalType;
import org.cyclos.entities.access.QPrincipalType;
import org.cyclos.entities.access.QTokenPrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductAccessClient;
import org.cyclos.entities.users.QProductMyAccessClient;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QProductTokenType;
import org.cyclos.entities.users.QProductUserTokenType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.PrincipalTypeCacheKey;
import org.cyclos.impl.access.PrincipalTypeContext;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ChannelConfigurationServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.principaltypes.AccessClientPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.ActivatablePrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.BuiltInPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.CustomFieldPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.CustomFieldPrincipalTypeData;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.PrincipalTypeData;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeData;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrincipalTypeServiceImpl
extends CRUDServiceImpl<PrincipalType, QPrincipalType, PrincipalTypeDTO, PrincipalTypeData, PrincipalTypeNature>
implements PrincipalTypeServiceLocal {
    private static final int NFC_TAG_MANAGEMENT_KEY_LEN = 16;
    private static final byte[] DEFAULT_NFC_TAG_MANAGEMENT_KEY = new byte[16];
    private static final String DEFAULT_NFC_TOKEN_LABEL_MASK = "#### #### #### ####";
    private static final BidiMap<Class<? extends PrincipalType>, Class<? extends PrincipalTypeDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final QProductAccessClient pac;
    private static final QProductMyAccessClient pmy;
    private byte[] nfcTokenPrincipalTypeKey;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ChannelConfigurationServiceLocal channelConfigurationService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<PrincipalTypeCacheKey, AccessorCacheValue> cache;

    public PrincipalTypeServiceImpl() {
        super(PrincipalType.class, QPrincipalType.principalType, PrincipalTypeDTO.class);
    }

    public PrincipalType find(String string, Network network) {
        PrincipalTypeCacheKey principalTypeCacheKey = new PrincipalTypeCacheKey(string, SimpleEntity.id((SimpleEntity)network));
        AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)principalTypeCacheKey, () -> {
            try {
                return AccessorCacheValue.create((Object)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QPrincipalType)this.$).internalName.eq((Object)string).and((Predicate)(network == null ? ((QPrincipalType)this.$).network().isNull() : ((QPrincipalType)this.$).network().isNull().or((Predicate)((QPrincipalType)this.$).network().eq((Object)network)))))).requiredUniqueResult((Expression)this.$));
            }
            catch (EntityNotFoundException entityNotFoundException) {
                entityNotFoundException.setEntityType(PrincipalType.class.getSimpleName());
                entityNotFoundException.setKey(string);
                throw entityNotFoundException;
            }
        });
        return (PrincipalType)accessorCacheValue.unwrap(this.getApplicationContext());
    }

    public BuiltInPrincipalType getAccountNumber() throws FrameworkException {
        return (BuiltInPrincipalType)this.find(ExistingBuiltInPrincipalType.ACCOUNT_NUMBER.getInternalName(), null);
    }

    public CustomFieldPrincipalType getCustomField(UserCustomField userCustomField) throws FrameworkException {
        QCustomFieldPrincipalType qCustomFieldPrincipalType = QCustomFieldPrincipalType.customFieldPrincipalType;
        return (CustomFieldPrincipalType)((DBQuery)this.from(new EntityPath[]{qCustomFieldPrincipalType}).where((Predicate)qCustomFieldPrincipalType.customField().eq((Object)userCustomField))).requiredUniqueResult((Expression)qCustomFieldPrincipalType);
    }

    public BuiltInPrincipalType getEmail() throws FrameworkException {
        return (BuiltInPrincipalType)this.find(ExistingBuiltInPrincipalType.EMAIL.getInternalName(), null);
    }

    public BuiltInPrincipalType getMobilePhone() throws FrameworkException {
        return (BuiltInPrincipalType)this.find(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName(), null);
    }

    public byte[] getPiccMasterKey(NFCTokenPrincipalType nFCTokenPrincipalType) {
        String string = this.applicationHandler.decrypt(nFCTokenPrincipalType.getPiccMasterKey(), this.getKeyMask(nFCTokenPrincipalType));
        return Base64.getDecoder().decode(string);
    }

    public BuiltInPrincipalType getTrustedDevice() throws FrameworkException {
        return (BuiltInPrincipalType)this.find(ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName(), null);
    }

    public BuiltInPrincipalType getUsername() throws FrameworkException {
        return (BuiltInPrincipalType)this.find(ExistingBuiltInPrincipalType.USERNAME.getInternalName(), null);
    }

    @PostConstruct
    public void initialize() {
        this.cache = this.cacheHandler.getCache(CacheType.PRINCIPAL_TYPES);
        String string = this.cyclosProperties.getNFCTokenTypeKey();
        this.nfcTokenPrincipalTypeKey = null;
        boolean bl = "zero".equalsIgnoreCase(string);
        if (!bl && !"random".equalsIgnoreCase(string)) {
            try {
                byte[] byArray = Hex.decodeHex((char[])string.toCharArray());
                if (byArray.length != 16) {
                    throw new IllegalStateException(String.format("Invalid key defined for property '%s' in %s file: %s (length in bytes %s). It must contains 32 hexdecimal chars (16 bytes long)", "cyclos.nfcTokenTypeKey", CyclosPropertiesFactoryBean.getCyclosPropertiesFileName("cyclos.properties"), string, string.length() / 2));
                }
                this.nfcTokenPrincipalTypeKey = byArray;
            }
            catch (DecoderException decoderException) {
                throw new IllegalStateException(String.format("Invalid hexadecimal value for property '%s' in %s file: %s", "cyclos.nfcTokenTypeKey", CyclosPropertiesFactoryBean.getCyclosPropertiesFileName("cyclos.properties"), string), decoderException);
            }
        } else if (bl) {
            this.nfcTokenPrincipalTypeKey = DEFAULT_NFC_TAG_MANAGEMENT_KEY;
        }
        BuiltinPrincipalTypeResolver.register(existingBuiltInPrincipalType -> this.find(existingBuiltInPrincipalType.getInternalName(), null));
    }

    public List<PrincipalTypeVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(PrincipalTypeVO.class, this.listAll());
    }

    public List<AccessClientPrincipalType> listAccessClients() {
        QAccessClientPrincipalType qAccessClientPrincipalType = QAccessClientPrincipalType.accessClientPrincipalType;
        return ((DBQuery)this.from(new EntityPath[]{qAccessClientPrincipalType}).orderBy(qAccessClientPrincipalType.name.asc())).list((Expression)qAccessClientPrincipalType);
    }

    public List<PrincipalType> listAll() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(new OrderSpecifier[]{((QPrincipalType)this.$).order.asc(), ((QPrincipalType)this.$).name.asc()})).list((Expression)this.$);
    }

    public List<PrincipalType> listByNatures(PrincipalTypeNature ... principalTypeNatureArray) {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QPrincipalType)this.$).nature.in((Object[])principalTypeNatureArray))).orderBy(((QPrincipalType)this.$).name.asc())).list((Expression)this.$);
    }

    public List<TokenPrincipalType> listByType(TokenType tokenType) {
        QTokenPrincipalType qTokenPrincipalType = QTokenPrincipalType.tokenPrincipalType;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qTokenPrincipalType}).where((Predicate)qTokenPrincipalType.tokenType.eq((Object)tokenType))).orderBy(qTokenPrincipalType.name.asc())).list((Expression)qTokenPrincipalType);
    }

    public List<TokenPrincipalType> listEnabledTokenTypes(BasicUser basicUser) {
        return CollectionHelper.sort((Collection)this.productsHandler.getAccessor(basicUser).member().getMyTokenTypes().keysSet((Path)QProductMyTokenType.productMyTokenType.enable));
    }

    public List<PrincipalType> listForConfiguration(ConfigurationAccessor configurationAccessor, Channel channel, PrincipalTypeContext principalTypeContext) throws FrameworkException {
        return this.listAll().stream().filter(principalType -> {
            String string = principalType.getInternalName();
            if (string.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                return configurationAccessor.isEmailUnique();
            }
            if (string.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                return configurationAccessor.isMobileUnique();
            }
            if (string.equals(ExistingBuiltInPrincipalType.TRUSTED_DEVICE.getInternalName())) {
                return this.channelConfigurationService.canActivateTrustedDevice(channel) && principalTypeContext == PrincipalTypeContext.ACCESS;
            }
            if (principalType instanceof AccessClientPrincipalType) {
                return channel.isService() && principalTypeContext == PrincipalTypeContext.ACCESS;
            }
            if (principalType instanceof NFCTokenPrincipalType) {
                return channel.isService() && ObjectHelper.isOneOf((Object)principalTypeContext, (Object[])new Object[]{PrincipalTypeContext.PAYMENT, PrincipalTypeContext.POS});
            }
            return true;
        }).collect(Collectors.toList());
    }

    public List<PrincipalType> listForLogin() {
        return this.listAll().stream().filter(this::isForLogin).sorted().collect(Collectors.toList());
    }

    public List<PrincipalType> listForLogin(ChannelConfiguration channelConfiguration) {
        return channelConfiguration.getPrincipalTypes().stream().filter(this::isForLogin).sorted().collect(Collectors.toList());
    }

    public List<TokenPrincipalType> listTokens() {
        QTokenPrincipalType qTokenPrincipalType = QTokenPrincipalType.tokenPrincipalType;
        return ((DBQuery)this.from(new EntityPath[]{qTokenPrincipalType}).orderBy(qTokenPrincipalType.name.asc())).list((Expression)qTokenPrincipalType);
    }

    public List<TokenPermissionsVO> listUserTokenPermissions(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        return this.toUserTokenPermissions(basicUser == null ? null : this.productsHandler.getAccessor(basicUser), basicUser == null ? false : basicUser.getUser().equals((Object)sessionData.getLoggedUser()), basicUser == null ? sessionData.isMember() && !sessionData.isBroker() : sessionData.isMember() && !sessionData.isBrokerOf(basicUser));
    }

    public List<TokenPermissionsVO> listUserTokenPermissions(UserGroup userGroup, boolean bl) {
        ProductsAccessor productsAccessor = userGroup == null ? null : this.productsHandler.getAccessor((BasicGroup)userGroup);
        return this.toUserTokenPermissions(productsAccessor, false, bl);
    }

    public List<TokenPermissionsVO> listUserTokenPermissions(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.listUserTokenPermissions(this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO));
    }

    public List<AccessClientPrincipalType> listVisibleAccessClients(User user) throws FrameworkException {
        ProductsAccessor productsAccessor;
        Set set = null;
        if (user != null && (set = (productsAccessor = this.productsHandler.getAccessor((BasicUser)user)).product().getMyAccessClients().keysSet((Path)PrincipalTypeServiceImpl.pmy.enable)).isEmpty()) {
            return Collections.emptyList();
        }
        User user2 = this.getLoggedUser();
        productsAccessor = user != null && user.equals((Object)user2) ? this.getProducts().product().getMyAccessClients() : this.getProducts().userManagement().getUserAccessClients();
        Set set2 = productsAccessor.keysSet((Path)PrincipalTypeServiceImpl.pac.view);
        if (user != null) {
            set2.retainAll(set);
        }
        return CollectionHelper.sort((Collection)set2);
    }

    public PrincipalType load(String string) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        return this.find(string, sessionData.getNetwork());
    }

    @Override
    public PrincipalType newEntity(PrincipalTypeNature principalTypeNature) {
        switch (principalTypeNature) {
            case BUILT_IN: {
                throw new IllegalActionException();
            }
            case CUSTOM_FIELD: {
                return new CustomFieldPrincipalType();
            }
            case TOKEN: 
            case NFC_TOKEN: {
                return new TokenPrincipalType();
            }
            case ACCESS_CLIENT: {
                return new AccessClientPrincipalType();
            }
        }
        throw new IllegalStateException("Unhandled principal type nature: " + String.valueOf(principalTypeNature));
    }

    public void sort(List<PrincipalType> list) {
        Collections.sort(list);
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, PrincipalTypeDTO principalTypeDTO) {
        PrincipalType principalType;
        property.required();
        PrincipalType principalType2 = principalType = principalTypeDTO.isPersistent() ? (PrincipalType)this.find(principalTypeDTO.getId()) : null;
        if (principalType instanceof BuiltInPrincipalType && !principalType.getInternalName().equals(principalTypeDTO.getInternalName())) {
            property.invalid();
        }
    }

    @Override
    protected PrincipalTypeData getData(PrincipalType principalType) {
        PrincipalTypeData principalTypeData;
        switch (principalType.getNature()) {
            case CUSTOM_FIELD: {
                CustomFieldPrincipalTypeData customFieldPrincipalTypeData = new CustomFieldPrincipalTypeData();
                customFieldPrincipalTypeData.setCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, this.listPossibleUserCustomFields()));
                principalTypeData = customFieldPrincipalTypeData;
                break;
            }
            case TOKEN: 
            case NFC_TOKEN: {
                TokenPrincipalTypeData tokenPrincipalTypeData = new TokenPrincipalTypeData();
                tokenPrincipalTypeData.setDefaultNFCLabelMask(DEFAULT_NFC_TOKEN_LABEL_MASK);
                principalTypeData = tokenPrincipalTypeData;
                break;
            }
            default: {
                principalTypeData = new PrincipalTypeData();
            }
        }
        principalTypeData.setDto((EntityDTO)((PrincipalTypeDTO)this.toDTO(principalType)));
        principalTypeData.setNature(principalType.getNature());
        return principalTypeData;
    }

    @Override
    protected void onAfterSave(PrincipalType principalType, PrincipalType principalType2, Object object) {
        if (principalType instanceof NFCTokenPrincipalType) {
            NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)principalType;
            if (principalType2 == null || ((NFCTokenPrincipalType)principalType2).getPiccMasterKey() == null) {
                nFCTokenPrincipalType.setPiccMasterKey(this.generateEncKey(nFCTokenPrincipalType));
            }
        }
    }

    @Override
    protected Object onBeforeSave(PrincipalType principalType, PrincipalType principalType2) {
        if (principalType instanceof NFCTokenPrincipalType) {
            NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)principalType;
            if (nFCTokenPrincipalType.getTokenType().isNFCDevice()) {
                nFCTokenPrincipalType.setActivation(null);
                nFCTokenPrincipalType.setTokenMask(null);
            }
            nFCTokenPrincipalType.setAllowManualInputOfValue(false);
        }
        this.calcOrder(principalType);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QPrincipalType)this.$).network(), true);
    }

    @Override
    protected Class<? extends PrincipalTypeDTO> resolveDTOType(PrincipalType principalType) {
        if (principalType.getNature() == PrincipalTypeNature.NFC_TOKEN) {
            return TokenPrincipalTypeDTO.class;
        }
        return super.resolveDTOType(principalType);
    }

    @Override
    protected Class<? extends PrincipalType> resolveEntityType(PrincipalTypeDTO principalTypeDTO) {
        if (principalTypeDTO instanceof TokenPrincipalTypeDTO && ((TokenPrincipalTypeDTO)principalTypeDTO).getTokenType() != null && ((TokenPrincipalTypeDTO)principalTypeDTO).getTokenType().isNFC()) {
            return NFCTokenPrincipalType.class;
        }
        return super.resolveEntityType(principalTypeDTO);
    }

    @Override
    protected Validator resolveValidator(PrincipalTypeDTO principalTypeDTO) {
        Validator validator = new Validator();
        if (principalTypeDTO instanceof CustomFieldPrincipalTypeDTO) {
            CustomFieldPrincipalTypeDTO customFieldPrincipalTypeDTO = (CustomFieldPrincipalTypeDTO)principalTypeDTO;
            QCustomFieldPrincipalType qCustomFieldPrincipalType = QCustomFieldPrincipalType.customFieldPrincipalType;
            UserCustomField userCustomField = (UserCustomField)this.conversionHandler.convert(UserCustomField.class, (Object)customFieldPrincipalTypeDTO.getCustomField());
            DBQuery dBQuery = null;
            String string = null;
            if (userCustomField != null) {
                dBQuery = (DBQuery)this.from(new EntityPath[]{qCustomFieldPrincipalType}).where(new Predicate[]{principalTypeDTO.isPersistent() ? qCustomFieldPrincipalType.id.ne((Object)principalTypeDTO.getId()) : qCustomFieldPrincipalType.id.isNotNull(), qCustomFieldPrincipalType.customField().eq((Object)userCustomField)});
                Network network = this.getSessionData().getNetwork();
                string = "fieldPrincipalType_" + SimpleEntity.id((SimpleEntity)network) + "_" + userCustomField.getId();
            }
            validator.property((Property)CustomFieldPrincipalTypeDTO.CUSTOM_FIELD, AccessKeys.PrincipalTypes.CUSTOM_FIELD).required().unique(string, dBQuery).entity(UserCustomField.class, (EntityValidation)new BaseEntityValidation<UserCustomField>(){

                protected boolean isValid(Object object, Object object2, UserCustomField userCustomField) {
                    return userCustomField.isUnique();
                }
            });
        } else if (principalTypeDTO instanceof ActivatablePrincipalTypeDTO) {
            validator.property((Property)ActivatablePrincipalTypeDTO.PLURAL_NAME, AccessKeys.PrincipalTypes.PLURAL_NAME).required().maxLength(100);
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)ActivatablePrincipalTypeDTO.MAXIMUM_PER_USER, AccessKeys.PrincipalTypes.MAXIMUM_PER_USER);
            property.positiveIntegerNonZero();
            if (principalTypeDTO instanceof TokenPrincipalTypeDTO) {
                TokenType tokenType = ((TokenPrincipalTypeDTO)principalTypeDTO).getTokenType();
                org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)TokenPrincipalTypeDTO.TOKEN_TYPE, AccessKeys.PrincipalTypes.TOKEN_TYPE);
                property2.required();
                property.required();
                validator.property((Property)TokenPrincipalTypeDTO.ACTIVATION, AccessKeys.PrincipalTypes.ACTIVATION).timeInterval();
                validator.property((Property)TokenPrincipalTypeDTO.EXPIRATION, AccessKeys.PrincipalTypes.EXPIRATION).timeInterval();
                if (tokenType != null) {
                    TokenType tokenType2;
                    boolean bl = tokenType.isNFC();
                    org.cyclos.impl.utils.validation.Property property3 = validator.property((Property)TokenPrincipalTypeDTO.TOKEN_MASK, bl ? AccessKeys.PrincipalTypes.NFC_TOKEN_LABEL_MASK : AccessKeys.PrincipalTypes.TOKEN_VALUE_MASK).mask(3);
                    if (principalTypeDTO.isPersistent() && ((tokenType2 = ((TokenPrincipalType)this.find(principalTypeDTO.getId())).getTokenType()).isNFC() || tokenType.isNFC()) && tokenType != tokenType2) {
                        property2.invalid();
                    }
                    if (tokenType.isNFCTag()) {
                        property3.required();
                    }
                }
            } else if (principalTypeDTO instanceof AccessClientPrincipalTypeDTO) {
                validator.property((Property)AccessClientPrincipalTypeDTO.PERMISSION, AccessKeys.PrincipalTypes.PERMISSION).required();
                property.required();
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends PrincipalType>, Class<? extends PrincipalTypeDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void calcOrder(PrincipalType principalType) {
        switch (principalType.getNature()) {
            case BUILT_IN: {
                ExistingBuiltInPrincipalType existingBuiltInPrincipalType = ExistingBuiltInPrincipalType.getByInternalName((String)principalType.getInternalName());
                principalType.setOrder(Integer.valueOf(existingBuiltInPrincipalType != null ? existingBuiltInPrincipalType.ordinal() : ExistingBuiltInPrincipalType.values().length + 1));
                break;
            }
            case CUSTOM_FIELD: {
                principalType.setOrder(Integer.valueOf(20));
                break;
            }
            case TOKEN: {
                principalType.setOrder(Integer.valueOf(30));
                break;
            }
            case NFC_TOKEN: {
                principalType.setOrder(Integer.valueOf(40));
                break;
            }
            case ACCESS_CLIENT: {
                principalType.setOrder(Integer.valueOf(50));
                break;
            }
            default: {
                principalType.setOrder(Integer.valueOf(99));
            }
        }
    }

    private byte[] generateEncKey(NFCTokenPrincipalType nFCTokenPrincipalType) {
        String string;
        if (this.nfcTokenPrincipalTypeKey != null) {
            string = Base64.getEncoder().encodeToString(this.nfcTokenPrincipalTypeKey);
        } else {
            byte[] byArray = new byte[16];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            string = Base64.getEncoder().encodeToString(byArray);
        }
        return this.applicationHandler.encrypt(string, this.getKeyMask(nFCTokenPrincipalType));
    }

    private Set<TokenPrincipalType> getEnabledTokenPrincipalTypes(ProductsAccessor productsAccessor) {
        if (productsAccessor == null) {
            return null;
        }
        return productsAccessor.member().getMyTokenTypes().keysSet((Path)QProductMyTokenType.productMyTokenType.enable);
    }

    private byte[] getKeyMask(NFCTokenPrincipalType nFCTokenPrincipalType) {
        return ByteBuffer.allocate(8).putLong(nFCTokenPrincipalType.getId()).array();
    }

    private boolean isForLogin(PrincipalType principalType) {
        return !(principalType instanceof AccessClientPrincipalType);
    }

    private List<UserCustomField> listPossibleUserCustomFields() {
        ArrayList<UserCustomField> arrayList = new ArrayList<UserCustomField>();
        for (UserCustomField userCustomField : this.userCustomFieldService.listAll()) {
            if (!userCustomField.isUnique()) continue;
            arrayList.add(userCustomField);
        }
        return arrayList;
    }

    private List<TokenPermissionsVO> toUserTokenPermissions(ProductsAccessor productsAccessor, boolean bl, boolean bl2) {
        Set<TokenPrincipalType> set = this.getEnabledTokenPrincipalTypes(productsAccessor);
        if (set != null && set.isEmpty()) {
            return Collections.emptyList();
        }
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return (set == null ? this.listTokens() : set).stream().map(tokenPrincipalType -> {
                TokenPermissionsVO tokenPermissionsVO = new TokenPermissionsVO();
                tokenPermissionsVO.setType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, tokenPrincipalType));
                tokenPermissionsVO.setActivate(true);
                tokenPermissionsVO.setCreate(true);
                return tokenPermissionsVO;
            }).collect(Collectors.toList());
        }
        if (bl2 && !bl) {
            return this.getProducts().member().getActivateUserTokenTypes().stream().filter(tokenPrincipalType -> set == null || set.contains(tokenPrincipalType)).map(tokenPrincipalType -> {
                TokenPermissionsVO tokenPermissionsVO = new TokenPermissionsVO();
                tokenPermissionsVO.setType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, tokenPrincipalType));
                tokenPermissionsVO.setActivate(true);
                return tokenPermissionsVO;
            }).collect(Collectors.toList());
        }
        QProductTokenType qProductTokenType = QProductTokenType.productTokenType;
        QProductUserTokenType qProductUserTokenType = QProductUserTokenType.productUserTokenType;
        Stream<Object> stream = bl ? sessionData.getProducts().member().getMyTokenTypes().entries().stream() : sessionData.getProducts().userManagement().getUserTokenTypes().entries().stream().filter(entry -> ((BooleanProperties)entry.getValue()).isSet((Path)qProductUserTokenType.view));
        return stream.filter(entry -> set == null || set.contains(entry.getKey())).map(entry -> {
            BooleanProperties booleanProperties = (BooleanProperties)entry.getValue();
            TokenPermissionsVO tokenPermissionsVO = new TokenPermissionsVO();
            tokenPermissionsVO.setType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, entry.getKey()));
            tokenPermissionsVO.setCreate(booleanProperties.isSet((Path)qProductUserTokenType.create) || booleanProperties.isSet((Path)qProductUserTokenType.initialize));
            tokenPermissionsVO.setActivate(booleanProperties.isSet((Path)qProductTokenType.activate) || booleanProperties.isSet((Path)qProductTokenType.personalize));
            return tokenPermissionsVO;
        }).sorted(Comparator.comparing(tokenPermissionsVO -> tokenPermissionsVO.getType().getName())).collect(Collectors.toList());
    }

    static {
        SUBCLASS_MAPPINGS.put(BuiltInPrincipalType.class, BuiltInPrincipalTypeDTO.class);
        SUBCLASS_MAPPINGS.put(CustomFieldPrincipalType.class, CustomFieldPrincipalTypeDTO.class);
        SUBCLASS_MAPPINGS.put(TokenPrincipalType.class, TokenPrincipalTypeDTO.class);
        SUBCLASS_MAPPINGS.put(AccessClientPrincipalType.class, AccessClientPrincipalTypeDTO.class);
        pac = QProductAccessClient.productAccessClient;
        pmy = QProductMyAccessClient.productMyAccessClient;
    }
}

