/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.ActivatablePrincipalType;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.principaltypes.AccessClientPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.ActivatablePrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.BuiltInPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.CustomFieldPrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.springframework.stereotype.Component;

@Component
public class PrincipalTypeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<PrincipalType, PrincipalTypeDTO> {
    public Class<PrincipalType> getEntityClass() {
        return PrincipalType.class;
    }

    public EntityLogType getType() {
        return EntityLogType.PRINCIPAL_TYPE;
    }

    public EntityLogDescriptor<? extends PrincipalTypeDTO> resolveLogDescriptor(PrincipalType principalType) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDTOType(principalType)).property(PrincipalTypeDTO.NAME, GeneralKeys.Ui.NAME).property(PrincipalTypeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(PrincipalTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION);
        if (principalType instanceof ActivatablePrincipalType) {
            entityLogDescriptor.cast().property((Property)ActivatablePrincipalTypeDTO.MAXIMUM_PER_USER, AccessKeys.PrincipalTypes.MAXIMUM_PER_USER).property((Property)ActivatablePrincipalTypeDTO.PLURAL_NAME, AccessKeys.PrincipalTypes.PLURAL_NAME);
            if (principalType instanceof TokenPrincipalType) {
                entityLogDescriptor.cast().property((Property)TokenPrincipalTypeDTO.ACTIVATION, AccessKeys.PrincipalTypes.ACTIVATION).property((Property)TokenPrincipalTypeDTO.ALLOW_MANUAL_INPUT_OF_VALUE, AccessKeys.PrincipalTypes.ALLOW_MANUAL_INPUT_OF_VALUE).property((Property)TokenPrincipalTypeDTO.EXPIRATION, AccessKeys.PrincipalTypes.EXPIRATION).property((Property)TokenPrincipalTypeDTO.GENERATE_ON_USER_CREATION, AccessKeys.PrincipalTypes.AUTO_GENERATION_ON_USER_CREATION).property((Property)TokenPrincipalTypeDTO.TOKEN_MASK, AccessKeys.PrincipalTypes.TOKEN_VALUE_MASK).property((Property)TokenPrincipalTypeDTO.TOKEN_TYPE, AccessKeys.PrincipalTypes.TOKEN_TYPE);
            } else if (principalType instanceof AccessClientPrincipalType) {
                entityLogDescriptor.cast().property((Property)AccessClientPrincipalTypeDTO.ALLOW_IP_WHITELIST, AccessKeys.PrincipalTypes.ALLOW_IP_WHITELIST).property((Property)AccessClientPrincipalTypeDTO.ALLOW_MANUAL_CREATION, AccessKeys.PrincipalTypes.ALLOW_MANUAL_CREATION).property((Property)AccessClientPrincipalTypeDTO.PERMISSION, AccessKeys.PrincipalTypes.PERMISSION).property((Property)AccessClientPrincipalTypeDTO.INFORMATION_MESSAGE, AccessKeys.PrincipalTypes.INFORMATION_MESSAGE);
            }
        } else if (!(principalType instanceof BuiltInPrincipalType)) {
            entityLogDescriptor.cast().property((Property)CustomFieldPrincipalTypeDTO.CUSTOM_FIELD, AccessKeys.PrincipalTypes.CUSTOM_FIELD);
        }
        return entityLogDescriptor;
    }

    @Override
    protected PrincipalType getEntityToViewLog(long l) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) ? this.find(PrincipalType.class, l) : null;
    }

    private Class<? extends PrincipalTypeDTO> resolveDTOType(PrincipalType principalType) {
        switch (principalType.getNature()) {
            case ACCESS_CLIENT: {
                return AccessClientPrincipalTypeDTO.class;
            }
            case BUILT_IN: {
                return BuiltInPrincipalTypeDTO.class;
            }
            case CUSTOM_FIELD: {
                return CustomFieldPrincipalTypeDTO.class;
            }
            case NFC_TOKEN: 
            case TOKEN: {
                return TokenPrincipalTypeDTO.class;
            }
        }
        throw new IllegalArgumentException("Unknown principal type: " + String.valueOf(principalType.getNature()));
    }
}

