/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.contentmanagement.GuestHomeContent;
import org.cyclos.entities.contentmanagement.QMenuEntry;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.marketplace.QAdCategory;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.QCustomOperation;
import org.cyclos.entities.system.QWizardWithChannels;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QProductRecordType;
import org.cyclos.entities.users.QRecordType;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.DateRange;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.app.InternalFrontendServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.UserAccountVisibilitySettingsServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.contentmanagement.BannerServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentCategoryServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentServiceLocal;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.LicenseServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.system.SetupServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.QuickAccessHandler;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.users.UserFrontendSettingsServiceLocal;
import org.cyclos.impl.users.UserQuickAccessServiceLocal;
import org.cyclos.impl.users.UserRegionalSettingsServiceLocal;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.BasicInitializationWithContentData;
import org.cyclos.model.access.GuestInitializationData;
import org.cyclos.model.access.InitializationData;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.UserInitializationData;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.contentmanagement.contentitems.BannerDetailedVO;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.contentmanagement.staticcontents.FooterContentVO;
import org.cyclos.model.contentmanagement.staticcontents.HeaderContentVO;
import org.cyclos.model.contentmanagement.staticcontents.HomeContentVO;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.licensing.LicenseVO;
import org.cyclos.model.system.networks.NetworkQuery;
import org.cyclos.model.system.networks.NetworkVO;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.setup.SetupData;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.dashboard.DashboardStatusLinkType;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeVO;
import org.cyclos.model.users.recordtypes.UserRecordTypeVO;
import org.cyclos.model.users.references.TransactionsAwaitingFeedbackQuery;
import org.cyclos.model.users.users.ConnectedUserSearchData;
import org.cyclos.model.users.users.HomeData;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.security.messaging.MessageServiceSecurity;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitializationServiceImpl
extends BaseServiceImpl
implements InitializationServiceLocal {
    private static final Map<Role, DashboardStatusLinkType> CONNECTED_USERS_LINK_TYPES = new HashMap<Role, DashboardStatusLinkType>();
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private UserAccountVisibilitySettingsServiceLocal accountVisibilitySettingsServiceLocal;
    @Autowired
    private DocumentServiceLocal documentService;
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private DocumentCategoryServiceLocal documentCategoryService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private SystemImageCategoryServiceLocal systemImageCategoryService;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private MessageServiceLocal messageService;
    @Autowired
    private MessageServiceSecurity messageServiceSecurity;
    @Autowired
    private NotificationServiceLocal notificationService;
    @Autowired
    private BannerServiceLocal bannerService;
    @Autowired
    private UserQuickAccessServiceLocal userQuickAccessService;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private OrderServiceLocal orderService;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private SetupServiceLocal setupService;
    @Autowired
    private LicenseServiceLocal licenseService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private UserRegionalSettingsServiceLocal userRegionalSettingsService;
    @Autowired
    private LoginServiceLocal loginService;
    private String _resourceCacheKey;
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private UserFrontendSettingsServiceLocal userFrontendSettingsService;
    @Autowired
    private InternalFrontendServiceLocal internalFrontendService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private QuickAccessHandler quickAccessHandler;
    @Autowired
    private TotpServiceLocal totpService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public BasicInitializationData getBasicInitializationData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        BasicInitializationData basicInitializationData = new BasicInitializationData();
        this.fill(sessionData, basicInitializationData);
        return basicInitializationData;
    }

    public BasicInitializationWithContentData getBasicInitializationWithContentData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        BasicInitializationWithContentData basicInitializationWithContentData = new BasicInitializationWithContentData();
        this.fill(sessionData, basicInitializationWithContentData);
        return basicInitializationWithContentData;
    }

    public HomeData getHomeData() {
        GuestHomeContent guestHomeContent;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        HomeData homeData = new HomeData();
        if (basicUser != null) {
            Cloneable cloneable;
            Object object;
            Date date;
            DateRange dateRange = this.loginService.getFirstAndLastLogin(basicUser);
            Date date2 = dateRange == null ? null : dateRange.getMax();
            homeData.setLastLogin(this.toDateTime(date2));
            Date date3 = date = date2 == null ? basicUser.getCreationDate() : date2;
            if (basicUser.isGlobalAdmin() && (object = this.licenseService.getLicense()) != null) {
                homeData.setLicense((LicenseVO)object);
            }
            homeData.setQuickAccess(this.userQuickAccessService.listEnabled().stream().map(arg_0 -> ((QuickAccessHandler)this.quickAccessHandler).toRunnableDTO(arg_0)).collect(Collectors.toList()));
            homeData.setDashboardStatusCounters(this.getDashboardStatusCounters(sessionData, date));
            object = this.accountService.listVisible(this.accountHandler.getAccountOwner());
            if (!object.isEmpty() && object.size() <= 15) {
                cloneable = basicUser.isMember() ? date : null;
                homeData.setVisibleAccounts(this.accountService.getAccountsWithStatus(this.accountHandler.getAccountOwner(), null, (Date)cloneable, false));
            }
            guestHomeContent = configurationAccessor.getLoggedUserHomeContent();
            if (!this.isGlobalAdminInNetwork()) {
                cloneable = new ArrayList();
                ArrayList<PasswordTypeVO> arrayList = new ArrayList<PasswordTypeVO>();
                ArrayList<PasswordTypeVO> arrayList2 = new ArrayList<PasswordTypeVO>();
                for (PasswordType passwordType : configurationAccessor.getPasswords()) {
                    Pair pair = this.passwordService.getStatusAndActions(basicUser, passwordType);
                    PasswordStatus passwordStatus = (PasswordStatus)pair.getFirst();
                    Set set = (Set)pair.getSecond();
                    boolean bl = CollectionHelper.containsAny((Collection)set, (Object[])new Object[]{PasswordAction.CHANGE, PasswordAction.ACTIVATE});
                    if (!bl) continue;
                    if (passwordStatus == PasswordStatus.NEVER_CREATED || passwordStatus == PasswordStatus.PENDING) {
                        cloneable.add((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
                        continue;
                    }
                    if (passwordStatus == PasswordStatus.EXPIRED) {
                        arrayList.add((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
                        continue;
                    }
                    if (passwordStatus != PasswordStatus.RESET) continue;
                    arrayList2.add((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
                }
                homeData.setPendingPasswords((List)((Object)cloneable));
                homeData.setExpiredPasswords(arrayList);
                homeData.setResetPasswords(arrayList2);
                homeData.setPendingTotp(this.totpService.isPendingActivation(basicUser));
                homeData.setPendingSecurityQuestion(this.passwordService.isPendingSecurityQuestion());
            }
        } else {
            guestHomeContent = configurationAccessor.getGuestHomeContent();
        }
        homeData.setHomeContent((HomeContentVO)this.conversionHandler.convert(HomeContentVO.class, (Object)guestHomeContent));
        return homeData;
    }

    public InitializationData getInitializationData(Long l, PinLocatorVO pinLocatorVO) {
        List list;
        InternetAddressList internetAddressList;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        User user = basicUser == null ? null : basicUser.getUser();
        InitializationData initializationData = new InitializationData();
        GuestInitializationData guestInitializationData = null;
        UserInitializationData userInitializationData = null;
        SetupData setupData = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!this.setupService.isSetupDone()) {
            setupData = this.setupService.getSetupData();
        } else if (basicUser == null) {
            bl = CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getGroupsForUserSearch());
            bl2 = CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getGroupsForUserDirectory());
            bl3 = CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getGroupsForViewProfile());
            bl4 = CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getVisibleAdGroups()) && (configurationAccessor.isAllowViewUserAd() || configurationAccessor.isAllowViewUserWebShop());
            guestInitializationData = new GuestInitializationData();
            guestInitializationData.setLoginData(this.loginService.getLoginData(sessionData.getChannel(), l, pinLocatorVO));
            guestInitializationData.setUseLeftSpace(configurationAccessor.isUseLeftSpaceForGuests());
            guestInitializationData.setCommunityMenuLabel(configurationAccessor.getCommunityMenuLabel());
            guestInitializationData.setMarketplaceMenuLabel(configurationAccessor.getMarketplaceMenuLabel());
            guestInitializationData.setPossibleInitialGroups(this.groupsHandler.getPossiblePublicInitialGroups());
            guestInitializationData.setLargeScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getLargeScreenRegistrationWizard()));
            guestInitializationData.setMediumScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getMediumScreenRegistrationWizard()));
            guestInitializationData.setSmallScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getSmallScreenRegistrationWizard()));
            internetAddressList = sessionData.getChannelAccessAccessor().getWhitelist();
            guestInitializationData.setUnauthorizedAddress(!this.internetAddressListHandler.isWhitelisted(internetAddressList, sessionData.getRemoteAddress()));
            initializationData.setMenuType(configurationAccessor.getGuestsMenuType());
        } else {
            ArrayList arrayList;
            ArrayList<RecordVO> arrayList2;
            boolean bl5 = this.isGlobalAdminInNetwork();
            bl = this.groupsHandler.users().basic().isNotEmpty();
            bl2 = this.groupsHandler.directory().basic().isNotEmpty();
            bl3 = sessionData.isBroker() || CollectionHelper.isNotEmpty((Iterable)this.groupsHandler.getViewProfileOnGroups());
            bl4 = !(!sessionData.hasPermission(Permission.USER_ADS_VIEW) && !sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW) || this.isBroker() && !this.getProducts().hasMemberProducts());
            userInitializationData = new UserInitializationData();
            list = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.VIEW);
            ProductsAccessor productsAccessor = sessionData.getProducts();
            userInitializationData.setUser(sessionData.getAuthenticatedUser());
            if (user.isGlobal()) {
                userInitializationData.setGlobal(true);
                userInitializationData.setGlobalSystemAdmin(user.isGlobalAdmin());
                arrayList2 = this.configurationHandler.getGlobalDefault().getRootUrl();
                if (!((String)((Object)arrayList2)).endsWith("/global")) {
                    arrayList2 = (String)((Object)arrayList2) + "/global";
                }
                userInitializationData.setGlobalUrl((String)((Object)arrayList2));
            }
            userInitializationData.setAllowFrontendSwitching(this.internalFrontendService.isAllowFrontendSwitching(basicUser));
            userInitializationData.setHasTrustedDevices(this.trustedDeviceService.hasActiveDevices(basicUser));
            userInitializationData.setHasDocuments(this.documentService.hasDocuments(user));
            userInitializationData.setCanSearchSharedRecordFields(!this.recordService.getSharedSearchableRecordTypes().isEmpty());
            userInitializationData.setCanSendMessage(this.messageServiceSecurity.canSendMessage(null));
            userInitializationData.setCanViewMessages(this.messageServiceSecurity.canViewMessages());
            userInitializationData.setCanViewProducts(this.productService.canViewProducts());
            userInitializationData.setHasTotpEnabled(configurationAccessor.isTotpEnabled());
            userInitializationData.setMyVisibleProfileFields(this.profileFieldHandler.toVOs((Collection)list));
            userInitializationData.setCanHaveContactInfos(this.contactInfoService.canHaveContactInfos(user));
            userInitializationData.setRegionalSettings(this.userRegionalSettingsService.get());
            userInitializationData.setDocumentCategoryView(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)this.documentCategoryService.getDocumentCategoriesView()));
            userInitializationData.setDocumentCategoryManage(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)this.documentCategoryService.getDocumentCategoriesManage()));
            userInitializationData.setMaxProfileImages(Integer.valueOf(productsAccessor.product().getMaxProfileImages()));
            userInitializationData.setMaxCustomImages(Integer.valueOf(productsAccessor.product().getMaxCustomImages()));
            arrayList2 = new ArrayList<RecordVO>();
            this.addSingleFormRecords(arrayList2, this.recordTypeService.listVisibleSystemTypes(), null);
            this.addSingleFormRecords(arrayList2, this.recordTypeService.listVisibleMyTypes(), user);
            userInitializationData.setSingleFormRecords(arrayList2);
            userInitializationData.setSystemRecordTypes(this.recordTypes(SystemRecordTypeVO.class, this.recordTypeService.listVisibleSystemTypes()));
            List list2 = this.conversionHandler.convertList(AccountVO.class, (Iterable)this.accountService.listVisible((InternalAccountOwner)user));
            userInitializationData.setVisibleAccounts(list2);
            userInitializationData.setHasAccountsToShowHide(this.accountVisibilitySettingsServiceLocal.hasAccountsToShowHide(basicUser));
            List list3 = this.recordTypeService.listVisibleUserTypes();
            list3.removeIf(userRecordType -> !userRecordType.isGeneralSearch());
            userInitializationData.setUserTokenPrincipalTypes(this.principalTypeService.listUserTokenPermissions((BasicUser)null).stream().map(TokenPermissionsVO::getType).collect(Collectors.toList()));
            userInitializationData.setMyTokenPrincipalTypes(this.principalTypeService.listUserTokenPermissions(basicUser).stream().map(TokenPermissionsVO::getType).collect(Collectors.toList()));
            userInitializationData.setUserRecordTypes(this.conversionHandler.convertList(UserRecordTypeVO.class, (Iterable)list3));
            userInitializationData.setMyRecordTypes(this.recordTypes(UserRecordTypeVO.class, this.recordTypeService.listVisibleMyTypes()));
            userInitializationData.setIdentityProviders(this.conversionHandler.convertList(IdentityProviderVO.class, (Iterable)this.identityProviderService.listEnabled(basicUser)));
            userInitializationData.setUserAccessClientTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listVisibleAccessClients(null)));
            userInitializationData.setSystemImageCategoriesManage(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listManageable()));
            userInitializationData.setSystemImageCategoriesView(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)this.systemImageCategoryService.listVisible()));
            userInitializationData.setNewMessages(Integer.valueOf(this.messageService.countNewMessages()));
            userInitializationData.setNotificationsStatus(this.notificationService.getNotificationsStatus());
            if (!bl5) {
                userInitializationData.setMyAccessClientTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listVisibleAccessClients(user)));
            }
            userInitializationData.setHasQuickAccessItems(!this.userQuickAccessService.list((BasicUser)user).isEmpty());
            if (user.isGlobal()) {
                if (user.isGlobalAdmin()) {
                    NetworkQuery networkQuery = new NetworkQuery();
                    networkQuery.setUnlimited();
                    networkQuery.setReturnDisabled(false);
                    arrayList = this.networkService.search(networkQuery).getPageItems();
                } else {
                    AdminGroup adminGroup = (AdminGroup)user.getGroup();
                    arrayList = this.conversionHandler.convertList(NetworkVO.class, (Iterable)adminGroup.getManagedNetworks());
                    Collections.sort(arrayList);
                    if (sessionData.getNetwork() != null) {
                        initializationData.setManageScripts(((AdminGroup)user.getGroup()).isManageScripts());
                    }
                }
                userInitializationData.setNetworks((List)arrayList);
                userInitializationData.setCurrentNetwork((NetworkVO)this.conversionHandler.convert(NetworkVO.class, (Object)sessionData.getNetwork()));
            }
            if (user.isAdmin()) {
                userInitializationData.setConfigurations(this.conversionHandler.convertList(ConfigurationDetailedVO.class, (Iterable)this.configurationService.list()));
                userInitializationData.setGlobalAdminOnNetwork(bl5);
                userInitializationData.setLicenseServerUrl(this.cyclosProperties.getLicenseUrl());
            } else if (sessionData.isMember()) {
                userInitializationData.setCartItems(Integer.valueOf(this.orderService.countCartItems()));
            }
            if (!list2.isEmpty()) {
                if (sessionData.isRestrictedOperator()) {
                    arrayList = sessionData.getLoggedOperator().getGroup();
                    userInitializationData.setRestrictedOperatorAuthorize(this.operatorGroupService.canAuthorizeAnyPayment((OperatorGroup)arrayList));
                    userInitializationData.setRestrictedOperatorRequiresAuthorization(this.operatorGroupService.anyRequiresAuthorization(arrayList));
                } else if (sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE)) {
                    userInitializationData.setHasOperatorGroupsRequiringPaymentAuthorization(this.operatorGroupService.anyRequiresAuthorization(user));
                }
            }
            userInitializationData.setCustomOperations(this.conversionHandler.convertList(RunnableCustomOperationVO.class, (Iterable)this.customOperationService.listAllowedToRun()));
            arrayList = new ArrayList();
            arrayList.addAll(this.customWizardService.listForRun(user));
            arrayList.addAll(this.customWizardService.listSystemForRun());
            userInitializationData.setWizards(this.conversionHandler.convertList(CustomWizardVO.class, arrayList));
            initializationData.setMenuType(configurationAccessor.getUsersMenuType());
            userInitializationData.setVoucherBuyingMenu(configurationAccessor.getVoucherBuyingMenu());
            userInitializationData.setVoucherTopUpEnabled(this.voucherConfigurationService.listVisible(user).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null));
        }
        this.fill(sessionData, (BasicInitializationWithContentData)initializationData);
        initializationData.setDevelopment(this.cyclosProperties.isDevelopment());
        initializationData.setGlobalMode(sessionData.getNetwork() == null);
        initializationData.setGuestData(guestInitializationData);
        initializationData.setUserData(userInitializationData);
        initializationData.setSetupData(setupData);
        initializationData.setLoginUrl(configurationAccessor.getLoginUrl());
        initializationData.setLogoutUrl(configurationAccessor.getLogoutUrl());
        initializationData.setMaxUploadSize((FileSizeDTO)this.conversionHandler.convert(FileSizeDTO.class, (Object)configurationAccessor.getMaxUploadSize()));
        initializationData.setMaxMediumThumbDimensions((DimensionsDTO)this.conversionHandler.convert(DimensionsDTO.class, (Object)configurationAccessor.getMaxMediumThumbDimensions()));
        initializationData.setMaxSmallThumbDimensions((DimensionsDTO)this.conversionHandler.convert(DimensionsDTO.class, (Object)configurationAccessor.getMaxSmallThumbDimensions()));
        initializationData.setMaxTinyThumbDimensions((DimensionsDTO)this.conversionHandler.convert(DimensionsDTO.class, (Object)configurationAccessor.getMaxTinyThumbDimensions()));
        initializationData.setMaxResults(configurationAccessor.getMaxResults());
        initializationData.setAutocompleteResults(configurationAccessor.getAutocompleteResults());
        internetAddressList = this.userRegionalSettingsService.getLocalesData();
        initializationData.setCurrentLocale(internetAddressList.getCurrentLocale());
        initializationData.setDefaultLocale(internetAddressList.getDefaultLocale());
        initializationData.setAllowedLocales(internetAddressList.getAllowedLocales());
        initializationData.setListSeparator(configurationAccessor.getListSeparator());
        initializationData.setDistanceUnit(configurationAccessor.getDistanceUnit());
        initializationData.setMobilePhoneExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.MOBILE, configurationAccessor));
        initializationData.setLandlinePhoneExample(this.phoneNumberHandler.getExampleNumber(PhoneNature.LANDLINE, configurationAccessor));
        initializationData.setMaxResultsOnMap(configurationAccessor.getMaxResultsOnMap());
        initializationData.setMenuEntries(this.menuEntryService.getMenu(Frontend.CLASSIC));
        initializationData.setCanSearchUsers(bl);
        initializationData.setCanViewUserProfile(bl3);
        initializationData.setHideUserSearchInMenu(this.isHideUserSearchInMenu());
        initializationData.setCanSearchAds(bl4);
        initializationData.setUseMapDirectory(configurationAccessor.isUseMap() && bl2);
        initializationData.setSvgIconNames(this.getSvgIconNames());
        list = configurationAccessor.getAccountNumberConfiguration();
        if (list != null && list.isEnabled()) {
            initializationData.setAccountNumberMask(list.getMask());
        }
        return initializationData;
    }

    public String getResourceCacheKey() {
        if (this._resourceCacheKey == null) {
            this._resourceCacheKey = !this.cyclosProperties.isDevelopment() && CyclosVersion.isCommitIdKnown() ? CyclosVersion.getCommitId() : RandomStringUtils.randomAlphanumeric((int)16);
        }
        return this._resourceCacheKey;
    }

    public SortedSet<String> getSvgIconNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        QMenuEntry qMenuEntry = QMenuEntry.menuEntry;
        treeSet.addAll(((DBQuery)((DBQuery)this.fromCacheable((EntityPath<?>)qMenuEntry).where((Predicate)qMenuEntry.svgIcon.isNotNull())).distinct()).list((Expression)qMenuEntry.svgIcon));
        QAdCategory qAdCategory = QAdCategory.adCategory;
        treeSet.addAll(((DBQuery)((DBQuery)this.fromCacheable((EntityPath<?>)qAdCategory).where((Predicate)qAdCategory.svgIcon.isNotNull())).distinct()).list((Expression)qAdCategory.svgIcon));
        QWizardWithChannels qWizardWithChannels = QWizardWithChannels.wizardWithChannels;
        treeSet.addAll(((DBQuery)((DBQuery)this.fromCacheable((EntityPath<?>)qWizardWithChannels).where((Predicate)qWizardWithChannels.svgIcon.isNotNull())).distinct()).list((Expression)qWizardWithChannels.svgIcon));
        QCustomOperation qCustomOperation = QCustomOperation.customOperation;
        treeSet.addAll(((DBQuery)((DBQuery)this.fromCacheable((EntityPath<?>)qCustomOperation).where((Predicate)qCustomOperation.svgIcon.isNotNull())).distinct()).list((Expression)qCustomOperation.svgIcon));
        QRecordType qRecordType = QRecordType.recordType;
        treeSet.addAll(((DBQuery)((DBQuery)this.fromCacheable((EntityPath<?>)qRecordType).where((Predicate)qRecordType.svgIcon.isNotNull())).distinct()).list((Expression)qRecordType.svgIcon));
        return treeSet;
    }

    public boolean isHideUserSearchInMenu() {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        boolean bl = sessionData.isGuest() ? CollectionHelper.isNotEmpty((Iterable)configurationAccessor.getGroupsForUserSearch()) : this.groupsHandler.users().isNotEmpty();
        return !bl || configurationAccessor.getUserSearchInMenuMode().isHideUserSearchInMenu();
    }

    public void ping() throws FrameworkException {
    }

    protected <T extends RecordType> void addSingleFormRecords(List<RecordVO> list, List<T> list2, User user) {
        for (RecordType recordType : list2) {
            SystemRecord systemRecord;
            if (recordType.getResultsLayout() != RecordTypeResultsLayout.SINGLE_FORM) continue;
            if (recordType instanceof SystemRecordType) {
                systemRecord = this.recordService.getSingleFormRecord((SystemRecordType)recordType);
                if (systemRecord == null) continue;
                list.add((RecordVO)this.conversionHandler.convert(SystemRecordVO.class, (Object)systemRecord));
                continue;
            }
            if (!(recordType instanceof UserRecordType) || user == null || (systemRecord = this.recordService.getSingleFormRecord((UserRecordType)recordType, user)) == null) continue;
            list.add((RecordVO)this.conversionHandler.convert(UserRecordVO.class, (Object)systemRecord));
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private int countPaymentsToQualify(User user) {
        TransactionsAwaitingFeedbackQuery transactionsAwaitingFeedbackQuery = new TransactionsAwaitingFeedbackQuery();
        transactionsAwaitingFeedbackQuery.setCountOnly();
        transactionsAwaitingFeedbackQuery.setFrom(new UserVO(user.getId()));
        return this.transactionFeedbackService.searchTransactionsAwaitingFeedback(transactionsAwaitingFeedbackQuery).getTotalCount();
    }

    private void fill(SessionData sessionData, BasicInitializationData basicInitializationData) {
        Theme theme;
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        basicInitializationData.setLicense(this.licenseService.getBasicLicense());
        basicInitializationData.setConfigurationId(configurationAccessor.getConfiguration().getId());
        basicInitializationData.setConfigurationVersion(configurationAccessor.getConfiguration().getVersion());
        basicInitializationData.setFrontend(this.userFrontendSettingsService.get().getFrontend());
        Language language = configurationAccessor.getLanguage();
        basicInitializationData.setLanguage(language.getTemplate().getIsoLanguage());
        basicInitializationData.setLanguageId(language.getId());
        basicInitializationData.setLanguageVersion(language.getVersion());
        basicInitializationData.setLanguageLastModified(language.getLastModifiedInMillis());
        basicInitializationData.setResourceCacheKey(this.getResourceCacheKey());
        basicInitializationData.setCurrentClientTime(this.toDateTime(DateHelper.now()));
        basicInitializationData.setDateFormat(configurationAccessor.getDateFormat());
        basicInitializationData.setNumberFormat(configurationAccessor.getNumberFormat());
        basicInitializationData.setTimeFormat(configurationAccessor.getTimeFormat());
        basicInitializationData.setTimeZoneId(configurationAccessor.getTimeZoneId());
        basicInitializationData.setCountry(configurationAccessor.getCountry());
        basicInitializationData.setRootUrl(configurationAccessor.getFullUrl());
        basicInitializationData.setApiUrl(configurationAccessor.getApiUrl());
        Theme theme2 = theme = this.isLoggedIn() ? configurationAccessor.getUsersTheme() : configurationAccessor.getGuestsTheme();
        if (theme != null) {
            basicInitializationData.setThemeId(theme.getId());
            basicInitializationData.setThemeVersion(theme.getVersion());
            basicInitializationData.setThemeLastModified(theme.getLastModifiedInMillis());
        }
        basicInitializationData.setApplicationName(configurationAccessor.getApplicationName());
        basicInitializationData.setApplicationUsername(configurationAccessor.getApplicationUsername());
        basicInitializationData.setApplicationVersion(CyclosVersion.get());
        basicInitializationData.setApplicationCommitId(CyclosVersion.getCommitId());
        basicInitializationData.setApplicationDescription(configurationAccessor.getApplicationDescription());
        basicInitializationData.setMaxUploadSize((FileSizeDTO)this.conversionHandler.convert(FileSizeDTO.class, (Object)configurationAccessor.getMaxUploadSize()));
        basicInitializationData.setMaxImageDimensions((DimensionsDTO)this.conversionHandler.convert(DimensionsDTO.class, (Object)configurationAccessor.getMaxImageDimensions()));
        basicInitializationData.setJpegQuality(Integer.valueOf(configurationAccessor.getJpegQuality()));
        basicInitializationData.setBuiltinLanguage(language.getTemplate());
        basicInitializationData.setShortcutIcon(this.configurationImageService.getImageVO(new ConfigurationVO(configurationAccessor.getConfiguration().getId()), ConfigurationImageType.SHORTCUT_ICON));
        basicInitializationData.setUseMap(configurationAccessor.isUseMap());
        basicInitializationData.setMapBrowserApiKey(configurationAccessor.getMapBrowserApiKey());
        basicInitializationData.setDefaultMapLocation((LatLongDTO)this.conversionHandler.convert(LatLongDTO.class, (Object)configurationAccessor.getDefaultMapLocation()));
        basicInitializationData.setDefaultMapZoomWeb(configurationAccessor.getDefaultMapZoomWeb());
        basicInitializationData.setDefaultMapZoomMobile(configurationAccessor.getDefaultMapZoomMobile());
    }

    private void fill(SessionData sessionData, BasicInitializationWithContentData basicInitializationWithContentData) {
        this.fill(sessionData, (BasicInitializationData)basicInitializationWithContentData);
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        basicInitializationWithContentData.setHeaderContent((HeaderContentVO)this.conversionHandler.convert(HeaderContentVO.class, (Object)configurationAccessor.getHeaderContent()));
        basicInitializationWithContentData.setFooterContent((FooterContentVO)this.conversionHandler.convert(FooterContentVO.class, (Object)configurationAccessor.getFooterContent()));
        basicInitializationWithContentData.setBanners(this.conversionHandler.convertList(BannerDetailedVO.class, (Iterable)this.bannerService.getClassicBanners()));
        basicInitializationWithContentData.getBanners().removeIf(bannerDetailedVO -> StringHelper.isBlank((Object)bannerDetailedVO.getContent()));
        basicInitializationWithContentData.setMaxLeftBanners(configurationAccessor.getMaxLeftBanners());
        basicInitializationWithContentData.setMaxRightBanners(Integer.valueOf(configurationAccessor.getMaxRightBanners()));
        basicInitializationWithContentData.setBannerRotateSeconds(configurationAccessor.getBannerRotateSeconds());
    }

    private Map<DashboardStatusLinkType, Integer> getDashboardStatusCounters(SessionData sessionData, Date date) {
        ConnectedUserSearchData connectedUserSearchData;
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (!(basicUser instanceof User)) {
            return null;
        }
        User user = (User)basicUser;
        boolean bl = CollectionHelper.isNotEmpty((Iterable)sessionData.getProducts().member().getUserAccounts());
        HashMap<DashboardStatusLinkType, Integer> hashMap = new HashMap<DashboardStatusLinkType, Integer>();
        if (sessionData.hasPermission(Permission.USER_ALERTS_VIEW)) {
            hashMap.put(DashboardStatusLinkType.USER_ALERTS, this.alertService.countUserAlerts(date));
        }
        if (sessionData.hasPermission(Permission.SYSTEM_ALERTS_VIEW)) {
            hashMap.put(DashboardStatusLinkType.SYSTEM_ALERTS, this.alertService.countSystemAlerts(date));
        }
        if (sessionData.hasPermission(Permission.ERROR_LOG_VIEW)) {
            hashMap.put(DashboardStatusLinkType.APPLICATION_ERRORS, this.errorLogService.countErrors(date));
        }
        if (sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE)) {
            hashMap.put(DashboardStatusLinkType.PENDING_SALES, this.orderService.countPending(user, true, OrderStatus.PENDING_SELLER, date));
        }
        if (sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW) && bl) {
            hashMap.put(DashboardStatusLinkType.PENDING_PURCHASES, this.orderService.countPending(user, false, OrderStatus.PENDING_BUYER, date));
        }
        if (sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_USER) && sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE)) {
            hashMap.put(DashboardStatusLinkType.PAYMENTS_TO_QUALIFY, this.countPaymentsToQualify(user));
        }
        if (sessionData.hasPermission(Permission.CONNECTED_USERS_VIEW) && CollectionHelper.isNotEmpty((Iterable)(connectedUserSearchData = this.connectedUserService.getSearchData()).getRoles())) {
            Map map = this.connectedUserService.countConnectedUsers(connectedUserSearchData.getRoles(), true);
            for (Role role : connectedUserSearchData.getRoles()) {
                DashboardStatusLinkType dashboardStatusLinkType = CONNECTED_USERS_LINK_TYPES.get(role);
                if (dashboardStatusLinkType == null) {
                    throw new IllegalStateException("No DashboardStatusLinkType mapped for role " + String.valueOf(role));
                }
                hashMap.put(dashboardStatusLinkType, map.getOrDefault(role, 0));
            }
        }
        if (sessionData.hasPermission(Permission.MY_MESSAGES_VIEW) || sessionData.hasPermission(Permission.SYSTEM_MESSAGES_VIEW)) {
            hashMap.put(DashboardStatusLinkType.UNREAD_MESSAGES, this.messageService.countUnreadMessages());
        }
        if (sessionData.hasPermission(Permission.MY_ADS_ENABLE)) {
            hashMap.put(DashboardStatusLinkType.MY_ADS, this.adService.getAdvertisementsCount(user, AdType.ADVERTISEMENT));
        }
        if (sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE)) {
            hashMap.put(DashboardStatusLinkType.MY_WEBSHOP, this.adService.getAdvertisementsCount(user, AdType.WEB_SHOP));
        }
        if (sessionData.hasPermission(Permission.MY_REFERENCES_RECEIVE)) {
            hashMap.put(DashboardStatusLinkType.RECEIVED_REFERENCES, this.generalReferenceService.countReceived(user));
        }
        if (sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE)) {
            hashMap.put(DashboardStatusLinkType.RECEIVED_TRANSACTION_FEEDBACKS, this.transactionFeedbackService.countReceived(user));
        }
        return hashMap;
    }

    private <VO extends RecordTypeVO> List<VO> recordTypes(Class<VO> clazz, List<? extends RecordType> list) {
        return CollectionHelper.orEmpty(list).stream().filter(this::showRecordTypeOnInitializationData).map(this.conversionHandler.convertingFunction(clazz, new Object[0])).collect(Collectors.toList());
    }

    private boolean showRecordTypeOnInitializationData(RecordType recordType) {
        if (recordType.getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM) {
            if (recordType instanceof SystemRecordType) {
                if (this.recordService.getRecordsCount((SystemRecordType)recordType) == 0) {
                    return this.getProducts().admin().getSystemRecordTypes().isSet((Object)((SystemRecordType)recordType), (Path)QProductRecordType.productRecordType.create);
                }
            } else if (this.recordService.getRecordsCount((UserRecordType)recordType, this.getLoggedUser()) == 0) {
                return this.getProducts().product().getMyRecordTypes().isSet((Object)((UserRecordType)recordType), (Path)QProductRecordType.productRecordType.create);
            }
        }
        return true;
    }

    static {
        CONNECTED_USERS_LINK_TYPES.put(Role.ADMIN, DashboardStatusLinkType.CONNECTED_ADMINISTRATORS);
        CONNECTED_USERS_LINK_TYPES.put(Role.BROKER, DashboardStatusLinkType.CONNECTED_BROKERS);
        CONNECTED_USERS_LINK_TYPES.put(Role.MEMBER, DashboardStatusLinkType.CONNECTED_MEMBERS);
        CONNECTED_USERS_LINK_TYPES.put(Role.OPERATOR, DashboardStatusLinkType.CONNECTED_OPERATORS);
    }
}

