/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_7;

import org.cyclos.db.BaseMigration;
import org.cyclos.utils.MaskHelper;
import org.springframework.jdbc.core.RowCallbackHandler;

public class MaskedCustomValuesMigration
extends BaseMigration {
    private int affected;

    @Override
    public int run() throws Exception {
        this.run("user");
        this.run("transaction");
        return this.affected;
    }

    private void processField(long l, String string, String string2) {
        RowCallbackHandler rowCallbackHandler = resultSet -> {
            long l = resultSet.getLong("id");
            String string3 = resultSet.getString("string_value");
            this.processValue(string2, string, l, string3);
        };
        this.jdbcTemplate.query("select id, string_value from " + string2 + " where field_id = ? and string_value is not null and string_value <> ''", rowCallbackHandler, new Object[]{l});
    }

    private void processValue(String string, String string2, long l, String string3) {
        if (MaskHelper.isValidMaskedValue((String)string2, (String)string3)) {
            String string4 = MaskHelper.removeMask((String)string2, (String)string3);
            this.jdbcTemplate.update("update " + string + " set string_value = ? where id = ?", new Object[]{string4, l});
            ++this.affected;
        }
    }

    int run(String string) {
        String string2 = string + "_custom_fields";
        String string3 = string + "_custom_field_values";
        RowCallbackHandler rowCallbackHandler = resultSet -> this.processField(resultSet.getLong("id"), resultSet.getString("pattern"), string3);
        this.jdbcTemplate.query("select id, pattern from " + string2 + " where pattern is not null", rowCallbackHandler);
        return this.affected;
    }
}

