/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_6;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclos.db.BaseMigration;
import org.cyclos.impl.ApplicationHandlerImpl;
import org.cyclos.license.core.CipherHelper;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.TokenType;

public class NFCTokenPrincipalTypeMigration
extends BaseMigration {
    @Override
    public int run() throws Exception {
        byte[] byArray = (byte[])this.jdbcTemplate.queryForObject("SELECT license_key FROM application", byte[].class);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.jdbcTemplate.query("SELECT id FROM principal_types WHERE token_type in (?, ?) and key is null", preparedStatement -> {
            preparedStatement.setString(1, TokenType.NFC_TAG.name());
            preparedStatement.setString(2, TokenType.NFC_DEVICE.name());
        }, resultSet -> {
            long l = resultSet.getLong(1);
            atomicInteger.addAndGet(this.jdbcTemplate.update("UPDATE principal_types set (subclass, key) = (?, ?) WHERE id = ?", preparedStatement -> {
                preparedStatement.setString(1, PrincipalTypeNature.NFC_TOKEN.name());
                preparedStatement.setBytes(2, this.calcDefaultKey(byArray, l));
                preparedStatement.setLong(3, l);
            }));
        });
        return atomicInteger.intValue();
    }

    private byte[] calcDefaultKey(byte[] byArray, long l) {
        byte[] byArray2 = new byte[16];
        String string = Base64.getEncoder().encodeToString(byArray2);
        byte[] byArray3 = this.keyMask(l);
        byte[] byArray4 = CipherHelper.encrypt((byte[])ApplicationHandlerImpl.deriveKey(byArray, byArray3), (String)string);
        return byArray4;
    }

    private byte[] keyMask(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }
}

