/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_15;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.Permission;
import org.cyclos.model.messaging.alerts.AlertNature;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.utils.coercion.CoercionHelper;

public class RemoveRelatedDataFromNeverVisibleAccountsMigration
extends BaseMigration {
    private static final List<ProductRelationTable> RELATIONS = Arrays.asList(RemoveRelatedDataFromNeverVisibleAccountsMigration.relation("Payment filters", "products_my_transfer_filters", "transfer_filter_id", "transfer_filters", new Permission[0]), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Perform payments", "products_user_payment_types", Permission.MY_PAYMENTS_PAY_TO_SELF, Permission.MY_PAYMENTS_PAY_TO_SYSTEM, Permission.MY_PAYMENTS_PAY_TO_USER), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Perform external payments", "products_user_external_payment_types", Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Receive payments (POS)", "products_user_receive_payment_types", Permission.MY_PAYMENTS_RECEIVE), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Receive payments (Tickets)", "products_user_create_ticket_payment_types", Permission.MY_PAYMENT_TICKETS_CREATE), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Make payments (tickets)", "products_user_approve_ticket_payment_types", Permission.MY_PAYMENT_TICKETS_APPROVE), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Chargeback payments", "products_user_chargeback_payment_types", Permission.MY_PAYMENTS_CHARGEBACK), RemoveRelatedDataFromNeverVisibleAccountsMigration.transferType("Request payments", "products_user_request_payment_types", Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM, Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER));

    private static ProductRelationTable relation(String string, String string2, String string3, String string4, Permission ... permissionArray) {
        ProductRelationTable productRelationTable = new ProductRelationTable();
        productRelationTable.name = string;
        productRelationTable.permissions = permissionArray;
        productRelationTable.relationTable = string2;
        productRelationTable.relationColumn = string3;
        productRelationTable.foreignTable = string4;
        return productRelationTable;
    }

    private static ProductRelationTable transferType(String string, String string2, Permission ... permissionArray) {
        return RemoveRelatedDataFromNeverVisibleAccountsMigration.relation(string, string2, "payment_type_id", "transfer_types", permissionArray);
    }

    @Override
    public int run() throws Exception {
        List list = this.jdbcTemplate.queryForList(" select id, name, network_id from products where member_account_accessibility = ?", new Object[]{AccountAccessibility.NEVER.name()});
        int n = 0;
        for (Map map : list) {
            Long l = (Long)CoercionHelper.coerce(Long.class, map.get("id"));
            String string = (String)CoercionHelper.coerce(String.class, map.get("name"));
            Long l2 = (Long)CoercionHelper.coerce(Long.class, map.get("network_id"));
            n += this.process(l, string, l2);
        }
        return n;
    }

    private int process(Long l, String string2, Long l2) {
        LinkedHashMap<String, List> linkedHashMap = new LinkedHashMap<String, List>();
        RELATIONS.forEach(productRelationTable -> {
            String string = String.format(" select e.name from %s r inner join %s e on r.%s = e.id where r.product_id = ? order by 1", productRelationTable.relationTable, productRelationTable.foreignTable, productRelationTable.relationColumn);
            List list = this.jdbcTemplate.queryForList(string, String.class, new Object[]{l});
            if (!list.isEmpty()) {
                linkedHashMap.put(productRelationTable.name, list);
                string = String.format("delete from %s where product_id = ?", productRelationTable.relationTable);
                this.jdbcTemplate.update(string, new Object[]{l});
                if (ArrayUtils.isNotEmpty((Object[])productRelationTable.permissions)) {
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    arrayList.add(l);
                    Stream.of(productRelationTable.permissions).map(Enum::name).forEach(arrayList::add);
                    this.jdbcTemplate.update("delete from products_permissions where product_id = ? and permission in " + RemoveRelatedDataFromNeverVisibleAccountsMigration.inPlaceholders(productRelationTable.permissions), arrayList.toArray());
                }
            }
        });
        if (linkedHashMap.isEmpty()) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder().append("On migration, the product ").append(string2).append(" was found to have ").append("Account visibility (general) = Never, but had inconsistent related data which was removed: ");
        linkedHashMap.forEach((string, list) -> stringBuilder.append("\n \u2022 ").append((String)string).append(": ").append(StringUtils.join((Iterable)list, (String)", ")));
        stringBuilder.append("\nIf it was the only product granting those permissions,").append(" another product should be created to grant those permissions again.");
        this.jdbcTemplate.update("insert into alerts (date, subclass, system_type, network_id, arg0) values (now(), ?, ?, ?, ?)", new Object[]{AlertNature.SYSTEM.name(), SystemAlertType.CUSTOM.name(), l2, stringBuilder});
        return 1;
    }

    private static class ProductRelationTable {
        private String name;
        private Permission[] permissions;
        private String relationTable;
        private String relationColumn;
        private String foreignTable;

        private ProductRelationTable() {
        }
    }
}

