/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.db.AbstractDatabasePopulator;
import org.cyclos.db.DatabasePopulator;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.QSystemCustomImage;
import org.cyclos.entities.contentmanagement.SystemCustomImage;
import org.cyclos.entities.contentmanagement.SystemImageCategory;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.system.AddressConfiguration;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmtpConfiguration;
import org.cyclos.entities.system.UserFormatConfiguration;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.utils.Dimensions;
import org.cyclos.entities.utils.FileSize;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.VoucherTemplateServiceLocal;
import org.cyclos.impl.contentmanagement.DataTranslationServiceLocal;
import org.cyclos.impl.contentmanagement.MobilePageServiceLocal;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.impl.contentmanagement.SystemCustomImageServiceLocal;
import org.cyclos.impl.contentmanagement.SystemImageCategoryServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsGroupServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.ChannelDTO;
import org.cyclos.model.access.channels.IdentificationMethod;
import org.cyclos.model.access.passwordtypes.DefaultPasswordType;
import org.cyclos.model.access.passwordtypes.InvalidPasswordAction;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDTO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.banking.accounts.AccountStatusIndicator;
import org.cyclos.model.banking.accounts.DefaultAccountHistoryPeriod;
import org.cyclos.model.contentmanagement.contentitems.FrontendContentLayout;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryDTO;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageDTO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageShowInOption;
import org.cyclos.model.contentmanagement.staticcontents.AdminHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.EmailTemplateDTO;
import org.cyclos.model.contentmanagement.staticcontents.FooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendDashboardContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.GuestHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.HeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.HelpContentDefinitionType;
import org.cyclos.model.contentmanagement.staticcontents.HomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoggedUserHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoginFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoginHeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.MobileHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.MobilePosHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PayFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PayHeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.UserHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.WelcomeContentDTO;
import org.cyclos.model.contentmanagement.themes.ApplyThemesDTO;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.contentmanagement.translations.DataTranslationDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationData;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.contentmanagement.translations.DataTranslationValueDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.advertisements.AdInitialSearchType;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.model.system.configurations.AllowAccessMode;
import org.cyclos.model.system.configurations.ConfigurationDTO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.configurations.FormatSeparator;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.configurations.FrontendDashboardAccounts;
import org.cyclos.model.system.configurations.FrontendLandingPage;
import org.cyclos.model.system.configurations.MenuType;
import org.cyclos.model.system.configurations.ResultType;
import org.cyclos.model.system.configurations.TaskLoggingMode;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.exportformats.ExportFormatDTO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.languages.DateFormat;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.languages.ListSeparator;
import org.cyclos.model.system.languages.NumberFormat;
import org.cyclos.model.system.languages.TimeFormat;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.products.ProductMyProfileFieldDTO;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.FileSizeUnit;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicPopulator
extends AbstractDatabasePopulator {
    public static final int DEFAULT_USERNAME_LENGTH_MIN = 2;
    public static final int DEFAULT_USERNAME_LENGTH_MAX = 16;
    public static final int DEFAULT_GENERATED_USERNAME_LENGTH = 10;
    private static final Logger logger = LogManager.getLogger((String)BasicPopulator.class.getName());
    private static final Pattern FILE_PATTERN = Pattern.compile("\\[\\[([\\w|\\.]+)\\]\\]");
    private static final String DEFAULT_MAIN_WEB_THEME = "blue_bkg-grey_menu-solid-full";
    private static final String DEFAULT_MOBILE_THEME = "default_mobile";
    private static final String DEFAULT_PAY_THEME = "default_pay";
    private static final String DEFAULT_APP_THEME = "default_app";
    @Autowired
    protected ConfigurationServiceLocal configurationService;
    @Autowired
    protected ChannelServiceLocal channelService;
    @Autowired
    protected GroupServiceLocal groupService;
    @Autowired
    protected ProductsGroupServiceLocal groupProductsService;
    @Autowired
    protected LanguageServiceLocal languageService;
    @Autowired
    protected ThemeServiceLocal themeService;
    @Autowired
    protected VoucherTemplateServiceLocal voucherTemplateService;
    @Autowired
    protected UserServiceLocal userService;
    @Autowired
    protected ProductServiceLocal productService;
    @Autowired
    protected SystemCustomImageServiceLocal systemCustomImageService;
    @Autowired
    protected SystemImageCategoryServiceLocal systemImageCategoryService;
    @Autowired
    protected StaticContentServiceLocal staticContentService;
    @Autowired
    protected MobilePageServiceLocal mobilePageService;
    @Autowired
    protected DataTranslationServiceLocal dataTranslationService;
    @Autowired
    protected TranslationHandler translationHandler;
    protected BuiltInPrincipalType username;
    protected BuiltInPrincipalType email;
    protected BuiltInPrincipalType mobilePhone;
    protected BuiltInPrincipalType accountNumber;
    protected BuiltInPrincipalType trustedDevice;
    protected PasswordType loginPassword;
    protected PasswordType transactionPassword;
    protected PasswordType pin;
    protected PasswordType oneTimePassword;
    protected Language english;
    protected Map<BuiltinLanguage, Language> languagesByTemplate;
    protected Channel mainChannel;
    protected Channel webServicesChannel;
    protected Channel oidcChannel;
    protected Channel smsChannel;
    protected Channel posChannel;
    protected Channel mobileChannel;
    protected Channel ticketChannel;
    protected Channel easyInvoiceChannel;
    protected ExportFormat csv;
    protected ExportFormat xlsx;
    protected ExportFormat pdf;
    protected Configuration globalDefaultConfig;
    protected ChannelConfiguration globalDefaultMainChannel;
    protected ChannelConfiguration globalDefaultWebServicesChannel;
    protected ChannelConfiguration globalDefaultOidcChannel;
    protected ChannelConfiguration globalDefaultSmsChannel;
    protected ChannelConfiguration globalDefaultPosChannel;
    protected ChannelConfiguration globalDefaultMobileChannel;
    protected ChannelConfiguration globalDefaultTicketChannel;
    protected ChannelConfiguration globalDefaultEasyInvoiceChannel;
    protected AdminGroup globalAdminsGroup;
    protected SystemImageCategory globalImgCat;
    protected User admin;
    protected Theme defaultMainWebTheme;
    protected Theme defaultMobileTheme;
    protected Theme defaultPayTheme;
    protected Theme defaultAppTheme;

    @Override
    public String getDisplayName() {
        return "Basic data";
    }

    @Override
    public void populate() {
        DatabasePopulator.inPopulator();
        this.createLanguages();
        this.createChannels();
        this.createExportFormats();
        this.createConfiguration();
        this.createPrincipalTypes();
        RequestData requestData = new RequestData();
        requestData.setRemoteAddress("127.0.0.1");
        requestData.setConfigurationId(this.globalDefaultConfig.getId());
        this.invokerHandler.runAs(SessionDataFactory.system((RequestData)requestData), () -> {
            this.createPasswordTypes();
            this.createChannelConfigurations();
            this.createThemes();
            this.createVoucherTemplates();
            this.createGlobalSystemImageCategories();
            this.createGlobalContent();
            this.createGlobalAdminsGroup();
            this.createDataTranslation();
            return null;
        });
    }

    protected void assignProductToBasicGroup(Product product, BasicGroup basicGroup) {
        this.groupProductsService.assign(new ProductVO(product.getId()), (EntityVO)new BasicGroupVO(basicGroup.getId()));
        basicGroup.getProducts().add(product);
        Set set = product.getGroups();
        set.add(basicGroup);
    }

    protected void createGlobalAdmin() {
        UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
        userRegistrationDTO.setGroup(new GroupVO(this.globalAdminsGroup.getId()));
        userRegistrationDTO.setName("System Administrator");
        userRegistrationDTO.setUsername("admin");
        userRegistrationDTO.setEmail("admin@email.com");
        userRegistrationDTO.setSkipActivationEmail(true);
        PasswordRegistrationDTO passwordRegistrationDTO = new PasswordRegistrationDTO();
        passwordRegistrationDTO.setType(new PasswordTypeVO(this.loginPassword.getId()));
        passwordRegistrationDTO.setAssign(true);
        passwordRegistrationDTO.setValue("1234");
        passwordRegistrationDTO.setConfirmationValue(passwordRegistrationDTO.getValue());
        userRegistrationDTO.setPasswords(Arrays.asList(passwordRegistrationDTO));
        try {
            UserRegistrationResult userRegistrationResult = this.userService.register(userRegistrationDTO);
            this.admin = (User)this.userService.find(userRegistrationResult.getUser().getId());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error creating system admin", exception);
        }
    }

    protected List<ProductMyProfileFieldDTO> createProductMyBasicProfileFields() {
        ArrayList<ProductMyProfileFieldDTO> arrayList = new ArrayList<ProductMyProfileFieldDTO>();
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.LOGIN_NAME, true, true, false, true, false));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.FULL_NAME, true, true, false, true, false));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.EMAIL, true, true, true, true, true));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.IMAGE, true, true, true, true, false));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.ACCOUNT_NUMBER, true, true, false, false, false));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.ADDRESS, true, true, true, true, true));
        arrayList.add(this.createProductMyProfileField((ProfileField)BasicProfileField.PHONE, true, true, true, true, true));
        return arrayList;
    }

    protected ProductMyProfileFieldDTO createProductMyProfileField(ProfileField profileField, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ProductMyProfileFieldDTO productMyProfileFieldDTO = new ProductMyProfileFieldDTO();
        productMyProfileFieldDTO.setProfileField(profileField);
        productMyProfileFieldDTO.setEnabled(bl);
        productMyProfileFieldDTO.setVisible(bl2);
        productMyProfileFieldDTO.setEditable(bl3);
        productMyProfileFieldDTO.setEditableAtRegistration(bl4);
        productMyProfileFieldDTO.setManagePrivacy(bl5);
        return productMyProfileFieldDTO;
    }

    protected ProductUserProfileFieldDTO createProductUserProfileField(Collection<ProductUserProfileFieldDTO> collection, ProfileField profileField, boolean bl, boolean bl2, boolean bl3) {
        ProductUserProfileFieldDTO productUserProfileFieldDTO = null;
        if (collection != null) {
            for (ProductUserProfileFieldDTO productUserProfileFieldDTO2 : collection) {
                if (!profileField.equals((Object)productUserProfileFieldDTO2.getProfileField())) continue;
                productUserProfileFieldDTO = productUserProfileFieldDTO2;
                break;
            }
        }
        if (productUserProfileFieldDTO == null) {
            productUserProfileFieldDTO = new ProductUserProfileFieldDTO();
            productUserProfileFieldDTO.setProfileField(profileField);
        }
        productUserProfileFieldDTO.setVisible(bl);
        productUserProfileFieldDTO.setEditable(bl2);
        productUserProfileFieldDTO.setUserKeywords(bl3);
        productUserProfileFieldDTO.setAdKeywords(bl3);
        productUserProfileFieldDTO.setRecordKeywords(bl3);
        return productUserProfileFieldDTO;
    }

    protected List<ProductUserProfileFieldDTO> createProductUserProfileFields(Collection<ProductUserProfileFieldDTO> collection, boolean bl, UserCustomField ... userCustomFieldArray) {
        ArrayList<ProductUserProfileFieldDTO> arrayList = new ArrayList<ProductUserProfileFieldDTO>();
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.LOGIN_NAME, true, bl, true));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.FULL_NAME, true, bl, true));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.EMAIL, true, bl, bl));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.IMAGE, true, bl, false));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.ACCOUNT_NUMBER, true, false, true));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.ADDRESS, true, bl, true));
        arrayList.add(this.createProductUserProfileField(collection, (ProfileField)BasicProfileField.PHONE, true, bl, true));
        for (UserCustomField userCustomField : userCustomFieldArray) {
            arrayList.add(this.createProductUserProfileField(collection, (ProfileField)userCustomField, true, bl, false));
        }
        return arrayList;
    }

    protected int getLoginPasswordMinLength() {
        return 6;
    }

    protected String loadContentAndImportImages(String string, SystemImageCategory systemImageCategory) {
        try {
            String string2 = ResourceHelper.readContent((String)string);
            if (string2 == null) {
                throw new FileNotFoundException(string);
            }
            String string3 = ResourceHelper.getParentName((String)string);
            Matcher matcher = FILE_PATTERN.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string4 = matcher.group(1);
                String string5 = this.imageKey(systemImageCategory, string3, string4);
                matcher.appendReplacement(stringBuffer, "#SYSTEM_CUSTOM:" + string5 + "#");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error importing resource " + string, exception);
        }
    }

    protected String loadGroovyScript(String string) {
        return this.loadGroovyScript(string, true);
    }

    protected String loadGroovyScript(String string, boolean bl) {
        try {
            string = StringUtils.appendIfMissing((String)string, (CharSequence)".groovy", (CharSequence[])new CharSequence[0]);
            String string2 = ResourceHelper.readContent((String)string);
            if (string2 == null && !bl) {
                throw new FileNotFoundException(String.format("Missing script file: %s", string));
            }
            if (string2 == null) {
                logger.info("Optional script not found: {}", (Object)string);
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(String.format("Error loading script %s", string), iOException);
        }
    }

    protected <T> void set(ConfigurationDTO configurationDTO, Property<T, ? super ConfigurationDTO> property, T t) {
        configurationDTO.set(property, t);
        configurationDTO.getDefinedProperties().add(property.getName());
    }

    protected ChannelConfiguration setChannelConfiguration(Configuration configuration, Channel channel, UserChannelAccess userChannelAccess, PasswordType passwordType, PasswordType passwordType2, TimeInterval timeInterval) {
        ChannelConfiguration channelConfiguration = configuration.getChannelConfiguration(channel);
        if (channelConfiguration == null) {
            channelConfiguration = channel.isSms() ? new SmsChannelConfiguration() : new ChannelConfiguration();
            channelConfiguration.setConfiguration(configuration);
            channelConfiguration.setChannel(channel);
            configuration.getChannelConfigurations().add(channelConfiguration);
        }
        channelConfiguration.setDefined(true);
        channelConfiguration.setAllowLogin(true);
        channelConfiguration.setEnabled(passwordType != null);
        channelConfiguration.setUserAccess(userChannelAccess);
        channelConfiguration.setAccessPassword(passwordType);
        if (passwordType2 != null) {
            channelConfiguration.setConfirmation(new CredentialsConfiguration(passwordType2));
        }
        channelConfiguration.setSessionTimeout(timeInterval);
        Set set = CollectionHelper.asSet((Object[])new PrincipalType[]{this.username});
        channelConfiguration.setPrincipalTypes(set);
        channelConfiguration.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.PRINCIPAL_TYPE);
            if (channel.isSms()) {
                paymentPrincipalsConfiguration.setPrincipalTypes(CollectionHelper.asSet((Object[])new PrincipalType[]{this.username, this.mobilePhone}));
            } else {
                paymentPrincipalsConfiguration.setPrincipalTypes(set);
            }
            if (channel.isMain()) {
                paymentPrincipalsConfiguration.setDefaultPrincipalType((PrincipalType)this.username);
            }
        }));
        if (channelConfiguration.isTransient()) {
            this.persist((IEntity)channelConfiguration);
        }
        this.entityManagerHandler.flush();
        return channelConfiguration;
    }

    protected void setGroupConfiguration(BasicGroup basicGroup, Configuration configuration) {
        this.groupService.changeConfiguration(new BasicGroupVO(basicGroup.getId()), new ConfigurationVO(configuration.getId()));
    }

    private void addKey(Map<Long, Map<String, MessageKey>> map, SimpleEntity simpleEntity, String string, MessageKey messageKey) {
        Map<String, MessageKey> map2 = map.get(simpleEntity.getId());
        if (map2 == null) {
            map2 = new HashMap<String, MessageKey>();
            map.put(simpleEntity.getId(), map2);
        }
        map2.put(string, messageKey);
    }

    private void createChannelConfigurations() {
        for (Channel channel : this.channelService.listAll()) {
            this.setChannelConfiguration(this.globalDefaultConfig, channel, UserChannelAccess.DEFAULT_DISABLED, null, null, null);
        }
        this.globalDefaultMainChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.mainChannel, UserChannelAccess.ENFORCED_ENABLED, this.loginPassword, null, new TimeInterval(Integer.valueOf(20), TimeField.MINUTES));
        this.globalDefaultMainChannel.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setAutocomplete(true);
            paymentPrincipalsConfiguration.setContacts(true);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.AUTOCOMPLETE);
        }));
        this.globalDefaultWebServicesChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.webServicesChannel, UserChannelAccess.DEFAULT_DISABLED, this.loginPassword, null, new TimeInterval(Integer.valueOf(5), TimeField.MINUTES));
        this.globalDefaultWebServicesChannel.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setAutocomplete(true);
            paymentPrincipalsConfiguration.setContacts(true);
            paymentPrincipalsConfiguration.getPrincipalTypes().add(this.username);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.PRINCIPAL_TYPE);
        }));
        this.globalDefaultOidcChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.oidcChannel, UserChannelAccess.DEFAULT_DISABLED, this.loginPassword, null, null);
        this.globalDefaultOidcChannel.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setAutocomplete(false);
            paymentPrincipalsConfiguration.setContacts(false);
            paymentPrincipalsConfiguration.getPrincipalTypes().add(this.username);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.PRINCIPAL_TYPE);
        }));
        this.globalDefaultMobileChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.mobileChannel, UserChannelAccess.DEFAULT_DISABLED, this.loginPassword, null, new TimeInterval(Integer.valueOf(5), TimeField.MINUTES));
        this.globalDefaultMobileChannel.setTrustedDeviceOnStartup(Integer.valueOf(5));
        this.globalDefaultMobileChannel.setPrincipalTypesAllowingQrCode(CollectionHelper.asSet((Object[])new PrincipalType[]{this.username}));
        this.globalDefaultMobileChannel.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setAutocomplete(true);
            paymentPrincipalsConfiguration.setContacts(true);
            paymentPrincipalsConfiguration.getPrincipalTypes().add(this.username);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.AUTOCOMPLETE);
        }));
        this.globalDefaultSmsChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.smsChannel, UserChannelAccess.DEFAULT_DISABLED, this.loginPassword, null, null);
        this.globalDefaultPosChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.posChannel, UserChannelAccess.DEFAULT_DISABLED, null, null, null);
        this.globalDefaultTicketChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.ticketChannel, UserChannelAccess.DEFAULT_ENABLED, this.loginPassword, null, new TimeInterval(Integer.valueOf(10), TimeField.MINUTES));
        this.globalDefaultEasyInvoiceChannel = this.setChannelConfiguration(this.globalDefaultConfig, this.easyInvoiceChannel, UserChannelAccess.DEFAULT_ENABLED, this.loginPassword, null, new TimeInterval(Integer.valueOf(10), TimeField.MINUTES));
        this.globalDefaultEasyInvoiceChannel.setPayment((PaymentPrincipalsConfiguration)ObjectHelper.with(PaymentPrincipalsConfiguration::new, paymentPrincipalsConfiguration -> {
            paymentPrincipalsConfiguration.setAutocomplete(true);
            paymentPrincipalsConfiguration.setContacts(true);
            paymentPrincipalsConfiguration.setDefaultIdMethod(IdentificationMethod.AUTOCOMPLETE);
        }));
        this.globalDefaultConfig = (Configuration)this.entityManagerHandler.refresh((IEntity)this.globalDefaultConfig);
    }

    private void createChannels() {
        block10: for (BuiltInChannel builtInChannel : BuiltInChannel.values()) {
            Channel channel = new Channel();
            channel.setInternalName(builtInChannel.getInternalName());
            channel.setName(builtInChannel.getDisplayName());
            this.persist((IEntity)channel);
            switch (builtInChannel) {
                case MAIN: {
                    this.mainChannel = channel;
                    continue block10;
                }
                case WEB_SERVICES: {
                    this.webServicesChannel = channel;
                    continue block10;
                }
                case OIDC: {
                    this.oidcChannel = channel;
                }
                case SMS: {
                    this.smsChannel = channel;
                    continue block10;
                }
                case POS: {
                    this.posChannel = channel;
                    continue block10;
                }
                case MOBILE: {
                    this.mobileChannel = channel;
                    continue block10;
                }
                case TICKET: {
                    this.ticketChannel = channel;
                    continue block10;
                }
                case EASY_INVOICE: {
                    this.easyInvoiceChannel = channel;
                }
            }
        }
    }

    private void createConfiguration() {
        this.globalDefaultConfig = new Configuration();
        this.globalDefaultConfig.setDefaultType(DefaultConfigurationType.GLOBAL);
        this.globalDefaultConfig.setName("Global default");
        this.globalDefaultConfig.setInternalName("globalDefault");
        this.globalDefaultConfig.setDefaultLanguage(this.english);
        this.globalDefaultConfig.setCountry("US");
        this.globalDefaultConfig.setApplicationName("Cyclos");
        this.globalDefaultConfig.setApplicationUsername("Administration");
        this.globalDefaultConfig.setRootUrl("http://localhost:8888");
        this.globalDefaultConfig.setAllowAccessMode(AllowAccessMode.CURRENT_OR_ANCESTORS);
        this.globalDefaultConfig.setIncludeInSitemap(Boolean.valueOf(true));
        this.globalDefaultConfig.setAutocompleteResults(Integer.valueOf(8));
        this.globalDefaultConfig.setMaxResults(Integer.valueOf(1000));
        this.globalDefaultConfig.setMaxImageDimensions(new Dimensions(Integer.valueOf(960), Integer.valueOf(960)));
        this.globalDefaultConfig.setMaxMediumThumbDimensions(new Dimensions(Integer.valueOf(240), Integer.valueOf(240)));
        this.globalDefaultConfig.setMaxSmallThumbDimensions(new Dimensions(Integer.valueOf(150), Integer.valueOf(150)));
        this.globalDefaultConfig.setMaxTinyThumbDimensions(new Dimensions(Integer.valueOf(80), Integer.valueOf(80)));
        this.globalDefaultConfig.setMaxUploadSize(new FileSize(Integer.valueOf(5), FileSizeUnit.M));
        this.globalDefaultConfig.setMaxPngSize(new FileSize(Integer.valueOf(300), FileSizeUnit.K));
        this.globalDefaultConfig.setJpegQuality(Integer.valueOf(80));
        this.globalDefaultConfig.setUsernameLength(new IntegerRange(Integer.valueOf(2), Integer.valueOf(16)));
        this.globalDefaultConfig.setGeneratedUsername(Boolean.valueOf(false));
        this.globalDefaultConfig.setRegexForUsername("^[\\w\\.]*$");
        AddressConfiguration addressConfiguration = new AddressConfiguration();
        addressConfiguration.setEnabledAddressFields(CollectionHelper.asSet((Object[])new AddressFields[]{AddressFields.STREET, AddressFields.BUILDING_NUMBER, AddressFields.COMPLEMENT, AddressFields.NEIGHBORHOOD, AddressFields.CITY, AddressFields.COUNTRY, AddressFields.ZIP}));
        this.globalDefaultConfig.setAddressConfiguration(addressConfiguration);
        UserFormatConfiguration userFormatConfiguration = new UserFormatConfiguration();
        userFormatConfiguration.setSeparator(FormatSeparator.DASH);
        userFormatConfiguration.setProfileFields(Collections.singletonList(BasicProfileField.FULL_NAME));
        this.globalDefaultConfig.setUserFormatForManagers(userFormatConfiguration);
        this.globalDefaultConfig.setUserFormatForOthers(userFormatConfiguration);
        this.globalDefaultConfig.setDateFormat(DateFormat.DMY_SLASH);
        this.globalDefaultConfig.setTimeFormat(TimeFormat.H24);
        this.globalDefaultConfig.setNumberFormat(NumberFormat.COMMA_AS_DECIMAL);
        this.globalDefaultConfig.setDistanceUnit(DistanceUnit.KILOMETER);
        this.globalDefaultConfig.setListSeparator(ListSeparator.SEMI_COLON);
        this.globalDefaultConfig.setUsersResultType(ResultType.TILED);
        this.globalDefaultConfig.setAdsResultType(ResultType.TILED);
        this.globalDefaultConfig.setAdInitialSearchType(AdInitialSearchType.CATEGORIES);
        this.globalDefaultConfig.setUsersSortOrder(UserOrderBy.RELEVANCE);
        this.globalDefaultConfig.setAdsSortOrder(AdOrderBy.DATE);
        this.globalDefaultConfig.setTimeZoneId("GMT");
        this.globalDefaultConfig.setApiDescriptorLastModified(new Date());
        this.globalDefaultConfig.setImagesLastModified(new Date());
        this.globalDefaultConfig.setSitemapLastModified(new Date());
        this.globalDefaultConfig.setMaxUserTempImages(Integer.valueOf(50));
        this.globalDefaultConfig.setMaxGuestTempImages(Integer.valueOf(20));
        this.globalDefaultConfig.setDefaultAccountHistoryPeriod(DefaultAccountHistoryPeriod.LAST_12_MONTHS);
        this.globalDefaultConfig.setAccountStatusIndicators(EnumSet.allOf(AccountStatusIndicator.class));
        SmtpConfiguration smtpConfiguration = new SmtpConfiguration();
        smtpConfiguration.setHost("localhost");
        smtpConfiguration.setPort(Integer.valueOf(25));
        smtpConfiguration.setFromAddress("noreply@localdomain.com");
        this.globalDefaultConfig.setSmtpConfiguration(smtpConfiguration);
        this.globalDefaultConfig.setEmailName(this.globalDefaultConfig.getName());
        this.globalDefaultConfig.setEmailRequired(Boolean.valueOf(true));
        this.globalDefaultConfig.setEmailUnique(Boolean.valueOf(true));
        this.globalDefaultConfig.setMobileUnique(Boolean.valueOf(true));
        this.globalDefaultConfig.setUseMap(Boolean.valueOf(false));
        this.globalDefaultConfig.setMaxResultsOnMap(Integer.valueOf(1000));
        this.globalDefaultConfig.setDefaultMapZoomWeb(Integer.valueOf(15));
        this.globalDefaultConfig.setDefaultMapZoomMobile(Integer.valueOf(16));
        this.globalDefaultConfig.setUseLeftSpaceForGuests(Boolean.valueOf(true));
        this.globalDefaultConfig.setInvalidUsernameAttempts(Integer.valueOf(10));
        this.globalDefaultConfig.setInvalidPosPayerAttempts(Integer.valueOf(40));
        this.globalDefaultConfig.setInvalidTotpAttempts(Integer.valueOf(10));
        this.globalDefaultConfig.setRemoteAddressBlockTime(new TimeInterval(Integer.valueOf(15), TimeField.MINUTES));
        this.globalDefaultConfig.setMaxBlockedUsers(Integer.valueOf(5));
        this.globalDefaultConfig.setRemoteAddressBlockTimeByBlockedUsers(new TimeInterval(Integer.valueOf(1), TimeField.DAYS));
        this.globalDefaultConfig.setUsersMenuType(MenuType.TOP_AND_LEFT);
        this.globalDefaultConfig.setGuestsMenuType(MenuType.TOP);
        this.globalDefaultConfig.setEnableServicesLog(Boolean.valueOf(true));
        this.globalDefaultConfig.setTasksLoggingMode(TaskLoggingMode.VERBOSE);
        this.globalDefaultConfig.setMaxLogEntries(Integer.valueOf(1000));
        this.globalDefaultConfig.setLogServicesForGuests(Boolean.valueOf(false));
        this.globalDefaultConfig.setLogServicesParameters(Boolean.valueOf(true));
        this.globalDefaultConfig.setLogServicesResults(Boolean.valueOf(false));
        this.globalDefaultConfig.setDefinedProperties(new HashSet(this.configurationHandler.getConfigurableProperties()));
        this.globalDefaultConfig.setDefaultAddressPrivacy(FieldVisibility.VISIBLE);
        this.globalDefaultConfig.setDefaultPhonePrivacy(FieldVisibility.HIDDEN);
        this.globalDefaultConfig.setDefaultEmailPrivacy(FieldVisibility.HIDDEN);
        this.globalDefaultConfig.setAllowMultipleReports(Boolean.valueOf(true));
        this.globalDefaultConfig.setForgotPasswordMode(ForgotPasswordMode.DISABLED);
        this.globalDefaultConfig.setFrontend(Frontend.CLASSIC);
        this.globalDefaultConfig.setAllowFrontendSwitching(Boolean.valueOf(false));
        this.globalDefaultConfig.setFrontendTitle("Cyclos");
        this.globalDefaultConfig.setFrontendMobileTitle("Cyclos");
        this.globalDefaultConfig.setFrontendMobileMenuTitle("Cyclos");
        this.globalDefaultConfig.setFrontendMobileLandingPage(FrontendLandingPage.HOME);
        this.globalDefaultConfig.setFrontendMenuBar(Boolean.valueOf(false));
        this.globalDefaultConfig.setFrontendDashboardAccounts(FrontendDashboardAccounts.MERGED);
        this.globalDefaultConfig.setFrontendDashboardUsers(Boolean.valueOf(false));
        this.globalDefaultConfig.setFrontendDashboardAds(Boolean.valueOf(true));
        this.globalDefaultConfig.setCaptchaConfiguration(new CaptchaConfiguration());
        this.globalDefaultConfig.setVoucherBuyingMenu(UserMainMenu.BANKING);
        this.globalDefaultConfig.setNotifyLoginsOnNewDevices(Boolean.valueOf(true));
        this.persist((IEntity)this.globalDefaultConfig);
        this.globalDefaultConfig = (Configuration)this.save(this.configurationService, (ConfigurationDTO)this.configurationService.load(this.globalDefaultConfig.getId()));
    }

    private void createDataTranslation() {
        HashMap<DataTranslationType, HashMap<Long, Map<String, MessageKey>>> hashMap = new HashMap<DataTranslationType, HashMap<Long, Map<String, MessageKey>>>();
        HashMap<Long, Map<String, MessageKey>> hashMap2 = new HashMap<Long, Map<String, MessageKey>>();
        String string = ChannelDTO.NAME.getName();
        this.addKey(hashMap2, (SimpleEntity)this.mainChannel, string, GeneralKeys.InitialData.CHANNEL_MAIN);
        this.addKey(hashMap2, (SimpleEntity)this.webServicesChannel, string, GeneralKeys.InitialData.CHANNEL_WEB_SERVICES);
        this.addKey(hashMap2, (SimpleEntity)this.oidcChannel, string, GeneralKeys.InitialData.CHANNEL_OIDC);
        this.addKey(hashMap2, (SimpleEntity)this.smsChannel, string, GeneralKeys.InitialData.CHANNEL_SMS);
        this.addKey(hashMap2, (SimpleEntity)this.posChannel, string, GeneralKeys.InitialData.CHANNEL_POS);
        this.addKey(hashMap2, (SimpleEntity)this.mobileChannel, string, GeneralKeys.InitialData.CHANNEL_MOBILE);
        this.addKey(hashMap2, (SimpleEntity)this.ticketChannel, string, GeneralKeys.InitialData.CHANNEL_TICKET);
        this.addKey(hashMap2, (SimpleEntity)this.easyInvoiceChannel, string, GeneralKeys.InitialData.CHANNEL_EASY_INVOICE);
        hashMap.put(DataTranslationType.CHANNEL, hashMap2);
        HashMap<Long, Map<String, MessageKey>> hashMap3 = new HashMap<Long, Map<String, MessageKey>>();
        string = ExportFormatDTO.NAME.getName();
        this.addKey(hashMap3, (SimpleEntity)this.csv, string, GeneralKeys.InitialData.EXPORT_FORMAT_CSV);
        this.addKey(hashMap3, (SimpleEntity)this.xlsx, string, GeneralKeys.InitialData.EXPORT_FORMAT_XLSX);
        this.addKey(hashMap3, (SimpleEntity)this.pdf, string, GeneralKeys.InitialData.EXPORT_FORMAT_PDF);
        hashMap.put(DataTranslationType.EXPORT_FORMAT, hashMap3);
        HashMap<Long, Map<String, MessageKey>> hashMap4 = new HashMap<Long, Map<String, MessageKey>>();
        string = PrincipalTypeDTO.NAME.getName();
        this.addKey(hashMap4, (SimpleEntity)this.username, string, GeneralKeys.InitialData.PRINCIPAL_TYPE_USERNAME);
        this.addKey(hashMap4, (SimpleEntity)this.email, string, GeneralKeys.InitialData.PRINCIPAL_TYPE_EMAIL);
        this.addKey(hashMap4, (SimpleEntity)this.mobilePhone, string, GeneralKeys.InitialData.PRINCIPAL_TYPE_MOBILE_PHONE);
        this.addKey(hashMap4, (SimpleEntity)this.accountNumber, string, GeneralKeys.InitialData.PRINCIPAL_TYPE_ACCOUNT_NUMBER);
        this.addKey(hashMap4, (SimpleEntity)this.trustedDevice, string, GeneralKeys.InitialData.PRINCIPAL_TYPE_TRUSTED_DEVICE);
        hashMap.put(DataTranslationType.PRINCIPAL_TYPE, hashMap4);
        HashMap<Long, Map<String, MessageKey>> hashMap5 = new HashMap<Long, Map<String, MessageKey>>();
        string = PasswordTypeDTO.NAME.getName();
        this.addKey(hashMap5, (SimpleEntity)this.loginPassword, string, GeneralKeys.InitialData.PASSWORD_TYPE_LOGIN_PASSWORD);
        this.addKey(hashMap5, (SimpleEntity)this.transactionPassword, string, GeneralKeys.InitialData.PASSWORD_TYPE_TRANSACTION_PASSWORD);
        this.addKey(hashMap5, (SimpleEntity)this.pin, string, GeneralKeys.InitialData.PASSWORD_TYPE_PIN);
        this.addKey(hashMap5, (SimpleEntity)this.oneTimePassword, string, GeneralKeys.InitialData.PASSWORD_TYPE_ONE_TIME_PASSWORD);
        string = PasswordTypeDTO.DESCRIPTION_ON_REGISTRATION.getName();
        this.addKey(hashMap5, (SimpleEntity)this.loginPassword, string, GeneralKeys.InitialData.PASSWORD_TYPE_LOGIN_DESC);
        this.addKey(hashMap5, (SimpleEntity)this.transactionPassword, string, GeneralKeys.InitialData.PASSWORD_TYPE_TRANSACTION_DESC);
        this.addKey(hashMap5, (SimpleEntity)this.pin, string, GeneralKeys.InitialData.PASSWORD_TYPE_PIN_DESC);
        hashMap.put(DataTranslationType.PASSWORD_TYPE, hashMap5);
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            Language language = this.languagesByTemplate.get(builtinLanguage);
            ResourceBundle resourceBundle = this.translationHandler.getBuiltinResourceBundle(builtinLanguage, Module.GENERAL);
            for (DataTranslationType dataTranslationType : EnumSet.of(DataTranslationType.CHANNEL, DataTranslationType.PRINCIPAL_TYPE, DataTranslationType.PASSWORD_TYPE)) {
                DataTranslationData dataTranslationData = this.dataTranslationService.getData(new LanguageVO(language.getId()), dataTranslationType);
                for (DataTranslationDTO dataTranslationDTO : dataTranslationData.getTranslations()) {
                    Map map = (Map)hashMap.get(dataTranslationType);
                    Long l = dataTranslationDTO.getEntityId();
                    Map map2 = (Map)map.get(l);
                    block5: for (String string2 : map2.keySet()) {
                        String string3;
                        MessageKey messageKey = (MessageKey)map2.get(string2);
                        String string4 = messageKey.submodule().name() + "." + messageKey.key();
                        try {
                            string3 = resourceBundle.getString(string4);
                        }
                        catch (MissingResourceException missingResourceException) {
                            string3 = null;
                        }
                        List list = dataTranslationDTO.getValues();
                        for (DataTranslationValueDTO dataTranslationValueDTO : list) {
                            if (!dataTranslationValueDTO.getProperty().equals(string2)) continue;
                            dataTranslationValueDTO.setValue(string3);
                            continue block5;
                        }
                    }
                }
                this.dataTranslationService.translate(new LanguageVO(language.getId()), dataTranslationData.getTranslations());
            }
        }
    }

    private void createExportFormats() {
        block5: for (BuiltInExportFormat builtInExportFormat : BuiltInExportFormat.values()) {
            ExportFormat exportFormat = new ExportFormat();
            exportFormat.setInternalName(builtInExportFormat.getInternalName());
            exportFormat.setName(builtInExportFormat.getDisplayName());
            exportFormat.setBinary(builtInExportFormat.isBinary());
            exportFormat.setEnabled(true);
            if (!builtInExportFormat.isBinary()) {
                exportFormat.setEncoding("UTF-8");
            }
            exportFormat.setContentType(builtInExportFormat.getContentType());
            exportFormat.setFileExtension(builtInExportFormat.getFileExtension());
            this.persist((IEntity)exportFormat);
            switch (builtInExportFormat) {
                case CSV: {
                    this.csv = exportFormat;
                    continue block5;
                }
                case XLSX: {
                    this.xlsx = exportFormat;
                    continue block5;
                }
                case PDF: {
                    this.pdf = exportFormat;
                }
            }
        }
    }

    private void createGlobalAdminsGroup() {
        this.globalAdminsGroup = new AdminGroup();
        this.globalAdminsGroup.setName("Global administrators");
        this.globalAdminsGroup.setInternalName("globalAdmins");
        this.globalAdminsGroup.setAdminType(AdminGroupType.GLOBAL);
        this.globalAdminsGroup.setConfiguration(this.globalDefaultConfig);
        this.globalAdminsGroup.setAdminProduct(this.productService.createAdminProduct(this.globalAdminsGroup, true));
        this.persist((IEntity)this.globalAdminsGroup);
    }

    private void createGlobalContent() {
        ConfigurationVO configurationVO = new ConfigurationVO((Property)ConfigurationVO.ID, (Object)this.globalDefaultConfig.getId());
        HeaderContentDTO headerContentDTO = new HeaderContentDTO();
        headerContentDTO.setCustomized(true);
        headerContentDTO.setContent(this.readStaticContent("header.html"));
        headerContentDTO.setConfiguration(configurationVO);
        this.save(this.staticContentService, headerContentDTO);
        FooterContentDTO footerContentDTO = new FooterContentDTO();
        footerContentDTO.setCustomized(true);
        footerContentDTO.setThemed(true);
        footerContentDTO.setConfiguration(configurationVO);
        footerContentDTO.setContent(this.readStaticContent("footer.html"));
        this.save(this.staticContentService, footerContentDTO);
        LoggedUserHomeContentDTO loggedUserHomeContentDTO = new LoggedUserHomeContentDTO();
        loggedUserHomeContentDTO.setCustomized(true);
        loggedUserHomeContentDTO.setConfiguration(configurationVO);
        this.save(this.staticContentService, loggedUserHomeContentDTO);
        GuestHomeContentDTO guestHomeContentDTO = new GuestHomeContentDTO();
        guestHomeContentDTO.setCustomized(true);
        guestHomeContentDTO.setConfiguration(configurationVO);
        guestHomeContentDTO.setContent(this.readStaticContent("guestsHome.html"));
        this.save(this.staticContentService, guestHomeContentDTO);
        FrontendHomeContentDTO frontendHomeContentDTO = new FrontendHomeContentDTO();
        frontendHomeContentDTO.setCustomized(true);
        frontendHomeContentDTO.setConfiguration(configurationVO);
        frontendHomeContentDTO.setLayout(FrontendContentLayout.FULL);
        frontendHomeContentDTO.setContent(this.readStaticContent("frontendHome.html"));
        this.save(this.staticContentService, frontendHomeContentDTO);
        FrontendHelpContentDTO frontendHelpContentDTO = new FrontendHelpContentDTO();
        frontendHelpContentDTO.setCustomized(true);
        frontendHelpContentDTO.setEnabled(true);
        frontendHelpContentDTO.setConfiguration(configurationVO);
        frontendHelpContentDTO.setLayout(FrontendContentLayout.CARD);
        frontendHelpContentDTO.setContent(this.readStaticContent("frontendHelp.html"));
        this.save(this.staticContentService, frontendHelpContentDTO);
        FrontendDashboardContentDTO frontendDashboardContentDTO = new FrontendDashboardContentDTO();
        frontendDashboardContentDTO.setCustomized(true);
        frontendDashboardContentDTO.setConfiguration(configurationVO);
        frontendDashboardContentDTO.setLayout(FrontendContentLayout.CARD_TIGHT);
        frontendDashboardContentDTO.setTitle("Upcoming events (example)");
        frontendDashboardContentDTO.setContent(this.readStaticContent("frontendDashboard.html"));
        this.save(this.staticContentService, frontendDashboardContentDTO);
        FrontendFooterContentDTO frontendFooterContentDTO = new FrontendFooterContentDTO();
        frontendFooterContentDTO.setCustomized(true);
        frontendFooterContentDTO.setConfiguration(configurationVO);
        frontendFooterContentDTO.setContent(this.readStaticContent("frontendFooter.html"));
        this.save(this.staticContentService, frontendFooterContentDTO);
        EmailTemplateDTO emailTemplateDTO = new EmailTemplateDTO();
        emailTemplateDTO.setConfiguration(configurationVO);
        emailTemplateDTO.setCustomized(true);
        emailTemplateDTO.setContent(this.readStaticContent("emailTemplate.html"));
        this.save(this.staticContentService, emailTemplateDTO);
        AdminHelpContentDTO adminHelpContentDTO = new AdminHelpContentDTO();
        adminHelpContentDTO.setConfiguration(configurationVO);
        adminHelpContentDTO.setDefinitionType(HelpContentDefinitionType.ORIGINAL);
        this.save(this.staticContentService, adminHelpContentDTO);
        UserHelpContentDTO userHelpContentDTO = new UserHelpContentDTO();
        userHelpContentDTO.setConfiguration(configurationVO);
        userHelpContentDTO.setDefinitionType(HelpContentDefinitionType.ORIGINAL);
        this.save(this.staticContentService, userHelpContentDTO);
        MobileHelpContentDTO mobileHelpContentDTO = new MobileHelpContentDTO();
        mobileHelpContentDTO.setConfiguration(configurationVO);
        mobileHelpContentDTO.setDefinitionType(HelpContentDefinitionType.ORIGINAL);
        this.save(this.staticContentService, mobileHelpContentDTO);
        MobilePosHelpContentDTO mobilePosHelpContentDTO = new MobilePosHelpContentDTO();
        mobilePosHelpContentDTO.setConfiguration(configurationVO);
        mobilePosHelpContentDTO.setDefinitionType(HelpContentDefinitionType.ORIGINAL);
        this.save(this.staticContentService, mobilePosHelpContentDTO);
        LoginHeaderContentDTO loginHeaderContentDTO = new LoginHeaderContentDTO();
        loginHeaderContentDTO.setCustomized(true);
        loginHeaderContentDTO.setContent("<img src=\"#CURRENT_CONFIGURATION:MOBILE_LOGO#\">");
        loginHeaderContentDTO.setConfiguration(configurationVO);
        this.save(this.staticContentService, loginHeaderContentDTO);
        LoginFooterContentDTO loginFooterContentDTO = new LoginFooterContentDTO();
        loginFooterContentDTO.setCustomized(true);
        loginFooterContentDTO.setContent("<div>Welcome to the Cyclos mobile app. This is a welcome message that can be changed by the admin.</div>");
        loginFooterContentDTO.setConfiguration(configurationVO);
        this.save(this.staticContentService, loginFooterContentDTO);
        WelcomeContentDTO welcomeContentDTO = new WelcomeContentDTO();
        welcomeContentDTO.setConfiguration(configurationVO);
        welcomeContentDTO.setContent("<img src=\"#CURRENT_CONFIGURATION:MOBILE_LOGO#\" /><div style=\"text-align: center;margin: 30px 0;font-size: 16px;\">Welcome on board! Thank you for installing our app.<br><br>Please, register or login if you have an active user. </div>");
        welcomeContentDTO.setCustomized(true);
        this.save(this.staticContentService, welcomeContentDTO);
        HomeContentDTO homeContentDTO = new HomeContentDTO();
        homeContentDTO.setConfiguration(configurationVO);
        homeContentDTO.setContent("<div class=\"grid grid-radius\">  <div th:if=\"${#accounts.first()}\" th:attr=\"onclick=|handleOpenURL('cyclos://history?typeId=${#format.maskId(#accounts.first().type.id)}'); return false;|\" class=\"balance\">${account.balance}</div>  <div class=\"welcome\">Current balance</div>  <button class=\"pay\" onclick=\"scanQRAndPay()\">    <img src=\"#IMAGE:system_image_mobile_pay.png#\"/>    <span class=\"imageText\">Pay</span>  </button>  <button th:if=\"${#permissions.has('MY_PAYMENT_TICKETS_CREATE')}\" class=\"receive\" onclick=\"handleOpenURL('cyclos://createTicket')\">    <img src=\"#IMAGE:system_image_mobile_receive.png#\"/>        <span class=\"imageText\">Receive</span>  </button>  <button th:unless=\"${#permissions.has('MY_PAYMENT_TICKETS_CREATE')}\" class=\"receive\" onclick=\"handleOpenURL('cyclos://viewUserIdentification?tokenValue={username}&amp;tokenTypeId=username')\">    <img src=\"#IMAGE:system_image_mobile_receive.png#\"/>        <span class=\"imageText\">Receive</span>  </button></div><div class=\"homeTitle\">Last transactions</div><div class=\"listWrapper listWrapper-smallSpace\">    <div class=\"listContainer\">        <div class=\"listContent\">            <th:block th:if=\"${#accounts.first()}\" th:with=\"firstAccount = ${#accounts.first()}\">                <th:block th:with=\"transfers = ${firstAccount.lastTransfers(3)}\">                    <div th:if=\"${transfers.empty}\" class=\"noResults\">No transfers</div>                          <div th:each=\"t : ${transfers}\" th:attr=\"onclick=|handleOpenURL('cyclos://transferDetails?id=${#format.maskId(t.id)}'); return false;|\" style=\"display: block\" class=\"rowWrapper\" >                        <div class=\"rowContent\">                                <th:block th:if=\"${t.relatedUser}\">                                <div th:if=\"${t.relatedUser.image}\" class=\"thumbnailHolder listPicture\" th:style=\"|background-image: url('${#format.url(t.relatedUser.image)}'); background-color: transparent;|\"></div>                                <div th:unless=\"${t.relatedUser.image}\" class=\"thumbnailHolder listPicture thumbnailHolder-noIcon\">                                                                     <span th:text=\"${#format.truncate(#format.object(t.relatedUser),1)}\"></span>                                </div>                                                  </th:block>                                                                                                                                             <th:block th:unless=\"${t.relatedUser}\">                                <div class=\"thumbnailHolder listPicture\">                                    <span>w</span>                                </div>                            </th:block>                            <div class=\"rowInfoContainer\">                                <div class=\"rowInfoLeft\">                                    <div class=\"rowTitle\"><th:block th:text=\"${#format.object(t.related)}\"></th:block></div>                                    <div class=\"rowSub\"><th:block th:text=\"${#format.object(t.date)}\"></th:block></div>                                    <div class=\"rowDescription\"><th:block th:text=\"${t.description}\"></th:block></div>                                </div>                                <div class=\"rowInfoRight\">                                     <div th:if=\"${#decimals.isPositive(t.amount)}\" class=\"infoBoxLabelNormalRight rowInfoAmount amountPlus\">                                          <th:block th:text=\"${#format.object(t.currencyAmount)}\"></th:block>                                                                        </div>                                     <div th:if=\"${#decimals.isNegative(t.amount)}\" class=\"infoBoxLabelNormalRight rowInfoAmount amountMin\">                                          <th:block th:text=\"${#format.object(t.currencyAmount)}\"></th:block>                                                                        </div>                                </div>                            </div>                                                 </div>                    </div>                    <div th:unless=\"${transfers.empty}\" th:attr=\"onclick=|handleOpenURL('cyclos://history?typeId=${#format.maskId(firstAccount.type.id)}'); return false;|\" class=\"rowWrapper more\" >                                    Show more >                    </div>                </th:block>             </th:block>                   </div>    </div></div>");
        homeContentDTO.setCustomized(true);
        homeContentDTO.setShowIn(MobilePageShowInOption.MOBILE_APP_AND_MOBILE_POS);
        this.save(this.staticContentService, homeContentDTO);
        MobilePageDTO mobilePageDTO = new MobilePageDTO();
        mobilePageDTO.setIcon("N");
        mobilePageDTO.setConfiguration(configurationVO);
        mobilePageDTO.setName("Information");
        mobilePageDTO.setShowIn(MobilePageShowInOption.MOBILE_APP_AND_MOBILE_POS);
        mobilePageDTO.setContent("This is a custom page, the admin can change it by going to:<br>Content management > Menu & content > Mobile pages");
        this.save(this.mobilePageService, mobilePageDTO);
        PayHeaderContentDTO payHeaderContentDTO = new PayHeaderContentDTO();
        payHeaderContentDTO.setCustomized(true);
        payHeaderContentDTO.setContent("empty");
        payHeaderContentDTO.setConfiguration(configurationVO);
        BaseStaticContent baseStaticContent = (BaseStaticContent)this.save(this.staticContentService, payHeaderContentDTO);
        baseStaticContent.setContent("<img src=\"#CURRENT_CONFIGURATION:SYSTEM_LOGO#\">");
        PayFooterContentDTO payFooterContentDTO = new PayFooterContentDTO();
        payFooterContentDTO.setCustomized(true);
        payFooterContentDTO.setContent("");
        payFooterContentDTO.setConfiguration(configurationVO);
        this.save(this.staticContentService, payFooterContentDTO);
        this.entityManagerHandler.flush();
    }

    private void createGlobalSystemImageCategories() {
        SystemImageCategoryDTO systemImageCategoryDTO = (SystemImageCategoryDTO)this.systemImageCategoryService.toDTO((SimpleEntity)new SystemImageCategory());
        systemImageCategoryDTO.setName("General system images");
        this.globalImgCat = (SystemImageCategory)this.save(this.systemImageCategoryService, systemImageCategoryDTO);
    }

    private void createLanguages() {
        this.languagesByTemplate = this.languageService.importBuiltin().stream().collect(Collectors.toMap(Language::getTemplate, language -> language));
        this.english = this.languagesByTemplate.get(BuiltinLanguage.EN);
    }

    private void createPasswordTypes() {
        this.loginPassword = new PasswordType();
        this.loginPassword.setName(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_LOGIN_PASSWORD, new Object[0]));
        this.loginPassword.setInternalName(DefaultPasswordType.LOGIN_PASSWORD.getInternalName());
        this.loginPassword.setDescriptionOnRegistration(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_LOGIN_DESC, new Object[0]));
        int n = this.getLoginPasswordMinLength();
        if (n < 3) {
            throw new IllegalStateException("Min password length must gte to: 3");
        }
        this.loginPassword.setLength(new IntegerRange(Integer.valueOf(n), Integer.valueOf(50)));
        this.loginPassword.setInvalidAttempts(Integer.valueOf(3));
        this.loginPassword.setExpiresAfter(new TimeInterval(Integer.valueOf(5), TimeField.YEARS));
        this.loginPassword.setPasswordMode(PasswordMode.MANUAL);
        this.loginPassword.setInvalidAction(InvalidPasswordAction.TEMPORARILY_BLOCK);
        this.loginPassword.setBlockTime(new TimeInterval(Integer.valueOf(15), TimeField.MINUTES));
        this.loginPassword.setAvoidRepeatedValue(false);
        this.loginPassword.setAvoidObvious(false);
        this.loginPassword.setInputMethod(PasswordInputMethod.TEXT_BOX);
        this.loginPassword.setBcryptStrength(Integer.valueOf(10));
        this.loginPassword.setLowerCaseLetters(Availability.OPTIONAL);
        this.loginPassword.setUpperCaseLetters(Availability.OPTIONAL);
        this.loginPassword.setNumbers(Availability.OPTIONAL);
        this.loginPassword.setSpecialCharacters(Availability.OPTIONAL);
        this.persist((IEntity)this.loginPassword);
        this.transactionPassword = new PasswordType();
        this.transactionPassword.setName(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_TRANSACTION_PASSWORD, new Object[0]));
        this.transactionPassword.setInternalName(DefaultPasswordType.TRANSACTION_PASSWORD.getInternalName());
        this.transactionPassword.setDescriptionOnRegistration(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_TRANSACTION_DESC, new Object[0]));
        this.transactionPassword.setLength(new IntegerRange(Integer.valueOf(4), Integer.valueOf(4)));
        this.transactionPassword.setPasswordMode(PasswordMode.GENERATED);
        this.transactionPassword.setInvalidAttempts(Integer.valueOf(3));
        this.transactionPassword.setExpiresAfter(new TimeInterval(Integer.valueOf(1), TimeField.YEARS));
        this.transactionPassword.setInvalidAction(InvalidPasswordAction.INDEFINITELY_BLOCK);
        this.transactionPassword.setInputMethod(PasswordInputMethod.VIRTUAL_KEYBOARD);
        this.transactionPassword.setPossibleCharacters("ABCDEFGHIJ");
        this.transactionPassword.setUpperCaseLetters(Availability.DISABLED);
        this.transactionPassword.setSpecialCharacters(Availability.DISABLED);
        this.transactionPassword.setCharactersPerButton(Integer.valueOf(1));
        this.transactionPassword.setNumberOfButtons(Integer.valueOf(10));
        this.transactionPassword.setNumberOfRows(Integer.valueOf(2));
        this.persist((IEntity)this.transactionPassword);
        this.pin = new PasswordType();
        this.pin.setName(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_PIN, new Object[0]));
        this.pin.setInternalName(DefaultPasswordType.PIN.getInternalName());
        this.pin.setDescriptionOnRegistration(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_PIN_DESC, new Object[0]));
        this.pin.setPasswordMode(PasswordMode.MANUAL);
        this.pin.setLength(new IntegerRange(Integer.valueOf(4), Integer.valueOf(12)));
        this.pin.setInvalidAttempts(Integer.valueOf(3));
        this.pin.setExpiresAfter(new TimeInterval(Integer.valueOf(1), TimeField.YEARS));
        this.pin.setInvalidAction(InvalidPasswordAction.TEMPORARILY_BLOCK);
        this.pin.setBlockTime(new TimeInterval(Integer.valueOf(15), TimeField.MINUTES));
        this.pin.setAvoidRepeatedValue(true);
        this.pin.setInputMethod(PasswordInputMethod.TEXT_BOX);
        this.pin.setLowerCaseLetters(Availability.DISABLED);
        this.pin.setUpperCaseLetters(Availability.DISABLED);
        this.pin.setSpecialCharacters(Availability.DISABLED);
        this.pin.setNumbers(Availability.REQUIRED);
        this.persist((IEntity)this.pin);
        this.oneTimePassword = new PasswordType();
        this.oneTimePassword.setName(this.translationHandler.message(this.english, GeneralKeys.InitialData.PASSWORD_TYPE_ONE_TIME_PASSWORD, new Object[0]));
        this.oneTimePassword.setInternalName(DefaultPasswordType.ONE_TIME_PASSWORD.getInternalName());
        this.oneTimePassword.setLength(new IntegerRange(Integer.valueOf(6), Integer.valueOf(6)));
        this.oneTimePassword.setPasswordMode(PasswordMode.OTP);
        this.oneTimePassword.setOtpSendMediums(CollectionHelper.asSet((Object[])SendMedium.values()));
        this.oneTimePassword.setInvalidAttempts(Integer.valueOf(3));
        this.oneTimePassword.setExpiresAfter(new TimeInterval(Integer.valueOf(1), TimeField.HOURS));
        this.oneTimePassword.setInvalidAction(InvalidPasswordAction.INDEFINITELY_BLOCK);
        this.oneTimePassword.setInputMethod(PasswordInputMethod.TEXT_BOX);
        this.oneTimePassword.setBcryptStrength(Integer.valueOf(4));
        this.oneTimePassword.setLowerCaseLetters(Availability.DISABLED);
        this.oneTimePassword.setNumbers(Availability.OPTIONAL);
        this.oneTimePassword.setUpperCaseLetters(Availability.DISABLED);
        this.oneTimePassword.setSpecialCharacters(Availability.DISABLED);
        this.persist((IEntity)this.oneTimePassword);
    }

    private void createPrincipalTypes() {
        block7: for (ExistingBuiltInPrincipalType existingBuiltInPrincipalType : ExistingBuiltInPrincipalType.values()) {
            BuiltInPrincipalType builtInPrincipalType = new BuiltInPrincipalType();
            builtInPrincipalType.setInternalName(existingBuiltInPrincipalType.getInternalName());
            builtInPrincipalType.setName(existingBuiltInPrincipalType.getDisplayName());
            builtInPrincipalType.setOrder(Integer.valueOf(existingBuiltInPrincipalType.ordinal() + 1));
            this.persist((IEntity)builtInPrincipalType);
            switch (existingBuiltInPrincipalType) {
                case USERNAME: {
                    this.username = builtInPrincipalType;
                    continue block7;
                }
                case EMAIL: {
                    this.email = builtInPrincipalType;
                    continue block7;
                }
                case MOBILE_PHONE: {
                    this.mobilePhone = builtInPrincipalType;
                    continue block7;
                }
                case ACCOUNT_NUMBER: {
                    this.accountNumber = builtInPrincipalType;
                    continue block7;
                }
                case TRUSTED_DEVICE: {
                    this.trustedDevice = builtInPrincipalType;
                }
            }
        }
    }

    private void createThemes() {
        this.entityManagerHandler.flush();
        List list = this.themeService.importBuiltin();
        for (Theme theme : list) {
            if (this.defaultMainWebTheme == null && DEFAULT_MAIN_WEB_THEME.equals(theme.getFileName())) {
                this.defaultMainWebTheme = theme;
            } else if (this.defaultMobileTheme == null && DEFAULT_MOBILE_THEME.equals(theme.getFileName())) {
                this.defaultMobileTheme = theme;
            } else if (this.defaultPayTheme == null && DEFAULT_PAY_THEME.equals(theme.getFileName())) {
                this.defaultPayTheme = theme;
            } else if (this.defaultAppTheme == null && DEFAULT_APP_THEME.equals(theme.getFileName())) {
                this.defaultAppTheme = theme;
            }
            if (this.defaultMainWebTheme == null || this.defaultMobileTheme == null || this.defaultPayTheme == null) continue;
            break;
        }
        if (this.defaultMainWebTheme != null && this.defaultMobileTheme != null && this.defaultPayTheme != null) {
            ApplyThemesDTO applyThemesDTO = new ApplyThemesDTO();
            applyThemesDTO.setConfiguration(new ConfigurationVO(this.globalDefaultConfig.getId()));
            applyThemesDTO.setUsersTheme(new ThemeVO(this.defaultMainWebTheme.getId()));
            applyThemesDTO.setGuestsTheme(new ThemeVO(this.defaultMainWebTheme.getId()));
            applyThemesDTO.setMobileTheme(new ThemeVO(this.defaultMobileTheme.getId()));
            applyThemesDTO.setPayTheme(new ThemeVO(this.defaultPayTheme.getId()));
            applyThemesDTO.setAppTheme(new ThemeVO(this.defaultAppTheme.getId()));
            this.themeService.applyThemes(applyThemesDTO);
        }
    }

    private void createVoucherTemplates() {
        this.voucherTemplateService.importBuiltin();
    }

    private String imageKey(SystemImageCategory systemImageCategory, String string, String string2) throws IOException {
        ImageVO imageVO;
        QSystemCustomImage qSystemCustomImage = QSystemCustomImage.systemCustomImage;
        SystemCustomImage systemCustomImage = (SystemCustomImage)((DBQuery)this.from(new EntityPathBase[]{qSystemCustomImage}).where(new Predicate[]{qSystemCustomImage.category().eq((Object)systemImageCategory), qSystemCustomImage.name.eq((Object)string2)})).singleResult((Expression)qSystemCustomImage);
        if (systemCustomImage == null) {
            String string3 = ResourceHelper.getFullName((String)string, (String)string2);
            SerializableInputStream serializableInputStream = new SerializableInputStream(ResourceHelper.openStream((String)string3));
            String string4 = ServerImageHelper.ImageType.getByFileName((String)string2).getContentType();
            imageVO = this.systemCustomImageService.save((Object)new SystemImageCategoryVO(systemImageCategory.getId()), string2, serializableInputStream, string4);
        } else {
            imageVO = (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)systemCustomImage);
        }
        return imageVO.getKey();
    }

    private String readStaticContent(String string) {
        try {
            return ResourceHelper.readContent((String)("/staticContent/" + string));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

