/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.cyclos.entities.EntityFormatter;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.BuiltinPrincipalTypeResolver;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.Otp;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.users.phones.PhoneNature;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="MOBILE")
public class MobilePhone
extends Phone
implements UserPrincipal,
OtpOwner,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="verification_date")
    @ReadOnlyFromDTO
    private Date verificationDate;
    @Basic
    @Column(name="enabled_for_sms")
    private Boolean enabledForSms;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<Session> sessions;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<UserIdentityProvider> userIdentityProviders;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<OidcAuthorization> oidcAuthorization;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<ExternalRedirectExecution> externalRedirectExecutions;
    @OneToMany(mappedBy="mobilePhone", cascade={CascadeType.REMOVE})
    private Set<Otp> otps = new HashSet<Otp>();
    static final long serialVersionUID = 8740485982648758386L;

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public UserAccountType getAccountType() {
        return null;
    }

    @Override
    public BasicUser getBasicUser() {
        return this.getUser();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    @Override
    public MobilePhone getMobilePhone() {
        return this;
    }

    @Override
    public PhoneNature getNature() {
        return PhoneNature.MOBILE;
    }

    @Override
    public String getOtpOwnerPathName() {
        return "mobilePhone";
    }

    @Override
    public Set<Otp> getOtps() {
        return this._persistence_get_otps();
    }

    @Override
    public BasicUser getOtpUser() {
        return this.getUser();
    }

    @Override
    public String getPrincipal() {
        return EntityFormatter.get().formatPhone(this, false);
    }

    @Override
    public PrincipalType getPrincipalType() {
        return BuiltinPrincipalTypeResolver.resolve(ExistingBuiltInPrincipalType.MOBILE_PHONE);
    }

    @Override
    public Token getToken() {
        return null;
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return null;
    }

    public Date getVerificationDate() {
        return this._persistence_get_verificationDate();
    }

    public boolean isEnabledForSms() {
        return Boolean.TRUE.equals(this._persistence_get_enabledForSms());
    }

    public boolean isVerified() {
        return this._persistence_get_verificationDate() != null;
    }

    @Override
    public void setAsOwnerFor(Otp otp) {
        otp.setMobilePhone(this);
    }

    public void setEnabledForSms(boolean bl) {
        this._persistence_set_enabledForSms(bl);
    }

    public void setVerificationDate(Date date) {
        this._persistence_set_verificationDate(date);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new MobilePhone();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "sessions") {
            return this.sessions;
        }
        if (string == "enabledForSms") {
            return this.enabledForSms;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "userIdentityProviders") {
            return this.userIdentityProviders;
        }
        if (string == "otps") {
            return this.otps;
        }
        if (string == "verificationDate") {
            return this.verificationDate;
        }
        if (string == "oidcAuthorization") {
            return this.oidcAuthorization;
        }
        if (string == "externalRedirectExecutions") {
            return this.externalRedirectExecutions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "sessions") {
            this.sessions = (Set)object;
            return;
        }
        if (string == "enabledForSms") {
            this.enabledForSms = (Boolean)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "userIdentityProviders") {
            this.userIdentityProviders = (Set)object;
            return;
        }
        if (string == "otps") {
            this.otps = (Set)object;
            return;
        }
        if (string == "verificationDate") {
            this.verificationDate = (Date)object;
            return;
        }
        if (string == "oidcAuthorization") {
            this.oidcAuthorization = (Set)object;
            return;
        }
        if (string == "externalRedirectExecutions") {
            this.externalRedirectExecutions = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_sessions() {
        this._persistence_checkFetched("sessions");
        return this.sessions;
    }

    public void _persistence_set_sessions(Set set) {
        this._persistence_checkFetchedForSet("sessions");
        this._persistence_propertyChange("sessions", this.sessions, set);
        this.sessions = set;
    }

    public Boolean _persistence_get_enabledForSms() {
        this._persistence_checkFetched("enabledForSms");
        return this.enabledForSms;
    }

    public void _persistence_set_enabledForSms(Boolean bl) {
        this._persistence_checkFetchedForSet("enabledForSms");
        this._persistence_propertyChange("enabledForSms", this.enabledForSms, bl);
        this.enabledForSms = bl;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    public Set _persistence_get_userIdentityProviders() {
        this._persistence_checkFetched("userIdentityProviders");
        return this.userIdentityProviders;
    }

    public void _persistence_set_userIdentityProviders(Set set) {
        this._persistence_checkFetchedForSet("userIdentityProviders");
        this._persistence_propertyChange("userIdentityProviders", this.userIdentityProviders, set);
        this.userIdentityProviders = set;
    }

    public Set _persistence_get_otps() {
        this._persistence_checkFetched("otps");
        return this.otps;
    }

    public void _persistence_set_otps(Set set) {
        this._persistence_checkFetchedForSet("otps");
        this._persistence_propertyChange("otps", this.otps, set);
        this.otps = set;
    }

    public Date _persistence_get_verificationDate() {
        this._persistence_checkFetched("verificationDate");
        return this.verificationDate;
    }

    public void _persistence_set_verificationDate(Date date) {
        this._persistence_checkFetchedForSet("verificationDate");
        this._persistence_propertyChange("verificationDate", this.verificationDate, date);
        this.verificationDate = date;
    }

    public Set _persistence_get_oidcAuthorization() {
        this._persistence_checkFetched("oidcAuthorization");
        return this.oidcAuthorization;
    }

    public void _persistence_set_oidcAuthorization(Set set) {
        this._persistence_checkFetchedForSet("oidcAuthorization");
        this._persistence_propertyChange("oidcAuthorization", this.oidcAuthorization, set);
        this.oidcAuthorization = set;
    }

    public Set _persistence_get_externalRedirectExecutions() {
        this._persistence_checkFetched("externalRedirectExecutions");
        return this.externalRedirectExecutions;
    }

    public void _persistence_set_externalRedirectExecutions(Set set) {
        this._persistence_checkFetchedForSet("externalRedirectExecutions");
        this._persistence_propertyChange("externalRedirectExecutions", this.externalRedirectExecutions, set);
        this.externalRedirectExecutions = set;
    }
}

