/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedImage;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedStoredFile;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileStatus;
import org.cyclos.model.system.languages.ListSeparator;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="imported_files")
@DiscriminatorColumn(name="subclass")
public abstract class ImportedFile
extends BaseEntity
implements DefinesNetwork,
ImageOwner<ImportedFile, ImportedImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    protected Network network;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="channel_id", nullable=false)
    private Channel channel;
    @Basic
    @Lob
    @Column(name="description")
    private String description;
    @Basic
    @Column(name="process_automatically", nullable=false)
    protected boolean processAutomatically;
    @Basic
    @Column(name="permanent", nullable=false)
    protected boolean permanent;
    @OneToMany(mappedBy="importedFile")
    protected List<ImportedImage> images = new ArrayList<ImportedImage>();
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO
    @JoinColumn(name="by_user_id")
    protected User by;
    @OneToMany(mappedBy="importedFile", cascade={CascadeType.ALL})
    protected Set<ImportedStoredFile> storedFiles;
    @Basic
    @Column(name="creation_date")
    @ReadOnlyFromDTO
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @Basic
    @Column(name="processing_date")
    @ReadOnlyFromDTO
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date processingDate;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="list_separator")
    @ReadOnlyFromDTO
    protected ListSeparator listSeparator;
    @Basic
    @Column(name="file_name")
    protected String fileName;
    @OneToMany(mappedBy="importedFile", cascade={CascadeType.ALL})
    protected List<ImportedLine> lines = new ArrayList<ImportedLine>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    @ReadOnlyFromDTO
    protected ImportedFileStatus status;
    @Basic
    @Column(name="lines_ready")
    protected Integer linesReady;
    @Basic
    @Column(name="lines_validation_error")
    protected Integer linesValidationError;
    @Basic
    @Column(name="lines_skipped")
    protected Integer linesSkipped;
    @Basic
    @Column(name="lines_import_errors")
    @ReadOnlyFromDTO
    protected Integer linesImportError;
    @Basic
    @Column(name="lines_imported")
    @ReadOnlyFromDTO
    protected Integer linesImported;
    @Basic
    @Lob
    @Column(name="ignored_fields")
    protected String ignoredFields;
    @Basic
    @Lob
    @Column(name="error_message")
    protected String errorMessage;
    @OneToMany(mappedBy="importedFile", cascade={CascadeType.REMOVE})
    @OrderBy(value="index")
    protected List<ImportedField> fields = new ArrayList<ImportedField>();
    static final long serialVersionUID = -7291807888603938822L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_channel_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;

    public User getBy() {
        return this._persistence_get_by();
    }

    public Channel getChannel() {
        return this._persistence_get_channel();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public String getErrorMessage() {
        return this._persistence_get_errorMessage();
    }

    public ImportedField getField(ImportField importField) {
        return this.getField(importField.getName());
    }

    public ImportedField getField(ImportField importField, String string) {
        return this.getField(importField.getName(), string);
    }

    public ImportedField getField(String string) {
        return this.getField(string, null);
    }

    public ImportedField getField(String string, String string2) {
        for (ImportedField importedField : this._persistence_get_fields()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)importedField.getFieldName(), (CharSequence)string) || !StringUtils.equalsIgnoreCase((CharSequence)importedField.getFieldId(), (CharSequence)string2)) continue;
            return importedField;
        }
        return null;
    }

    public List<ImportedField> getFields() {
        return this._persistence_get_fields();
    }

    public String getFileName() {
        return this._persistence_get_fileName();
    }

    public List<String> getIgnoredFields() {
        return StringHelper.splitTrimming((String)this._persistence_get_ignoredFields(), (String)",");
    }

    @Override
    public ImportedImage getImage() {
        return (ImportedImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    @Override
    public List<ImportedImage> getImages() {
        return this._persistence_get_images();
    }

    public abstract ImportType getImportType();

    public Integer getLinesImported() {
        return this._persistence_get_linesImported();
    }

    public Integer getLinesImportError() {
        return this._persistence_get_linesImportError();
    }

    public Integer getLinesReady() {
        return this._persistence_get_linesReady();
    }

    public Integer getLinesSkipped() {
        return this._persistence_get_linesSkipped();
    }

    public Integer getLinesValidationError() {
        return this._persistence_get_linesValidationError();
    }

    public ListSeparator getListSeparator() {
        return this._persistence_get_listSeparator();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Date getProcessingDate() {
        return this._persistence_get_processingDate();
    }

    public ImportedFileStatus getStatus() {
        return this._persistence_get_status();
    }

    public ImportedStoredFile getStoredFile() {
        return (ImportedStoredFile)CollectionHelper.first((Iterable)this._persistence_get_storedFiles());
    }

    public boolean isPermanent() {
        return this._persistence_get_permanent();
    }

    public boolean isProcessAutomatically() {
        return this._persistence_get_processAutomatically();
    }

    public void setBy(User user) {
        this._persistence_set_by(user);
    }

    public void setChannel(Channel channel) {
        this._persistence_set_channel(channel);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setDescription(String string) {
        this._persistence_set_description(string);
    }

    public void setErrorMessage(String string) {
        this._persistence_set_errorMessage(string);
    }

    public void setFields(List<ImportedField> list) {
        this._persistence_set_fields(list);
    }

    public void setFileName(String string) {
        this._persistence_set_fileName(string);
    }

    public void setIgnoredFields(List<String> list) {
        this._persistence_set_ignoredFields(CollectionHelper.isEmpty(list) ? null : CollectionHelper.join(list, (String)","));
    }

    @Override
    public void setImage(ImportedImage importedImage) {
    }

    @Override
    public void setImages(List<ImportedImage> list) {
        this._persistence_set_images(list);
    }

    public void setLinesImported(Integer n) {
        this._persistence_set_linesImported(n);
    }

    public void setLinesImportError(Integer n) {
        this._persistence_set_linesImportError(n);
    }

    public void setLinesReady(Integer n) {
        this._persistence_set_linesReady(n);
    }

    public void setLinesSkipped(Integer n) {
        this._persistence_set_linesSkipped(n);
    }

    public void setLinesValidationError(Integer n) {
        this._persistence_set_linesValidationError(n);
    }

    public void setListSeparator(ListSeparator listSeparator) {
        this._persistence_set_listSeparator(listSeparator);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPermanent(boolean bl) {
        this._persistence_set_permanent(bl);
    }

    public void setProcessAutomatically(boolean bl) {
        this._persistence_set_processAutomatically(bl);
    }

    public void setProcessingDate(Date date) {
        this._persistence_set_processingDate(date);
    }

    public void setStatus(ImportedFileStatus importedFileStatus) {
        this._persistence_set_status(importedFileStatus);
    }

    public void setStoredFile(ImportedStoredFile importedStoredFile) {
        this._persistence_set_storedFiles(CollectionHelper.asSet((Object[])new ImportedStoredFile[]{importedStoredFile}));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_channel_vh != null) {
            this._persistence_channel_vh = (WeavedAttributeValueHolderInterface)this._persistence_channel_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ImportedFile();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "fileName") {
            return this.fileName;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "listSeparator") {
            return this.listSeparator;
        }
        if (string == "processingDate") {
            return this.processingDate;
        }
        if (string == "linesValidationError") {
            return this.linesValidationError;
        }
        if (string == "errorMessage") {
            return this.errorMessage;
        }
        if (string == "channel") {
            return this.channel;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "linesImported") {
            return this.linesImported;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "storedFiles") {
            return this.storedFiles;
        }
        if (string == "linesReady") {
            return this.linesReady;
        }
        if (string == "processAutomatically") {
            return this.processAutomatically;
        }
        if (string == "permanent") {
            return this.permanent;
        }
        if (string == "ignoredFields") {
            return this.ignoredFields;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "linesImportError") {
            return this.linesImportError;
        }
        if (string == "lines") {
            return this.lines;
        }
        if (string == "fields") {
            return this.fields;
        }
        if (string == "linesSkipped") {
            return this.linesSkipped;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "fileName") {
            this.fileName = (String)object;
            return;
        }
        if (string == "images") {
            this.images = (List)object;
            return;
        }
        if (string == "listSeparator") {
            this.listSeparator = (ListSeparator)object;
            return;
        }
        if (string == "processingDate") {
            this.processingDate = (Date)object;
            return;
        }
        if (string == "linesValidationError") {
            this.linesValidationError = (Integer)object;
            return;
        }
        if (string == "errorMessage") {
            this.errorMessage = (String)object;
            return;
        }
        if (string == "channel") {
            this.channel = (Channel)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "linesImported") {
            this.linesImported = (Integer)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "storedFiles") {
            this.storedFiles = (Set)object;
            return;
        }
        if (string == "linesReady") {
            this.linesReady = (Integer)object;
            return;
        }
        if (string == "processAutomatically") {
            this.processAutomatically = (Boolean)object;
            return;
        }
        if (string == "permanent") {
            this.permanent = (Boolean)object;
            return;
        }
        if (string == "ignoredFields") {
            this.ignoredFields = (String)object;
            return;
        }
        if (string == "by") {
            this.by = (User)object;
            return;
        }
        if (string == "linesImportError") {
            this.linesImportError = (Integer)object;
            return;
        }
        if (string == "lines") {
            this.lines = (List)object;
            return;
        }
        if (string == "fields") {
            this.fields = (List)object;
            return;
        }
        if (string == "linesSkipped") {
            this.linesSkipped = (Integer)object;
            return;
        }
        if (string == "status") {
            this.status = (ImportedFileStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_fileName() {
        this._persistence_checkFetched("fileName");
        return this.fileName;
    }

    public void _persistence_set_fileName(String string) {
        this._persistence_checkFetchedForSet("fileName");
        this._persistence_propertyChange("fileName", this.fileName, string);
        this.fileName = string;
    }

    public List _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(List list) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, list);
        this.images = list;
    }

    public ListSeparator _persistence_get_listSeparator() {
        this._persistence_checkFetched("listSeparator");
        return this.listSeparator;
    }

    public void _persistence_set_listSeparator(ListSeparator listSeparator) {
        this._persistence_checkFetchedForSet("listSeparator");
        this._persistence_propertyChange("listSeparator", this.listSeparator, listSeparator);
        this.listSeparator = listSeparator;
    }

    public Date _persistence_get_processingDate() {
        this._persistence_checkFetched("processingDate");
        return this.processingDate;
    }

    public void _persistence_set_processingDate(Date date) {
        this._persistence_checkFetchedForSet("processingDate");
        this._persistence_propertyChange("processingDate", this.processingDate, date);
        this.processingDate = date;
    }

    public Integer _persistence_get_linesValidationError() {
        this._persistence_checkFetched("linesValidationError");
        return this.linesValidationError;
    }

    public void _persistence_set_linesValidationError(Integer n) {
        this._persistence_checkFetchedForSet("linesValidationError");
        this._persistence_propertyChange("linesValidationError", this.linesValidationError, n);
        this.linesValidationError = n;
    }

    public String _persistence_get_errorMessage() {
        this._persistence_checkFetched("errorMessage");
        return this.errorMessage;
    }

    public void _persistence_set_errorMessage(String string) {
        this._persistence_checkFetchedForSet("errorMessage");
        this._persistence_propertyChange("errorMessage", this.errorMessage, string);
        this.errorMessage = string;
    }

    protected void _persistence_initialize_channel_vh() {
        if (this._persistence_channel_vh == null) {
            this._persistence_channel_vh = new ValueHolder((Object)this.channel);
            this._persistence_channel_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_channel_vh() {
        Channel channel;
        this._persistence_initialize_channel_vh();
        if ((this._persistence_channel_vh.isCoordinatedWithProperty() || this._persistence_channel_vh.isNewlyWeavedValueHolder()) && (channel = this._persistence_get_channel()) != this._persistence_channel_vh.getValue()) {
            this._persistence_set_channel(channel);
        }
        return this._persistence_channel_vh;
    }

    public void _persistence_set_channel_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_channel_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Channel channel = this._persistence_get_channel();
            if (channel != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_channel((Channel)object);
            }
        } else {
            this.channel = null;
        }
    }

    public Channel _persistence_get_channel() {
        this._persistence_checkFetched("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        return this.channel;
    }

    public void _persistence_set_channel(Channel channel) {
        this._persistence_checkFetchedForSet("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        this._persistence_propertyChange("channel", this.channel, channel);
        this.channel = channel;
        this._persistence_channel_vh.setValue((Object)channel);
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Integer _persistence_get_linesImported() {
        this._persistence_checkFetched("linesImported");
        return this.linesImported;
    }

    public void _persistence_set_linesImported(Integer n) {
        this._persistence_checkFetchedForSet("linesImported");
        this._persistence_propertyChange("linesImported", this.linesImported, n);
        this.linesImported = n;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_storedFiles() {
        this._persistence_checkFetched("storedFiles");
        return this.storedFiles;
    }

    public void _persistence_set_storedFiles(Set set) {
        this._persistence_checkFetchedForSet("storedFiles");
        this._persistence_propertyChange("storedFiles", this.storedFiles, set);
        this.storedFiles = set;
    }

    public Integer _persistence_get_linesReady() {
        this._persistence_checkFetched("linesReady");
        return this.linesReady;
    }

    public void _persistence_set_linesReady(Integer n) {
        this._persistence_checkFetchedForSet("linesReady");
        this._persistence_propertyChange("linesReady", this.linesReady, n);
        this.linesReady = n;
    }

    public boolean _persistence_get_processAutomatically() {
        this._persistence_checkFetched("processAutomatically");
        return this.processAutomatically;
    }

    public void _persistence_set_processAutomatically(boolean bl) {
        this._persistence_checkFetchedForSet("processAutomatically");
        this._persistence_propertyChange("processAutomatically", new Boolean(this.processAutomatically), new Boolean(bl));
        this.processAutomatically = bl;
    }

    public boolean _persistence_get_permanent() {
        this._persistence_checkFetched("permanent");
        return this.permanent;
    }

    public void _persistence_set_permanent(boolean bl) {
        this._persistence_checkFetchedForSet("permanent");
        this._persistence_propertyChange("permanent", new Boolean(this.permanent), new Boolean(bl));
        this.permanent = bl;
    }

    public String _persistence_get_ignoredFields() {
        this._persistence_checkFetched("ignoredFields");
        return this.ignoredFields;
    }

    public void _persistence_set_ignoredFields(String string) {
        this._persistence_checkFetchedForSet("ignoredFields");
        this._persistence_propertyChange("ignoredFields", this.ignoredFields, string);
        this.ignoredFields = string;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        User user;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(user);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_by();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((User)object);
            }
        } else {
            this.by = null;
        }
    }

    public User _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (User)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(User user) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (User)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, user);
        this.by = user;
        this._persistence_by_vh.setValue((Object)user);
    }

    public Integer _persistence_get_linesImportError() {
        this._persistence_checkFetched("linesImportError");
        return this.linesImportError;
    }

    public void _persistence_set_linesImportError(Integer n) {
        this._persistence_checkFetchedForSet("linesImportError");
        this._persistence_propertyChange("linesImportError", this.linesImportError, n);
        this.linesImportError = n;
    }

    public List _persistence_get_lines() {
        this._persistence_checkFetched("lines");
        return this.lines;
    }

    public void _persistence_set_lines(List list) {
        this._persistence_checkFetchedForSet("lines");
        this._persistence_propertyChange("lines", this.lines, list);
        this.lines = list;
    }

    public List _persistence_get_fields() {
        this._persistence_checkFetched("fields");
        return this.fields;
    }

    public void _persistence_set_fields(List list) {
        this._persistence_checkFetchedForSet("fields");
        this._persistence_propertyChange("fields", this.fields, list);
        this.fields = list;
    }

    public Integer _persistence_get_linesSkipped() {
        this._persistence_checkFetched("linesSkipped");
        return this.linesSkipped;
    }

    public void _persistence_set_linesSkipped(Integer n) {
        this._persistence_checkFetchedForSet("linesSkipped");
        this._persistence_propertyChange("linesSkipped", this.linesSkipped, n);
        this.linesSkipped = n;
    }

    public ImportedFileStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(ImportedFileStatus importedFileStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, importedFileStatus);
        this.status = importedFileStatus;
    }
}

