/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.cyclos.entities.system.BaseCustomTask;
import org.cyclos.entities.utils.BackgroundTaskExecution;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="custom_background_tasks")
public class CustomBackgroundTask
extends BaseCustomTask
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="verbose_log")
    private Boolean verboseLog;
    @OneToMany(mappedBy="custom", cascade={CascadeType.REMOVE})
    private Set<BackgroundTaskExecution> executions;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="priority", nullable=false)
    private BackgroundTaskPriority priority;
    static final long serialVersionUID = 7495638491722972157L;

    public BackgroundTaskPriority getPriority() {
        return this._persistence_get_priority();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.BACKGROUND_TASK;
    }

    public boolean isVerboseLog() {
        return Boolean.TRUE.equals(this._persistence_get_verboseLog());
    }

    public void setPriority(BackgroundTaskPriority backgroundTaskPriority) {
        this._persistence_set_priority(backgroundTaskPriority);
    }

    public void setVerboseLog(boolean bl) {
        this._persistence_set_verboseLog(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomBackgroundTask();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "verboseLog") {
            return this.verboseLog;
        }
        if (string == "executions") {
            return this.executions;
        }
        if (string == "priority") {
            return this.priority;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "verboseLog") {
            this.verboseLog = (Boolean)object;
            return;
        }
        if (string == "executions") {
            this.executions = (Set)object;
            return;
        }
        if (string == "priority") {
            this.priority = (BackgroundTaskPriority)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_verboseLog() {
        this._persistence_checkFetched("verboseLog");
        return this.verboseLog;
    }

    public void _persistence_set_verboseLog(Boolean bl) {
        this._persistence_checkFetchedForSet("verboseLog");
        this._persistence_propertyChange("verboseLog", this.verboseLog, bl);
        this.verboseLog = bl;
    }

    public Set _persistence_get_executions() {
        this._persistence_checkFetched("executions");
        return this.executions;
    }

    public void _persistence_set_executions(Set set) {
        this._persistence_checkFetchedForSet("executions");
        this._persistence_propertyChange("executions", this.executions, set);
        this.executions = set;
    }

    public BackgroundTaskPriority _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(BackgroundTaskPriority backgroundTaskPriority) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", this.priority, backgroundTaskPriority);
        this.priority = backgroundTaskPriority;
    }
}

