/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.system.channelconfigurations.RegistrationWithIdentityProviders;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorColumn(name="subclass")
@DiscriminatorValue(value="DEFAULT")
@Cacheable(value=true)
@Table(name="channel_configurations", uniqueConstraints={@UniqueConstraint(columnNames={"channel_id", "configuration_id"})})
public class ChannelConfiguration
extends BaseEntity
implements ChannelSettingsAccessor,
ChannelAccessAccessor,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="channel_id", updatable=false, nullable=false)
    private Channel channel;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="configuration_id", updatable=false, nullable=false)
    private Configuration configuration;
    @Basic
    @Column(name="defined", nullable=false)
    private boolean defined;
    @Basic
    @Column(name="locked", nullable=false)
    private boolean locked;
    @Basic
    @Column(name="enabled", nullable=false)
    private boolean enabled;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_access")
    private UserChannelAccess userAccess;
    @Basic
    @Column(name="allow_login", nullable=false)
    private boolean allowLogin;
    @ManyToMany
    @JoinTable(name="channels_principal_types", joinColumns={@JoinColumn(name="channel_configuration_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})
    private Set<PrincipalType> principalTypes = new HashSet<PrincipalType>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="default_principal_type_id")
    private PrincipalType defaultPrincipalType;
    @ManyToMany
    @JoinTable(name="channels_principals_allowing_qr_code", joinColumns={@JoinColumn(name="channel_configuration_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})
    private Set<PrincipalType> principalTypesAllowingQrCode = new HashSet<PrincipalType>();
    @ManyToMany
    @JoinTable(name="channel_configurations_identity_providers", joinColumns={@JoinColumn(name="channel_configuration_id")}, inverseJoinColumns={@JoinColumn(name="identity_provider_id")})
    private Set<IdentityProvider> identityProviders = new HashSet<IdentityProvider>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="reg_with_id_providers")
    private RegistrationWithIdentityProviders registrationWithIdentityProviders;
    @Basic
    @Column(name="require_trusted_device_for_login")
    private boolean requireTrustedDeviceForLogin;
    @Basic
    @Column(name="trusted_device_on_startup")
    private Integer trustedDeviceOnStartup;
    @Basic
    @Column(name="require_authentication_for_device_confirmation")
    private boolean requireAuthenticationForDeviceConfirmation;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="session_timeout_amount")), @AttributeOverride(name="field", column=@Column(name="session_timeout_field"))})
    private TimeInterval sessionTimeout;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="whitelist_id")
    private InternetAddressList whitelist;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scanQrCode", column=@Column(name="payment_scan_qr_code")), @AttributeOverride(name="autocomplete", column=@Column(name="payment_autocomplete")), @AttributeOverride(name="contacts", column=@Column(name="payment_contacts")), @AttributeOverride(name="defaultIdMethod", column=@Column(name="payment_default_id_method"))})
    @AssociationOverrides(value={@AssociationOverride(name="principalTypes", joinTable=@JoinTable(name="channels_payment_principal_types", joinColumns={@JoinColumn(name="channel_configuration_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})), @AssociationOverride(name="defaultPrincipalType", joinColumns={@JoinColumn(name="payment_default_principal_type_id")})})
    private PaymentPrincipalsConfiguration payment = new PaymentPrincipalsConfiguration();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scanQrCode", column=@Column(name="pos_scan_qr_code")), @AttributeOverride(name="autocomplete", column=@Column(name="pos_autocomplete")), @AttributeOverride(name="contacts", column=@Column(name="pos_contacts")), @AttributeOverride(name="defaultIdMethod", column=@Column(name="pos_default_id_method"))})
    @AssociationOverrides(value={@AssociationOverride(name="principalTypes", joinTable=@JoinTable(name="channels_pos_principal_types", joinColumns={@JoinColumn(name="channel_configuration_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})), @AssociationOverride(name="defaultPrincipalType", joinColumns={@JoinColumn(name="pos_default_principal_type_id")})})
    private PaymentPrincipalsConfiguration pos = new PaymentPrincipalsConfiguration();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="access_password_id")
    private PasswordType accessPassword;
    @Embedded
    private PinChannelConfiguration pinConfiguration = new PinChannelConfiguration();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="device", column=@Column(name="login_confirmation_device")), @AttributeOverride(name="totp", column=@Column(name="login_confirmation_totp"))})
    @AssociationOverrides(value={@AssociationOverride(name="password", joinColumns={@JoinColumn(name="login_confirmation_password_id")})})
    private CredentialsConfiguration loginConfirmation = new CredentialsConfiguration();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="device", column=@Column(name="confirmation_device")), @AttributeOverride(name="totp", column=@Column(name="confirmation_totp"))})
    @AssociationOverrides(value={@AssociationOverride(name="password", joinColumns={@JoinColumn(name="confirmation_password_id")})})
    private CredentialsConfiguration confirmation = new CredentialsConfiguration();
    @Basic
    @Column(name="confirmation_once_per_session")
    private Boolean confirmationOncePerSession;
    @Basic
    @Column(name="skip_confirmation_for_trusted_devices")
    private Boolean skipConfirmationForTrustedDevices;
    @Transient
    private boolean canBeDefined = true;
    static final long serialVersionUID = -4841214817418047364L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_configuration_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_channel_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accessPassword_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_whitelist_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_defaultPrincipalType_vh;

    @Override
    public PasswordType getAccessPassword() {
        return this._persistence_get_accessPassword();
    }

    @Override
    public Channel getChannel() {
        return this._persistence_get_channel();
    }

    public Configuration getConfiguration() {
        return this._persistence_get_configuration();
    }

    @Override
    public CredentialsConfiguration getConfirmation() {
        return (CredentialsConfiguration)ObjectHelper.defaultValue((Object)this._persistence_get_confirmation(), CredentialsConfiguration::new);
    }

    @Override
    public PrincipalType getDefaultPrincipalType() {
        return this._persistence_get_defaultPrincipalType();
    }

    @Override
    public Set<IdentityProvider> getIdentityProviders() {
        return this._persistence_get_identityProviders();
    }

    public String getIpWhitelist() {
        return this._persistence_get_whitelist() == null ? null : this._persistence_get_whitelist().getAddresses();
    }

    @Override
    public CredentialsConfiguration getLoginConfirmation() {
        return (CredentialsConfiguration)ObjectHelper.defaultValue((Object)this._persistence_get_loginConfirmation(), CredentialsConfiguration::new);
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_configuration().getNetwork();
    }

    @Override
    public PaymentPrincipalsConfiguration getPayment() {
        return this._persistence_get_payment();
    }

    @Override
    public PinChannelConfiguration getPinConfiguration() {
        return this._persistence_get_pinConfiguration();
    }

    @Override
    public PaymentPrincipalsConfiguration getPos() {
        return this._persistence_get_pos();
    }

    @Override
    public Set<PrincipalType> getPrincipalTypes() {
        return this._persistence_get_principalTypes();
    }

    @Override
    public Set<PrincipalType> getPrincipalTypesAllowingQrCode() {
        return this._persistence_get_principalTypesAllowingQrCode();
    }

    @Override
    public RegistrationWithIdentityProviders getRegistrationWithIdentityProviders() {
        return (RegistrationWithIdentityProviders)ObjectHelper.defaultValue((Object)this._persistence_get_registrationWithIdentityProviders(), (Object)RegistrationWithIdentityProviders.DISABLED);
    }

    @Override
    public TimeInterval getSessionTimeout() {
        return this._persistence_get_sessionTimeout();
    }

    @Override
    public Integer getTrustedDeviceOnStartup() {
        return this._persistence_get_trustedDeviceOnStartup();
    }

    @Override
    public UserChannelAccess getUserAccess() {
        return this._persistence_get_userAccess();
    }

    @Override
    public InternetAddressList getWhitelist() {
        return this._persistence_get_whitelist();
    }

    public boolean isAllowLogin() {
        return this._persistence_get_allowLogin();
    }

    public boolean isCanBeDefined() {
        return this.canBeDefined;
    }

    @Override
    public boolean isConfirmationOncePerSession() {
        return Boolean.TRUE.equals(this._persistence_get_confirmationOncePerSession());
    }

    public boolean isDefined() {
        return this._persistence_get_defined();
    }

    public boolean isEnabled() {
        return this._persistence_get_enabled();
    }

    public boolean isLocked() {
        return this._persistence_get_locked();
    }

    @Override
    public boolean isRequireAuthenticationForDeviceConfirmation() {
        return this._persistence_get_requireAuthenticationForDeviceConfirmation();
    }

    @Override
    public boolean isRequireTrustedDeviceForLogin() {
        return this._persistence_get_requireTrustedDeviceForLogin();
    }

    @Override
    public boolean isSkipConfirmationForTrustedDevices() {
        return Boolean.TRUE.equals(this._persistence_get_skipConfirmationForTrustedDevices());
    }

    @Override
    public boolean isUseIpWhitelist() {
        return this._persistence_get_whitelist() != null;
    }

    public void setAccessPassword(PasswordType passwordType) {
        this._persistence_set_accessPassword(passwordType);
    }

    public void setAllowLogin(boolean bl) {
        this._persistence_set_allowLogin(bl);
    }

    public void setCanBeDefined(boolean bl) {
        this.canBeDefined = bl;
    }

    public void setChannel(Channel channel) {
        this._persistence_set_channel(channel);
    }

    public void setConfiguration(Configuration configuration) {
        this._persistence_set_configuration(configuration);
    }

    public void setConfirmation(CredentialsConfiguration credentialsConfiguration) {
        this._persistence_set_confirmation(credentialsConfiguration);
    }

    public void setConfirmationOncePerSession(boolean bl) {
        this._persistence_set_confirmationOncePerSession(bl);
    }

    public void setDefaultPrincipalType(PrincipalType principalType) {
        this._persistence_set_defaultPrincipalType(principalType);
    }

    public void setDefined(boolean bl) {
        this._persistence_set_defined(bl);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setIdentityProviders(Set<IdentityProvider> set) {
        this._persistence_set_identityProviders(set);
    }

    public void setLocked(boolean bl) {
        this._persistence_set_locked(bl);
    }

    public void setLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        this._persistence_set_loginConfirmation(credentialsConfiguration);
    }

    public void setPayment(PaymentPrincipalsConfiguration paymentPrincipalsConfiguration) {
        this._persistence_set_payment(paymentPrincipalsConfiguration);
    }

    public void setPinConfiguration(PinChannelConfiguration pinChannelConfiguration) {
        this._persistence_set_pinConfiguration((PinChannelConfiguration)ObjectHelper.defaultValue((Object)pinChannelConfiguration, (Object)new PinChannelConfiguration()));
    }

    public void setPos(PaymentPrincipalsConfiguration paymentPrincipalsConfiguration) {
        this._persistence_set_pos(paymentPrincipalsConfiguration);
    }

    public void setPrincipalTypes(Set<PrincipalType> set) {
        this._persistence_set_principalTypes(set);
    }

    public void setPrincipalTypesAllowingQrCode(Set<PrincipalType> set) {
        this._persistence_set_principalTypesAllowingQrCode(set);
    }

    public void setRegistrationWithIdentityProviders(RegistrationWithIdentityProviders registrationWithIdentityProviders) {
        this._persistence_set_registrationWithIdentityProviders(registrationWithIdentityProviders);
    }

    public void setRequireAuthenticationForDeviceConfirmation(boolean bl) {
        this._persistence_set_requireAuthenticationForDeviceConfirmation(bl);
    }

    public void setRequireTrustedDeviceForLogin(boolean bl) {
        this._persistence_set_requireTrustedDeviceForLogin(bl);
    }

    public void setSessionTimeout(TimeInterval timeInterval) {
        this._persistence_set_sessionTimeout(timeInterval);
    }

    public void setSkipConfirmationForTrustedDevices(boolean bl) {
        this._persistence_set_skipConfirmationForTrustedDevices(bl);
    }

    public void setTrustedDeviceOnStartup(Integer n) {
        this._persistence_set_trustedDeviceOnStartup(n);
    }

    public void setUserAccess(UserChannelAccess userChannelAccess) {
        this._persistence_set_userAccess(userChannelAccess);
    }

    public void setWhitelist(InternetAddressList internetAddressList) {
        this._persistence_set_whitelist(internetAddressList);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_configuration_vh != null) {
            this._persistence_configuration_vh = (WeavedAttributeValueHolderInterface)this._persistence_configuration_vh.clone();
        }
        if (this._persistence_channel_vh != null) {
            this._persistence_channel_vh = (WeavedAttributeValueHolderInterface)this._persistence_channel_vh.clone();
        }
        if (this._persistence_accessPassword_vh != null) {
            this._persistence_accessPassword_vh = (WeavedAttributeValueHolderInterface)this._persistence_accessPassword_vh.clone();
        }
        if (this._persistence_whitelist_vh != null) {
            this._persistence_whitelist_vh = (WeavedAttributeValueHolderInterface)this._persistence_whitelist_vh.clone();
        }
        if (this._persistence_defaultPrincipalType_vh != null) {
            this._persistence_defaultPrincipalType_vh = (WeavedAttributeValueHolderInterface)this._persistence_defaultPrincipalType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ChannelConfiguration();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "registrationWithIdentityProviders") {
            return this.registrationWithIdentityProviders;
        }
        if (string == "configuration") {
            return this.configuration;
        }
        if (string == "principalTypesAllowingQrCode") {
            return this.principalTypesAllowingQrCode;
        }
        if (string == "channel") {
            return this.channel;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "pinConfiguration") {
            return this.pinConfiguration;
        }
        if (string == "pos") {
            return this.pos;
        }
        if (string == "allowLogin") {
            return this.allowLogin;
        }
        if (string == "payment") {
            return this.payment;
        }
        if (string == "locked") {
            return this.locked;
        }
        if (string == "requireAuthenticationForDeviceConfirmation") {
            return this.requireAuthenticationForDeviceConfirmation;
        }
        if (string == "accessPassword") {
            return this.accessPassword;
        }
        if (string == "defined") {
            return this.defined;
        }
        if (string == "loginConfirmation") {
            return this.loginConfirmation;
        }
        if (string == "identityProviders") {
            return this.identityProviders;
        }
        if (string == "skipConfirmationForTrustedDevices") {
            return this.skipConfirmationForTrustedDevices;
        }
        if (string == "whitelist") {
            return this.whitelist;
        }
        if (string == "confirmation") {
            return this.confirmation;
        }
        if (string == "principalTypes") {
            return this.principalTypes;
        }
        if (string == "userAccess") {
            return this.userAccess;
        }
        if (string == "trustedDeviceOnStartup") {
            return this.trustedDeviceOnStartup;
        }
        if (string == "defaultPrincipalType") {
            return this.defaultPrincipalType;
        }
        if (string == "sessionTimeout") {
            return this.sessionTimeout;
        }
        if (string == "confirmationOncePerSession") {
            return this.confirmationOncePerSession;
        }
        if (string == "requireTrustedDeviceForLogin") {
            return this.requireTrustedDeviceForLogin;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "registrationWithIdentityProviders") {
            this.registrationWithIdentityProviders = (RegistrationWithIdentityProviders)object;
            return;
        }
        if (string == "configuration") {
            this.configuration = (Configuration)object;
            return;
        }
        if (string == "principalTypesAllowingQrCode") {
            this.principalTypesAllowingQrCode = (Set)object;
            return;
        }
        if (string == "channel") {
            this.channel = (Channel)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "pinConfiguration") {
            this.pinConfiguration = (PinChannelConfiguration)object;
            return;
        }
        if (string == "pos") {
            this.pos = (PaymentPrincipalsConfiguration)object;
            return;
        }
        if (string == "allowLogin") {
            this.allowLogin = (Boolean)object;
            return;
        }
        if (string == "payment") {
            this.payment = (PaymentPrincipalsConfiguration)object;
            return;
        }
        if (string == "locked") {
            this.locked = (Boolean)object;
            return;
        }
        if (string == "requireAuthenticationForDeviceConfirmation") {
            this.requireAuthenticationForDeviceConfirmation = (Boolean)object;
            return;
        }
        if (string == "accessPassword") {
            this.accessPassword = (PasswordType)object;
            return;
        }
        if (string == "defined") {
            this.defined = (Boolean)object;
            return;
        }
        if (string == "loginConfirmation") {
            this.loginConfirmation = (CredentialsConfiguration)object;
            return;
        }
        if (string == "identityProviders") {
            this.identityProviders = (Set)object;
            return;
        }
        if (string == "skipConfirmationForTrustedDevices") {
            this.skipConfirmationForTrustedDevices = (Boolean)object;
            return;
        }
        if (string == "whitelist") {
            this.whitelist = (InternetAddressList)object;
            return;
        }
        if (string == "confirmation") {
            this.confirmation = (CredentialsConfiguration)object;
            return;
        }
        if (string == "principalTypes") {
            this.principalTypes = (Set)object;
            return;
        }
        if (string == "userAccess") {
            this.userAccess = (UserChannelAccess)object;
            return;
        }
        if (string == "trustedDeviceOnStartup") {
            this.trustedDeviceOnStartup = (Integer)object;
            return;
        }
        if (string == "defaultPrincipalType") {
            this.defaultPrincipalType = (PrincipalType)object;
            return;
        }
        if (string == "sessionTimeout") {
            this.sessionTimeout = (TimeInterval)object;
            return;
        }
        if (string == "confirmationOncePerSession") {
            this.confirmationOncePerSession = (Boolean)object;
            return;
        }
        if (string == "requireTrustedDeviceForLogin") {
            this.requireTrustedDeviceForLogin = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public RegistrationWithIdentityProviders _persistence_get_registrationWithIdentityProviders() {
        this._persistence_checkFetched("registrationWithIdentityProviders");
        return this.registrationWithIdentityProviders;
    }

    public void _persistence_set_registrationWithIdentityProviders(RegistrationWithIdentityProviders registrationWithIdentityProviders) {
        this._persistence_checkFetchedForSet("registrationWithIdentityProviders");
        this._persistence_propertyChange("registrationWithIdentityProviders", this.registrationWithIdentityProviders, registrationWithIdentityProviders);
        this.registrationWithIdentityProviders = registrationWithIdentityProviders;
    }

    protected void _persistence_initialize_configuration_vh() {
        if (this._persistence_configuration_vh == null) {
            this._persistence_configuration_vh = new ValueHolder((Object)this.configuration);
            this._persistence_configuration_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_configuration_vh() {
        Configuration configuration;
        this._persistence_initialize_configuration_vh();
        if ((this._persistence_configuration_vh.isCoordinatedWithProperty() || this._persistence_configuration_vh.isNewlyWeavedValueHolder()) && (configuration = this._persistence_get_configuration()) != this._persistence_configuration_vh.getValue()) {
            this._persistence_set_configuration(configuration);
        }
        return this._persistence_configuration_vh;
    }

    public void _persistence_set_configuration_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_configuration_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Configuration configuration = this._persistence_get_configuration();
            if (configuration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_configuration((Configuration)object);
            }
        } else {
            this.configuration = null;
        }
    }

    public Configuration _persistence_get_configuration() {
        this._persistence_checkFetched("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        return this.configuration;
    }

    public void _persistence_set_configuration(Configuration configuration) {
        this._persistence_checkFetchedForSet("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        this._persistence_propertyChange("configuration", this.configuration, configuration);
        this.configuration = configuration;
        this._persistence_configuration_vh.setValue((Object)configuration);
    }

    public Set _persistence_get_principalTypesAllowingQrCode() {
        this._persistence_checkFetched("principalTypesAllowingQrCode");
        return this.principalTypesAllowingQrCode;
    }

    public void _persistence_set_principalTypesAllowingQrCode(Set set) {
        this._persistence_checkFetchedForSet("principalTypesAllowingQrCode");
        this._persistence_propertyChange("principalTypesAllowingQrCode", this.principalTypesAllowingQrCode, set);
        this.principalTypesAllowingQrCode = set;
    }

    protected void _persistence_initialize_channel_vh() {
        if (this._persistence_channel_vh == null) {
            this._persistence_channel_vh = new ValueHolder((Object)this.channel);
            this._persistence_channel_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_channel_vh() {
        Channel channel;
        this._persistence_initialize_channel_vh();
        if ((this._persistence_channel_vh.isCoordinatedWithProperty() || this._persistence_channel_vh.isNewlyWeavedValueHolder()) && (channel = this._persistence_get_channel()) != this._persistence_channel_vh.getValue()) {
            this._persistence_set_channel(channel);
        }
        return this._persistence_channel_vh;
    }

    public void _persistence_set_channel_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_channel_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Channel channel = this._persistence_get_channel();
            if (channel != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_channel((Channel)object);
            }
        } else {
            this.channel = null;
        }
    }

    public Channel _persistence_get_channel() {
        this._persistence_checkFetched("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        return this.channel;
    }

    public void _persistence_set_channel(Channel channel) {
        this._persistence_checkFetchedForSet("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        this._persistence_propertyChange("channel", this.channel, channel);
        this.channel = channel;
        this._persistence_channel_vh.setValue((Object)channel);
    }

    public boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", new Boolean(this.enabled), new Boolean(bl));
        this.enabled = bl;
    }

    public PinChannelConfiguration _persistence_get_pinConfiguration() {
        this._persistence_checkFetched("pinConfiguration");
        return this.pinConfiguration;
    }

    public void _persistence_set_pinConfiguration(PinChannelConfiguration pinChannelConfiguration) {
        this._persistence_checkFetchedForSet("pinConfiguration");
        this._persistence_propertyChange("pinConfiguration", this.pinConfiguration, pinChannelConfiguration);
        this.pinConfiguration = pinChannelConfiguration;
    }

    public PaymentPrincipalsConfiguration _persistence_get_pos() {
        this._persistence_checkFetched("pos");
        return this.pos;
    }

    public void _persistence_set_pos(PaymentPrincipalsConfiguration paymentPrincipalsConfiguration) {
        this._persistence_checkFetchedForSet("pos");
        this._persistence_propertyChange("pos", this.pos, paymentPrincipalsConfiguration);
        this.pos = paymentPrincipalsConfiguration;
    }

    public boolean _persistence_get_allowLogin() {
        this._persistence_checkFetched("allowLogin");
        return this.allowLogin;
    }

    public void _persistence_set_allowLogin(boolean bl) {
        this._persistence_checkFetchedForSet("allowLogin");
        this._persistence_propertyChange("allowLogin", new Boolean(this.allowLogin), new Boolean(bl));
        this.allowLogin = bl;
    }

    public PaymentPrincipalsConfiguration _persistence_get_payment() {
        this._persistence_checkFetched("payment");
        return this.payment;
    }

    public void _persistence_set_payment(PaymentPrincipalsConfiguration paymentPrincipalsConfiguration) {
        this._persistence_checkFetchedForSet("payment");
        this._persistence_propertyChange("payment", this.payment, paymentPrincipalsConfiguration);
        this.payment = paymentPrincipalsConfiguration;
    }

    public boolean _persistence_get_locked() {
        this._persistence_checkFetched("locked");
        return this.locked;
    }

    public void _persistence_set_locked(boolean bl) {
        this._persistence_checkFetchedForSet("locked");
        this._persistence_propertyChange("locked", new Boolean(this.locked), new Boolean(bl));
        this.locked = bl;
    }

    public boolean _persistence_get_requireAuthenticationForDeviceConfirmation() {
        this._persistence_checkFetched("requireAuthenticationForDeviceConfirmation");
        return this.requireAuthenticationForDeviceConfirmation;
    }

    public void _persistence_set_requireAuthenticationForDeviceConfirmation(boolean bl) {
        this._persistence_checkFetchedForSet("requireAuthenticationForDeviceConfirmation");
        this._persistence_propertyChange("requireAuthenticationForDeviceConfirmation", new Boolean(this.requireAuthenticationForDeviceConfirmation), new Boolean(bl));
        this.requireAuthenticationForDeviceConfirmation = bl;
    }

    protected void _persistence_initialize_accessPassword_vh() {
        if (this._persistence_accessPassword_vh == null) {
            this._persistence_accessPassword_vh = new ValueHolder((Object)this.accessPassword);
            this._persistence_accessPassword_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accessPassword_vh() {
        PasswordType passwordType;
        this._persistence_initialize_accessPassword_vh();
        if ((this._persistence_accessPassword_vh.isCoordinatedWithProperty() || this._persistence_accessPassword_vh.isNewlyWeavedValueHolder()) && (passwordType = this._persistence_get_accessPassword()) != this._persistence_accessPassword_vh.getValue()) {
            this._persistence_set_accessPassword(passwordType);
        }
        return this._persistence_accessPassword_vh;
    }

    public void _persistence_set_accessPassword_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accessPassword_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PasswordType passwordType = this._persistence_get_accessPassword();
            if (passwordType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accessPassword((PasswordType)object);
            }
        } else {
            this.accessPassword = null;
        }
    }

    public PasswordType _persistence_get_accessPassword() {
        this._persistence_checkFetched("accessPassword");
        this._persistence_initialize_accessPassword_vh();
        this.accessPassword = (PasswordType)this._persistence_accessPassword_vh.getValue();
        return this.accessPassword;
    }

    public void _persistence_set_accessPassword(PasswordType passwordType) {
        this._persistence_checkFetchedForSet("accessPassword");
        this._persistence_initialize_accessPassword_vh();
        this.accessPassword = (PasswordType)this._persistence_accessPassword_vh.getValue();
        this._persistence_propertyChange("accessPassword", this.accessPassword, passwordType);
        this.accessPassword = passwordType;
        this._persistence_accessPassword_vh.setValue((Object)passwordType);
    }

    public boolean _persistence_get_defined() {
        this._persistence_checkFetched("defined");
        return this.defined;
    }

    public void _persistence_set_defined(boolean bl) {
        this._persistence_checkFetchedForSet("defined");
        this._persistence_propertyChange("defined", new Boolean(this.defined), new Boolean(bl));
        this.defined = bl;
    }

    public CredentialsConfiguration _persistence_get_loginConfirmation() {
        this._persistence_checkFetched("loginConfirmation");
        return this.loginConfirmation;
    }

    public void _persistence_set_loginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        this._persistence_checkFetchedForSet("loginConfirmation");
        this._persistence_propertyChange("loginConfirmation", this.loginConfirmation, credentialsConfiguration);
        this.loginConfirmation = credentialsConfiguration;
    }

    public Set _persistence_get_identityProviders() {
        this._persistence_checkFetched("identityProviders");
        return this.identityProviders;
    }

    public void _persistence_set_identityProviders(Set set) {
        this._persistence_checkFetchedForSet("identityProviders");
        this._persistence_propertyChange("identityProviders", this.identityProviders, set);
        this.identityProviders = set;
    }

    public Boolean _persistence_get_skipConfirmationForTrustedDevices() {
        this._persistence_checkFetched("skipConfirmationForTrustedDevices");
        return this.skipConfirmationForTrustedDevices;
    }

    public void _persistence_set_skipConfirmationForTrustedDevices(Boolean bl) {
        this._persistence_checkFetchedForSet("skipConfirmationForTrustedDevices");
        this._persistence_propertyChange("skipConfirmationForTrustedDevices", this.skipConfirmationForTrustedDevices, bl);
        this.skipConfirmationForTrustedDevices = bl;
    }

    protected void _persistence_initialize_whitelist_vh() {
        if (this._persistence_whitelist_vh == null) {
            this._persistence_whitelist_vh = new ValueHolder((Object)this.whitelist);
            this._persistence_whitelist_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_whitelist_vh() {
        InternetAddressList internetAddressList;
        this._persistence_initialize_whitelist_vh();
        if ((this._persistence_whitelist_vh.isCoordinatedWithProperty() || this._persistence_whitelist_vh.isNewlyWeavedValueHolder()) && (internetAddressList = this._persistence_get_whitelist()) != this._persistence_whitelist_vh.getValue()) {
            this._persistence_set_whitelist(internetAddressList);
        }
        return this._persistence_whitelist_vh;
    }

    public void _persistence_set_whitelist_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_whitelist_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            InternetAddressList internetAddressList = this._persistence_get_whitelist();
            if (internetAddressList != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_whitelist((InternetAddressList)object);
            }
        } else {
            this.whitelist = null;
        }
    }

    public InternetAddressList _persistence_get_whitelist() {
        this._persistence_checkFetched("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        return this.whitelist;
    }

    public void _persistence_set_whitelist(InternetAddressList internetAddressList) {
        this._persistence_checkFetchedForSet("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        this._persistence_propertyChange("whitelist", this.whitelist, internetAddressList);
        this.whitelist = internetAddressList;
        this._persistence_whitelist_vh.setValue((Object)internetAddressList);
    }

    public CredentialsConfiguration _persistence_get_confirmation() {
        this._persistence_checkFetched("confirmation");
        return this.confirmation;
    }

    public void _persistence_set_confirmation(CredentialsConfiguration credentialsConfiguration) {
        this._persistence_checkFetchedForSet("confirmation");
        this._persistence_propertyChange("confirmation", this.confirmation, credentialsConfiguration);
        this.confirmation = credentialsConfiguration;
    }

    public Set _persistence_get_principalTypes() {
        this._persistence_checkFetched("principalTypes");
        return this.principalTypes;
    }

    public void _persistence_set_principalTypes(Set set) {
        this._persistence_checkFetchedForSet("principalTypes");
        this._persistence_propertyChange("principalTypes", this.principalTypes, set);
        this.principalTypes = set;
    }

    public UserChannelAccess _persistence_get_userAccess() {
        this._persistence_checkFetched("userAccess");
        return this.userAccess;
    }

    public void _persistence_set_userAccess(UserChannelAccess userChannelAccess) {
        this._persistence_checkFetchedForSet("userAccess");
        this._persistence_propertyChange("userAccess", this.userAccess, userChannelAccess);
        this.userAccess = userChannelAccess;
    }

    public Integer _persistence_get_trustedDeviceOnStartup() {
        this._persistence_checkFetched("trustedDeviceOnStartup");
        return this.trustedDeviceOnStartup;
    }

    public void _persistence_set_trustedDeviceOnStartup(Integer n) {
        this._persistence_checkFetchedForSet("trustedDeviceOnStartup");
        this._persistence_propertyChange("trustedDeviceOnStartup", this.trustedDeviceOnStartup, n);
        this.trustedDeviceOnStartup = n;
    }

    protected void _persistence_initialize_defaultPrincipalType_vh() {
        if (this._persistence_defaultPrincipalType_vh == null) {
            this._persistence_defaultPrincipalType_vh = new ValueHolder((Object)this.defaultPrincipalType);
            this._persistence_defaultPrincipalType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_defaultPrincipalType_vh() {
        PrincipalType principalType;
        this._persistence_initialize_defaultPrincipalType_vh();
        if ((this._persistence_defaultPrincipalType_vh.isCoordinatedWithProperty() || this._persistence_defaultPrincipalType_vh.isNewlyWeavedValueHolder()) && (principalType = this._persistence_get_defaultPrincipalType()) != this._persistence_defaultPrincipalType_vh.getValue()) {
            this._persistence_set_defaultPrincipalType(principalType);
        }
        return this._persistence_defaultPrincipalType_vh;
    }

    public void _persistence_set_defaultPrincipalType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_defaultPrincipalType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PrincipalType principalType = this._persistence_get_defaultPrincipalType();
            if (principalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_defaultPrincipalType((PrincipalType)object);
            }
        } else {
            this.defaultPrincipalType = null;
        }
    }

    public PrincipalType _persistence_get_defaultPrincipalType() {
        this._persistence_checkFetched("defaultPrincipalType");
        this._persistence_initialize_defaultPrincipalType_vh();
        this.defaultPrincipalType = (PrincipalType)this._persistence_defaultPrincipalType_vh.getValue();
        return this.defaultPrincipalType;
    }

    public void _persistence_set_defaultPrincipalType(PrincipalType principalType) {
        this._persistence_checkFetchedForSet("defaultPrincipalType");
        this._persistence_initialize_defaultPrincipalType_vh();
        this.defaultPrincipalType = (PrincipalType)this._persistence_defaultPrincipalType_vh.getValue();
        this._persistence_propertyChange("defaultPrincipalType", this.defaultPrincipalType, principalType);
        this.defaultPrincipalType = principalType;
        this._persistence_defaultPrincipalType_vh.setValue((Object)principalType);
    }

    public TimeInterval _persistence_get_sessionTimeout() {
        this._persistence_checkFetched("sessionTimeout");
        return this.sessionTimeout;
    }

    public void _persistence_set_sessionTimeout(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("sessionTimeout");
        this._persistence_propertyChange("sessionTimeout", this.sessionTimeout, timeInterval);
        this.sessionTimeout = timeInterval;
    }

    public Boolean _persistence_get_confirmationOncePerSession() {
        this._persistence_checkFetched("confirmationOncePerSession");
        return this.confirmationOncePerSession;
    }

    public void _persistence_set_confirmationOncePerSession(Boolean bl) {
        this._persistence_checkFetchedForSet("confirmationOncePerSession");
        this._persistence_propertyChange("confirmationOncePerSession", this.confirmationOncePerSession, bl);
        this.confirmationOncePerSession = bl;
    }

    public boolean _persistence_get_requireTrustedDeviceForLogin() {
        this._persistence_checkFetched("requireTrustedDeviceForLogin");
        return this.requireTrustedDeviceForLogin;
    }

    public void _persistence_set_requireTrustedDeviceForLogin(boolean bl) {
        this._persistence_checkFetchedForSet("requireTrustedDeviceForLogin");
        this._persistence_propertyChange("requireTrustedDeviceForLogin", new Boolean(this.requireTrustedDeviceForLogin), new Boolean(bl));
        this.requireTrustedDeviceForLogin = bl;
    }
}

