/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.marketplace.OrderAddress;
import org.cyclos.entities.marketplace.OrderLog;
import org.cyclos.entities.marketplace.OrderProduct;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodType;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.utils.TimeField;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="ad_orders", indexes={@Index(name="ix_order_number", unique=true, columnList="lower(number)")})
public class Order
extends BaseEntity
implements DefinesNetwork,
HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    public static final int QUANTITY_SCALE = 2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="buyer_id", updatable=false, nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private User buyer;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="seller_id", updatable=false, nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private User seller;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="currency_id", updatable=false, nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private Currency currency;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="order_status", nullable=false)
    @ReadOnlyFromDTO
    private OrderStatus status;
    @Basic
    @Column(name="pending_by_admin", nullable=true)
    private Boolean pendingByAdmin;
    @Basic
    @Column(name="sale", nullable=false)
    @ReadOnlyFromDTO
    private boolean sale;
    @Basic
    @Column(name="creation_date", updatable=true, nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ReadOnlyFromDTO
    private Date creationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_date", updatable=true, nullable=false)
    @ReadOnlyFromDTO
    private Date updatedDate;
    @Basic
    @Column(name="finish_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ReadOnlyFromDTO
    private Date finishDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="created_by", updatable=false, nullable=false)
    @ReadOnlyFromDTO
    private User createdBy;
    @Basic
    @Column(name="order_total", nullable=false)
    @CurrencyScale
    @ReadOnlyFromDTO
    private BigDecimal total = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=false)
    private Network network;
    @Basic
    @Column(name="delivery_method_name")
    private String deliveryMethodName;
    @Basic
    @Column(name="delivery_price")
    @CurrencyScale
    private BigDecimal deliveryPrice;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="min_delivery_time_amount")), @AttributeOverride(name="field", column=@Column(name="min_delivery_time_field"))})
    private TimeInterval minDeliveryTime;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="max_delivery_time_amount")), @AttributeOverride(name="field", column=@Column(name="max_delivery_time_field"))})
    private TimeInterval maxDeliveryTime = new TimeInterval(1, TimeField.DAYS);
    @Enumerated(value=EnumType.STRING)
    @Column(name="delivery_type")
    private AdDeliveryMethodType deliveryType = AdDeliveryMethodType.DELIVER;
    @ManyToOne
    @JoinColumn(name="payment_id")
    private Payment payment;
    @OneToMany(mappedBy="order", cascade={CascadeType.ALL})
    private Set<OrderAddress> deliveryAddresses;
    @Basic
    @Column(name="number")
    @ReadOnlyFromDTO
    private String number;
    @Basic
    @Column(name="delivery_confirm", nullable=false)
    private boolean deliveryConfirm;
    @Basic
    @Column(name="stock_updated", nullable=false)
    private boolean stockUpdated;
    @Basic
    @Column(name="show_done_msg", nullable=false)
    private boolean showDoneMsg;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_type_id")
    private PaymentTransferType paymentType;
    @Basic
    @Lob
    @Column(name="remarks")
    private String remarks;
    @OneToMany(mappedBy="order", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="productIndex")
    private List<OrderProduct> products = new ArrayList<OrderProduct>();
    @OneToMany(mappedBy="order", cascade={CascadeType.REMOVE})
    @OrderBy(value="date DESC")
    private List<OrderLog> logs = new ArrayList<OrderLog>();
    static final long serialVersionUID = -4140389031813586936L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_seller_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_paymentType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_currency_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_buyer_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_createdBy_vh;

    public void addProduct(OrderProduct orderProduct) {
        orderProduct.setOrder(this);
        int n = this._persistence_get_products().isEmpty() ? 0 : ((OrderProduct)this._persistence_get_products().get(this._persistence_get_products().size() - 1)).getProductIndex() + 1;
        orderProduct.setProductIndex(n);
        this._persistence_get_products().add(orderProduct);
    }

    public User getBuyer() {
        return this._persistence_get_buyer();
    }

    public User getCreatedBy() {
        return this._persistence_get_createdBy();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    public OrderAddress getDeliveryAddress() {
        return (OrderAddress)CollectionHelper.first((Iterable)this._persistence_get_deliveryAddresses());
    }

    public String getDeliveryMethodName() {
        return this._persistence_get_deliveryMethodName();
    }

    public BigDecimal getDeliveryPrice() {
        return this._persistence_get_deliveryPrice();
    }

    public AdDeliveryMethodType getDeliveryType() {
        return this._persistence_get_deliveryType();
    }

    public Date getFinishDate() {
        return this._persistence_get_finishDate();
    }

    public List<OrderLog> getLogs() {
        return this._persistence_get_logs();
    }

    public TimeInterval getMaxDeliveryTime() {
        return this._persistence_get_maxDeliveryTime();
    }

    public TimeInterval getMinDeliveryTime() {
        return this._persistence_get_minDeliveryTime();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getNumber() {
        return this._persistence_get_number();
    }

    public Payment getPayment() {
        return this._persistence_get_payment();
    }

    public PaymentTransferType getPaymentType() {
        return this._persistence_get_paymentType();
    }

    public boolean isPendingByAdmin() {
        return Boolean.TRUE.equals(this._persistence_get_pendingByAdmin());
    }

    public List<OrderProduct> getProducts() {
        return this._persistence_get_products();
    }

    public String getRemarks() {
        return this._persistence_get_remarks();
    }

    public User getSeller() {
        return this._persistence_get_seller();
    }

    public OrderStatus getStatus() {
        return this._persistence_get_status();
    }

    public BigDecimal getSubTotal() {
        MutableDouble mutableDouble = new MutableDouble();
        this.getProducts().forEach(orderProduct -> mutableDouble.add(orderProduct.getProductTotal().doubleValue()));
        return new BigDecimal(mutableDouble.doubleValue()).setScale(this.getCurrency().getPrecision(), RoundingMode.HALF_UP);
    }

    public BigDecimal getTotal() {
        return this._persistence_get_total();
    }

    public CurrencyAmount getTotalAmount() {
        return this._persistence_get_total() == null ? null : new CurrencyAmount(this._persistence_get_currency(), this._persistence_get_total());
    }

    public Date getUpdatedDate() {
        return this._persistence_get_updatedDate();
    }

    public boolean isDeliveryConfirm() {
        return this._persistence_get_deliveryConfirm();
    }

    public boolean isSale() {
        return this._persistence_get_sale();
    }

    public boolean isShowDoneMsg() {
        return this._persistence_get_showDoneMsg();
    }

    public boolean isStockUpdated() {
        return this._persistence_get_stockUpdated();
    }

    public void setBuyer(User user) {
        this._persistence_set_buyer(user);
    }

    public void setCreatedBy(User user) {
        this._persistence_set_createdBy(user);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setCurrency(Currency currency) {
        this._persistence_set_currency(currency);
    }

    public void setDeliveryAddress(OrderAddress orderAddress) {
        this._persistence_set_deliveryAddresses(CollectionHelper.asSet((Object[])new OrderAddress[]{orderAddress}));
    }

    public void setDeliveryConfirm(boolean bl) {
        this._persistence_set_deliveryConfirm(bl);
    }

    public void setDeliveryMethodName(String string) {
        this._persistence_set_deliveryMethodName(string);
    }

    public void setDeliveryPrice(BigDecimal bigDecimal) {
        this._persistence_set_deliveryPrice(bigDecimal);
    }

    public void setDeliveryType(AdDeliveryMethodType adDeliveryMethodType) {
        this._persistence_set_deliveryType(adDeliveryMethodType);
    }

    public void setFinishDate(Date date) {
        this._persistence_set_finishDate(date);
    }

    public void setLogs(List<OrderLog> list) {
        this._persistence_set_logs(list);
    }

    public void setMaxDeliveryTime(TimeInterval timeInterval) {
        this._persistence_set_maxDeliveryTime(timeInterval);
    }

    public void setMinDeliveryTime(TimeInterval timeInterval) {
        this._persistence_set_minDeliveryTime(timeInterval);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setNumber(String string) {
        this._persistence_set_number(string);
    }

    public void setPayment(Payment payment) {
        this._persistence_set_payment(payment);
    }

    public void setPaymentType(PaymentTransferType paymentTransferType) {
        this._persistence_set_paymentType(paymentTransferType);
    }

    public void setPendingByAdmin(boolean bl) {
        this._persistence_set_pendingByAdmin(bl);
    }

    public void setProducts(List<OrderProduct> list) {
        this._persistence_set_products(list);
    }

    public void setRemarks(String string) {
        this._persistence_set_remarks(string);
    }

    public void setSale(boolean bl) {
        this._persistence_set_sale(bl);
    }

    public void setSeller(User user) {
        this._persistence_set_seller(user);
    }

    public void setShowDoneMsg(boolean bl) {
        this._persistence_set_showDoneMsg(bl);
    }

    public void setStatus(OrderStatus orderStatus) {
        this._persistence_set_status(orderStatus);
    }

    public void setStockUpdated(boolean bl) {
        this._persistence_set_stockUpdated(bl);
    }

    public void setTotal(BigDecimal bigDecimal) {
        this._persistence_set_total(bigDecimal);
    }

    public void setUpdatedDate(Date date) {
        this._persistence_set_updatedDate(date);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_seller_vh != null) {
            this._persistence_seller_vh = (WeavedAttributeValueHolderInterface)this._persistence_seller_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_paymentType_vh != null) {
            this._persistence_paymentType_vh = (WeavedAttributeValueHolderInterface)this._persistence_paymentType_vh.clone();
        }
        if (this._persistence_currency_vh != null) {
            this._persistence_currency_vh = (WeavedAttributeValueHolderInterface)this._persistence_currency_vh.clone();
        }
        if (this._persistence_buyer_vh != null) {
            this._persistence_buyer_vh = (WeavedAttributeValueHolderInterface)this._persistence_buyer_vh.clone();
        }
        if (this._persistence_createdBy_vh != null) {
            this._persistence_createdBy_vh = (WeavedAttributeValueHolderInterface)this._persistence_createdBy_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Order();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "deliveryMethodName") {
            return this.deliveryMethodName;
        }
        if (string == "seller") {
            return this.seller;
        }
        if (string == "deliveryAddresses") {
            return this.deliveryAddresses;
        }
        if (string == "updatedDate") {
            return this.updatedDate;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "paymentType") {
            return this.paymentType;
        }
        if (string == "products") {
            return this.products;
        }
        if (string == "number") {
            return this.number;
        }
        if (string == "total") {
            return this.total;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "payment") {
            return this.payment;
        }
        if (string == "showDoneMsg") {
            return this.showDoneMsg;
        }
        if (string == "logs") {
            return this.logs;
        }
        if (string == "stockUpdated") {
            return this.stockUpdated;
        }
        if (string == "deliveryConfirm") {
            return this.deliveryConfirm;
        }
        if (string == "deliveryType") {
            return this.deliveryType;
        }
        if (string == "deliveryPrice") {
            return this.deliveryPrice;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "buyer") {
            return this.buyer;
        }
        if (string == "sale") {
            return this.sale;
        }
        if (string == "minDeliveryTime") {
            return this.minDeliveryTime;
        }
        if (string == "maxDeliveryTime") {
            return this.maxDeliveryTime;
        }
        if (string == "createdBy") {
            return this.createdBy;
        }
        if (string == "finishDate") {
            return this.finishDate;
        }
        if (string == "pendingByAdmin") {
            return this.pendingByAdmin;
        }
        if (string == "remarks") {
            return this.remarks;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "deliveryMethodName") {
            this.deliveryMethodName = (String)object;
            return;
        }
        if (string == "seller") {
            this.seller = (User)object;
            return;
        }
        if (string == "deliveryAddresses") {
            this.deliveryAddresses = (Set)object;
            return;
        }
        if (string == "updatedDate") {
            this.updatedDate = (Date)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "paymentType") {
            this.paymentType = (PaymentTransferType)object;
            return;
        }
        if (string == "products") {
            this.products = (List)object;
            return;
        }
        if (string == "number") {
            this.number = (String)object;
            return;
        }
        if (string == "total") {
            this.total = (BigDecimal)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
        if (string == "payment") {
            this.payment = (Payment)object;
            return;
        }
        if (string == "showDoneMsg") {
            this.showDoneMsg = (Boolean)object;
            return;
        }
        if (string == "logs") {
            this.logs = (List)object;
            return;
        }
        if (string == "stockUpdated") {
            this.stockUpdated = (Boolean)object;
            return;
        }
        if (string == "deliveryConfirm") {
            this.deliveryConfirm = (Boolean)object;
            return;
        }
        if (string == "deliveryType") {
            this.deliveryType = (AdDeliveryMethodType)object;
            return;
        }
        if (string == "deliveryPrice") {
            this.deliveryPrice = (BigDecimal)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "buyer") {
            this.buyer = (User)object;
            return;
        }
        if (string == "sale") {
            this.sale = (Boolean)object;
            return;
        }
        if (string == "minDeliveryTime") {
            this.minDeliveryTime = (TimeInterval)object;
            return;
        }
        if (string == "maxDeliveryTime") {
            this.maxDeliveryTime = (TimeInterval)object;
            return;
        }
        if (string == "createdBy") {
            this.createdBy = (User)object;
            return;
        }
        if (string == "finishDate") {
            this.finishDate = (Date)object;
            return;
        }
        if (string == "pendingByAdmin") {
            this.pendingByAdmin = (Boolean)object;
            return;
        }
        if (string == "remarks") {
            this.remarks = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (OrderStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_deliveryMethodName() {
        this._persistence_checkFetched("deliveryMethodName");
        return this.deliveryMethodName;
    }

    public void _persistence_set_deliveryMethodName(String string) {
        this._persistence_checkFetchedForSet("deliveryMethodName");
        this._persistence_propertyChange("deliveryMethodName", this.deliveryMethodName, string);
        this.deliveryMethodName = string;
    }

    protected void _persistence_initialize_seller_vh() {
        if (this._persistence_seller_vh == null) {
            this._persistence_seller_vh = new ValueHolder((Object)this.seller);
            this._persistence_seller_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_seller_vh() {
        User user;
        this._persistence_initialize_seller_vh();
        if ((this._persistence_seller_vh.isCoordinatedWithProperty() || this._persistence_seller_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_seller()) != this._persistence_seller_vh.getValue()) {
            this._persistence_set_seller(user);
        }
        return this._persistence_seller_vh;
    }

    public void _persistence_set_seller_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_seller_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_seller();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_seller((User)object);
            }
        } else {
            this.seller = null;
        }
    }

    public User _persistence_get_seller() {
        this._persistence_checkFetched("seller");
        this._persistence_initialize_seller_vh();
        this.seller = (User)this._persistence_seller_vh.getValue();
        return this.seller;
    }

    public void _persistence_set_seller(User user) {
        this._persistence_checkFetchedForSet("seller");
        this._persistence_initialize_seller_vh();
        this.seller = (User)this._persistence_seller_vh.getValue();
        this._persistence_propertyChange("seller", this.seller, user);
        this.seller = user;
        this._persistence_seller_vh.setValue((Object)user);
    }

    public Set _persistence_get_deliveryAddresses() {
        this._persistence_checkFetched("deliveryAddresses");
        return this.deliveryAddresses;
    }

    public void _persistence_set_deliveryAddresses(Set set) {
        this._persistence_checkFetchedForSet("deliveryAddresses");
        this._persistence_propertyChange("deliveryAddresses", this.deliveryAddresses, set);
        this.deliveryAddresses = set;
    }

    public Date _persistence_get_updatedDate() {
        this._persistence_checkFetched("updatedDate");
        return this.updatedDate;
    }

    public void _persistence_set_updatedDate(Date date) {
        this._persistence_checkFetchedForSet("updatedDate");
        this._persistence_propertyChange("updatedDate", this.updatedDate, date);
        this.updatedDate = date;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    protected void _persistence_initialize_paymentType_vh() {
        if (this._persistence_paymentType_vh == null) {
            this._persistence_paymentType_vh = new ValueHolder((Object)this.paymentType);
            this._persistence_paymentType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_paymentType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_paymentType_vh();
        if ((this._persistence_paymentType_vh.isCoordinatedWithProperty() || this._persistence_paymentType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_paymentType()) != this._persistence_paymentType_vh.getValue()) {
            this._persistence_set_paymentType(paymentTransferType);
        }
        return this._persistence_paymentType_vh;
    }

    public void _persistence_set_paymentType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_paymentType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_paymentType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_paymentType((PaymentTransferType)object);
            }
        } else {
            this.paymentType = null;
        }
    }

    public PaymentTransferType _persistence_get_paymentType() {
        this._persistence_checkFetched("paymentType");
        this._persistence_initialize_paymentType_vh();
        this.paymentType = (PaymentTransferType)this._persistence_paymentType_vh.getValue();
        return this.paymentType;
    }

    public void _persistence_set_paymentType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("paymentType");
        this._persistence_initialize_paymentType_vh();
        this.paymentType = (PaymentTransferType)this._persistence_paymentType_vh.getValue();
        this._persistence_propertyChange("paymentType", this.paymentType, paymentTransferType);
        this.paymentType = paymentTransferType;
        this._persistence_paymentType_vh.setValue((Object)paymentTransferType);
    }

    public List _persistence_get_products() {
        this._persistence_checkFetched("products");
        return this.products;
    }

    public void _persistence_set_products(List list) {
        this._persistence_checkFetchedForSet("products");
        this._persistence_propertyChange("products", this.products, list);
        this.products = list;
    }

    public String _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(String string) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, string);
        this.number = string;
    }

    public BigDecimal _persistence_get_total() {
        this._persistence_checkFetched("total");
        return this.total;
    }

    public void _persistence_set_total(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("total");
        this._persistence_propertyChange("total", this.total, bigDecimal);
        this.total = bigDecimal;
    }

    protected void _persistence_initialize_currency_vh() {
        if (this._persistence_currency_vh == null) {
            this._persistence_currency_vh = new ValueHolder((Object)this.currency);
            this._persistence_currency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_currency_vh() {
        Currency currency;
        this._persistence_initialize_currency_vh();
        if ((this._persistence_currency_vh.isCoordinatedWithProperty() || this._persistence_currency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_currency()) != this._persistence_currency_vh.getValue()) {
            this._persistence_set_currency(currency);
        }
        return this._persistence_currency_vh;
    }

    public void _persistence_set_currency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_currency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_currency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_currency((Currency)object);
            }
        } else {
            this.currency = null;
        }
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        this._persistence_propertyChange("currency", this.currency, currency);
        this.currency = currency;
        this._persistence_currency_vh.setValue((Object)currency);
    }

    public Payment _persistence_get_payment() {
        this._persistence_checkFetched("payment");
        return this.payment;
    }

    public void _persistence_set_payment(Payment payment) {
        this._persistence_checkFetchedForSet("payment");
        this._persistence_propertyChange("payment", this.payment, payment);
        this.payment = payment;
    }

    public boolean _persistence_get_showDoneMsg() {
        this._persistence_checkFetched("showDoneMsg");
        return this.showDoneMsg;
    }

    public void _persistence_set_showDoneMsg(boolean bl) {
        this._persistence_checkFetchedForSet("showDoneMsg");
        this._persistence_propertyChange("showDoneMsg", new Boolean(this.showDoneMsg), new Boolean(bl));
        this.showDoneMsg = bl;
    }

    public List _persistence_get_logs() {
        this._persistence_checkFetched("logs");
        return this.logs;
    }

    public void _persistence_set_logs(List list) {
        this._persistence_checkFetchedForSet("logs");
        this._persistence_propertyChange("logs", this.logs, list);
        this.logs = list;
    }

    public boolean _persistence_get_stockUpdated() {
        this._persistence_checkFetched("stockUpdated");
        return this.stockUpdated;
    }

    public void _persistence_set_stockUpdated(boolean bl) {
        this._persistence_checkFetchedForSet("stockUpdated");
        this._persistence_propertyChange("stockUpdated", new Boolean(this.stockUpdated), new Boolean(bl));
        this.stockUpdated = bl;
    }

    public boolean _persistence_get_deliveryConfirm() {
        this._persistence_checkFetched("deliveryConfirm");
        return this.deliveryConfirm;
    }

    public void _persistence_set_deliveryConfirm(boolean bl) {
        this._persistence_checkFetchedForSet("deliveryConfirm");
        this._persistence_propertyChange("deliveryConfirm", new Boolean(this.deliveryConfirm), new Boolean(bl));
        this.deliveryConfirm = bl;
    }

    public AdDeliveryMethodType _persistence_get_deliveryType() {
        this._persistence_checkFetched("deliveryType");
        return this.deliveryType;
    }

    public void _persistence_set_deliveryType(AdDeliveryMethodType adDeliveryMethodType) {
        this._persistence_checkFetchedForSet("deliveryType");
        this._persistence_propertyChange("deliveryType", this.deliveryType, adDeliveryMethodType);
        this.deliveryType = adDeliveryMethodType;
    }

    public BigDecimal _persistence_get_deliveryPrice() {
        this._persistence_checkFetched("deliveryPrice");
        return this.deliveryPrice;
    }

    public void _persistence_set_deliveryPrice(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("deliveryPrice");
        this._persistence_propertyChange("deliveryPrice", this.deliveryPrice, bigDecimal);
        this.deliveryPrice = bigDecimal;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    protected void _persistence_initialize_buyer_vh() {
        if (this._persistence_buyer_vh == null) {
            this._persistence_buyer_vh = new ValueHolder((Object)this.buyer);
            this._persistence_buyer_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_buyer_vh() {
        User user;
        this._persistence_initialize_buyer_vh();
        if ((this._persistence_buyer_vh.isCoordinatedWithProperty() || this._persistence_buyer_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_buyer()) != this._persistence_buyer_vh.getValue()) {
            this._persistence_set_buyer(user);
        }
        return this._persistence_buyer_vh;
    }

    public void _persistence_set_buyer_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_buyer_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_buyer();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_buyer((User)object);
            }
        } else {
            this.buyer = null;
        }
    }

    public User _persistence_get_buyer() {
        this._persistence_checkFetched("buyer");
        this._persistence_initialize_buyer_vh();
        this.buyer = (User)this._persistence_buyer_vh.getValue();
        return this.buyer;
    }

    public void _persistence_set_buyer(User user) {
        this._persistence_checkFetchedForSet("buyer");
        this._persistence_initialize_buyer_vh();
        this.buyer = (User)this._persistence_buyer_vh.getValue();
        this._persistence_propertyChange("buyer", this.buyer, user);
        this.buyer = user;
        this._persistence_buyer_vh.setValue((Object)user);
    }

    public boolean _persistence_get_sale() {
        this._persistence_checkFetched("sale");
        return this.sale;
    }

    public void _persistence_set_sale(boolean bl) {
        this._persistence_checkFetchedForSet("sale");
        this._persistence_propertyChange("sale", new Boolean(this.sale), new Boolean(bl));
        this.sale = bl;
    }

    public TimeInterval _persistence_get_minDeliveryTime() {
        this._persistence_checkFetched("minDeliveryTime");
        return this.minDeliveryTime;
    }

    public void _persistence_set_minDeliveryTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("minDeliveryTime");
        this._persistence_propertyChange("minDeliveryTime", this.minDeliveryTime, timeInterval);
        this.minDeliveryTime = timeInterval;
    }

    public TimeInterval _persistence_get_maxDeliveryTime() {
        this._persistence_checkFetched("maxDeliveryTime");
        return this.maxDeliveryTime;
    }

    public void _persistence_set_maxDeliveryTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("maxDeliveryTime");
        this._persistence_propertyChange("maxDeliveryTime", this.maxDeliveryTime, timeInterval);
        this.maxDeliveryTime = timeInterval;
    }

    protected void _persistence_initialize_createdBy_vh() {
        if (this._persistence_createdBy_vh == null) {
            this._persistence_createdBy_vh = new ValueHolder((Object)this.createdBy);
            this._persistence_createdBy_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_createdBy_vh() {
        User user;
        this._persistence_initialize_createdBy_vh();
        if ((this._persistence_createdBy_vh.isCoordinatedWithProperty() || this._persistence_createdBy_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_createdBy()) != this._persistence_createdBy_vh.getValue()) {
            this._persistence_set_createdBy(user);
        }
        return this._persistence_createdBy_vh;
    }

    public void _persistence_set_createdBy_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_createdBy_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_createdBy();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_createdBy((User)object);
            }
        } else {
            this.createdBy = null;
        }
    }

    public User _persistence_get_createdBy() {
        this._persistence_checkFetched("createdBy");
        this._persistence_initialize_createdBy_vh();
        this.createdBy = (User)this._persistence_createdBy_vh.getValue();
        return this.createdBy;
    }

    public void _persistence_set_createdBy(User user) {
        this._persistence_checkFetchedForSet("createdBy");
        this._persistence_initialize_createdBy_vh();
        this.createdBy = (User)this._persistence_createdBy_vh.getValue();
        this._persistence_propertyChange("createdBy", this.createdBy, user);
        this.createdBy = user;
        this._persistence_createdBy_vh.setValue((Object)user);
    }

    public Date _persistence_get_finishDate() {
        this._persistence_checkFetched("finishDate");
        return this.finishDate;
    }

    public void _persistence_set_finishDate(Date date) {
        this._persistence_checkFetchedForSet("finishDate");
        this._persistence_propertyChange("finishDate", this.finishDate, date);
        this.finishDate = date;
    }

    public Boolean _persistence_get_pendingByAdmin() {
        this._persistence_checkFetched("pendingByAdmin");
        return this.pendingByAdmin;
    }

    public void _persistence_set_pendingByAdmin(Boolean bl) {
        this._persistence_checkFetchedForSet("pendingByAdmin");
        this._persistence_propertyChange("pendingByAdmin", this.pendingByAdmin, bl);
        this.pendingByAdmin = bl;
    }

    public String _persistence_get_remarks() {
        this._persistence_checkFetched("remarks");
        return this.remarks;
    }

    public void _persistence_set_remarks(String string) {
        this._persistence_checkFetchedForSet("remarks");
        this._persistence_propertyChange("remarks", this.remarks, string);
        this.remarks = string;
    }

    public OrderStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(OrderStatus orderStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, orderStatus);
        this.status = orderStatus;
    }
}

