/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferTransferStatusFlow;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorColumn(name="subclass")
@Table(name="transfers", indexes={@Index(name="ix_transfers_from_id_date", columnList="from_id, date"), @Index(name="ix_transfers_to_id_date", columnList="to_id, date"), @Index(name="ix_transfers_date", columnList="date"), @Index(name="ix_transfers_subclass", columnList="subclass"), @Index(name="ix_transfers_amount", columnList="amount"), @Index(name="ix_transfers_transaction_number", columnList="lower(transaction_number)"), @Index(name="ix_transfers_pending_notification", columnList="pending_notification")})
public abstract class Transfer
extends NetworkedEntity
implements Trans,
RatedEntity,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass")
    private TransferNature nature;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="transaction_id")
    private Transaction transaction;
    @Basic
    @Column(name="pending_notification")
    protected Boolean pendingNotification;
    @Basic
    @Column(name="date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="from_id", nullable=false)
    private Account from;
    @Basic
    @Column(name="from_id", insertable=false, updatable=false, nullable=false)
    private Long fromId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="to_id", nullable=false)
    private Account to;
    @Basic
    @Column(name="to_id", insertable=false, updatable=false, nullable=false)
    private Long toId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false)
    private TransferType type;
    @Basic
    @Column(name="amount", nullable=false)
    @CurrencyScale
    private BigDecimal amount;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="emission_date")
    private Date emissionDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    private Date expirationDate;
    @Basic
    @Column(name="transaction_number", nullable=true)
    private String transactionNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    private Transfer parent;
    @OneToMany(mappedBy="parent")
    private List<Transfer> children = new ArrayList<Transfer>();
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="charged_back_by_id")
    private ChargebackTransfer chargedBackBy;
    @OneToMany(mappedBy="transfer", cascade={CascadeType.ALL})
    private Set<TransferTransferStatusFlow> statuses = new HashSet<TransferTransferStatusFlow>();
    static final long serialVersionUID = 8209136308578034368L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parent_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_chargedBackBy_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_from_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_to_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transaction_vh;

    @Override
    public AccessClient getAccessClient() {
        return this.fromTransaction(Transaction::getAccessClient);
    }

    @Override
    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    @Override
    public Channel getChannel() {
        return this.fromTransaction(Transaction::getChannel);
    }

    public ChargebackTransfer getChargedBackBy() {
        return this._persistence_get_chargedBackBy();
    }

    public List<Transfer> getChildren() {
        return this._persistence_get_children();
    }

    @Override
    public Currency getCurrency() {
        try {
            return this._persistence_get_type().getFrom().getCurrency();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Set<TransactionCustomFieldValue> getCustomValues() {
        return this.fromTransaction(Transaction::getCustomValues);
    }

    @Override
    public Date getDate() {
        return this._persistence_get_date();
    }

    @Override
    public Date getEmissionDate() {
        return this._persistence_get_emissionDate();
    }

    @Override
    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    @Override
    public Account getFrom() {
        return this._persistence_get_from();
    }

    @Override
    public String getFromName() {
        return this.fromTransaction(Transaction::getFromName);
    }

    @Override
    public InternalAccountOwner getFromOwner() {
        return this._persistence_get_from() == null ? null : this._persistence_get_from().getOwner();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_type().getNetwork();
    }

    public Transfer getParent() {
        return this._persistence_get_parent();
    }

    public Transfer getRoot() {
        Transfer transfer = this;
        while (transfer.getParent() != null) {
            transfer = transfer.getParent();
        }
        return transfer;
    }

    public TransferStatus getStatus(TransferStatusFlow transferStatusFlow) {
        TransferTransferStatusFlow transferTransferStatusFlow2 = this._persistence_get_statuses() == null ? null : (TransferTransferStatusFlow)this._persistence_get_statuses().stream().filter(transferTransferStatusFlow -> transferTransferStatusFlow.getFlow().equals(transferStatusFlow)).findFirst().orElse(null);
        return transferTransferStatusFlow2 == null ? null : transferTransferStatusFlow2.getStatus();
    }

    public Set<TransferStatus> getStatuses() {
        if (CollectionHelper.isEmpty((Iterable)this._persistence_get_statuses())) {
            return Collections.emptySet();
        }
        return this._persistence_get_statuses().stream().map(TransferTransferStatusFlow::getStatus).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Account getTo() {
        return this._persistence_get_to();
    }

    @Override
    public String getToName() {
        return this.fromTransaction(Transaction::getToName);
    }

    public InternalAccountOwner getToOwner() {
        return (InternalAccountOwner)Trans.super.getToOwner();
    }

    public Transaction getTransaction() {
        return this._persistence_get_transaction();
    }

    public final Long getTransactionId() {
        return this.fromTransaction(SimpleEntity::getId);
    }

    public String getTransactionNumber() {
        return this._persistence_get_transactionNumber();
    }

    public String getTransactionTransactionNumber() {
        return this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getTransactionNumber();
    }

    public abstract TransferNature getTransferNature();

    @Override
    public TransferType getType() {
        return this._persistence_get_type();
    }

    public boolean isPendingNotification() {
        return Boolean.TRUE.equals(this._persistence_get_pendingNotification());
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setChargedBackBy(ChargebackTransfer chargebackTransfer) {
        this._persistence_set_chargedBackBy(chargebackTransfer);
    }

    public void setChildren(List<Transfer> list) {
        this._persistence_set_children(list);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    @Override
    public void setEmissionDate(Date date) {
        this._persistence_set_emissionDate(date);
    }

    @Override
    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setFrom(Account account) {
        this._persistence_set_from(account);
    }

    public void setParent(Transfer transfer) {
        this._persistence_set_parent(transfer);
    }

    public void setPendingNotification(boolean bl) {
        this._persistence_set_pendingNotification(bl);
    }

    public void setStatus(TransferStatusFlow transferStatusFlow, TransferStatus transferStatus) {
        TransferTransferStatusFlow transferTransferStatusFlow2;
        if (transferStatus != null && !transferStatusFlow.equals(transferStatus.getFlow())) {
            throw new IllegalActionException();
        }
        if (this._persistence_get_statuses() == null) {
            this._persistence_set_statuses(new HashSet());
        }
        if ((transferTransferStatusFlow2 = (TransferTransferStatusFlow)this._persistence_get_statuses().stream().filter(transferTransferStatusFlow -> transferTransferStatusFlow.getFlow().equals(transferStatusFlow)).findFirst().orElse(null)) == null) {
            transferTransferStatusFlow2 = new TransferTransferStatusFlow();
            transferTransferStatusFlow2.setTransfer(this);
            transferTransferStatusFlow2.setFlow(transferStatusFlow);
            this._persistence_get_statuses().add(transferTransferStatusFlow2);
        }
        transferTransferStatusFlow2.setStatus(transferStatus);
    }

    public void setTo(Account account) {
        this._persistence_set_to(account);
    }

    public void setTransaction(Transaction transaction) {
        this._persistence_set_transaction(transaction);
    }

    public void setTransactionNumber(String string) {
        this._persistence_set_transactionNumber(string);
    }

    public void setType(TransferType transferType) {
        this._persistence_set_type(transferType);
    }

    protected <T> T fromTransaction(Function<Transaction, T> function) {
        Transaction transaction = this.getTransaction();
        return transaction == null ? null : (T)function.apply(transaction);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_parent_vh != null) {
            this._persistence_parent_vh = (WeavedAttributeValueHolderInterface)this._persistence_parent_vh.clone();
        }
        if (this._persistence_chargedBackBy_vh != null) {
            this._persistence_chargedBackBy_vh = (WeavedAttributeValueHolderInterface)this._persistence_chargedBackBy_vh.clone();
        }
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_from_vh != null) {
            this._persistence_from_vh = (WeavedAttributeValueHolderInterface)this._persistence_from_vh.clone();
        }
        if (this._persistence_to_vh != null) {
            this._persistence_to_vh = (WeavedAttributeValueHolderInterface)this._persistence_to_vh.clone();
        }
        if (this._persistence_transaction_vh != null) {
            this._persistence_transaction_vh = (WeavedAttributeValueHolderInterface)this._persistence_transaction_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Transfer();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "toId") {
            return this.toId;
        }
        if (string == "parent") {
            return this.parent;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "transactionNumber") {
            return this.transactionNumber;
        }
        if (string == "chargedBackBy") {
            return this.chargedBackBy;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "fromId") {
            return this.fromId;
        }
        if (string == "emissionDate") {
            return this.emissionDate;
        }
        if (string == "children") {
            return this.children;
        }
        if (string == "statuses") {
            return this.statuses;
        }
        if (string == "from") {
            return this.from;
        }
        if (string == "pendingNotification") {
            return this.pendingNotification;
        }
        if (string == "to") {
            return this.to;
        }
        if (string == "transaction") {
            return this.transaction;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "toId") {
            this.toId = (Long)object;
            return;
        }
        if (string == "parent") {
            this.parent = (Transfer)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "nature") {
            this.nature = (TransferNature)object;
            return;
        }
        if (string == "transactionNumber") {
            this.transactionNumber = (String)object;
            return;
        }
        if (string == "chargedBackBy") {
            this.chargedBackBy = (ChargebackTransfer)object;
            return;
        }
        if (string == "type") {
            this.type = (TransferType)object;
            return;
        }
        if (string == "fromId") {
            this.fromId = (Long)object;
            return;
        }
        if (string == "emissionDate") {
            this.emissionDate = (Date)object;
            return;
        }
        if (string == "children") {
            this.children = (List)object;
            return;
        }
        if (string == "statuses") {
            this.statuses = (Set)object;
            return;
        }
        if (string == "from") {
            this.from = (Account)object;
            return;
        }
        if (string == "pendingNotification") {
            this.pendingNotification = (Boolean)object;
            return;
        }
        if (string == "to") {
            this.to = (Account)object;
            return;
        }
        if (string == "transaction") {
            this.transaction = (Transaction)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public Long _persistence_get_toId() {
        this._persistence_checkFetched("toId");
        return this.toId;
    }

    public void _persistence_set_toId(Long l) {
        this._persistence_checkFetchedForSet("toId");
        this._persistence_propertyChange("toId", this.toId, l);
        this.toId = l;
    }

    protected void _persistence_initialize_parent_vh() {
        if (this._persistence_parent_vh == null) {
            this._persistence_parent_vh = new ValueHolder((Object)this.parent);
            this._persistence_parent_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parent_vh() {
        Transfer transfer;
        this._persistence_initialize_parent_vh();
        if ((this._persistence_parent_vh.isCoordinatedWithProperty() || this._persistence_parent_vh.isNewlyWeavedValueHolder()) && (transfer = this._persistence_get_parent()) != this._persistence_parent_vh.getValue()) {
            this._persistence_set_parent(transfer);
        }
        return this._persistence_parent_vh;
    }

    public void _persistence_set_parent_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parent_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Transfer transfer = this._persistence_get_parent();
            if (transfer != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parent((Transfer)object);
            }
        } else {
            this.parent = null;
        }
    }

    public Transfer _persistence_get_parent() {
        this._persistence_checkFetched("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Transfer)this._persistence_parent_vh.getValue();
        return this.parent;
    }

    public void _persistence_set_parent(Transfer transfer) {
        this._persistence_checkFetchedForSet("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Transfer)this._persistence_parent_vh.getValue();
        this._persistence_propertyChange("parent", this.parent, transfer);
        this.parent = transfer;
        this._persistence_parent_vh.setValue((Object)transfer);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public TransferNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(TransferNature transferNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, transferNature);
        this.nature = transferNature;
    }

    public String _persistence_get_transactionNumber() {
        this._persistence_checkFetched("transactionNumber");
        return this.transactionNumber;
    }

    public void _persistence_set_transactionNumber(String string) {
        this._persistence_checkFetchedForSet("transactionNumber");
        this._persistence_propertyChange("transactionNumber", this.transactionNumber, string);
        this.transactionNumber = string;
    }

    protected void _persistence_initialize_chargedBackBy_vh() {
        if (this._persistence_chargedBackBy_vh == null) {
            this._persistence_chargedBackBy_vh = new ValueHolder((Object)this.chargedBackBy);
            this._persistence_chargedBackBy_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_chargedBackBy_vh() {
        ChargebackTransfer chargebackTransfer;
        this._persistence_initialize_chargedBackBy_vh();
        if ((this._persistence_chargedBackBy_vh.isCoordinatedWithProperty() || this._persistence_chargedBackBy_vh.isNewlyWeavedValueHolder()) && (chargebackTransfer = this._persistence_get_chargedBackBy()) != this._persistence_chargedBackBy_vh.getValue()) {
            this._persistence_set_chargedBackBy(chargebackTransfer);
        }
        return this._persistence_chargedBackBy_vh;
    }

    public void _persistence_set_chargedBackBy_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_chargedBackBy_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ChargebackTransfer chargebackTransfer = this._persistence_get_chargedBackBy();
            if (chargebackTransfer != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_chargedBackBy((ChargebackTransfer)object);
            }
        } else {
            this.chargedBackBy = null;
        }
    }

    public ChargebackTransfer _persistence_get_chargedBackBy() {
        this._persistence_checkFetched("chargedBackBy");
        this._persistence_initialize_chargedBackBy_vh();
        this.chargedBackBy = (ChargebackTransfer)this._persistence_chargedBackBy_vh.getValue();
        return this.chargedBackBy;
    }

    public void _persistence_set_chargedBackBy(ChargebackTransfer chargebackTransfer) {
        this._persistence_checkFetchedForSet("chargedBackBy");
        this._persistence_initialize_chargedBackBy_vh();
        this.chargedBackBy = (ChargebackTransfer)this._persistence_chargedBackBy_vh.getValue();
        this._persistence_propertyChange("chargedBackBy", this.chargedBackBy, chargebackTransfer);
        this.chargedBackBy = chargebackTransfer;
        this._persistence_chargedBackBy_vh.setValue((Object)chargebackTransfer);
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        TransferType transferType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (transferType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(transferType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TransferType transferType = this._persistence_get_type();
            if (transferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((TransferType)object);
            }
        } else {
            this.type = null;
        }
    }

    public TransferType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (TransferType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(TransferType transferType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (TransferType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, transferType);
        this.type = transferType;
        this._persistence_type_vh.setValue((Object)transferType);
    }

    public Long _persistence_get_fromId() {
        this._persistence_checkFetched("fromId");
        return this.fromId;
    }

    public void _persistence_set_fromId(Long l) {
        this._persistence_checkFetchedForSet("fromId");
        this._persistence_propertyChange("fromId", this.fromId, l);
        this.fromId = l;
    }

    public Date _persistence_get_emissionDate() {
        this._persistence_checkFetched("emissionDate");
        return this.emissionDate;
    }

    public void _persistence_set_emissionDate(Date date) {
        this._persistence_checkFetchedForSet("emissionDate");
        this._persistence_propertyChange("emissionDate", this.emissionDate, date);
        this.emissionDate = date;
    }

    public List _persistence_get_children() {
        this._persistence_checkFetched("children");
        return this.children;
    }

    public void _persistence_set_children(List list) {
        this._persistence_checkFetchedForSet("children");
        this._persistence_propertyChange("children", this.children, list);
        this.children = list;
    }

    public Set _persistence_get_statuses() {
        this._persistence_checkFetched("statuses");
        return this.statuses;
    }

    public void _persistence_set_statuses(Set set) {
        this._persistence_checkFetchedForSet("statuses");
        this._persistence_propertyChange("statuses", this.statuses, set);
        this.statuses = set;
    }

    protected void _persistence_initialize_from_vh() {
        if (this._persistence_from_vh == null) {
            this._persistence_from_vh = new ValueHolder((Object)this.from);
            this._persistence_from_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_from_vh() {
        Account account;
        this._persistence_initialize_from_vh();
        if ((this._persistence_from_vh.isCoordinatedWithProperty() || this._persistence_from_vh.isNewlyWeavedValueHolder()) && (account = this._persistence_get_from()) != this._persistence_from_vh.getValue()) {
            this._persistence_set_from(account);
        }
        return this._persistence_from_vh;
    }

    public void _persistence_set_from_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_from_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Account account = this._persistence_get_from();
            if (account != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_from((Account)object);
            }
        } else {
            this.from = null;
        }
    }

    public Account _persistence_get_from() {
        this._persistence_checkFetched("from");
        this._persistence_initialize_from_vh();
        this.from = (Account)this._persistence_from_vh.getValue();
        return this.from;
    }

    public void _persistence_set_from(Account account) {
        this._persistence_checkFetchedForSet("from");
        this._persistence_initialize_from_vh();
        this.from = (Account)this._persistence_from_vh.getValue();
        this._persistence_propertyChange("from", this.from, account);
        this.from = account;
        this._persistence_from_vh.setValue((Object)account);
    }

    public Boolean _persistence_get_pendingNotification() {
        this._persistence_checkFetched("pendingNotification");
        return this.pendingNotification;
    }

    public void _persistence_set_pendingNotification(Boolean bl) {
        this._persistence_checkFetchedForSet("pendingNotification");
        this._persistence_propertyChange("pendingNotification", this.pendingNotification, bl);
        this.pendingNotification = bl;
    }

    protected void _persistence_initialize_to_vh() {
        if (this._persistence_to_vh == null) {
            this._persistence_to_vh = new ValueHolder((Object)this.to);
            this._persistence_to_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_to_vh() {
        Account account;
        this._persistence_initialize_to_vh();
        if ((this._persistence_to_vh.isCoordinatedWithProperty() || this._persistence_to_vh.isNewlyWeavedValueHolder()) && (account = this._persistence_get_to()) != this._persistence_to_vh.getValue()) {
            this._persistence_set_to(account);
        }
        return this._persistence_to_vh;
    }

    public void _persistence_set_to_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_to_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Account account = this._persistence_get_to();
            if (account != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_to((Account)object);
            }
        } else {
            this.to = null;
        }
    }

    public Account _persistence_get_to() {
        this._persistence_checkFetched("to");
        this._persistence_initialize_to_vh();
        this.to = (Account)this._persistence_to_vh.getValue();
        return this.to;
    }

    public void _persistence_set_to(Account account) {
        this._persistence_checkFetchedForSet("to");
        this._persistence_initialize_to_vh();
        this.to = (Account)this._persistence_to_vh.getValue();
        this._persistence_propertyChange("to", this.to, account);
        this.to = account;
        this._persistence_to_vh.setValue((Object)account);
    }

    protected void _persistence_initialize_transaction_vh() {
        if (this._persistence_transaction_vh == null) {
            this._persistence_transaction_vh = new ValueHolder((Object)this.transaction);
            this._persistence_transaction_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transaction_vh() {
        Transaction transaction;
        this._persistence_initialize_transaction_vh();
        if ((this._persistence_transaction_vh.isCoordinatedWithProperty() || this._persistence_transaction_vh.isNewlyWeavedValueHolder()) && (transaction = this._persistence_get_transaction()) != this._persistence_transaction_vh.getValue()) {
            this._persistence_set_transaction(transaction);
        }
        return this._persistence_transaction_vh;
    }

    public void _persistence_set_transaction_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transaction_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Transaction transaction = this._persistence_get_transaction();
            if (transaction != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transaction((Transaction)object);
            }
        } else {
            this.transaction = null;
        }
    }

    public Transaction _persistence_get_transaction() {
        this._persistence_checkFetched("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (Transaction)this._persistence_transaction_vh.getValue();
        return this.transaction;
    }

    public void _persistence_set_transaction(Transaction transaction) {
        this._persistence_checkFetchedForSet("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (Transaction)this._persistence_transaction_vh.getValue();
        this._persistence_propertyChange("transaction", this.transaction, transaction);
        this.transaction = transaction;
        this._persistence_transaction_vh.setValue((Object)transaction);
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }
}

