/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValue;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorColumn(name="subclass")
@Table(name="transactions", indexes={@Index(name="ix_transactions_from_id_date", columnList="from_id, date"), @Index(name="ix_transactions_to_id_date", columnList="to_id, date"), @Index(name="ix_transactions_date", columnList="date"), @Index(name="ix_transactions_amount", columnList="amount"), @Index(name="ix_transactions_subclass", columnList="subclass"), @Index(name="ix_transactions_creation_type", columnList="creation_type"), @Index(name="ix_transactions_status", columnList="status"), @Index(name="ix_transactions_authorization_status", columnList="authorization_status"), @Index(name="ix_transactions_authorization_type", columnList="authorization_type"), @Index(name="ix_transactions_show_to_receiver", columnList="show_to_receiver"), @Index(name="ix_external_principal_value", columnList="external_principal_value"), @Index(name="ix_ticket_number", columnList="lower(ticket_number)"), @Index(name="ix_transactions_transaction_number", columnList="lower(transaction_number)"), @Index(name="ix_transactions_pending_notification", columnList="pending_notification"), @Index(name="ix_transactions_sms_code", columnList="sms_code")})
public abstract class Transaction
extends BaseEntity
implements Trans,
EntityWithCustomValues<TransactionCustomField, TransactionCustomFieldPossibleValueCategory, TransactionCustomFieldPossibleValue, TransactionCustomFieldValue>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="transaction_id")
    protected Transaction transaction;
    @Basic
    @Column(name="status")
    protected String status;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    protected Date expirationDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="from_id")
    private Account from;
    @Basic
    @Column(name="from_id", insertable=false, updatable=false)
    private Long fromId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="to_id")
    private Account to;
    @Basic
    @Column(name="to_id", insertable=false, updatable=false)
    private Long toId;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private TransactionNature nature;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", nullable=false)
    private Date date;
    @Basic
    @Column(name="from_name")
    private String fromName;
    @Basic
    @Column(name="to_name")
    private String toName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false)
    private TransferType type;
    @Basic
    @Column(name="amount", nullable=false)
    @CurrencyScale
    private BigDecimal amount;
    @Basic
    @Lob
    @Column(name="description")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="by_id")
    private BasicUser by;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="channel_id", nullable=false)
    private Channel channel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="principal_type_id")
    private PrincipalType principalType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="access_client_id")
    private AccessClient accessClient;
    @Basic
    @Column(name="transaction_number", nullable=true)
    @ReadOnlyFromDTO
    private String transactionNumber;
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    private Set<TransactionCustomFieldValue> customValues = new HashSet<TransactionCustomFieldValue>();
    @Basic
    @Column(name="show_to_receiver")
    protected Boolean showToReceiver;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="authorization_status", nullable=false)
    protected TransactionAuthorizationStatus authorizationStatus = TransactionAuthorizationStatus.NA;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="authorization_type", nullable=false)
    protected TransactionAuthorizationType authorizationType = TransactionAuthorizationType.NA;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="next_authorization_level_id")
    protected AuthorizationLevel nextAuthorizationLevel;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="creation_type")
    protected PaymentCreationType creationType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="received_by_id")
    protected Operator receivedBy;
    @Basic
    @Column(name="pending_notification")
    private Boolean pendingNotification;
    static final long serialVersionUID = 5085178287612078345L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_channel_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_from_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_nextAuthorizationLevel_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_receivedBy_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_to_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accessClient_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transaction_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_principalType_vh;

    @Override
    public AccessClient getAccessClient() {
        return this._persistence_get_accessClient();
    }

    @Override
    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    @Override
    public Channel getChannel() {
        return this._persistence_get_channel();
    }

    @Override
    public Currency getCurrency() {
        try {
            return this._persistence_get_type().getFrom().getCurrency();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Class<TransactionCustomField> getCustomFieldClass() {
        return TransactionCustomField.class;
    }

    @Override
    public Class<TransactionCustomFieldValue> getCustomFieldValueClass() {
        return TransactionCustomFieldValue.class;
    }

    @Override
    public Set<TransactionCustomFieldValue> getCustomValues() {
        return this._persistence_get_customValues();
    }

    @Override
    public Date getDate() {
        return this._persistence_get_date();
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    @Override
    public Account getFrom() {
        return this._persistence_get_from();
    }

    public BasicUser getFromBasicUser() {
        return this._persistence_get_by() instanceof Operator ? this._persistence_get_by() : this.getFromUser();
    }

    @Override
    public String getFromName() {
        return this._persistence_get_fromName();
    }

    public abstract Location getLocation();

    public abstract TransactionNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_type().getNetwork();
    }

    public BasicUser getPerformer() {
        User user = this.getFromUser();
        BasicUser basicUser = this.getBy();
        if (basicUser instanceof Operator && ((Operator)basicUser).getUser().equals(user)) {
            return basicUser;
        }
        return user;
    }

    public PrincipalType getPrincipalType() {
        return this._persistence_get_principalType();
    }

    public abstract Date getProcessDate();

    public BasicUser getReceiver() {
        return this.getToUser();
    }

    public String getRelatedName(InternalAccountOwner internalAccountOwner) {
        return this.isDebit(internalAccountOwner) ? this.getToName() : this.getFromName();
    }

    @Override
    public Account getTo() {
        return this._persistence_get_to();
    }

    public BasicUser getToBasicUser() {
        return this._persistence_get_receivedBy() != null ? this._persistence_get_receivedBy() : this.getToUser();
    }

    @Override
    public String getToName() {
        return this._persistence_get_toName();
    }

    @Override
    public User getToUser() {
        return this._persistence_get_to() instanceof UserAccount ? ((UserAccount)this._persistence_get_to()).getUser() : null;
    }

    public String getTransactionNumber() {
        return this._persistence_get_transactionNumber();
    }

    @Override
    public TransferType getType() {
        return this._persistence_get_type();
    }

    public boolean isPendingNotification() {
        return Boolean.TRUE.equals(this._persistence_get_pendingNotification());
    }

    public void setAccessClient(AccessClient accessClient) {
        this._persistence_set_accessClient(accessClient);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setChannel(Channel channel) {
        this._persistence_set_channel(channel);
    }

    public void setCustomValues(Set<TransactionCustomFieldValue> set) {
        this._persistence_set_customValues(set);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setDescription(String string) {
        this._persistence_set_description(string);
    }

    public void setFrom(Account account) {
        this._persistence_set_from(account);
    }

    public void setFromName(String string) {
        this._persistence_set_fromName(string);
    }

    public void setPendingNotification(boolean bl) {
        this._persistence_set_pendingNotification(bl);
    }

    public void setPrincipalType(PrincipalType principalType) {
        this._persistence_set_principalType(principalType);
    }

    public void setTo(Account account) {
        this._persistence_set_to(account);
    }

    public void setToName(String string) {
        this._persistence_set_toName(string);
    }

    public void setTransactionNumber(String string) {
        this._persistence_set_transactionNumber(string);
    }

    public void setType(TransferType transferType) {
        this._persistence_set_type(transferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_channel_vh != null) {
            this._persistence_channel_vh = (WeavedAttributeValueHolderInterface)this._persistence_channel_vh.clone();
        }
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        if (this._persistence_from_vh != null) {
            this._persistence_from_vh = (WeavedAttributeValueHolderInterface)this._persistence_from_vh.clone();
        }
        if (this._persistence_nextAuthorizationLevel_vh != null) {
            this._persistence_nextAuthorizationLevel_vh = (WeavedAttributeValueHolderInterface)this._persistence_nextAuthorizationLevel_vh.clone();
        }
        if (this._persistence_receivedBy_vh != null) {
            this._persistence_receivedBy_vh = (WeavedAttributeValueHolderInterface)this._persistence_receivedBy_vh.clone();
        }
        if (this._persistence_to_vh != null) {
            this._persistence_to_vh = (WeavedAttributeValueHolderInterface)this._persistence_to_vh.clone();
        }
        if (this._persistence_accessClient_vh != null) {
            this._persistence_accessClient_vh = (WeavedAttributeValueHolderInterface)this._persistence_accessClient_vh.clone();
        }
        if (this._persistence_transaction_vh != null) {
            this._persistence_transaction_vh = (WeavedAttributeValueHolderInterface)this._persistence_transaction_vh.clone();
        }
        if (this._persistence_principalType_vh != null) {
            this._persistence_principalType_vh = (WeavedAttributeValueHolderInterface)this._persistence_principalType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Transaction();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "toId") {
            return this.toId;
        }
        if (string == "date") {
            return this.date;
        }
        if (string == "channel") {
            return this.channel;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "authorizationStatus") {
            return this.authorizationStatus;
        }
        if (string == "toName") {
            return this.toName;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "fromName") {
            return this.fromName;
        }
        if (string == "authorizationType") {
            return this.authorizationType;
        }
        if (string == "from") {
            return this.from;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        if (string == "customValues") {
            return this.customValues;
        }
        if (string == "nextAuthorizationLevel") {
            return this.nextAuthorizationLevel;
        }
        if (string == "receivedBy") {
            return this.receivedBy;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "transactionNumber") {
            return this.transactionNumber;
        }
        if (string == "fromId") {
            return this.fromId;
        }
        if (string == "creationType") {
            return this.creationType;
        }
        if (string == "showToReceiver") {
            return this.showToReceiver;
        }
        if (string == "pendingNotification") {
            return this.pendingNotification;
        }
        if (string == "to") {
            return this.to;
        }
        if (string == "accessClient") {
            return this.accessClient;
        }
        if (string == "transaction") {
            return this.transaction;
        }
        if (string == "principalType") {
            return this.principalType;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "toId") {
            this.toId = (Long)object;
            return;
        }
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "channel") {
            this.channel = (Channel)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "type") {
            this.type = (TransferType)object;
            return;
        }
        if (string == "authorizationStatus") {
            this.authorizationStatus = (TransactionAuthorizationStatus)object;
            return;
        }
        if (string == "toName") {
            this.toName = (String)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "fromName") {
            this.fromName = (String)object;
            return;
        }
        if (string == "authorizationType") {
            this.authorizationType = (TransactionAuthorizationType)object;
            return;
        }
        if (string == "from") {
            this.from = (Account)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        if (string == "customValues") {
            this.customValues = (Set)object;
            return;
        }
        if (string == "nextAuthorizationLevel") {
            this.nextAuthorizationLevel = (AuthorizationLevel)object;
            return;
        }
        if (string == "receivedBy") {
            this.receivedBy = (Operator)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "nature") {
            this.nature = (TransactionNature)object;
            return;
        }
        if (string == "transactionNumber") {
            this.transactionNumber = (String)object;
            return;
        }
        if (string == "fromId") {
            this.fromId = (Long)object;
            return;
        }
        if (string == "creationType") {
            this.creationType = (PaymentCreationType)object;
            return;
        }
        if (string == "showToReceiver") {
            this.showToReceiver = (Boolean)object;
            return;
        }
        if (string == "pendingNotification") {
            this.pendingNotification = (Boolean)object;
            return;
        }
        if (string == "to") {
            this.to = (Account)object;
            return;
        }
        if (string == "accessClient") {
            this.accessClient = (AccessClient)object;
            return;
        }
        if (string == "transaction") {
            this.transaction = (Transaction)object;
            return;
        }
        if (string == "principalType") {
            this.principalType = (PrincipalType)object;
            return;
        }
        if (string == "status") {
            this.status = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_toId() {
        this._persistence_checkFetched("toId");
        return this.toId;
    }

    public void _persistence_set_toId(Long l) {
        this._persistence_checkFetchedForSet("toId");
        this._persistence_propertyChange("toId", this.toId, l);
        this.toId = l;
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    protected void _persistence_initialize_channel_vh() {
        if (this._persistence_channel_vh == null) {
            this._persistence_channel_vh = new ValueHolder((Object)this.channel);
            this._persistence_channel_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_channel_vh() {
        Channel channel;
        this._persistence_initialize_channel_vh();
        if ((this._persistence_channel_vh.isCoordinatedWithProperty() || this._persistence_channel_vh.isNewlyWeavedValueHolder()) && (channel = this._persistence_get_channel()) != this._persistence_channel_vh.getValue()) {
            this._persistence_set_channel(channel);
        }
        return this._persistence_channel_vh;
    }

    public void _persistence_set_channel_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_channel_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Channel channel = this._persistence_get_channel();
            if (channel != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_channel((Channel)object);
            }
        } else {
            this.channel = null;
        }
    }

    public Channel _persistence_get_channel() {
        this._persistence_checkFetched("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        return this.channel;
    }

    public void _persistence_set_channel(Channel channel) {
        this._persistence_checkFetchedForSet("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        this._persistence_propertyChange("channel", this.channel, channel);
        this.channel = channel;
        this._persistence_channel_vh.setValue((Object)channel);
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        TransferType transferType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (transferType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(transferType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TransferType transferType = this._persistence_get_type();
            if (transferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((TransferType)object);
            }
        } else {
            this.type = null;
        }
    }

    public TransferType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (TransferType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(TransferType transferType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (TransferType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, transferType);
        this.type = transferType;
        this._persistence_type_vh.setValue((Object)transferType);
    }

    public TransactionAuthorizationStatus _persistence_get_authorizationStatus() {
        this._persistence_checkFetched("authorizationStatus");
        return this.authorizationStatus;
    }

    public void _persistence_set_authorizationStatus(TransactionAuthorizationStatus transactionAuthorizationStatus) {
        this._persistence_checkFetchedForSet("authorizationStatus");
        this._persistence_propertyChange("authorizationStatus", this.authorizationStatus, transactionAuthorizationStatus);
        this.authorizationStatus = transactionAuthorizationStatus;
    }

    public String _persistence_get_toName() {
        this._persistence_checkFetched("toName");
        return this.toName;
    }

    public void _persistence_set_toName(String string) {
        this._persistence_checkFetchedForSet("toName");
        this._persistence_propertyChange("toName", this.toName, string);
        this.toName = string;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        BasicUser basicUser;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(basicUser);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_by();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((BasicUser)object);
            }
        } else {
            this.by = null;
        }
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
        this._persistence_by_vh.setValue((Object)basicUser);
    }

    public String _persistence_get_fromName() {
        this._persistence_checkFetched("fromName");
        return this.fromName;
    }

    public void _persistence_set_fromName(String string) {
        this._persistence_checkFetchedForSet("fromName");
        this._persistence_propertyChange("fromName", this.fromName, string);
        this.fromName = string;
    }

    public TransactionAuthorizationType _persistence_get_authorizationType() {
        this._persistence_checkFetched("authorizationType");
        return this.authorizationType;
    }

    public void _persistence_set_authorizationType(TransactionAuthorizationType transactionAuthorizationType) {
        this._persistence_checkFetchedForSet("authorizationType");
        this._persistence_propertyChange("authorizationType", this.authorizationType, transactionAuthorizationType);
        this.authorizationType = transactionAuthorizationType;
    }

    protected void _persistence_initialize_from_vh() {
        if (this._persistence_from_vh == null) {
            this._persistence_from_vh = new ValueHolder((Object)this.from);
            this._persistence_from_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_from_vh() {
        Account account;
        this._persistence_initialize_from_vh();
        if ((this._persistence_from_vh.isCoordinatedWithProperty() || this._persistence_from_vh.isNewlyWeavedValueHolder()) && (account = this._persistence_get_from()) != this._persistence_from_vh.getValue()) {
            this._persistence_set_from(account);
        }
        return this._persistence_from_vh;
    }

    public void _persistence_set_from_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_from_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Account account = this._persistence_get_from();
            if (account != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_from((Account)object);
            }
        } else {
            this.from = null;
        }
    }

    public Account _persistence_get_from() {
        this._persistence_checkFetched("from");
        this._persistence_initialize_from_vh();
        this.from = (Account)this._persistence_from_vh.getValue();
        return this.from;
    }

    public void _persistence_set_from(Account account) {
        this._persistence_checkFetchedForSet("from");
        this._persistence_initialize_from_vh();
        this.from = (Account)this._persistence_from_vh.getValue();
        this._persistence_propertyChange("from", this.from, account);
        this.from = account;
        this._persistence_from_vh.setValue((Object)account);
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }

    public Set _persistence_get_customValues() {
        this._persistence_checkFetched("customValues");
        return this.customValues;
    }

    public void _persistence_set_customValues(Set set) {
        this._persistence_checkFetchedForSet("customValues");
        this._persistence_propertyChange("customValues", this.customValues, set);
        this.customValues = set;
    }

    protected void _persistence_initialize_nextAuthorizationLevel_vh() {
        if (this._persistence_nextAuthorizationLevel_vh == null) {
            this._persistence_nextAuthorizationLevel_vh = new ValueHolder((Object)this.nextAuthorizationLevel);
            this._persistence_nextAuthorizationLevel_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_nextAuthorizationLevel_vh() {
        AuthorizationLevel authorizationLevel;
        this._persistence_initialize_nextAuthorizationLevel_vh();
        if ((this._persistence_nextAuthorizationLevel_vh.isCoordinatedWithProperty() || this._persistence_nextAuthorizationLevel_vh.isNewlyWeavedValueHolder()) && (authorizationLevel = this._persistence_get_nextAuthorizationLevel()) != this._persistence_nextAuthorizationLevel_vh.getValue()) {
            this._persistence_set_nextAuthorizationLevel(authorizationLevel);
        }
        return this._persistence_nextAuthorizationLevel_vh;
    }

    public void _persistence_set_nextAuthorizationLevel_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_nextAuthorizationLevel_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AuthorizationLevel authorizationLevel = this._persistence_get_nextAuthorizationLevel();
            if (authorizationLevel != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_nextAuthorizationLevel((AuthorizationLevel)object);
            }
        } else {
            this.nextAuthorizationLevel = null;
        }
    }

    public AuthorizationLevel _persistence_get_nextAuthorizationLevel() {
        this._persistence_checkFetched("nextAuthorizationLevel");
        this._persistence_initialize_nextAuthorizationLevel_vh();
        this.nextAuthorizationLevel = (AuthorizationLevel)this._persistence_nextAuthorizationLevel_vh.getValue();
        return this.nextAuthorizationLevel;
    }

    public void _persistence_set_nextAuthorizationLevel(AuthorizationLevel authorizationLevel) {
        this._persistence_checkFetchedForSet("nextAuthorizationLevel");
        this._persistence_initialize_nextAuthorizationLevel_vh();
        this.nextAuthorizationLevel = (AuthorizationLevel)this._persistence_nextAuthorizationLevel_vh.getValue();
        this._persistence_propertyChange("nextAuthorizationLevel", this.nextAuthorizationLevel, authorizationLevel);
        this.nextAuthorizationLevel = authorizationLevel;
        this._persistence_nextAuthorizationLevel_vh.setValue((Object)authorizationLevel);
    }

    protected void _persistence_initialize_receivedBy_vh() {
        if (this._persistence_receivedBy_vh == null) {
            this._persistence_receivedBy_vh = new ValueHolder((Object)this.receivedBy);
            this._persistence_receivedBy_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_receivedBy_vh() {
        Operator operator;
        this._persistence_initialize_receivedBy_vh();
        if ((this._persistence_receivedBy_vh.isCoordinatedWithProperty() || this._persistence_receivedBy_vh.isNewlyWeavedValueHolder()) && (operator = this._persistence_get_receivedBy()) != this._persistence_receivedBy_vh.getValue()) {
            this._persistence_set_receivedBy(operator);
        }
        return this._persistence_receivedBy_vh;
    }

    public void _persistence_set_receivedBy_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_receivedBy_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Operator operator = this._persistence_get_receivedBy();
            if (operator != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_receivedBy((Operator)object);
            }
        } else {
            this.receivedBy = null;
        }
    }

    public Operator _persistence_get_receivedBy() {
        this._persistence_checkFetched("receivedBy");
        this._persistence_initialize_receivedBy_vh();
        this.receivedBy = (Operator)this._persistence_receivedBy_vh.getValue();
        return this.receivedBy;
    }

    public void _persistence_set_receivedBy(Operator operator) {
        this._persistence_checkFetchedForSet("receivedBy");
        this._persistence_initialize_receivedBy_vh();
        this.receivedBy = (Operator)this._persistence_receivedBy_vh.getValue();
        this._persistence_propertyChange("receivedBy", this.receivedBy, operator);
        this.receivedBy = operator;
        this._persistence_receivedBy_vh.setValue((Object)operator);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public TransactionNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(TransactionNature transactionNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, transactionNature);
        this.nature = transactionNature;
    }

    public String _persistence_get_transactionNumber() {
        this._persistence_checkFetched("transactionNumber");
        return this.transactionNumber;
    }

    public void _persistence_set_transactionNumber(String string) {
        this._persistence_checkFetchedForSet("transactionNumber");
        this._persistence_propertyChange("transactionNumber", this.transactionNumber, string);
        this.transactionNumber = string;
    }

    public Long _persistence_get_fromId() {
        this._persistence_checkFetched("fromId");
        return this.fromId;
    }

    public void _persistence_set_fromId(Long l) {
        this._persistence_checkFetchedForSet("fromId");
        this._persistence_propertyChange("fromId", this.fromId, l);
        this.fromId = l;
    }

    public PaymentCreationType _persistence_get_creationType() {
        this._persistence_checkFetched("creationType");
        return this.creationType;
    }

    public void _persistence_set_creationType(PaymentCreationType paymentCreationType) {
        this._persistence_checkFetchedForSet("creationType");
        this._persistence_propertyChange("creationType", this.creationType, paymentCreationType);
        this.creationType = paymentCreationType;
    }

    public Boolean _persistence_get_showToReceiver() {
        this._persistence_checkFetched("showToReceiver");
        return this.showToReceiver;
    }

    public void _persistence_set_showToReceiver(Boolean bl) {
        this._persistence_checkFetchedForSet("showToReceiver");
        this._persistence_propertyChange("showToReceiver", this.showToReceiver, bl);
        this.showToReceiver = bl;
    }

    public Boolean _persistence_get_pendingNotification() {
        this._persistence_checkFetched("pendingNotification");
        return this.pendingNotification;
    }

    public void _persistence_set_pendingNotification(Boolean bl) {
        this._persistence_checkFetchedForSet("pendingNotification");
        this._persistence_propertyChange("pendingNotification", this.pendingNotification, bl);
        this.pendingNotification = bl;
    }

    protected void _persistence_initialize_to_vh() {
        if (this._persistence_to_vh == null) {
            this._persistence_to_vh = new ValueHolder((Object)this.to);
            this._persistence_to_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_to_vh() {
        Account account;
        this._persistence_initialize_to_vh();
        if ((this._persistence_to_vh.isCoordinatedWithProperty() || this._persistence_to_vh.isNewlyWeavedValueHolder()) && (account = this._persistence_get_to()) != this._persistence_to_vh.getValue()) {
            this._persistence_set_to(account);
        }
        return this._persistence_to_vh;
    }

    public void _persistence_set_to_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_to_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Account account = this._persistence_get_to();
            if (account != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_to((Account)object);
            }
        } else {
            this.to = null;
        }
    }

    public Account _persistence_get_to() {
        this._persistence_checkFetched("to");
        this._persistence_initialize_to_vh();
        this.to = (Account)this._persistence_to_vh.getValue();
        return this.to;
    }

    public void _persistence_set_to(Account account) {
        this._persistence_checkFetchedForSet("to");
        this._persistence_initialize_to_vh();
        this.to = (Account)this._persistence_to_vh.getValue();
        this._persistence_propertyChange("to", this.to, account);
        this.to = account;
        this._persistence_to_vh.setValue((Object)account);
    }

    protected void _persistence_initialize_accessClient_vh() {
        if (this._persistence_accessClient_vh == null) {
            this._persistence_accessClient_vh = new ValueHolder((Object)this.accessClient);
            this._persistence_accessClient_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accessClient_vh() {
        AccessClient accessClient;
        this._persistence_initialize_accessClient_vh();
        if ((this._persistence_accessClient_vh.isCoordinatedWithProperty() || this._persistence_accessClient_vh.isNewlyWeavedValueHolder()) && (accessClient = this._persistence_get_accessClient()) != this._persistence_accessClient_vh.getValue()) {
            this._persistence_set_accessClient(accessClient);
        }
        return this._persistence_accessClient_vh;
    }

    public void _persistence_set_accessClient_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accessClient_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccessClient accessClient = this._persistence_get_accessClient();
            if (accessClient != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accessClient((AccessClient)object);
            }
        } else {
            this.accessClient = null;
        }
    }

    public AccessClient _persistence_get_accessClient() {
        this._persistence_checkFetched("accessClient");
        this._persistence_initialize_accessClient_vh();
        this.accessClient = (AccessClient)this._persistence_accessClient_vh.getValue();
        return this.accessClient;
    }

    public void _persistence_set_accessClient(AccessClient accessClient) {
        this._persistence_checkFetchedForSet("accessClient");
        this._persistence_initialize_accessClient_vh();
        this.accessClient = (AccessClient)this._persistence_accessClient_vh.getValue();
        this._persistence_propertyChange("accessClient", this.accessClient, accessClient);
        this.accessClient = accessClient;
        this._persistence_accessClient_vh.setValue((Object)accessClient);
    }

    protected void _persistence_initialize_transaction_vh() {
        if (this._persistence_transaction_vh == null) {
            this._persistence_transaction_vh = new ValueHolder((Object)this.transaction);
            this._persistence_transaction_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transaction_vh() {
        Transaction transaction;
        this._persistence_initialize_transaction_vh();
        if ((this._persistence_transaction_vh.isCoordinatedWithProperty() || this._persistence_transaction_vh.isNewlyWeavedValueHolder()) && (transaction = this._persistence_get_transaction()) != this._persistence_transaction_vh.getValue()) {
            this._persistence_set_transaction(transaction);
        }
        return this._persistence_transaction_vh;
    }

    public void _persistence_set_transaction_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transaction_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Transaction transaction = this._persistence_get_transaction();
            if (transaction != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transaction((Transaction)object);
            }
        } else {
            this.transaction = null;
        }
    }

    public Transaction _persistence_get_transaction() {
        this._persistence_checkFetched("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (Transaction)this._persistence_transaction_vh.getValue();
        return this.transaction;
    }

    public void _persistence_set_transaction(Transaction transaction) {
        this._persistence_checkFetchedForSet("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (Transaction)this._persistence_transaction_vh.getValue();
        this._persistence_propertyChange("transaction", this.transaction, transaction);
        this.transaction = transaction;
        this._persistence_transaction_vh.setValue((Object)transaction);
    }

    protected void _persistence_initialize_principalType_vh() {
        if (this._persistence_principalType_vh == null) {
            this._persistence_principalType_vh = new ValueHolder((Object)this.principalType);
            this._persistence_principalType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_principalType_vh() {
        PrincipalType principalType;
        this._persistence_initialize_principalType_vh();
        if ((this._persistence_principalType_vh.isCoordinatedWithProperty() || this._persistence_principalType_vh.isNewlyWeavedValueHolder()) && (principalType = this._persistence_get_principalType()) != this._persistence_principalType_vh.getValue()) {
            this._persistence_set_principalType(principalType);
        }
        return this._persistence_principalType_vh;
    }

    public void _persistence_set_principalType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_principalType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PrincipalType principalType = this._persistence_get_principalType();
            if (principalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_principalType((PrincipalType)object);
            }
        } else {
            this.principalType = null;
        }
    }

    public PrincipalType _persistence_get_principalType() {
        this._persistence_checkFetched("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        return this.principalType;
    }

    public void _persistence_set_principalType(PrincipalType principalType) {
        this._persistence_checkFetchedForSet("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        this._persistence_propertyChange("principalType", this.principalType, principalType);
        this.principalType = principalType;
        this._persistence_principalType_vh.setValue((Object)principalType);
    }

    public String _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(String string) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, string);
        this.status = string;
    }
}

