/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeRestrictTo;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.references.TransactionFeedbackSetting;
import org.cyclos.model.utils.TimeField;
import org.cyclos.utils.BigDecimalHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="PAYMENT")
public class PaymentTransferType
extends TransferType
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="enabled")
    private Boolean enabled;
    @Basic
    @Lob
    @Column(name="confirmation_message")
    private String confirmationMessage;
    @Basic
    @Column(name="requires_authorization")
    private boolean requiresAuthorization;
    @OneToMany(mappedBy="transferType", cascade={CascadeType.REMOVE})
    @OrderBy(value="level")
    private List<AuthorizationLevel> authorizationLevels = new ArrayList<AuthorizationLevel>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="maturity_policy")
    private MaturityPolicy maturityPolicy;
    @Basic
    @Column(name="maturity_history_size")
    private Integer maturityHistorySize;
    @ManyToMany
    @JoinTable(name="transfer_types_custom_fields", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<TransactionCustomField> customFields = new HashSet<TransactionCustomField>();
    @Basic
    @Column(name="allow_from_custom_name")
    private boolean allowFromCustomName;
    @Basic
    @Column(name="allow_to_custom_name")
    private boolean allowToCustomName;
    @Basic
    @Column(name="default_feedback_comments")
    private String defaultFeedbackComments;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="payment_restrict_to")
    private PaymentTransferTypeRestrictTo restrictTo;
    @ManyToMany
    @JoinTable(name="payment_transfer_types_groups", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> restrictToGroups = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="payment_transfer_types_users", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<User> restrictToUsers = new HashSet<User>();
    @Basic
    @Column(name="payment_max_amount")
    @CurrencyScale
    private BigDecimal maxAmount;
    @Basic
    @Column(name="payment_min_amount")
    @CurrencyScale
    private BigDecimal minAmount;
    @Basic
    @Column(name="payment_max_amount_per_day")
    @CurrencyScale
    private BigDecimal maxAmountPerDay;
    @Basic
    @Column(name="payment_max_amount_per_week")
    @CurrencyScale
    private BigDecimal maxAmountPerWeek;
    @Basic
    @Column(name="payment_max_amount_per_month")
    @CurrencyScale
    private BigDecimal maxAmountPerMonth;
    @Basic
    @Column(name="payment_max_amount_per_year")
    @CurrencyScale
    private BigDecimal maxAmountPerYear;
    @Basic
    @Column(name="payment_max_amount_pinless")
    @CurrencyScale
    private BigDecimal maxAmountPinless;
    @Basic
    @Column(name="payment_max_amount_pinless_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPinlessTrustedDevices;
    @Basic
    @Column(name="payment_max_amount_per_day_pinless")
    @CurrencyScale
    private BigDecimal maxAmountPerDayPinless;
    @Basic
    @Column(name="payment_max_amount_per_day_pinless_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPerDayPinlessTrustedDevices;
    @Basic
    @Column(name="payment_max_transfers_per_day")
    private Integer maxTransfersPerDay;
    @Basic
    @Column(name="payment_max_transfers_per_week")
    private Integer maxTransfersPerWeek;
    @Basic
    @Column(name="payment_max_transfers_per_month")
    private Integer maxTransfersPerMonth;
    @Basic
    @Column(name="payment_max_amount_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountTrustedDevices;
    @Basic
    @Column(name="payment_max_amount_per_day_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPerDayTrustedDevices;
    @Basic
    @Column(name="payment_max_amount_per_week_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPerWeekTrustedDevices;
    @Basic
    @Column(name="payment_max_amount_per_month_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPerMonthTrustedDevices;
    @Basic
    @Column(name="payment_max_amount_per_year_trusted_devices")
    @CurrencyScale
    private BigDecimal maxAmountPerYearTrustedDevices;
    @Basic
    @Column(name="payment_max_transfers_per_day_trusted_devices")
    private Integer maxTransfersPerDayTrustedDevices;
    @Basic
    @Column(name="payment_max_transfers_per_week_trusted_devices")
    private Integer maxTransfersPerWeekTrustedDevices;
    @Basic
    @Column(name="payment_max_transfers_per_month_trusted_devices")
    private Integer maxTransfersPerMonthTrustedDevices;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="min_time_between_transfers_amount")), @AttributeOverride(name="field", column=@Column(name="min_time_between_transfers_field"))})
    private TimeInterval minTimeBetweenTransfers;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="request_default_expiration_interval_amount")), @AttributeOverride(name="field", column=@Column(name="request_default_expiration_interval_field"))})
    private TimeInterval defaultPaymentRequestExpirationPeriod;
    @Basic
    @Column(name="hide_payment_request_expiration")
    private Boolean hidePaymentRequestExpirationDate;
    @Basic
    @Column(name="skip_confirmation")
    private Boolean skipConfirmation;
    @ManyToMany
    @JoinTable(name="payment_transfer_types_channels", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="channel_id")})
    private Set<Channel> channels = new HashSet<Channel>();
    @ManyToMany
    @JoinTable(name="payment_transfer_types_principal_types", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})
    private Set<PrincipalType> principalTypes = new HashSet<PrincipalType>();
    @Basic
    @Column(name="payment_priority")
    private Boolean priority;
    @Basic
    @Column(name="transaction_requires_feedback")
    private Boolean requiresFeedback;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="transaction_feedback_setting")
    private TransactionFeedbackSetting feedbackSetting;
    @Basic
    @Column(name="transaction_feedback_enabled_since")
    @ReadOnlyFromDTO
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date feedbackEnabledSince;
    @Basic
    @Column(name="transaction_feedback_expiration_days")
    private Integer feedbackExpirationDays;
    @Basic
    @Column(name="transaction_feedback_reminder_days")
    private Integer feedbackReminderDays;
    @Basic
    @Column(name="max_days_to_change_feedback")
    private Integer maxDaysToChangeFeedback;
    @Basic
    @Column(name="transaction_feedback_expiration_reminder_days")
    private Integer feedbackExpirationReminderDays;
    @Basic
    @Column(name="transaction_feedback_reply_expiration_days")
    private Integer feedbackReplyExpirationDays;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="transaction_default_feedback_level")
    private ReferenceLevel defaultFeedbackLevel;
    @Basic
    @Column(name="allows_recurring_payments")
    private Boolean allowsRecurringPayments;
    @Basic
    @Column(name="show_recurring_payments_to_receiver")
    private Boolean showRecurringPaymentsToReceiver;
    @Basic
    @Column(name="allows_scheduled_payments")
    private Boolean allowsScheduledPayments;
    @Basic
    @Column(name="reserve_total_amount_on_scheduled_payments")
    private Boolean reserveTotalAmountOnScheduledPayments;
    @Basic
    @Column(name="show_scheduled_payments_to_receiver")
    private Boolean showScheduledPaymentsToReceiver;
    @Basic
    @Column(name="notify_payment_performed")
    private Boolean notifyPaymentPerformed;
    @Basic
    @Column(name="max_installments")
    private Integer maxInstallments;
    @ManyToMany(mappedBy="systemPayments")
    private Set<AdminProduct> systemPaymentsOnProducts;
    @ManyToMany(mappedBy="myPaymentTypes")
    private Set<MemberProduct> myPaymentsOnProducts;
    @ManyToMany(mappedBy="paymentsAsUser")
    private Set<UserManagementProduct> userPaymentsOnProducts;
    @ManyToMany(mappedBy="chargebackPaymentsToUser")
    private Set<UserManagementProduct> chargebackPaymentsToUserOnProducts;
    @ManyToMany(mappedBy="chargebackPaymentsToSystem")
    private Set<AdminProduct> chargebackPaymentsToSystemOnProducts;
    @ManyToMany(mappedBy="systemToUserExternalPayments")
    private Set<AdminProduct> systemToUserExternalPaymentOnProducts;
    @ManyToMany(mappedBy="externalPaymentsAsUser")
    private Set<UserManagementProduct> externalPaymentsAsUserOnProducts;
    @ManyToMany(mappedBy="myExternalPaymentTypes")
    private Set<MemberProduct> myExternalPaymentTypesOnProducts;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="authorization_expiration_period_amount")), @AttributeOverride(name="field", column=@Column(name="authorization_expiration_period_field"))})
    private TimeInterval authorizationExpirationPeriod = new TimeInterval(30, TimeField.DAYS);
    @Column(name="reserve_approved_ticket_amount")
    private Boolean reserveApprovedTicketAmount;
    static final long serialVersionUID = 8224776681925951039L;

    public void addAuthorizationLevel(AuthorizationLevel authorizationLevel) {
        this._persistence_get_authorizationLevels().add(authorizationLevel);
        authorizationLevel.setTransferType(this);
    }

    public TimeInterval getAuthorizationExpirationPeriod() {
        return this._persistence_get_authorizationExpirationPeriod();
    }

    public List<AuthorizationLevel> getAuthorizationLevels() {
        return this._persistence_get_authorizationLevels();
    }

    public Set<Channel> getChannels() {
        return this._persistence_get_channels();
    }

    public String getConfirmationMessage() {
        return this._persistence_get_confirmationMessage();
    }

    public Set<TransactionCustomField> getCustomFields() {
        return this._persistence_get_customFields();
    }

    public String getDefaultFeedbackComments() {
        return this._persistence_get_defaultFeedbackComments();
    }

    public ReferenceLevel getDefaultFeedbackLevel() {
        return this._persistence_get_defaultFeedbackLevel();
    }

    public TimeInterval getDefaultPaymentRequestExpirationPeriod() {
        return this._persistence_get_defaultPaymentRequestExpirationPeriod();
    }

    public Date getFeedbackEnabledSince() {
        return this._persistence_get_feedbackEnabledSince();
    }

    public Integer getFeedbackExpirationDays() {
        return this._persistence_get_feedbackExpirationDays();
    }

    public Integer getFeedbackExpirationReminderDays() {
        return this._persistence_get_feedbackExpirationReminderDays();
    }

    public Integer getFeedbackReminderDays() {
        return this._persistence_get_feedbackReminderDays();
    }

    public Integer getFeedbackReplyExpirationDays() {
        return this._persistence_get_feedbackReplyExpirationDays();
    }

    public TransactionFeedbackSetting getFeedbackSetting() {
        return this._persistence_get_feedbackSetting();
    }

    @CurrencyScale
    public BigDecimal getFixedAmount() {
        if (this.isUseFixedAmount()) {
            return this._persistence_get_minAmount();
        }
        return null;
    }

    public Integer getMaturityHistorySize() {
        return this._persistence_get_maturityHistorySize();
    }

    public MaturityPolicy getMaturityPolicy() {
        return this._persistence_get_maturityPolicy();
    }

    public BigDecimal getMaxAmount() {
        return this._persistence_get_maxAmount();
    }

    public BigDecimal getMaxAmountPerDay() {
        return this._persistence_get_maxAmountPerDay();
    }

    public BigDecimal getMaxAmountPerDayPinless() {
        return this._persistence_get_maxAmountPerDayPinless();
    }

    public BigDecimal getMaxAmountPerDayPinlessTrustedDevices() {
        return this._persistence_get_maxAmountPerDayPinlessTrustedDevices();
    }

    public BigDecimal getMaxAmountPerDayTrustedDevices() {
        return this._persistence_get_maxAmountPerDayTrustedDevices();
    }

    public BigDecimal getMaxAmountPerMonth() {
        return this._persistence_get_maxAmountPerMonth();
    }

    public BigDecimal getMaxAmountPerMonthTrustedDevices() {
        return this._persistence_get_maxAmountPerMonthTrustedDevices();
    }

    public BigDecimal getMaxAmountPerWeek() {
        return this._persistence_get_maxAmountPerWeek();
    }

    public BigDecimal getMaxAmountPerWeekTrustedDevices() {
        return this._persistence_get_maxAmountPerWeekTrustedDevices();
    }

    public BigDecimal getMaxAmountPerYear() {
        return this._persistence_get_maxAmountPerYear();
    }

    public BigDecimal getMaxAmountPerYearTrustedDevices() {
        return this._persistence_get_maxAmountPerYearTrustedDevices();
    }

    public BigDecimal getMaxAmountPinless() {
        return this._persistence_get_maxAmountPinless();
    }

    public BigDecimal getMaxAmountPinlessTrustedDevices() {
        return this._persistence_get_maxAmountPinlessTrustedDevices();
    }

    public BigDecimal getMaxAmountTrustedDevices() {
        return this._persistence_get_maxAmountTrustedDevices();
    }

    public Integer getMaxDaysToChangeFeedback() {
        return this._persistence_get_maxDaysToChangeFeedback();
    }

    public Integer getMaxInstallments() {
        return this._persistence_get_maxInstallments();
    }

    public Integer getMaxTransfersPerDay() {
        return this._persistence_get_maxTransfersPerDay();
    }

    public Integer getMaxTransfersPerDayTrustedDevices() {
        return this._persistence_get_maxTransfersPerDayTrustedDevices();
    }

    public Integer getMaxTransfersPerMonth() {
        return this._persistence_get_maxTransfersPerMonth();
    }

    public Integer getMaxTransfersPerMonthTrustedDevices() {
        return this._persistence_get_maxTransfersPerMonthTrustedDevices();
    }

    public Integer getMaxTransfersPerWeek() {
        return this._persistence_get_maxTransfersPerWeek();
    }

    public Integer getMaxTransfersPerWeekTrustedDevices() {
        return this._persistence_get_maxTransfersPerWeekTrustedDevices();
    }

    public BigDecimal getMinAmount() {
        return this._persistence_get_minAmount();
    }

    public TimeInterval getMinTimeBetweenTransfers() {
        return this._persistence_get_minTimeBetweenTransfers();
    }

    @Override
    public TransferTypeNature getNature() {
        return TransferTypeNature.PAYMENT;
    }

    public Set<PrincipalType> getPrincipalTypes() {
        return this._persistence_get_principalTypes();
    }

    public PaymentTransferTypeRestrictTo getRestrictTo() {
        return this._persistence_get_restrictTo();
    }

    public Set<BasicGroup> getRestrictToGroups() {
        return this._persistence_get_restrictToGroups();
    }

    public Set<User> getRestrictToUsers() {
        return this._persistence_get_restrictToUsers();
    }

    public boolean isAllowFromCustomName() {
        return Boolean.TRUE.equals(this._persistence_get_allowFromCustomName());
    }

    public boolean isAllowsRecurringPayments() {
        return Boolean.TRUE.equals(this._persistence_get_allowsRecurringPayments());
    }

    public boolean isAllowsScheduledPayments() {
        return Boolean.TRUE.equals(this._persistence_get_allowsScheduledPayments());
    }

    public boolean isAllowToCustomName() {
        return Boolean.TRUE.equals(this._persistence_get_allowToCustomName());
    }

    @Override
    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public boolean isHidePaymentRequestExpirationDate() {
        return Boolean.TRUE.equals(this._persistence_get_hidePaymentRequestExpirationDate());
    }

    public boolean isNotifyPaymentPerformed() {
        return Boolean.TRUE.equals(this._persistence_get_notifyPaymentPerformed());
    }

    public boolean isPriority() {
        return Boolean.TRUE.equals(this._persistence_get_priority());
    }

    public boolean isRequiresAuthorization() {
        return Boolean.TRUE.equals(this._persistence_get_requiresAuthorization());
    }

    public boolean isRequiresFeedback() {
        return Boolean.TRUE.equals(this._persistence_get_requiresFeedback());
    }

    public boolean isReserveApprovedTicketAmount() {
        return Boolean.TRUE.equals(this._persistence_get_reserveApprovedTicketAmount());
    }

    public boolean isReserveTotalAmountOnScheduledPayments() {
        return Boolean.TRUE.equals(this._persistence_get_reserveTotalAmountOnScheduledPayments());
    }

    public boolean isShowRecurringPaymentsToReceiver() {
        return Boolean.TRUE.equals(this._persistence_get_showRecurringPaymentsToReceiver());
    }

    public boolean isShowScheduledPaymentsToReceiver() {
        return Boolean.TRUE.equals(this._persistence_get_showScheduledPaymentsToReceiver());
    }

    public boolean isSkipConfirmation() {
        return Boolean.TRUE.equals(this._persistence_get_skipConfirmation());
    }

    public boolean isUseFixedAmount() {
        return this._persistence_get_minAmount() != null && BigDecimalHelper.areEquals((BigDecimal)this._persistence_get_minAmount(), (BigDecimal)this._persistence_get_maxAmount());
    }

    public void setAllowFromCustomName(boolean bl) {
        this._persistence_set_allowFromCustomName(bl);
    }

    public void setAllowsRecurringPayments(boolean bl) {
        this._persistence_set_allowsRecurringPayments(bl);
    }

    public void setAllowsScheduledPayments(boolean bl) {
        this._persistence_set_allowsScheduledPayments(bl);
    }

    public void setAllowToCustomName(boolean bl) {
        this._persistence_set_allowToCustomName(bl);
    }

    public void setAuthorizationExpirationPeriod(TimeInterval timeInterval) {
        this._persistence_set_authorizationExpirationPeriod(timeInterval);
    }

    public void setAuthorizationLevels(List<AuthorizationLevel> list) {
        this._persistence_set_authorizationLevels(list);
    }

    public void setChannels(Set<Channel> set) {
        this._persistence_set_channels(set);
    }

    public void setConfirmationMessage(String string) {
        this._persistence_set_confirmationMessage(string);
    }

    public void setCustomFields(Set<TransactionCustomField> set) {
        this._persistence_set_customFields(set);
    }

    public void setDefaultFeedbackComments(String string) {
        this._persistence_set_defaultFeedbackComments(string);
    }

    public void setDefaultFeedbackLevel(ReferenceLevel referenceLevel) {
        this._persistence_set_defaultFeedbackLevel(referenceLevel);
    }

    public void setDefaultPaymentRequestExpirationPeriod(TimeInterval timeInterval) {
        this._persistence_set_defaultPaymentRequestExpirationPeriod(timeInterval);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setFeedbackEnabledSince(Date date) {
        this._persistence_set_feedbackEnabledSince(date);
    }

    public void setFeedbackExpirationDays(Integer n) {
        this._persistence_set_feedbackExpirationDays(n);
    }

    public void setFeedbackExpirationReminderDays(Integer n) {
        this._persistence_set_feedbackExpirationReminderDays(n);
    }

    public void setFeedbackReminderDays(Integer n) {
        this._persistence_set_feedbackReminderDays(n);
    }

    public void setFeedbackReplyExpirationDays(Integer n) {
        this._persistence_set_feedbackReplyExpirationDays(n);
    }

    public void setFeedbackSetting(TransactionFeedbackSetting transactionFeedbackSetting) {
        this._persistence_set_feedbackSetting(transactionFeedbackSetting);
    }

    public void setHidePaymentRequestExpirationDate(boolean bl) {
        this._persistence_set_hidePaymentRequestExpirationDate(bl);
    }

    public void setMaturityHistorySize(Integer n) {
        this._persistence_set_maturityHistorySize(n);
    }

    public void setMaturityPolicy(MaturityPolicy maturityPolicy) {
        this._persistence_set_maturityPolicy(maturityPolicy);
    }

    public void setMaxAmount(BigDecimal bigDecimal) {
        this._persistence_set_maxAmount(bigDecimal);
    }

    public void setMaxAmountPerDay(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerDay(bigDecimal);
    }

    public void setMaxAmountPerDayPinless(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerDayPinless(bigDecimal);
    }

    public void setMaxAmountPerDayPinlessTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerDayPinlessTrustedDevices(bigDecimal);
    }

    public void setMaxAmountPerDayTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerDayTrustedDevices(bigDecimal);
    }

    public void setMaxAmountPerMonth(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerMonth(bigDecimal);
    }

    public void setMaxAmountPerMonthTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerMonthTrustedDevices(bigDecimal);
    }

    public void setMaxAmountPerWeek(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerWeek(bigDecimal);
    }

    public void setMaxAmountPerWeekTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerWeekTrustedDevices(bigDecimal);
    }

    public void setMaxAmountPerYear(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerYear(bigDecimal);
    }

    public void setMaxAmountPerYearTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerYearTrustedDevices(bigDecimal);
    }

    public void setMaxAmountPinless(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPinless(bigDecimal);
    }

    public void setMaxAmountPinlessTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPinlessTrustedDevices(bigDecimal);
    }

    public void setMaxAmountTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountTrustedDevices(bigDecimal);
    }

    public void setMaxDaysToChangeFeedback(Integer n) {
        this._persistence_set_maxDaysToChangeFeedback(n);
    }

    public void setMaxInstallments(Integer n) {
        this._persistence_set_maxInstallments(n);
    }

    public void setMaxTransfersPerDay(Integer n) {
        this._persistence_set_maxTransfersPerDay(n);
    }

    public void setMaxTransfersPerDayTrustedDevices(Integer n) {
        this._persistence_set_maxTransfersPerDayTrustedDevices(n);
    }

    public void setMaxTransfersPerMonth(Integer n) {
        this._persistence_set_maxTransfersPerMonth(n);
    }

    public void setMaxTransfersPerMonthTrustedDevices(Integer n) {
        this._persistence_set_maxTransfersPerMonthTrustedDevices(n);
    }

    public void setMaxTransfersPerWeek(Integer n) {
        this._persistence_set_maxTransfersPerWeek(n);
    }

    public void setMaxTransfersPerWeekTrustedDevices(Integer n) {
        this._persistence_set_maxTransfersPerWeekTrustedDevices(n);
    }

    public void setMinAmount(BigDecimal bigDecimal) {
        this._persistence_set_minAmount(bigDecimal);
    }

    public void setMinTimeBetweenTransfers(TimeInterval timeInterval) {
        this._persistence_set_minTimeBetweenTransfers(timeInterval);
    }

    public void setNotifyPaymentPerformed(Boolean bl) {
        this._persistence_set_notifyPaymentPerformed(bl);
    }

    public void setPrincipalTypes(Set<PrincipalType> set) {
        this._persistence_set_principalTypes(set);
    }

    public void setPriority(boolean bl) {
        this._persistence_set_priority(bl);
    }

    public void setRequiresAuthorization(boolean bl) {
        this._persistence_set_requiresAuthorization(bl);
    }

    public void setRequiresFeedback(boolean bl) {
        this._persistence_set_requiresFeedback(bl);
    }

    public void setReserveApprovedTicketAmount(boolean bl) {
        this._persistence_set_reserveApprovedTicketAmount(bl);
    }

    public void setReserveTotalAmountOnScheduledPayments(boolean bl) {
        this._persistence_set_reserveTotalAmountOnScheduledPayments(bl);
    }

    public void setRestrictTo(PaymentTransferTypeRestrictTo paymentTransferTypeRestrictTo) {
        this._persistence_set_restrictTo(paymentTransferTypeRestrictTo);
    }

    public void setRestrictToGroups(Set<BasicGroup> set) {
        this._persistence_set_restrictToGroups(set);
    }

    public void setRestrictToUsers(Set<User> set) {
        this._persistence_set_restrictToUsers(set);
    }

    public void setShowRecurringPaymentsToReceiver(boolean bl) {
        this._persistence_set_showRecurringPaymentsToReceiver(bl);
    }

    public void setShowScheduledPaymentsToReceiver(boolean bl) {
        this._persistence_set_showScheduledPaymentsToReceiver(bl);
    }

    public void setSkipConfirmation(boolean bl) {
        this._persistence_set_skipConfirmation(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PaymentTransferType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "authorizationLevels") {
            return this.authorizationLevels;
        }
        if (string == "feedbackSetting") {
            return this.feedbackSetting;
        }
        if (string == "feedbackReminderDays") {
            return this.feedbackReminderDays;
        }
        if (string == "myExternalPaymentTypesOnProducts") {
            return this.myExternalPaymentTypesOnProducts;
        }
        if (string == "maxDaysToChangeFeedback") {
            return this.maxDaysToChangeFeedback;
        }
        if (string == "maxAmountPerMonth") {
            return this.maxAmountPerMonth;
        }
        if (string == "maxAmountPerDayPinlessTrustedDevices") {
            return this.maxAmountPerDayPinlessTrustedDevices;
        }
        if (string == "maxAmountPinless") {
            return this.maxAmountPinless;
        }
        if (string == "systemToUserExternalPaymentOnProducts") {
            return this.systemToUserExternalPaymentOnProducts;
        }
        if (string == "feedbackEnabledSince") {
            return this.feedbackEnabledSince;
        }
        if (string == "hidePaymentRequestExpirationDate") {
            return this.hidePaymentRequestExpirationDate;
        }
        if (string == "maxTransfersPerDayTrustedDevices") {
            return this.maxTransfersPerDayTrustedDevices;
        }
        if (string == "maxTransfersPerMonthTrustedDevices") {
            return this.maxTransfersPerMonthTrustedDevices;
        }
        if (string == "feedbackExpirationReminderDays") {
            return this.feedbackExpirationReminderDays;
        }
        if (string == "chargebackPaymentsToUserOnProducts") {
            return this.chargebackPaymentsToUserOnProducts;
        }
        if (string == "maxTransfersPerMonth") {
            return this.maxTransfersPerMonth;
        }
        if (string == "systemPaymentsOnProducts") {
            return this.systemPaymentsOnProducts;
        }
        if (string == "skipConfirmation") {
            return this.skipConfirmation;
        }
        if (string == "maxInstallments") {
            return this.maxInstallments;
        }
        if (string == "maturityPolicy") {
            return this.maturityPolicy;
        }
        if (string == "feedbackReplyExpirationDays") {
            return this.feedbackReplyExpirationDays;
        }
        if (string == "maxAmountPerDayPinless") {
            return this.maxAmountPerDayPinless;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "reserveTotalAmountOnScheduledPayments") {
            return this.reserveTotalAmountOnScheduledPayments;
        }
        if (string == "maxAmountPerYearTrustedDevices") {
            return this.maxAmountPerYearTrustedDevices;
        }
        if (string == "showScheduledPaymentsToReceiver") {
            return this.showScheduledPaymentsToReceiver;
        }
        if (string == "restrictToUsers") {
            return this.restrictToUsers;
        }
        if (string == "maxTransfersPerWeek") {
            return this.maxTransfersPerWeek;
        }
        if (string == "authorizationExpirationPeriod") {
            return this.authorizationExpirationPeriod;
        }
        if (string == "channels") {
            return this.channels;
        }
        if (string == "principalTypes") {
            return this.principalTypes;
        }
        if (string == "maxAmountPerWeek") {
            return this.maxAmountPerWeek;
        }
        if (string == "maxAmountPerWeekTrustedDevices") {
            return this.maxAmountPerWeekTrustedDevices;
        }
        if (string == "maturityHistorySize") {
            return this.maturityHistorySize;
        }
        if (string == "restrictToGroups") {
            return this.restrictToGroups;
        }
        if (string == "maxAmountPinlessTrustedDevices") {
            return this.maxAmountPinlessTrustedDevices;
        }
        if (string == "minAmount") {
            return this.minAmount;
        }
        if (string == "defaultFeedbackLevel") {
            return this.defaultFeedbackLevel;
        }
        if (string == "notifyPaymentPerformed") {
            return this.notifyPaymentPerformed;
        }
        if (string == "customFields") {
            return this.customFields;
        }
        if (string == "allowsScheduledPayments") {
            return this.allowsScheduledPayments;
        }
        if (string == "maxAmountPerMonthTrustedDevices") {
            return this.maxAmountPerMonthTrustedDevices;
        }
        if (string == "showRecurringPaymentsToReceiver") {
            return this.showRecurringPaymentsToReceiver;
        }
        if (string == "feedbackExpirationDays") {
            return this.feedbackExpirationDays;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "maxTransfersPerDay") {
            return this.maxTransfersPerDay;
        }
        if (string == "externalPaymentsAsUserOnProducts") {
            return this.externalPaymentsAsUserOnProducts;
        }
        if (string == "maxAmount") {
            return this.maxAmount;
        }
        if (string == "myPaymentsOnProducts") {
            return this.myPaymentsOnProducts;
        }
        if (string == "requiresAuthorization") {
            return this.requiresAuthorization;
        }
        if (string == "allowFromCustomName") {
            return this.allowFromCustomName;
        }
        if (string == "chargebackPaymentsToSystemOnProducts") {
            return this.chargebackPaymentsToSystemOnProducts;
        }
        if (string == "userPaymentsOnProducts") {
            return this.userPaymentsOnProducts;
        }
        if (string == "allowToCustomName") {
            return this.allowToCustomName;
        }
        if (string == "maxAmountPerDayTrustedDevices") {
            return this.maxAmountPerDayTrustedDevices;
        }
        if (string == "defaultPaymentRequestExpirationPeriod") {
            return this.defaultPaymentRequestExpirationPeriod;
        }
        if (string == "maxAmountPerDay") {
            return this.maxAmountPerDay;
        }
        if (string == "minTimeBetweenTransfers") {
            return this.minTimeBetweenTransfers;
        }
        if (string == "allowsRecurringPayments") {
            return this.allowsRecurringPayments;
        }
        if (string == "reserveApprovedTicketAmount") {
            return this.reserveApprovedTicketAmount;
        }
        if (string == "defaultFeedbackComments") {
            return this.defaultFeedbackComments;
        }
        if (string == "maxAmountTrustedDevices") {
            return this.maxAmountTrustedDevices;
        }
        if (string == "maxTransfersPerWeekTrustedDevices") {
            return this.maxTransfersPerWeekTrustedDevices;
        }
        if (string == "restrictTo") {
            return this.restrictTo;
        }
        if (string == "requiresFeedback") {
            return this.requiresFeedback;
        }
        if (string == "maxAmountPerYear") {
            return this.maxAmountPerYear;
        }
        if (string == "confirmationMessage") {
            return this.confirmationMessage;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "authorizationLevels") {
            this.authorizationLevels = (List)object;
            return;
        }
        if (string == "feedbackSetting") {
            this.feedbackSetting = (TransactionFeedbackSetting)object;
            return;
        }
        if (string == "feedbackReminderDays") {
            this.feedbackReminderDays = (Integer)object;
            return;
        }
        if (string == "myExternalPaymentTypesOnProducts") {
            this.myExternalPaymentTypesOnProducts = (Set)object;
            return;
        }
        if (string == "maxDaysToChangeFeedback") {
            this.maxDaysToChangeFeedback = (Integer)object;
            return;
        }
        if (string == "maxAmountPerMonth") {
            this.maxAmountPerMonth = (BigDecimal)object;
            return;
        }
        if (string == "maxAmountPerDayPinlessTrustedDevices") {
            this.maxAmountPerDayPinlessTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "maxAmountPinless") {
            this.maxAmountPinless = (BigDecimal)object;
            return;
        }
        if (string == "systemToUserExternalPaymentOnProducts") {
            this.systemToUserExternalPaymentOnProducts = (Set)object;
            return;
        }
        if (string == "feedbackEnabledSince") {
            this.feedbackEnabledSince = (Date)object;
            return;
        }
        if (string == "hidePaymentRequestExpirationDate") {
            this.hidePaymentRequestExpirationDate = (Boolean)object;
            return;
        }
        if (string == "maxTransfersPerDayTrustedDevices") {
            this.maxTransfersPerDayTrustedDevices = (Integer)object;
            return;
        }
        if (string == "maxTransfersPerMonthTrustedDevices") {
            this.maxTransfersPerMonthTrustedDevices = (Integer)object;
            return;
        }
        if (string == "feedbackExpirationReminderDays") {
            this.feedbackExpirationReminderDays = (Integer)object;
            return;
        }
        if (string == "chargebackPaymentsToUserOnProducts") {
            this.chargebackPaymentsToUserOnProducts = (Set)object;
            return;
        }
        if (string == "maxTransfersPerMonth") {
            this.maxTransfersPerMonth = (Integer)object;
            return;
        }
        if (string == "systemPaymentsOnProducts") {
            this.systemPaymentsOnProducts = (Set)object;
            return;
        }
        if (string == "skipConfirmation") {
            this.skipConfirmation = (Boolean)object;
            return;
        }
        if (string == "maxInstallments") {
            this.maxInstallments = (Integer)object;
            return;
        }
        if (string == "maturityPolicy") {
            this.maturityPolicy = (MaturityPolicy)object;
            return;
        }
        if (string == "feedbackReplyExpirationDays") {
            this.feedbackReplyExpirationDays = (Integer)object;
            return;
        }
        if (string == "maxAmountPerDayPinless") {
            this.maxAmountPerDayPinless = (BigDecimal)object;
            return;
        }
        if (string == "priority") {
            this.priority = (Boolean)object;
            return;
        }
        if (string == "reserveTotalAmountOnScheduledPayments") {
            this.reserveTotalAmountOnScheduledPayments = (Boolean)object;
            return;
        }
        if (string == "maxAmountPerYearTrustedDevices") {
            this.maxAmountPerYearTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "showScheduledPaymentsToReceiver") {
            this.showScheduledPaymentsToReceiver = (Boolean)object;
            return;
        }
        if (string == "restrictToUsers") {
            this.restrictToUsers = (Set)object;
            return;
        }
        if (string == "maxTransfersPerWeek") {
            this.maxTransfersPerWeek = (Integer)object;
            return;
        }
        if (string == "authorizationExpirationPeriod") {
            this.authorizationExpirationPeriod = (TimeInterval)object;
            return;
        }
        if (string == "channels") {
            this.channels = (Set)object;
            return;
        }
        if (string == "principalTypes") {
            this.principalTypes = (Set)object;
            return;
        }
        if (string == "maxAmountPerWeek") {
            this.maxAmountPerWeek = (BigDecimal)object;
            return;
        }
        if (string == "maxAmountPerWeekTrustedDevices") {
            this.maxAmountPerWeekTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "maturityHistorySize") {
            this.maturityHistorySize = (Integer)object;
            return;
        }
        if (string == "restrictToGroups") {
            this.restrictToGroups = (Set)object;
            return;
        }
        if (string == "maxAmountPinlessTrustedDevices") {
            this.maxAmountPinlessTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "minAmount") {
            this.minAmount = (BigDecimal)object;
            return;
        }
        if (string == "defaultFeedbackLevel") {
            this.defaultFeedbackLevel = (ReferenceLevel)object;
            return;
        }
        if (string == "notifyPaymentPerformed") {
            this.notifyPaymentPerformed = (Boolean)object;
            return;
        }
        if (string == "customFields") {
            this.customFields = (Set)object;
            return;
        }
        if (string == "allowsScheduledPayments") {
            this.allowsScheduledPayments = (Boolean)object;
            return;
        }
        if (string == "maxAmountPerMonthTrustedDevices") {
            this.maxAmountPerMonthTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "showRecurringPaymentsToReceiver") {
            this.showRecurringPaymentsToReceiver = (Boolean)object;
            return;
        }
        if (string == "feedbackExpirationDays") {
            this.feedbackExpirationDays = (Integer)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "maxTransfersPerDay") {
            this.maxTransfersPerDay = (Integer)object;
            return;
        }
        if (string == "externalPaymentsAsUserOnProducts") {
            this.externalPaymentsAsUserOnProducts = (Set)object;
            return;
        }
        if (string == "maxAmount") {
            this.maxAmount = (BigDecimal)object;
            return;
        }
        if (string == "myPaymentsOnProducts") {
            this.myPaymentsOnProducts = (Set)object;
            return;
        }
        if (string == "requiresAuthorization") {
            this.requiresAuthorization = (Boolean)object;
            return;
        }
        if (string == "allowFromCustomName") {
            this.allowFromCustomName = (Boolean)object;
            return;
        }
        if (string == "chargebackPaymentsToSystemOnProducts") {
            this.chargebackPaymentsToSystemOnProducts = (Set)object;
            return;
        }
        if (string == "userPaymentsOnProducts") {
            this.userPaymentsOnProducts = (Set)object;
            return;
        }
        if (string == "allowToCustomName") {
            this.allowToCustomName = (Boolean)object;
            return;
        }
        if (string == "maxAmountPerDayTrustedDevices") {
            this.maxAmountPerDayTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "defaultPaymentRequestExpirationPeriod") {
            this.defaultPaymentRequestExpirationPeriod = (TimeInterval)object;
            return;
        }
        if (string == "maxAmountPerDay") {
            this.maxAmountPerDay = (BigDecimal)object;
            return;
        }
        if (string == "minTimeBetweenTransfers") {
            this.minTimeBetweenTransfers = (TimeInterval)object;
            return;
        }
        if (string == "allowsRecurringPayments") {
            this.allowsRecurringPayments = (Boolean)object;
            return;
        }
        if (string == "reserveApprovedTicketAmount") {
            this.reserveApprovedTicketAmount = (Boolean)object;
            return;
        }
        if (string == "defaultFeedbackComments") {
            this.defaultFeedbackComments = (String)object;
            return;
        }
        if (string == "maxAmountTrustedDevices") {
            this.maxAmountTrustedDevices = (BigDecimal)object;
            return;
        }
        if (string == "maxTransfersPerWeekTrustedDevices") {
            this.maxTransfersPerWeekTrustedDevices = (Integer)object;
            return;
        }
        if (string == "restrictTo") {
            this.restrictTo = (PaymentTransferTypeRestrictTo)object;
            return;
        }
        if (string == "requiresFeedback") {
            this.requiresFeedback = (Boolean)object;
            return;
        }
        if (string == "maxAmountPerYear") {
            this.maxAmountPerYear = (BigDecimal)object;
            return;
        }
        if (string == "confirmationMessage") {
            this.confirmationMessage = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_authorizationLevels() {
        this._persistence_checkFetched("authorizationLevels");
        return this.authorizationLevels;
    }

    public void _persistence_set_authorizationLevels(List list) {
        this._persistence_checkFetchedForSet("authorizationLevels");
        this._persistence_propertyChange("authorizationLevels", this.authorizationLevels, list);
        this.authorizationLevels = list;
    }

    public TransactionFeedbackSetting _persistence_get_feedbackSetting() {
        this._persistence_checkFetched("feedbackSetting");
        return this.feedbackSetting;
    }

    public void _persistence_set_feedbackSetting(TransactionFeedbackSetting transactionFeedbackSetting) {
        this._persistence_checkFetchedForSet("feedbackSetting");
        this._persistence_propertyChange("feedbackSetting", this.feedbackSetting, transactionFeedbackSetting);
        this.feedbackSetting = transactionFeedbackSetting;
    }

    public Integer _persistence_get_feedbackReminderDays() {
        this._persistence_checkFetched("feedbackReminderDays");
        return this.feedbackReminderDays;
    }

    public void _persistence_set_feedbackReminderDays(Integer n) {
        this._persistence_checkFetchedForSet("feedbackReminderDays");
        this._persistence_propertyChange("feedbackReminderDays", this.feedbackReminderDays, n);
        this.feedbackReminderDays = n;
    }

    public Set _persistence_get_myExternalPaymentTypesOnProducts() {
        this._persistence_checkFetched("myExternalPaymentTypesOnProducts");
        return this.myExternalPaymentTypesOnProducts;
    }

    public void _persistence_set_myExternalPaymentTypesOnProducts(Set set) {
        this._persistence_checkFetchedForSet("myExternalPaymentTypesOnProducts");
        this._persistence_propertyChange("myExternalPaymentTypesOnProducts", this.myExternalPaymentTypesOnProducts, set);
        this.myExternalPaymentTypesOnProducts = set;
    }

    public Integer _persistence_get_maxDaysToChangeFeedback() {
        this._persistence_checkFetched("maxDaysToChangeFeedback");
        return this.maxDaysToChangeFeedback;
    }

    public void _persistence_set_maxDaysToChangeFeedback(Integer n) {
        this._persistence_checkFetchedForSet("maxDaysToChangeFeedback");
        this._persistence_propertyChange("maxDaysToChangeFeedback", this.maxDaysToChangeFeedback, n);
        this.maxDaysToChangeFeedback = n;
    }

    public BigDecimal _persistence_get_maxAmountPerMonth() {
        this._persistence_checkFetched("maxAmountPerMonth");
        return this.maxAmountPerMonth;
    }

    public void _persistence_set_maxAmountPerMonth(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerMonth");
        this._persistence_propertyChange("maxAmountPerMonth", this.maxAmountPerMonth, bigDecimal);
        this.maxAmountPerMonth = bigDecimal;
    }

    public BigDecimal _persistence_get_maxAmountPerDayPinlessTrustedDevices() {
        this._persistence_checkFetched("maxAmountPerDayPinlessTrustedDevices");
        return this.maxAmountPerDayPinlessTrustedDevices;
    }

    public void _persistence_set_maxAmountPerDayPinlessTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerDayPinlessTrustedDevices");
        this._persistence_propertyChange("maxAmountPerDayPinlessTrustedDevices", this.maxAmountPerDayPinlessTrustedDevices, bigDecimal);
        this.maxAmountPerDayPinlessTrustedDevices = bigDecimal;
    }

    public BigDecimal _persistence_get_maxAmountPinless() {
        this._persistence_checkFetched("maxAmountPinless");
        return this.maxAmountPinless;
    }

    public void _persistence_set_maxAmountPinless(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPinless");
        this._persistence_propertyChange("maxAmountPinless", this.maxAmountPinless, bigDecimal);
        this.maxAmountPinless = bigDecimal;
    }

    public Set _persistence_get_systemToUserExternalPaymentOnProducts() {
        this._persistence_checkFetched("systemToUserExternalPaymentOnProducts");
        return this.systemToUserExternalPaymentOnProducts;
    }

    public void _persistence_set_systemToUserExternalPaymentOnProducts(Set set) {
        this._persistence_checkFetchedForSet("systemToUserExternalPaymentOnProducts");
        this._persistence_propertyChange("systemToUserExternalPaymentOnProducts", this.systemToUserExternalPaymentOnProducts, set);
        this.systemToUserExternalPaymentOnProducts = set;
    }

    public Date _persistence_get_feedbackEnabledSince() {
        this._persistence_checkFetched("feedbackEnabledSince");
        return this.feedbackEnabledSince;
    }

    public void _persistence_set_feedbackEnabledSince(Date date) {
        this._persistence_checkFetchedForSet("feedbackEnabledSince");
        this._persistence_propertyChange("feedbackEnabledSince", this.feedbackEnabledSince, date);
        this.feedbackEnabledSince = date;
    }

    public Boolean _persistence_get_hidePaymentRequestExpirationDate() {
        this._persistence_checkFetched("hidePaymentRequestExpirationDate");
        return this.hidePaymentRequestExpirationDate;
    }

    public void _persistence_set_hidePaymentRequestExpirationDate(Boolean bl) {
        this._persistence_checkFetchedForSet("hidePaymentRequestExpirationDate");
        this._persistence_propertyChange("hidePaymentRequestExpirationDate", this.hidePaymentRequestExpirationDate, bl);
        this.hidePaymentRequestExpirationDate = bl;
    }

    public Integer _persistence_get_maxTransfersPerDayTrustedDevices() {
        this._persistence_checkFetched("maxTransfersPerDayTrustedDevices");
        return this.maxTransfersPerDayTrustedDevices;
    }

    public void _persistence_set_maxTransfersPerDayTrustedDevices(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerDayTrustedDevices");
        this._persistence_propertyChange("maxTransfersPerDayTrustedDevices", this.maxTransfersPerDayTrustedDevices, n);
        this.maxTransfersPerDayTrustedDevices = n;
    }

    public Integer _persistence_get_maxTransfersPerMonthTrustedDevices() {
        this._persistence_checkFetched("maxTransfersPerMonthTrustedDevices");
        return this.maxTransfersPerMonthTrustedDevices;
    }

    public void _persistence_set_maxTransfersPerMonthTrustedDevices(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerMonthTrustedDevices");
        this._persistence_propertyChange("maxTransfersPerMonthTrustedDevices", this.maxTransfersPerMonthTrustedDevices, n);
        this.maxTransfersPerMonthTrustedDevices = n;
    }

    public Integer _persistence_get_feedbackExpirationReminderDays() {
        this._persistence_checkFetched("feedbackExpirationReminderDays");
        return this.feedbackExpirationReminderDays;
    }

    public void _persistence_set_feedbackExpirationReminderDays(Integer n) {
        this._persistence_checkFetchedForSet("feedbackExpirationReminderDays");
        this._persistence_propertyChange("feedbackExpirationReminderDays", this.feedbackExpirationReminderDays, n);
        this.feedbackExpirationReminderDays = n;
    }

    public Set _persistence_get_chargebackPaymentsToUserOnProducts() {
        this._persistence_checkFetched("chargebackPaymentsToUserOnProducts");
        return this.chargebackPaymentsToUserOnProducts;
    }

    public void _persistence_set_chargebackPaymentsToUserOnProducts(Set set) {
        this._persistence_checkFetchedForSet("chargebackPaymentsToUserOnProducts");
        this._persistence_propertyChange("chargebackPaymentsToUserOnProducts", this.chargebackPaymentsToUserOnProducts, set);
        this.chargebackPaymentsToUserOnProducts = set;
    }

    public Integer _persistence_get_maxTransfersPerMonth() {
        this._persistence_checkFetched("maxTransfersPerMonth");
        return this.maxTransfersPerMonth;
    }

    public void _persistence_set_maxTransfersPerMonth(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerMonth");
        this._persistence_propertyChange("maxTransfersPerMonth", this.maxTransfersPerMonth, n);
        this.maxTransfersPerMonth = n;
    }

    public Set _persistence_get_systemPaymentsOnProducts() {
        this._persistence_checkFetched("systemPaymentsOnProducts");
        return this.systemPaymentsOnProducts;
    }

    public void _persistence_set_systemPaymentsOnProducts(Set set) {
        this._persistence_checkFetchedForSet("systemPaymentsOnProducts");
        this._persistence_propertyChange("systemPaymentsOnProducts", this.systemPaymentsOnProducts, set);
        this.systemPaymentsOnProducts = set;
    }

    public Boolean _persistence_get_skipConfirmation() {
        this._persistence_checkFetched("skipConfirmation");
        return this.skipConfirmation;
    }

    public void _persistence_set_skipConfirmation(Boolean bl) {
        this._persistence_checkFetchedForSet("skipConfirmation");
        this._persistence_propertyChange("skipConfirmation", this.skipConfirmation, bl);
        this.skipConfirmation = bl;
    }

    public Integer _persistence_get_maxInstallments() {
        this._persistence_checkFetched("maxInstallments");
        return this.maxInstallments;
    }

    public void _persistence_set_maxInstallments(Integer n) {
        this._persistence_checkFetchedForSet("maxInstallments");
        this._persistence_propertyChange("maxInstallments", this.maxInstallments, n);
        this.maxInstallments = n;
    }

    public MaturityPolicy _persistence_get_maturityPolicy() {
        this._persistence_checkFetched("maturityPolicy");
        return this.maturityPolicy;
    }

    public void _persistence_set_maturityPolicy(MaturityPolicy maturityPolicy) {
        this._persistence_checkFetchedForSet("maturityPolicy");
        this._persistence_propertyChange("maturityPolicy", this.maturityPolicy, maturityPolicy);
        this.maturityPolicy = maturityPolicy;
    }

    public Integer _persistence_get_feedbackReplyExpirationDays() {
        this._persistence_checkFetched("feedbackReplyExpirationDays");
        return this.feedbackReplyExpirationDays;
    }

    public void _persistence_set_feedbackReplyExpirationDays(Integer n) {
        this._persistence_checkFetchedForSet("feedbackReplyExpirationDays");
        this._persistence_propertyChange("feedbackReplyExpirationDays", this.feedbackReplyExpirationDays, n);
        this.feedbackReplyExpirationDays = n;
    }

    public BigDecimal _persistence_get_maxAmountPerDayPinless() {
        this._persistence_checkFetched("maxAmountPerDayPinless");
        return this.maxAmountPerDayPinless;
    }

    public void _persistence_set_maxAmountPerDayPinless(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerDayPinless");
        this._persistence_propertyChange("maxAmountPerDayPinless", this.maxAmountPerDayPinless, bigDecimal);
        this.maxAmountPerDayPinless = bigDecimal;
    }

    public Boolean _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(Boolean bl) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", this.priority, bl);
        this.priority = bl;
    }

    public Boolean _persistence_get_reserveTotalAmountOnScheduledPayments() {
        this._persistence_checkFetched("reserveTotalAmountOnScheduledPayments");
        return this.reserveTotalAmountOnScheduledPayments;
    }

    public void _persistence_set_reserveTotalAmountOnScheduledPayments(Boolean bl) {
        this._persistence_checkFetchedForSet("reserveTotalAmountOnScheduledPayments");
        this._persistence_propertyChange("reserveTotalAmountOnScheduledPayments", this.reserveTotalAmountOnScheduledPayments, bl);
        this.reserveTotalAmountOnScheduledPayments = bl;
    }

    public BigDecimal _persistence_get_maxAmountPerYearTrustedDevices() {
        this._persistence_checkFetched("maxAmountPerYearTrustedDevices");
        return this.maxAmountPerYearTrustedDevices;
    }

    public void _persistence_set_maxAmountPerYearTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerYearTrustedDevices");
        this._persistence_propertyChange("maxAmountPerYearTrustedDevices", this.maxAmountPerYearTrustedDevices, bigDecimal);
        this.maxAmountPerYearTrustedDevices = bigDecimal;
    }

    public Boolean _persistence_get_showScheduledPaymentsToReceiver() {
        this._persistence_checkFetched("showScheduledPaymentsToReceiver");
        return this.showScheduledPaymentsToReceiver;
    }

    public void _persistence_set_showScheduledPaymentsToReceiver(Boolean bl) {
        this._persistence_checkFetchedForSet("showScheduledPaymentsToReceiver");
        this._persistence_propertyChange("showScheduledPaymentsToReceiver", this.showScheduledPaymentsToReceiver, bl);
        this.showScheduledPaymentsToReceiver = bl;
    }

    public Set _persistence_get_restrictToUsers() {
        this._persistence_checkFetched("restrictToUsers");
        return this.restrictToUsers;
    }

    public void _persistence_set_restrictToUsers(Set set) {
        this._persistence_checkFetchedForSet("restrictToUsers");
        this._persistence_propertyChange("restrictToUsers", this.restrictToUsers, set);
        this.restrictToUsers = set;
    }

    public Integer _persistence_get_maxTransfersPerWeek() {
        this._persistence_checkFetched("maxTransfersPerWeek");
        return this.maxTransfersPerWeek;
    }

    public void _persistence_set_maxTransfersPerWeek(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerWeek");
        this._persistence_propertyChange("maxTransfersPerWeek", this.maxTransfersPerWeek, n);
        this.maxTransfersPerWeek = n;
    }

    public TimeInterval _persistence_get_authorizationExpirationPeriod() {
        this._persistence_checkFetched("authorizationExpirationPeriod");
        return this.authorizationExpirationPeriod;
    }

    public void _persistence_set_authorizationExpirationPeriod(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("authorizationExpirationPeriod");
        this._persistence_propertyChange("authorizationExpirationPeriod", this.authorizationExpirationPeriod, timeInterval);
        this.authorizationExpirationPeriod = timeInterval;
    }

    public Set _persistence_get_channels() {
        this._persistence_checkFetched("channels");
        return this.channels;
    }

    public void _persistence_set_channels(Set set) {
        this._persistence_checkFetchedForSet("channels");
        this._persistence_propertyChange("channels", this.channels, set);
        this.channels = set;
    }

    public Set _persistence_get_principalTypes() {
        this._persistence_checkFetched("principalTypes");
        return this.principalTypes;
    }

    public void _persistence_set_principalTypes(Set set) {
        this._persistence_checkFetchedForSet("principalTypes");
        this._persistence_propertyChange("principalTypes", this.principalTypes, set);
        this.principalTypes = set;
    }

    public BigDecimal _persistence_get_maxAmountPerWeek() {
        this._persistence_checkFetched("maxAmountPerWeek");
        return this.maxAmountPerWeek;
    }

    public void _persistence_set_maxAmountPerWeek(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerWeek");
        this._persistence_propertyChange("maxAmountPerWeek", this.maxAmountPerWeek, bigDecimal);
        this.maxAmountPerWeek = bigDecimal;
    }

    public BigDecimal _persistence_get_maxAmountPerWeekTrustedDevices() {
        this._persistence_checkFetched("maxAmountPerWeekTrustedDevices");
        return this.maxAmountPerWeekTrustedDevices;
    }

    public void _persistence_set_maxAmountPerWeekTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerWeekTrustedDevices");
        this._persistence_propertyChange("maxAmountPerWeekTrustedDevices", this.maxAmountPerWeekTrustedDevices, bigDecimal);
        this.maxAmountPerWeekTrustedDevices = bigDecimal;
    }

    public Integer _persistence_get_maturityHistorySize() {
        this._persistence_checkFetched("maturityHistorySize");
        return this.maturityHistorySize;
    }

    public void _persistence_set_maturityHistorySize(Integer n) {
        this._persistence_checkFetchedForSet("maturityHistorySize");
        this._persistence_propertyChange("maturityHistorySize", this.maturityHistorySize, n);
        this.maturityHistorySize = n;
    }

    public Set _persistence_get_restrictToGroups() {
        this._persistence_checkFetched("restrictToGroups");
        return this.restrictToGroups;
    }

    public void _persistence_set_restrictToGroups(Set set) {
        this._persistence_checkFetchedForSet("restrictToGroups");
        this._persistence_propertyChange("restrictToGroups", this.restrictToGroups, set);
        this.restrictToGroups = set;
    }

    public BigDecimal _persistence_get_maxAmountPinlessTrustedDevices() {
        this._persistence_checkFetched("maxAmountPinlessTrustedDevices");
        return this.maxAmountPinlessTrustedDevices;
    }

    public void _persistence_set_maxAmountPinlessTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPinlessTrustedDevices");
        this._persistence_propertyChange("maxAmountPinlessTrustedDevices", this.maxAmountPinlessTrustedDevices, bigDecimal);
        this.maxAmountPinlessTrustedDevices = bigDecimal;
    }

    public BigDecimal _persistence_get_minAmount() {
        this._persistence_checkFetched("minAmount");
        return this.minAmount;
    }

    public void _persistence_set_minAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("minAmount");
        this._persistence_propertyChange("minAmount", this.minAmount, bigDecimal);
        this.minAmount = bigDecimal;
    }

    public ReferenceLevel _persistence_get_defaultFeedbackLevel() {
        this._persistence_checkFetched("defaultFeedbackLevel");
        return this.defaultFeedbackLevel;
    }

    public void _persistence_set_defaultFeedbackLevel(ReferenceLevel referenceLevel) {
        this._persistence_checkFetchedForSet("defaultFeedbackLevel");
        this._persistence_propertyChange("defaultFeedbackLevel", this.defaultFeedbackLevel, referenceLevel);
        this.defaultFeedbackLevel = referenceLevel;
    }

    public Boolean _persistence_get_notifyPaymentPerformed() {
        this._persistence_checkFetched("notifyPaymentPerformed");
        return this.notifyPaymentPerformed;
    }

    public void _persistence_set_notifyPaymentPerformed(Boolean bl) {
        this._persistence_checkFetchedForSet("notifyPaymentPerformed");
        this._persistence_propertyChange("notifyPaymentPerformed", this.notifyPaymentPerformed, bl);
        this.notifyPaymentPerformed = bl;
    }

    public Set _persistence_get_customFields() {
        this._persistence_checkFetched("customFields");
        return this.customFields;
    }

    public void _persistence_set_customFields(Set set) {
        this._persistence_checkFetchedForSet("customFields");
        this._persistence_propertyChange("customFields", this.customFields, set);
        this.customFields = set;
    }

    public Boolean _persistence_get_allowsScheduledPayments() {
        this._persistence_checkFetched("allowsScheduledPayments");
        return this.allowsScheduledPayments;
    }

    public void _persistence_set_allowsScheduledPayments(Boolean bl) {
        this._persistence_checkFetchedForSet("allowsScheduledPayments");
        this._persistence_propertyChange("allowsScheduledPayments", this.allowsScheduledPayments, bl);
        this.allowsScheduledPayments = bl;
    }

    public BigDecimal _persistence_get_maxAmountPerMonthTrustedDevices() {
        this._persistence_checkFetched("maxAmountPerMonthTrustedDevices");
        return this.maxAmountPerMonthTrustedDevices;
    }

    public void _persistence_set_maxAmountPerMonthTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerMonthTrustedDevices");
        this._persistence_propertyChange("maxAmountPerMonthTrustedDevices", this.maxAmountPerMonthTrustedDevices, bigDecimal);
        this.maxAmountPerMonthTrustedDevices = bigDecimal;
    }

    public Boolean _persistence_get_showRecurringPaymentsToReceiver() {
        this._persistence_checkFetched("showRecurringPaymentsToReceiver");
        return this.showRecurringPaymentsToReceiver;
    }

    public void _persistence_set_showRecurringPaymentsToReceiver(Boolean bl) {
        this._persistence_checkFetchedForSet("showRecurringPaymentsToReceiver");
        this._persistence_propertyChange("showRecurringPaymentsToReceiver", this.showRecurringPaymentsToReceiver, bl);
        this.showRecurringPaymentsToReceiver = bl;
    }

    public Integer _persistence_get_feedbackExpirationDays() {
        this._persistence_checkFetched("feedbackExpirationDays");
        return this.feedbackExpirationDays;
    }

    public void _persistence_set_feedbackExpirationDays(Integer n) {
        this._persistence_checkFetchedForSet("feedbackExpirationDays");
        this._persistence_propertyChange("feedbackExpirationDays", this.feedbackExpirationDays, n);
        this.feedbackExpirationDays = n;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    public Integer _persistence_get_maxTransfersPerDay() {
        this._persistence_checkFetched("maxTransfersPerDay");
        return this.maxTransfersPerDay;
    }

    public void _persistence_set_maxTransfersPerDay(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerDay");
        this._persistence_propertyChange("maxTransfersPerDay", this.maxTransfersPerDay, n);
        this.maxTransfersPerDay = n;
    }

    public Set _persistence_get_externalPaymentsAsUserOnProducts() {
        this._persistence_checkFetched("externalPaymentsAsUserOnProducts");
        return this.externalPaymentsAsUserOnProducts;
    }

    public void _persistence_set_externalPaymentsAsUserOnProducts(Set set) {
        this._persistence_checkFetchedForSet("externalPaymentsAsUserOnProducts");
        this._persistence_propertyChange("externalPaymentsAsUserOnProducts", this.externalPaymentsAsUserOnProducts, set);
        this.externalPaymentsAsUserOnProducts = set;
    }

    public BigDecimal _persistence_get_maxAmount() {
        this._persistence_checkFetched("maxAmount");
        return this.maxAmount;
    }

    public void _persistence_set_maxAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmount");
        this._persistence_propertyChange("maxAmount", this.maxAmount, bigDecimal);
        this.maxAmount = bigDecimal;
    }

    public Set _persistence_get_myPaymentsOnProducts() {
        this._persistence_checkFetched("myPaymentsOnProducts");
        return this.myPaymentsOnProducts;
    }

    public void _persistence_set_myPaymentsOnProducts(Set set) {
        this._persistence_checkFetchedForSet("myPaymentsOnProducts");
        this._persistence_propertyChange("myPaymentsOnProducts", this.myPaymentsOnProducts, set);
        this.myPaymentsOnProducts = set;
    }

    public boolean _persistence_get_requiresAuthorization() {
        this._persistence_checkFetched("requiresAuthorization");
        return this.requiresAuthorization;
    }

    public void _persistence_set_requiresAuthorization(boolean bl) {
        this._persistence_checkFetchedForSet("requiresAuthorization");
        this._persistence_propertyChange("requiresAuthorization", new Boolean(this.requiresAuthorization), new Boolean(bl));
        this.requiresAuthorization = bl;
    }

    public boolean _persistence_get_allowFromCustomName() {
        this._persistence_checkFetched("allowFromCustomName");
        return this.allowFromCustomName;
    }

    public void _persistence_set_allowFromCustomName(boolean bl) {
        this._persistence_checkFetchedForSet("allowFromCustomName");
        this._persistence_propertyChange("allowFromCustomName", new Boolean(this.allowFromCustomName), new Boolean(bl));
        this.allowFromCustomName = bl;
    }

    public Set _persistence_get_chargebackPaymentsToSystemOnProducts() {
        this._persistence_checkFetched("chargebackPaymentsToSystemOnProducts");
        return this.chargebackPaymentsToSystemOnProducts;
    }

    public void _persistence_set_chargebackPaymentsToSystemOnProducts(Set set) {
        this._persistence_checkFetchedForSet("chargebackPaymentsToSystemOnProducts");
        this._persistence_propertyChange("chargebackPaymentsToSystemOnProducts", this.chargebackPaymentsToSystemOnProducts, set);
        this.chargebackPaymentsToSystemOnProducts = set;
    }

    public Set _persistence_get_userPaymentsOnProducts() {
        this._persistence_checkFetched("userPaymentsOnProducts");
        return this.userPaymentsOnProducts;
    }

    public void _persistence_set_userPaymentsOnProducts(Set set) {
        this._persistence_checkFetchedForSet("userPaymentsOnProducts");
        this._persistence_propertyChange("userPaymentsOnProducts", this.userPaymentsOnProducts, set);
        this.userPaymentsOnProducts = set;
    }

    public boolean _persistence_get_allowToCustomName() {
        this._persistence_checkFetched("allowToCustomName");
        return this.allowToCustomName;
    }

    public void _persistence_set_allowToCustomName(boolean bl) {
        this._persistence_checkFetchedForSet("allowToCustomName");
        this._persistence_propertyChange("allowToCustomName", new Boolean(this.allowToCustomName), new Boolean(bl));
        this.allowToCustomName = bl;
    }

    public BigDecimal _persistence_get_maxAmountPerDayTrustedDevices() {
        this._persistence_checkFetched("maxAmountPerDayTrustedDevices");
        return this.maxAmountPerDayTrustedDevices;
    }

    public void _persistence_set_maxAmountPerDayTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerDayTrustedDevices");
        this._persistence_propertyChange("maxAmountPerDayTrustedDevices", this.maxAmountPerDayTrustedDevices, bigDecimal);
        this.maxAmountPerDayTrustedDevices = bigDecimal;
    }

    public TimeInterval _persistence_get_defaultPaymentRequestExpirationPeriod() {
        this._persistence_checkFetched("defaultPaymentRequestExpirationPeriod");
        return this.defaultPaymentRequestExpirationPeriod;
    }

    public void _persistence_set_defaultPaymentRequestExpirationPeriod(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("defaultPaymentRequestExpirationPeriod");
        this._persistence_propertyChange("defaultPaymentRequestExpirationPeriod", this.defaultPaymentRequestExpirationPeriod, timeInterval);
        this.defaultPaymentRequestExpirationPeriod = timeInterval;
    }

    public BigDecimal _persistence_get_maxAmountPerDay() {
        this._persistence_checkFetched("maxAmountPerDay");
        return this.maxAmountPerDay;
    }

    public void _persistence_set_maxAmountPerDay(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerDay");
        this._persistence_propertyChange("maxAmountPerDay", this.maxAmountPerDay, bigDecimal);
        this.maxAmountPerDay = bigDecimal;
    }

    public TimeInterval _persistence_get_minTimeBetweenTransfers() {
        this._persistence_checkFetched("minTimeBetweenTransfers");
        return this.minTimeBetweenTransfers;
    }

    public void _persistence_set_minTimeBetweenTransfers(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("minTimeBetweenTransfers");
        this._persistence_propertyChange("minTimeBetweenTransfers", this.minTimeBetweenTransfers, timeInterval);
        this.minTimeBetweenTransfers = timeInterval;
    }

    public Boolean _persistence_get_allowsRecurringPayments() {
        this._persistence_checkFetched("allowsRecurringPayments");
        return this.allowsRecurringPayments;
    }

    public void _persistence_set_allowsRecurringPayments(Boolean bl) {
        this._persistence_checkFetchedForSet("allowsRecurringPayments");
        this._persistence_propertyChange("allowsRecurringPayments", this.allowsRecurringPayments, bl);
        this.allowsRecurringPayments = bl;
    }

    public Boolean _persistence_get_reserveApprovedTicketAmount() {
        this._persistence_checkFetched("reserveApprovedTicketAmount");
        return this.reserveApprovedTicketAmount;
    }

    public void _persistence_set_reserveApprovedTicketAmount(Boolean bl) {
        this._persistence_checkFetchedForSet("reserveApprovedTicketAmount");
        this._persistence_propertyChange("reserveApprovedTicketAmount", this.reserveApprovedTicketAmount, bl);
        this.reserveApprovedTicketAmount = bl;
    }

    public String _persistence_get_defaultFeedbackComments() {
        this._persistence_checkFetched("defaultFeedbackComments");
        return this.defaultFeedbackComments;
    }

    public void _persistence_set_defaultFeedbackComments(String string) {
        this._persistence_checkFetchedForSet("defaultFeedbackComments");
        this._persistence_propertyChange("defaultFeedbackComments", this.defaultFeedbackComments, string);
        this.defaultFeedbackComments = string;
    }

    public BigDecimal _persistence_get_maxAmountTrustedDevices() {
        this._persistence_checkFetched("maxAmountTrustedDevices");
        return this.maxAmountTrustedDevices;
    }

    public void _persistence_set_maxAmountTrustedDevices(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountTrustedDevices");
        this._persistence_propertyChange("maxAmountTrustedDevices", this.maxAmountTrustedDevices, bigDecimal);
        this.maxAmountTrustedDevices = bigDecimal;
    }

    public Integer _persistence_get_maxTransfersPerWeekTrustedDevices() {
        this._persistence_checkFetched("maxTransfersPerWeekTrustedDevices");
        return this.maxTransfersPerWeekTrustedDevices;
    }

    public void _persistence_set_maxTransfersPerWeekTrustedDevices(Integer n) {
        this._persistence_checkFetchedForSet("maxTransfersPerWeekTrustedDevices");
        this._persistence_propertyChange("maxTransfersPerWeekTrustedDevices", this.maxTransfersPerWeekTrustedDevices, n);
        this.maxTransfersPerWeekTrustedDevices = n;
    }

    public PaymentTransferTypeRestrictTo _persistence_get_restrictTo() {
        this._persistence_checkFetched("restrictTo");
        return this.restrictTo;
    }

    public void _persistence_set_restrictTo(PaymentTransferTypeRestrictTo paymentTransferTypeRestrictTo) {
        this._persistence_checkFetchedForSet("restrictTo");
        this._persistence_propertyChange("restrictTo", this.restrictTo, paymentTransferTypeRestrictTo);
        this.restrictTo = paymentTransferTypeRestrictTo;
    }

    public Boolean _persistence_get_requiresFeedback() {
        this._persistence_checkFetched("requiresFeedback");
        return this.requiresFeedback;
    }

    public void _persistence_set_requiresFeedback(Boolean bl) {
        this._persistence_checkFetchedForSet("requiresFeedback");
        this._persistence_propertyChange("requiresFeedback", this.requiresFeedback, bl);
        this.requiresFeedback = bl;
    }

    public BigDecimal _persistence_get_maxAmountPerYear() {
        this._persistence_checkFetched("maxAmountPerYear");
        return this.maxAmountPerYear;
    }

    public void _persistence_set_maxAmountPerYear(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerYear");
        this._persistence_propertyChange("maxAmountPerYear", this.maxAmountPerYear, bigDecimal);
        this.maxAmountPerYear = bigDecimal;
    }

    public String _persistence_get_confirmationMessage() {
        this._persistence_checkFetched("confirmationMessage");
        return this.confirmationMessage;
    }

    public void _persistence_set_confirmationMessage(String string) {
        this._persistence_checkFetchedForSet("confirmationMessage");
        this._persistence_propertyChange("confirmationMessage", this.confirmationMessage, string);
        this.confirmationMessage = string;
    }
}

