/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.accountfees.AccountFeeBalanceHandling;
import org.cyclos.model.banking.accountfees.AccountFeeChargeMode;
import org.cyclos.model.banking.accountfees.AccountFeePaymentDirection;
import org.cyclos.model.banking.accountfees.AccountFeeRunMode;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.utils.WeekDay;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="account_fees")
public class AccountFee
extends ConfigurationEntity
implements HasCurrency,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="account_type_id", nullable=false)
    private UserAccountType accountType;
    @Basic
    @Column(name="enabled", nullable=false)
    private boolean enabled = true;
    @Basic
    @Column(name="enabled_since")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date enabledSince;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @ReadOnlyFromDTO(onInsert=false)
    @Column(name="charge_mode", updatable=false, nullable=false)
    private AccountFeeChargeMode chargeMode;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="balance_handling", nullable=false)
    private AccountFeeBalanceHandling balanceHandling;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="payment_direction", nullable=false)
    private AccountFeePaymentDirection paymentDirection;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="transfer_type_id", nullable=false)
    private GeneratedTransferType transferType;
    @Basic
    @Column(name="amount")
    @MaxScale
    private BigDecimal amount;
    @Basic
    @Column(name="free_base")
    @CurrencyScale
    private BigDecimal freeBase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="custom_script_id")
    private CustomScript customScript;
    @Basic
    @Lob
    @Column(name="custom_script_parameters")
    private String customScriptParameters;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="run_mode", updatable=false, nullable=false)
    private AccountFeeRunMode runMode;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="recurrence_amount")), @AttributeOverride(name="field", column=@Column(name="recurrence_field"))})
    private TimeInterval recurrence;
    @Basic
    @Column(name="day_month")
    private Integer dayMonth;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="day_week")
    private WeekDay dayWeek;
    @Basic
    @Column(name="hour")
    private Integer hour;
    @OneToMany(mappedBy="accountFee")
    private Set<AccountFeeLog> logs;
    @ManyToMany(mappedBy="accountFees")
    private Set<MemberProduct> usedOnProducts;
    @Basic
    @Column(name="notify_when_success", nullable=false)
    private boolean notifyWhenSuccess = true;
    static final long serialVersionUID = 7271787177779099314L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_customScript_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transferType_vh;

    public UserAccountType getAccountType() {
        return this._persistence_get_accountType();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public AccountFeeBalanceHandling getBalanceHandling() {
        return this._persistence_get_balanceHandling();
    }

    public AccountFeeChargeMode getChargeMode() {
        return this._persistence_get_chargeMode();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_accountType() == null ? null : this._persistence_get_accountType().getCurrency();
    }

    public CustomScript getCustomScript() {
        return this._persistence_get_customScript();
    }

    public String getCustomScriptParameters() {
        return this._persistence_get_customScriptParameters();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.ACCOUNT_FEES;
    }

    public Integer getDayMonth() {
        return this._persistence_get_dayMonth();
    }

    public WeekDay getDayWeek() {
        return this._persistence_get_dayWeek();
    }

    public Date getEnabledSince() {
        return this._persistence_get_enabledSince();
    }

    public BigDecimal getFreeBase() {
        return this._persistence_get_freeBase();
    }

    public Integer getHour() {
        return this._persistence_get_hour();
    }

    public Set<AccountFeeLog> getLogs() {
        return this._persistence_get_logs();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_accountType().getNetwork();
    }

    public AccountFeePaymentDirection getPaymentDirection() {
        return this._persistence_get_paymentDirection();
    }

    public TimeInterval getRecurrence() {
        return this._persistence_get_recurrence();
    }

    public AccountFeeRunMode getRunMode() {
        return this._persistence_get_runMode();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.ACCOUNT_FEE;
    }

    public GeneratedTransferType getTransferType() {
        return this._persistence_get_transferType();
    }

    public boolean isEnabled() {
        return this._persistence_get_enabled();
    }

    public boolean isManual() {
        return this._persistence_get_runMode() == AccountFeeRunMode.MANUAL;
    }

    public boolean isNotifyWhenSuccess() {
        return this._persistence_get_notifyWhenSuccess();
    }

    public boolean isScheduled() {
        return this._persistence_get_runMode() == AccountFeeRunMode.SCHEDULED;
    }

    public void setAccountType(UserAccountType userAccountType) {
        this._persistence_set_accountType(userAccountType);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setBalanceHandling(AccountFeeBalanceHandling accountFeeBalanceHandling) {
        this._persistence_set_balanceHandling(accountFeeBalanceHandling);
    }

    public void setChargeMode(AccountFeeChargeMode accountFeeChargeMode) {
        this._persistence_set_chargeMode(accountFeeChargeMode);
    }

    public void setCustomScript(CustomScript customScript) {
        this._persistence_set_customScript(customScript);
    }

    public void setCustomScriptParameters(String string) {
        this._persistence_set_customScriptParameters(string);
    }

    public void setDayMonth(Integer n) {
        this._persistence_set_dayMonth(n);
    }

    public void setDayWeek(WeekDay weekDay) {
        this._persistence_set_dayWeek(weekDay);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setEnabledSince(Date date) {
        this._persistence_set_enabledSince(date);
    }

    public void setFreeBase(BigDecimal bigDecimal) {
        this._persistence_set_freeBase(bigDecimal);
    }

    public void setHour(Integer n) {
        this._persistence_set_hour(n);
    }

    public void setLogs(Set<AccountFeeLog> set) {
        this._persistence_set_logs(set);
    }

    public void setNotify(boolean bl) {
        this._persistence_set_notifyWhenSuccess(bl);
    }

    public void setNotifyWhenSuccess(boolean bl) {
        this._persistence_set_notifyWhenSuccess(bl);
    }

    public void setPaymentDirection(AccountFeePaymentDirection accountFeePaymentDirection) {
        this._persistence_set_paymentDirection(accountFeePaymentDirection);
    }

    public void setRecurrence(TimeInterval timeInterval) {
        this._persistence_set_recurrence(timeInterval);
    }

    public void setRunMode(AccountFeeRunMode accountFeeRunMode) {
        this._persistence_set_runMode(accountFeeRunMode);
    }

    public void setTransferType(GeneratedTransferType generatedTransferType) {
        this._persistence_set_transferType(generatedTransferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_accountType_vh != null) {
            this._persistence_accountType_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountType_vh.clone();
        }
        if (this._persistence_customScript_vh != null) {
            this._persistence_customScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_customScript_vh.clone();
        }
        if (this._persistence_transferType_vh != null) {
            this._persistence_transferType_vh = (WeavedAttributeValueHolderInterface)this._persistence_transferType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountFee();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "balanceHandling") {
            return this.balanceHandling;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "customScriptParameters") {
            return this.customScriptParameters;
        }
        if (string == "enabledSince") {
            return this.enabledSince;
        }
        if (string == "accountType") {
            return this.accountType;
        }
        if (string == "notifyWhenSuccess") {
            return this.notifyWhenSuccess;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "runMode") {
            return this.runMode;
        }
        if (string == "recurrence") {
            return this.recurrence;
        }
        if (string == "customScript") {
            return this.customScript;
        }
        if (string == "chargeMode") {
            return this.chargeMode;
        }
        if (string == "hour") {
            return this.hour;
        }
        if (string == "dayWeek") {
            return this.dayWeek;
        }
        if (string == "dayMonth") {
            return this.dayMonth;
        }
        if (string == "transferType") {
            return this.transferType;
        }
        if (string == "freeBase") {
            return this.freeBase;
        }
        if (string == "usedOnProducts") {
            return this.usedOnProducts;
        }
        if (string == "logs") {
            return this.logs;
        }
        if (string == "paymentDirection") {
            return this.paymentDirection;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "balanceHandling") {
            this.balanceHandling = (AccountFeeBalanceHandling)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "customScriptParameters") {
            this.customScriptParameters = (String)object;
            return;
        }
        if (string == "enabledSince") {
            this.enabledSince = (Date)object;
            return;
        }
        if (string == "accountType") {
            this.accountType = (UserAccountType)object;
            return;
        }
        if (string == "notifyWhenSuccess") {
            this.notifyWhenSuccess = (Boolean)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "runMode") {
            this.runMode = (AccountFeeRunMode)object;
            return;
        }
        if (string == "recurrence") {
            this.recurrence = (TimeInterval)object;
            return;
        }
        if (string == "customScript") {
            this.customScript = (CustomScript)object;
            return;
        }
        if (string == "chargeMode") {
            this.chargeMode = (AccountFeeChargeMode)object;
            return;
        }
        if (string == "hour") {
            this.hour = (Integer)object;
            return;
        }
        if (string == "dayWeek") {
            this.dayWeek = (WeekDay)object;
            return;
        }
        if (string == "dayMonth") {
            this.dayMonth = (Integer)object;
            return;
        }
        if (string == "transferType") {
            this.transferType = (GeneratedTransferType)object;
            return;
        }
        if (string == "freeBase") {
            this.freeBase = (BigDecimal)object;
            return;
        }
        if (string == "usedOnProducts") {
            this.usedOnProducts = (Set)object;
            return;
        }
        if (string == "logs") {
            this.logs = (Set)object;
            return;
        }
        if (string == "paymentDirection") {
            this.paymentDirection = (AccountFeePaymentDirection)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AccountFeeBalanceHandling _persistence_get_balanceHandling() {
        this._persistence_checkFetched("balanceHandling");
        return this.balanceHandling;
    }

    public void _persistence_set_balanceHandling(AccountFeeBalanceHandling accountFeeBalanceHandling) {
        this._persistence_checkFetchedForSet("balanceHandling");
        this._persistence_propertyChange("balanceHandling", this.balanceHandling, accountFeeBalanceHandling);
        this.balanceHandling = accountFeeBalanceHandling;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public String _persistence_get_customScriptParameters() {
        this._persistence_checkFetched("customScriptParameters");
        return this.customScriptParameters;
    }

    public void _persistence_set_customScriptParameters(String string) {
        this._persistence_checkFetchedForSet("customScriptParameters");
        this._persistence_propertyChange("customScriptParameters", this.customScriptParameters, string);
        this.customScriptParameters = string;
    }

    public Date _persistence_get_enabledSince() {
        this._persistence_checkFetched("enabledSince");
        return this.enabledSince;
    }

    public void _persistence_set_enabledSince(Date date) {
        this._persistence_checkFetchedForSet("enabledSince");
        this._persistence_propertyChange("enabledSince", this.enabledSince, date);
        this.enabledSince = date;
    }

    protected void _persistence_initialize_accountType_vh() {
        if (this._persistence_accountType_vh == null) {
            this._persistence_accountType_vh = new ValueHolder((Object)this.accountType);
            this._persistence_accountType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountType_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_accountType_vh();
        if ((this._persistence_accountType_vh.isCoordinatedWithProperty() || this._persistence_accountType_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_accountType()) != this._persistence_accountType_vh.getValue()) {
            this._persistence_set_accountType(userAccountType);
        }
        return this._persistence_accountType_vh;
    }

    public void _persistence_set_accountType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_accountType();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountType((UserAccountType)object);
            }
        } else {
            this.accountType = null;
        }
    }

    public UserAccountType _persistence_get_accountType() {
        this._persistence_checkFetched("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        return this.accountType;
    }

    public void _persistence_set_accountType(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        this._persistence_propertyChange("accountType", this.accountType, userAccountType);
        this.accountType = userAccountType;
        this._persistence_accountType_vh.setValue((Object)userAccountType);
    }

    public boolean _persistence_get_notifyWhenSuccess() {
        this._persistence_checkFetched("notifyWhenSuccess");
        return this.notifyWhenSuccess;
    }

    public void _persistence_set_notifyWhenSuccess(boolean bl) {
        this._persistence_checkFetchedForSet("notifyWhenSuccess");
        this._persistence_propertyChange("notifyWhenSuccess", new Boolean(this.notifyWhenSuccess), new Boolean(bl));
        this.notifyWhenSuccess = bl;
    }

    public boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", new Boolean(this.enabled), new Boolean(bl));
        this.enabled = bl;
    }

    public AccountFeeRunMode _persistence_get_runMode() {
        this._persistence_checkFetched("runMode");
        return this.runMode;
    }

    public void _persistence_set_runMode(AccountFeeRunMode accountFeeRunMode) {
        this._persistence_checkFetchedForSet("runMode");
        this._persistence_propertyChange("runMode", this.runMode, accountFeeRunMode);
        this.runMode = accountFeeRunMode;
    }

    public TimeInterval _persistence_get_recurrence() {
        this._persistence_checkFetched("recurrence");
        return this.recurrence;
    }

    public void _persistence_set_recurrence(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("recurrence");
        this._persistence_propertyChange("recurrence", this.recurrence, timeInterval);
        this.recurrence = timeInterval;
    }

    protected void _persistence_initialize_customScript_vh() {
        if (this._persistence_customScript_vh == null) {
            this._persistence_customScript_vh = new ValueHolder((Object)this.customScript);
            this._persistence_customScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_customScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_customScript_vh();
        if ((this._persistence_customScript_vh.isCoordinatedWithProperty() || this._persistence_customScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_customScript()) != this._persistence_customScript_vh.getValue()) {
            this._persistence_set_customScript(customScript);
        }
        return this._persistence_customScript_vh;
    }

    public void _persistence_set_customScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_customScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_customScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_customScript((CustomScript)object);
            }
        } else {
            this.customScript = null;
        }
    }

    public CustomScript _persistence_get_customScript() {
        this._persistence_checkFetched("customScript");
        this._persistence_initialize_customScript_vh();
        this.customScript = (CustomScript)this._persistence_customScript_vh.getValue();
        return this.customScript;
    }

    public void _persistence_set_customScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("customScript");
        this._persistence_initialize_customScript_vh();
        this.customScript = (CustomScript)this._persistence_customScript_vh.getValue();
        this._persistence_propertyChange("customScript", this.customScript, customScript);
        this.customScript = customScript;
        this._persistence_customScript_vh.setValue((Object)customScript);
    }

    public AccountFeeChargeMode _persistence_get_chargeMode() {
        this._persistence_checkFetched("chargeMode");
        return this.chargeMode;
    }

    public void _persistence_set_chargeMode(AccountFeeChargeMode accountFeeChargeMode) {
        this._persistence_checkFetchedForSet("chargeMode");
        this._persistence_propertyChange("chargeMode", this.chargeMode, accountFeeChargeMode);
        this.chargeMode = accountFeeChargeMode;
    }

    public Integer _persistence_get_hour() {
        this._persistence_checkFetched("hour");
        return this.hour;
    }

    public void _persistence_set_hour(Integer n) {
        this._persistence_checkFetchedForSet("hour");
        this._persistence_propertyChange("hour", this.hour, n);
        this.hour = n;
    }

    public WeekDay _persistence_get_dayWeek() {
        this._persistence_checkFetched("dayWeek");
        return this.dayWeek;
    }

    public void _persistence_set_dayWeek(WeekDay weekDay) {
        this._persistence_checkFetchedForSet("dayWeek");
        this._persistence_propertyChange("dayWeek", this.dayWeek, weekDay);
        this.dayWeek = weekDay;
    }

    public Integer _persistence_get_dayMonth() {
        this._persistence_checkFetched("dayMonth");
        return this.dayMonth;
    }

    public void _persistence_set_dayMonth(Integer n) {
        this._persistence_checkFetchedForSet("dayMonth");
        this._persistence_propertyChange("dayMonth", this.dayMonth, n);
        this.dayMonth = n;
    }

    protected void _persistence_initialize_transferType_vh() {
        if (this._persistence_transferType_vh == null) {
            this._persistence_transferType_vh = new ValueHolder((Object)this.transferType);
            this._persistence_transferType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transferType_vh() {
        GeneratedTransferType generatedTransferType;
        this._persistence_initialize_transferType_vh();
        if ((this._persistence_transferType_vh.isCoordinatedWithProperty() || this._persistence_transferType_vh.isNewlyWeavedValueHolder()) && (generatedTransferType = this._persistence_get_transferType()) != this._persistence_transferType_vh.getValue()) {
            this._persistence_set_transferType(generatedTransferType);
        }
        return this._persistence_transferType_vh;
    }

    public void _persistence_set_transferType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transferType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            GeneratedTransferType generatedTransferType = this._persistence_get_transferType();
            if (generatedTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transferType((GeneratedTransferType)object);
            }
        } else {
            this.transferType = null;
        }
    }

    public GeneratedTransferType _persistence_get_transferType() {
        this._persistence_checkFetched("transferType");
        this._persistence_initialize_transferType_vh();
        this.transferType = (GeneratedTransferType)this._persistence_transferType_vh.getValue();
        return this.transferType;
    }

    public void _persistence_set_transferType(GeneratedTransferType generatedTransferType) {
        this._persistence_checkFetchedForSet("transferType");
        this._persistence_initialize_transferType_vh();
        this.transferType = (GeneratedTransferType)this._persistence_transferType_vh.getValue();
        this._persistence_propertyChange("transferType", this.transferType, generatedTransferType);
        this.transferType = generatedTransferType;
        this._persistence_transferType_vh.setValue((Object)generatedTransferType);
    }

    public BigDecimal _persistence_get_freeBase() {
        this._persistence_checkFetched("freeBase");
        return this.freeBase;
    }

    public void _persistence_set_freeBase(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("freeBase");
        this._persistence_propertyChange("freeBase", this.freeBase, bigDecimal);
        this.freeBase = bigDecimal;
    }

    public Set _persistence_get_usedOnProducts() {
        this._persistence_checkFetched("usedOnProducts");
        return this.usedOnProducts;
    }

    public void _persistence_set_usedOnProducts(Set set) {
        this._persistence_checkFetchedForSet("usedOnProducts");
        this._persistence_propertyChange("usedOnProducts", this.usedOnProducts, set);
        this.usedOnProducts = set;
    }

    public Set _persistence_get_logs() {
        this._persistence_checkFetched("logs");
        return this.logs;
    }

    public void _persistence_set_logs(Set set) {
        this._persistence_checkFetchedForSet("logs");
        this._persistence_propertyChange("logs", this.logs, set);
        this.logs = set;
    }

    public AccountFeePaymentDirection _persistence_get_paymentDirection() {
        this._persistence_checkFetched("paymentDirection");
        return this.paymentDirection;
    }

    public void _persistence_set_paymentDirection(AccountFeePaymentDirection accountFeePaymentDirection) {
        this._persistence_checkFetchedForSet("paymentDirection");
        this._persistence_propertyChange("paymentDirection", this.paymentDirection, accountFeePaymentDirection);
        this.paymentDirection = accountFeePaymentDirection;
    }
}

