/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.BuiltinPrincipalTypeResolver;
import org.cyclos.entities.access.Otp;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="trusted_devices", uniqueConstraints={@UniqueConstraint(columnNames={"key"})})
public class TrustedDevice
extends NamedEntity
implements UserPrincipal,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="key")
    private String key;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", nullable=false)
    @ReadOnlyFromDTO
    private Date date;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private BasicUser user;
    @OneToMany(mappedBy="trustedDevice")
    private Set<Pin> pins;
    @OneToMany(mappedBy="trustedDevice", cascade={CascadeType.REMOVE})
    private Set<CustomWizardExecution> customWizardExecutions;
    @OneToMany(mappedBy="trustedDevice", cascade={CascadeType.REMOVE})
    private Set<Otp> otps;
    @OneToMany(mappedBy="trustedDevice", cascade={CascadeType.REMOVE})
    private Set<ExternalRedirectExecution> externalRedirectExecutions;
    @OneToMany(mappedBy="trustedDevice")
    private Set<Session> sessions = new HashSet<Session>();
    static final long serialVersionUID = -1320678212108841599L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public void addOtp(Otp otp) {
        if (this._persistence_get_otps() == null) {
            this._persistence_set_otps(new HashSet());
        }
        this._persistence_get_otps().add(otp);
    }

    public void addSession(Session session) {
        session.setTrustedDevice(this);
        this._persistence_get_sessions().add(session);
    }

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public UserAccountType getAccountType() {
        return null;
    }

    @Override
    public BasicUser getBasicUser() {
        return this.getUser();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public String getKey() {
        return this._persistence_get_key();
    }

    @Override
    public MobilePhone getMobilePhone() {
        return null;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    public Set<Otp> getOtps() {
        return this._persistence_get_otps();
    }

    public Pin getPin() {
        return (Pin)CollectionHelper.first((Iterable)this._persistence_get_pins());
    }

    @Override
    public String getPrincipal() {
        return null;
    }

    @Override
    public PrincipalType getPrincipalType() {
        return BuiltinPrincipalTypeResolver.resolve(ExistingBuiltInPrincipalType.TRUSTED_DEVICE);
    }

    public Set<Session> getSessions() {
        return this._persistence_get_sessions();
    }

    @Override
    public Token getToken() {
        return null;
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return this;
    }

    public BasicUser getUser() {
        return this._persistence_get_user();
    }

    public boolean isActive() {
        return this._persistence_get_key() != null;
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setKey(String string) {
        this._persistence_set_key(string);
    }

    public void setSessions(Set<Session> set) {
        this._persistence_set_sessions(set);
    }

    public void setUser(BasicUser basicUser) {
        this._persistence_set_user(basicUser);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TrustedDevice();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "sessions") {
            return this.sessions;
        }
        if (string == "customWizardExecutions") {
            return this.customWizardExecutions;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "otps") {
            return this.otps;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "key") {
            return this.key;
        }
        if (string == "externalRedirectExecutions") {
            return this.externalRedirectExecutions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "sessions") {
            this.sessions = (Set)object;
            return;
        }
        if (string == "customWizardExecutions") {
            this.customWizardExecutions = (Set)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "otps") {
            this.otps = (Set)object;
            return;
        }
        if (string == "user") {
            this.user = (BasicUser)object;
            return;
        }
        if (string == "key") {
            this.key = (String)object;
            return;
        }
        if (string == "externalRedirectExecutions") {
            this.externalRedirectExecutions = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public Set _persistence_get_sessions() {
        this._persistence_checkFetched("sessions");
        return this.sessions;
    }

    public void _persistence_set_sessions(Set set) {
        this._persistence_checkFetchedForSet("sessions");
        this._persistence_propertyChange("sessions", this.sessions, set);
        this.sessions = set;
    }

    public Set _persistence_get_customWizardExecutions() {
        this._persistence_checkFetched("customWizardExecutions");
        return this.customWizardExecutions;
    }

    public void _persistence_set_customWizardExecutions(Set set) {
        this._persistence_checkFetchedForSet("customWizardExecutions");
        this._persistence_propertyChange("customWizardExecutions", this.customWizardExecutions, set);
        this.customWizardExecutions = set;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    public Set _persistence_get_otps() {
        this._persistence_checkFetched("otps");
        return this.otps;
    }

    public void _persistence_set_otps(Set set) {
        this._persistence_checkFetchedForSet("otps");
        this._persistence_propertyChange("otps", this.otps, set);
        this.otps = set;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        BasicUser basicUser;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(basicUser);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_user();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((BasicUser)object);
            }
        } else {
            this.user = null;
        }
    }

    public BasicUser _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, basicUser);
        this.user = basicUser;
        this._persistence_user_vh.setValue((Object)basicUser);
    }

    public String _persistence_get_key() {
        this._persistence_checkFetched("key");
        return this.key;
    }

    public void _persistence_set_key(String string) {
        this._persistence_checkFetchedForSet("key");
        this._persistence_propertyChange("key", this.key, string);
        this.key = string;
    }

    public Set _persistence_get_externalRedirectExecutions() {
        this._persistence_checkFetched("externalRedirectExecutions");
        return this.externalRedirectExecutions;
    }

    public void _persistence_set_externalRedirectExecutions(Set set) {
        this._persistence_checkFetchedForSet("externalRedirectExecutions");
        this._persistence_propertyChange("externalRedirectExecutions", this.externalRedirectExecutions, set);
        this.externalRedirectExecutions = set;
    }
}

