/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.MyProductPasswordAction;
import org.cyclos.entities.users.UserProductPasswordAction;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.Availability;
import org.cyclos.model.access.passwordtypes.InvalidPasswordAction;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="password_types")
public class PasswordType
extends ConfigurationEntity
implements DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @Basic
    @Lob
    @Column(name="description_on_registration")
    private String descriptionOnRegistration;
    @OneToMany(mappedBy="type", cascade={CascadeType.REMOVE})
    private Set<Password> passwords = new HashSet<Password>();
    @OneToMany(mappedBy="passwordType", cascade={CascadeType.REMOVE})
    private Set<MyProductPasswordAction> passwordActions = new HashSet<MyProductPasswordAction>();
    @OneToMany(mappedBy="passwordType", cascade={CascadeType.REMOVE})
    private Set<UserProductPasswordAction> userPasswordActions = new HashSet<UserProductPasswordAction>();
    @OneToMany(mappedBy="passwordType", cascade={CascadeType.REMOVE})
    private Set<Pin> pin;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="password_mode", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private PasswordMode passwordMode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id")
    private CustomScript script;
    @Basic
    @Lob
    @Column(name="script_parameters")
    private String scriptParameters;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="lower_case_letters")
    private Availability lowerCaseLetters;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="upper_case_letters")
    private Availability upperCaseLetters;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="numbers")
    private Availability numbers;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="special_characters")
    private Availability specialCharacters;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="min_length")), @AttributeOverride(name="max", column=@Column(name="max_length"))})
    private IntegerRange length;
    @Basic
    @Column(name="invalid_attempts")
    private Integer invalidAttempts;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="invalid_action")
    private InvalidPasswordAction invalidAction;
    @Basic
    @Column(name="possible_characters")
    private String possibleCharacters;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="expires_after_amount")), @AttributeOverride(name="field", column=@Column(name="expires_after_field"))})
    private TimeInterval expiresAfter = new TimeInterval(1, TimeField.YEARS);
    @Basic
    @Column(name="avoid_repeated_value", nullable=false)
    private boolean avoidRepeatedValue;
    @Basic
    @Column(name="requires_admin_authorization", nullable=false)
    private boolean requiresAdminAuthorization;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="input_method", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private PasswordInputMethod inputMethod;
    @Basic
    @Column(name="bcrypt_strength")
    private Integer bcryptStrength;
    @Basic
    @Column(name="number_of_rows")
    private Integer numberOfRows;
    @Basic
    @Column(name="number_of_buttons")
    private Integer numberOfButtons;
    @Basic
    @Column(name="characters_per_button")
    private Integer charactersPerButton;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="block_time_amount")), @AttributeOverride(name="field", column=@Column(name="block_time_field"))})
    private TimeInterval blockTime;
    @Basic
    @Column(name="avoid_obvious", nullable=false)
    private boolean avoidObvious;
    @ElementCollection
    @CollectionTable(name="password_types_otp_send_mediums", joinColumns={@JoinColumn(name="password_type_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"password_type_id, otp_send_medium"})})
    @Column(name="otp_send_medium")
    @Enumerated(value=EnumType.STRING)
    private Set<SendMedium> otpSendMediums = new HashSet<SendMedium>();
    @Basic
    @Column(name="allow_reuse_otp")
    private boolean allowReuseOTP;
    static final long serialVersionUID = 2483552075751658598L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_script_vh;

    public boolean canBeUsedForAccess() {
        if (this._persistence_get_passwordMode() == PasswordMode.OTP) {
            return false;
        }
        if (this._persistence_get_inputMethod() == PasswordInputMethod.VIRTUAL_KEYBOARD) {
            if (this._persistence_get_numberOfButtons() == null || this._persistence_get_charactersPerButton() == null || this._persistence_get_possibleCharacters() == null) {
                return false;
            }
            return this._persistence_get_possibleCharacters().length() <= this._persistence_get_numberOfButtons() * this._persistence_get_charactersPerButton();
        }
        return true;
    }

    public Integer getBcryptStrength() {
        return this._persistence_get_bcryptStrength();
    }

    public TimeInterval getBlockTime() {
        return this._persistence_get_blockTime();
    }

    public Integer getButtonsPerRow() {
        if (this._persistence_get_numberOfButtons() == null || this._persistence_get_numberOfRows() == null) {
            return null;
        }
        return (int)Math.ceil((double)this._persistence_get_numberOfButtons().intValue() / (double)this._persistence_get_numberOfRows().intValue());
    }

    public Integer getCharactersPerButton() {
        return this._persistence_get_charactersPerButton();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.PASSWORD_TYPE;
    }

    public String getDescriptionOnRegistration() {
        return this._persistence_get_descriptionOnRegistration();
    }

    public TimeInterval getExpiresAfter() {
        return this._persistence_get_expiresAfter();
    }

    public PasswordInputMethod getInputMethod() {
        return this._persistence_get_inputMethod();
    }

    public InvalidPasswordAction getInvalidAction() {
        return this._persistence_get_invalidAction();
    }

    public Integer getInvalidAttempts() {
        return this._persistence_get_invalidAttempts();
    }

    public IntegerRange getLength() {
        return this._persistence_get_length();
    }

    public Availability getLowerCaseLetters() {
        return this._persistence_get_lowerCaseLetters();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Integer getNumberOfButtons() {
        return this._persistence_get_numberOfButtons();
    }

    public Integer getNumberOfRows() {
        return this._persistence_get_numberOfRows();
    }

    public Availability getNumbers() {
        return this._persistence_get_numbers();
    }

    public Set<SendMedium> getOtpSendMediums() {
        return this._persistence_get_otpSendMediums();
    }

    public PasswordMode getPasswordMode() {
        return this._persistence_get_passwordMode();
    }

    public String getPossibleCharacters() {
        return this._persistence_get_possibleCharacters();
    }

    public CustomScript getScript() {
        return this._persistence_get_script();
    }

    public String getScriptParameters() {
        return this._persistence_get_scriptParameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.PASSWORD_TYPE;
    }

    public Availability getSpecialCharacters() {
        return this._persistence_get_specialCharacters();
    }

    public Availability getUpperCaseLetters() {
        return this._persistence_get_upperCaseLetters();
    }

    public boolean isAllowReuseOTP() {
        return this._persistence_get_allowReuseOTP();
    }

    public boolean isAvoidObvious() {
        return this._persistence_get_avoidObvious();
    }

    public boolean isAvoidRepeatedValue() {
        return this._persistence_get_avoidRepeatedValue();
    }

    public boolean isOnlyNumeric() {
        return this.getLowerCaseLetters() == Availability.DISABLED && this.getUpperCaseLetters() == Availability.DISABLED && this.getSpecialCharacters() == Availability.DISABLED && this.getNumbers() != Availability.DISABLED;
    }

    public boolean isRequiresAdminAuthorization() {
        return this._persistence_get_requiresAdminAuthorization();
    }

    public void setAllowReuseOTP(boolean bl) {
        this._persistence_set_allowReuseOTP(bl);
    }

    public void setAvoidObvious(boolean bl) {
        this._persistence_set_avoidObvious(bl);
    }

    public void setAvoidRepeatedValue(boolean bl) {
        this._persistence_set_avoidRepeatedValue(bl);
    }

    public void setBcryptStrength(Integer n) {
        this._persistence_set_bcryptStrength(n);
    }

    public void setBlockTime(TimeInterval timeInterval) {
        this._persistence_set_blockTime(timeInterval);
    }

    public void setCharactersPerButton(Integer n) {
        this._persistence_set_charactersPerButton(n);
    }

    public void setDescriptionOnRegistration(String string) {
        this._persistence_set_descriptionOnRegistration(string);
    }

    public void setExpiresAfter(TimeInterval timeInterval) {
        this._persistence_set_expiresAfter(timeInterval);
    }

    public void setInputMethod(PasswordInputMethod passwordInputMethod) {
        this._persistence_set_inputMethod(passwordInputMethod);
    }

    public void setInvalidAction(InvalidPasswordAction invalidPasswordAction) {
        this._persistence_set_invalidAction(invalidPasswordAction);
    }

    public void setInvalidAttempts(Integer n) {
        this._persistence_set_invalidAttempts(n);
    }

    public void setLength(IntegerRange integerRange) {
        this._persistence_set_length(integerRange);
    }

    public void setLowerCaseLetters(Availability availability) {
        this._persistence_set_lowerCaseLetters(availability);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setNumberOfButtons(Integer n) {
        this._persistence_set_numberOfButtons(n);
    }

    public void setNumberOfRows(Integer n) {
        this._persistence_set_numberOfRows(n);
    }

    public void setNumbers(Availability availability) {
        this._persistence_set_numbers(availability);
    }

    public void setOtpSendMediums(Set<SendMedium> set) {
        this._persistence_set_otpSendMediums(set);
    }

    public void setPasswordMode(PasswordMode passwordMode) {
        this._persistence_set_passwordMode(passwordMode);
    }

    public void setPossibleCharacters(String string) {
        this._persistence_set_possibleCharacters(string);
    }

    public void setRequiresAdminAuthorization(boolean bl) {
        this._persistence_set_requiresAdminAuthorization(bl);
    }

    public void setScript(CustomScript customScript) {
        this._persistence_set_script(customScript);
    }

    public void setScriptParameters(String string) {
        this._persistence_set_scriptParameters(string);
    }

    public void setSpecialCharacters(Availability availability) {
        this._persistence_set_specialCharacters(availability);
    }

    public void setUpperCaseLetters(Availability availability) {
        this._persistence_set_upperCaseLetters(availability);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PasswordType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "avoidRepeatedValue") {
            return this.avoidRepeatedValue;
        }
        if (string == "otpSendMediums") {
            return this.otpSendMediums;
        }
        if (string == "avoidObvious") {
            return this.avoidObvious;
        }
        if (string == "invalidAction") {
            return this.invalidAction;
        }
        if (string == "numbers") {
            return this.numbers;
        }
        if (string == "specialCharacters") {
            return this.specialCharacters;
        }
        if (string == "descriptionOnRegistration") {
            return this.descriptionOnRegistration;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "possibleCharacters") {
            return this.possibleCharacters;
        }
        if (string == "expiresAfter") {
            return this.expiresAfter;
        }
        if (string == "invalidAttempts") {
            return this.invalidAttempts;
        }
        if (string == "pin") {
            return this.pin;
        }
        if (string == "passwords") {
            return this.passwords;
        }
        if (string == "charactersPerButton") {
            return this.charactersPerButton;
        }
        if (string == "passwordMode") {
            return this.passwordMode;
        }
        if (string == "allowReuseOTP") {
            return this.allowReuseOTP;
        }
        if (string == "lowerCaseLetters") {
            return this.lowerCaseLetters;
        }
        if (string == "passwordActions") {
            return this.passwordActions;
        }
        if (string == "userPasswordActions") {
            return this.userPasswordActions;
        }
        if (string == "requiresAdminAuthorization") {
            return this.requiresAdminAuthorization;
        }
        if (string == "bcryptStrength") {
            return this.bcryptStrength;
        }
        if (string == "length") {
            return this.length;
        }
        if (string == "script") {
            return this.script;
        }
        if (string == "scriptParameters") {
            return this.scriptParameters;
        }
        if (string == "numberOfButtons") {
            return this.numberOfButtons;
        }
        if (string == "upperCaseLetters") {
            return this.upperCaseLetters;
        }
        if (string == "inputMethod") {
            return this.inputMethod;
        }
        if (string == "blockTime") {
            return this.blockTime;
        }
        if (string == "numberOfRows") {
            return this.numberOfRows;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "avoidRepeatedValue") {
            this.avoidRepeatedValue = (Boolean)object;
            return;
        }
        if (string == "otpSendMediums") {
            this.otpSendMediums = (Set)object;
            return;
        }
        if (string == "avoidObvious") {
            this.avoidObvious = (Boolean)object;
            return;
        }
        if (string == "invalidAction") {
            this.invalidAction = (InvalidPasswordAction)object;
            return;
        }
        if (string == "numbers") {
            this.numbers = (Availability)object;
            return;
        }
        if (string == "specialCharacters") {
            this.specialCharacters = (Availability)object;
            return;
        }
        if (string == "descriptionOnRegistration") {
            this.descriptionOnRegistration = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "possibleCharacters") {
            this.possibleCharacters = (String)object;
            return;
        }
        if (string == "expiresAfter") {
            this.expiresAfter = (TimeInterval)object;
            return;
        }
        if (string == "invalidAttempts") {
            this.invalidAttempts = (Integer)object;
            return;
        }
        if (string == "pin") {
            this.pin = (Set)object;
            return;
        }
        if (string == "passwords") {
            this.passwords = (Set)object;
            return;
        }
        if (string == "charactersPerButton") {
            this.charactersPerButton = (Integer)object;
            return;
        }
        if (string == "passwordMode") {
            this.passwordMode = (PasswordMode)object;
            return;
        }
        if (string == "allowReuseOTP") {
            this.allowReuseOTP = (Boolean)object;
            return;
        }
        if (string == "lowerCaseLetters") {
            this.lowerCaseLetters = (Availability)object;
            return;
        }
        if (string == "passwordActions") {
            this.passwordActions = (Set)object;
            return;
        }
        if (string == "userPasswordActions") {
            this.userPasswordActions = (Set)object;
            return;
        }
        if (string == "requiresAdminAuthorization") {
            this.requiresAdminAuthorization = (Boolean)object;
            return;
        }
        if (string == "bcryptStrength") {
            this.bcryptStrength = (Integer)object;
            return;
        }
        if (string == "length") {
            this.length = (IntegerRange)object;
            return;
        }
        if (string == "script") {
            this.script = (CustomScript)object;
            return;
        }
        if (string == "scriptParameters") {
            this.scriptParameters = (String)object;
            return;
        }
        if (string == "numberOfButtons") {
            this.numberOfButtons = (Integer)object;
            return;
        }
        if (string == "upperCaseLetters") {
            this.upperCaseLetters = (Availability)object;
            return;
        }
        if (string == "inputMethod") {
            this.inputMethod = (PasswordInputMethod)object;
            return;
        }
        if (string == "blockTime") {
            this.blockTime = (TimeInterval)object;
            return;
        }
        if (string == "numberOfRows") {
            this.numberOfRows = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public boolean _persistence_get_avoidRepeatedValue() {
        this._persistence_checkFetched("avoidRepeatedValue");
        return this.avoidRepeatedValue;
    }

    public void _persistence_set_avoidRepeatedValue(boolean bl) {
        this._persistence_checkFetchedForSet("avoidRepeatedValue");
        this._persistence_propertyChange("avoidRepeatedValue", new Boolean(this.avoidRepeatedValue), new Boolean(bl));
        this.avoidRepeatedValue = bl;
    }

    public Set _persistence_get_otpSendMediums() {
        this._persistence_checkFetched("otpSendMediums");
        return this.otpSendMediums;
    }

    public void _persistence_set_otpSendMediums(Set set) {
        this._persistence_checkFetchedForSet("otpSendMediums");
        this._persistence_propertyChange("otpSendMediums", this.otpSendMediums, set);
        this.otpSendMediums = set;
    }

    public boolean _persistence_get_avoidObvious() {
        this._persistence_checkFetched("avoidObvious");
        return this.avoidObvious;
    }

    public void _persistence_set_avoidObvious(boolean bl) {
        this._persistence_checkFetchedForSet("avoidObvious");
        this._persistence_propertyChange("avoidObvious", new Boolean(this.avoidObvious), new Boolean(bl));
        this.avoidObvious = bl;
    }

    public InvalidPasswordAction _persistence_get_invalidAction() {
        this._persistence_checkFetched("invalidAction");
        return this.invalidAction;
    }

    public void _persistence_set_invalidAction(InvalidPasswordAction invalidPasswordAction) {
        this._persistence_checkFetchedForSet("invalidAction");
        this._persistence_propertyChange("invalidAction", this.invalidAction, invalidPasswordAction);
        this.invalidAction = invalidPasswordAction;
    }

    public Availability _persistence_get_numbers() {
        this._persistence_checkFetched("numbers");
        return this.numbers;
    }

    public void _persistence_set_numbers(Availability availability) {
        this._persistence_checkFetchedForSet("numbers");
        this._persistence_propertyChange("numbers", this.numbers, availability);
        this.numbers = availability;
    }

    public Availability _persistence_get_specialCharacters() {
        this._persistence_checkFetched("specialCharacters");
        return this.specialCharacters;
    }

    public void _persistence_set_specialCharacters(Availability availability) {
        this._persistence_checkFetchedForSet("specialCharacters");
        this._persistence_propertyChange("specialCharacters", this.specialCharacters, availability);
        this.specialCharacters = availability;
    }

    public String _persistence_get_descriptionOnRegistration() {
        this._persistence_checkFetched("descriptionOnRegistration");
        return this.descriptionOnRegistration;
    }

    public void _persistence_set_descriptionOnRegistration(String string) {
        this._persistence_checkFetchedForSet("descriptionOnRegistration");
        this._persistence_propertyChange("descriptionOnRegistration", this.descriptionOnRegistration, string);
        this.descriptionOnRegistration = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public String _persistence_get_possibleCharacters() {
        this._persistence_checkFetched("possibleCharacters");
        return this.possibleCharacters;
    }

    public void _persistence_set_possibleCharacters(String string) {
        this._persistence_checkFetchedForSet("possibleCharacters");
        this._persistence_propertyChange("possibleCharacters", this.possibleCharacters, string);
        this.possibleCharacters = string;
    }

    public TimeInterval _persistence_get_expiresAfter() {
        this._persistence_checkFetched("expiresAfter");
        return this.expiresAfter;
    }

    public void _persistence_set_expiresAfter(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("expiresAfter");
        this._persistence_propertyChange("expiresAfter", this.expiresAfter, timeInterval);
        this.expiresAfter = timeInterval;
    }

    public Integer _persistence_get_invalidAttempts() {
        this._persistence_checkFetched("invalidAttempts");
        return this.invalidAttempts;
    }

    public void _persistence_set_invalidAttempts(Integer n) {
        this._persistence_checkFetchedForSet("invalidAttempts");
        this._persistence_propertyChange("invalidAttempts", this.invalidAttempts, n);
        this.invalidAttempts = n;
    }

    public Set _persistence_get_pin() {
        this._persistence_checkFetched("pin");
        return this.pin;
    }

    public void _persistence_set_pin(Set set) {
        this._persistence_checkFetchedForSet("pin");
        this._persistence_propertyChange("pin", this.pin, set);
        this.pin = set;
    }

    public Set _persistence_get_passwords() {
        this._persistence_checkFetched("passwords");
        return this.passwords;
    }

    public void _persistence_set_passwords(Set set) {
        this._persistence_checkFetchedForSet("passwords");
        this._persistence_propertyChange("passwords", this.passwords, set);
        this.passwords = set;
    }

    public Integer _persistence_get_charactersPerButton() {
        this._persistence_checkFetched("charactersPerButton");
        return this.charactersPerButton;
    }

    public void _persistence_set_charactersPerButton(Integer n) {
        this._persistence_checkFetchedForSet("charactersPerButton");
        this._persistence_propertyChange("charactersPerButton", this.charactersPerButton, n);
        this.charactersPerButton = n;
    }

    public PasswordMode _persistence_get_passwordMode() {
        this._persistence_checkFetched("passwordMode");
        return this.passwordMode;
    }

    public void _persistence_set_passwordMode(PasswordMode passwordMode) {
        this._persistence_checkFetchedForSet("passwordMode");
        this._persistence_propertyChange("passwordMode", this.passwordMode, passwordMode);
        this.passwordMode = passwordMode;
    }

    public boolean _persistence_get_allowReuseOTP() {
        this._persistence_checkFetched("allowReuseOTP");
        return this.allowReuseOTP;
    }

    public void _persistence_set_allowReuseOTP(boolean bl) {
        this._persistence_checkFetchedForSet("allowReuseOTP");
        this._persistence_propertyChange("allowReuseOTP", new Boolean(this.allowReuseOTP), new Boolean(bl));
        this.allowReuseOTP = bl;
    }

    public Availability _persistence_get_lowerCaseLetters() {
        this._persistence_checkFetched("lowerCaseLetters");
        return this.lowerCaseLetters;
    }

    public void _persistence_set_lowerCaseLetters(Availability availability) {
        this._persistence_checkFetchedForSet("lowerCaseLetters");
        this._persistence_propertyChange("lowerCaseLetters", this.lowerCaseLetters, availability);
        this.lowerCaseLetters = availability;
    }

    public Set _persistence_get_passwordActions() {
        this._persistence_checkFetched("passwordActions");
        return this.passwordActions;
    }

    public void _persistence_set_passwordActions(Set set) {
        this._persistence_checkFetchedForSet("passwordActions");
        this._persistence_propertyChange("passwordActions", this.passwordActions, set);
        this.passwordActions = set;
    }

    public Set _persistence_get_userPasswordActions() {
        this._persistence_checkFetched("userPasswordActions");
        return this.userPasswordActions;
    }

    public void _persistence_set_userPasswordActions(Set set) {
        this._persistence_checkFetchedForSet("userPasswordActions");
        this._persistence_propertyChange("userPasswordActions", this.userPasswordActions, set);
        this.userPasswordActions = set;
    }

    public boolean _persistence_get_requiresAdminAuthorization() {
        this._persistence_checkFetched("requiresAdminAuthorization");
        return this.requiresAdminAuthorization;
    }

    public void _persistence_set_requiresAdminAuthorization(boolean bl) {
        this._persistence_checkFetchedForSet("requiresAdminAuthorization");
        this._persistence_propertyChange("requiresAdminAuthorization", new Boolean(this.requiresAdminAuthorization), new Boolean(bl));
        this.requiresAdminAuthorization = bl;
    }

    public Integer _persistence_get_bcryptStrength() {
        this._persistence_checkFetched("bcryptStrength");
        return this.bcryptStrength;
    }

    public void _persistence_set_bcryptStrength(Integer n) {
        this._persistence_checkFetchedForSet("bcryptStrength");
        this._persistence_propertyChange("bcryptStrength", this.bcryptStrength, n);
        this.bcryptStrength = n;
    }

    public IntegerRange _persistence_get_length() {
        this._persistence_checkFetched("length");
        return this.length;
    }

    public void _persistence_set_length(IntegerRange integerRange) {
        this._persistence_checkFetchedForSet("length");
        this._persistence_propertyChange("length", this.length, integerRange);
        this.length = integerRange;
    }

    protected void _persistence_initialize_script_vh() {
        if (this._persistence_script_vh == null) {
            this._persistence_script_vh = new ValueHolder((Object)this.script);
            this._persistence_script_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_script_vh() {
        CustomScript customScript;
        this._persistence_initialize_script_vh();
        if ((this._persistence_script_vh.isCoordinatedWithProperty() || this._persistence_script_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_script()) != this._persistence_script_vh.getValue()) {
            this._persistence_set_script(customScript);
        }
        return this._persistence_script_vh;
    }

    public void _persistence_set_script_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_script_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_script();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_script((CustomScript)object);
            }
        } else {
            this.script = null;
        }
    }

    public CustomScript _persistence_get_script() {
        this._persistence_checkFetched("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        return this.script;
    }

    public void _persistence_set_script(CustomScript customScript) {
        this._persistence_checkFetchedForSet("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        this._persistence_propertyChange("script", this.script, customScript);
        this.script = customScript;
        this._persistence_script_vh.setValue((Object)customScript);
    }

    public String _persistence_get_scriptParameters() {
        this._persistence_checkFetched("scriptParameters");
        return this.scriptParameters;
    }

    public void _persistence_set_scriptParameters(String string) {
        this._persistence_checkFetchedForSet("scriptParameters");
        this._persistence_propertyChange("scriptParameters", this.scriptParameters, string);
        this.scriptParameters = string;
    }

    public Integer _persistence_get_numberOfButtons() {
        this._persistence_checkFetched("numberOfButtons");
        return this.numberOfButtons;
    }

    public void _persistence_set_numberOfButtons(Integer n) {
        this._persistence_checkFetchedForSet("numberOfButtons");
        this._persistence_propertyChange("numberOfButtons", this.numberOfButtons, n);
        this.numberOfButtons = n;
    }

    public Availability _persistence_get_upperCaseLetters() {
        this._persistence_checkFetched("upperCaseLetters");
        return this.upperCaseLetters;
    }

    public void _persistence_set_upperCaseLetters(Availability availability) {
        this._persistence_checkFetchedForSet("upperCaseLetters");
        this._persistence_propertyChange("upperCaseLetters", this.upperCaseLetters, availability);
        this.upperCaseLetters = availability;
    }

    public PasswordInputMethod _persistence_get_inputMethod() {
        this._persistence_checkFetched("inputMethod");
        return this.inputMethod;
    }

    public void _persistence_set_inputMethod(PasswordInputMethod passwordInputMethod) {
        this._persistence_checkFetchedForSet("inputMethod");
        this._persistence_propertyChange("inputMethod", this.inputMethod, passwordInputMethod);
        this.inputMethod = passwordInputMethod;
    }

    public TimeInterval _persistence_get_blockTime() {
        this._persistence_checkFetched("blockTime");
        return this.blockTime;
    }

    public void _persistence_set_blockTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("blockTime");
        this._persistence_propertyChange("blockTime", this.blockTime, timeInterval);
        this.blockTime = timeInterval;
    }

    public Integer _persistence_get_numberOfRows() {
        this._persistence_checkFetched("numberOfRows");
        return this.numberOfRows;
    }

    public void _persistence_set_numberOfRows(Integer n) {
        this._persistence_checkFetchedForSet("numberOfRows");
        this._persistence_propertyChange("numberOfRows", this.numberOfRows, n);
        this.numberOfRows = n;
    }
}

