/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.cyclos.server.utils.PropertyComparator;
import org.cyclos.server.utils.SortSpecifier;
import org.cyclos.utils.CollectionHelper;

public final class SortHelper {
    public static <T> List<T> sortBy(Collection<T> collection, Path<?> path) {
        return SortHelper.sortBy(collection, SortSpecifier.asc(path));
    }

    @SafeVarargs
    public static <T> List<T> sortBy(Collection<T> collection, SortSpecifier ... sortSpecifierArray) {
        ArrayList<T> arrayList;
        if (collection instanceof List) {
            arrayList = (ArrayList<T>)collection;
        } else if (collection != null) {
            arrayList = new ArrayList<T>(collection);
        } else {
            return null;
        }
        ComparatorChain comparatorChain = new ComparatorChain();
        if (CollectionHelper.isNotEmpty((Object[])sortSpecifierArray)) {
            for (SortSpecifier sortSpecifier : sortSpecifierArray) {
                comparatorChain.addComparator((Comparator)new PropertyComparator(sortSpecifier.getProperty(), sortSpecifier.isAscending(), false));
            }
        } else {
            Comparator comparator = Comparator.naturalOrder();
            comparatorChain.addComparator(comparator);
        }
        Collections.sort(arrayList, comparatorChain);
        return arrayList;
    }
}

