/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.server.utils.ObjectParameterStorage;
import org.cyclos.utils.AbstractParameterStorage;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionException;

public class JacksonParameterStorage
extends AbstractParameterStorage
implements ObjectParameterStorage {
    protected ObjectNode node;
    protected final ObjectMapper objectMapper;
    private transient Map<String, Object> cache;

    public JacksonParameterStorage(ObjectMapper objectMapper, Object object) {
        this.objectMapper = objectMapper;
        this.setInput(object);
    }

    public Iterator<String> getNames() {
        return this.node.fieldNames();
    }

    @Override
    public Object getObject(String string) {
        Object object;
        String string2;
        JavaType javaType;
        Map<String, Object> map = this.cache();
        if (map.containsKey(string)) {
            return map.get(string);
        }
        List<String> list = this.getStringList(string);
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        int n = list.size();
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        if (n == 1) {
            javaType = typeFactory.constructType(Object.class);
            string2 = list.get(0);
        } else {
            javaType = typeFactory.constructFromCanonical(list.get(0));
            string2 = list.get(1);
        }
        try {
            object = this.objectMapper.readValue(string2, javaType);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Couldn't read object for name " + string + " from " + String.valueOf(list), exception);
        }
        map.put(string, object);
        return object;
    }

    public String getString(String string) {
        JsonNode jsonNode = this.node.get(string);
        return this.toString(jsonNode);
    }

    public List<String> getStringList(String string) {
        JsonNode jsonNode = this.node.get(string);
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        if (jsonNode.isArray()) {
            int n = jsonNode.size();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                String string2 = this.toString(jsonNode.get(i));
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        return Collections.singletonList(jsonNode.asText());
    }

    public Object propertyMissing(String string) {
        return this.getObject(string);
    }

    public void propertyMissing(String string, Object object) {
        this.setObject(string, object);
    }

    public void remove(String string) {
        this.node.remove(string);
        this.onChange();
    }

    @Override
    public void setObject(String string, Object object) {
        Object object2;
        Iterator iterator;
        if (object == null) {
            this.cache().remove(string);
            this.remove(string);
            return;
        }
        this.cache().put(string, object);
        if (object instanceof List && !(object instanceof ArrayList)) {
            object = new ArrayList((List)object);
        } else if (object instanceof Set && !(object instanceof LinkedHashSet)) {
            object = new LinkedHashSet((Set)object);
        } else if (object instanceof Map && !(object instanceof LinkedHashMap)) {
            object = new LinkedHashMap((Map)object);
        } else if (object instanceof Iterable || object.getClass().isArray()) {
            iterator = IteratorUtils.getIterator(object);
            object2 = new ArrayList();
            iterator.forEachRemaining(arg_0 -> object2.add(arg_0));
            object = object2;
        } else if (object instanceof CharSequence && !(object instanceof String)) {
            object = object.toString();
        }
        iterator = this.objectMapper.getTypeFactory().constructType(object.getClass());
        try {
            object2 = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException("Couldn't write object for name " + string + " with value " + String.valueOf(object), jsonProcessingException);
        }
        this.doSet(string, Arrays.asList(iterator.toCanonical(), object2));
    }

    public String toString() {
        return this.node.toString();
    }

    protected Map<String, Object> cache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        return this.cache;
    }

    protected void doSet(String string, List<String> list) {
        if (list == null) {
            this.remove(string);
        } else {
            ArrayNode arrayNode = this.node.arrayNode();
            for (String string2 : list) {
                if ((string2 = StringHelper.trimToNull((Object)string2)) == null) continue;
                arrayNode.add(string2);
            }
            if (arrayNode.size() == 1) {
                this.node.set(string, arrayNode.get(0));
            } else {
                this.node.set(string, (JsonNode)arrayNode);
            }
            this.onChange();
        }
    }

    protected void onChange() {
    }

    protected void setInput(Object object) {
        if (object instanceof ObjectNode) {
            this.node = (ObjectNode)object;
        } else if (object == null) {
            this.node = this.objectMapper.createObjectNode();
        } else {
            JsonNode jsonNode = null;
            try {
                if (object instanceof CharSequence) {
                    String string = StringHelper.trimToNull((Object)object);
                    jsonNode = string == null ? this.objectMapper.createObjectNode() : this.objectMapper.readTree(object.toString());
                } else if (object instanceof InputStream) {
                    jsonNode = this.objectMapper.readTree((InputStream)object);
                } else if (object instanceof Reader) {
                    jsonNode = this.objectMapper.readTree((Reader)object);
                } else if (object instanceof File) {
                    jsonNode = this.objectMapper.readTree((File)object);
                } else if (object instanceof byte[]) {
                    jsonNode = this.objectMapper.readTree((byte[])object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(jsonNode instanceof ObjectNode)) {
                throw new CoercionException(Objects.toString(object, "<null>"));
            }
            this.node = (ObjectNode)jsonNode;
        }
        this.cache = null;
    }

    private String toString(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        if (jsonNode.isArray()) {
            if (jsonNode.size() == 0) {
                return null;
            }
            return this.toString(jsonNode.get(0));
        }
        return jsonNode.asText();
    }
}

