/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.cyclos.utils.StringHelper;

public class CyclosVersion {
    private static String version;
    private static String commitId;
    private static int[] parts;
    private static String qualifier;

    public static String get() {
        if (version == null) {
            try (InputStream inputStream = CyclosVersion.class.getResourceAsStream("/cyclos-version");){
                version = StringHelper.trimToNull(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                String[] stringArray = version.split("\\-");
                String[] stringArray2 = stringArray[0].split("\\.");
                parts = new int[3];
                for (int i = 0; i < stringArray2.length; ++i) {
                    CyclosVersion.parts[i] = i >= stringArray2.length ? 0 : Integer.parseInt(stringArray2[i]);
                }
                qualifier = parts.length == 1 ? "RELEASE" : stringArray[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (version == null) {
                version = "4.0";
                parts = new int[]{4, 0, 0};
                qualifier = "UNKNOWN";
            }
        }
        return version;
    }

    public static String getCommitId() {
        if (commitId == null) {
            try (InputStream inputStream = CyclosVersion.class.getResourceAsStream("/cyclos-git-commit-id");){
                commitId = StringHelper.trimToNull(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return commitId == null ? "UNKNOWN" : commitId;
    }

    public static int getPart(int n) {
        CyclosVersion.get();
        return parts[n];
    }

    public static String getQualifier() {
        CyclosVersion.get();
        return qualifier;
    }

    public static boolean isCommitIdKnown() {
        CyclosVersion.getCommitId();
        return commitId != null;
    }
}

