/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.system;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.imports.ImportSearchContext;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileQuery;
import org.cyclos.model.system.imports.ImportedFileSearchData;
import org.cyclos.model.system.imports.ImportedFileVO;
import org.cyclos.model.system.imports.ImportedLineDTO;
import org.cyclos.model.system.imports.ImportedLineData;
import org.cyclos.model.system.imports.ImportedLineQuery;
import org.cyclos.model.system.imports.ImportedLineSearchData;
import org.cyclos.model.system.imports.ImportedLineVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.CRUDWithConfirmationPasswordService;
import org.cyclos.services.MaskValueInLog;
import org.cyclos.services.RawText;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface ImportService
extends CRUDWithConfirmationPasswordService<ImportedFileDTO, ImportedFileData, ImportedFileDataParams> {
    @Transaction(value=TransactionLevel.READ_WRITE)
    public boolean abort(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ImportedLineData getImportedLineData(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ImportedLineSearchData getLineSearchData(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ImportedFileSearchData getSearchData(@NotNull ImportSearchContext var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void markAsSkipped(@NotNull Long var1, @NotNull List<Long> var2, boolean var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void process(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void saveImportedLine(@NotNull ImportedLineDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<ImportedFileVO> search(@NotNull ImportedFileQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<ImportedLineVO> searchImportedLines(@NotNull ImportedLineQuery var1) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public Long upload(@NotNull ImportedFileDTO var1, @NotNull SerializableInputStream var2, @MaskValueInLog @RawText String var3) throws FrameworkException;
}

