/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.system;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.operations.CustomOperationDTO;
import org.cyclos.model.system.operations.CustomOperationData;
import org.cyclos.model.system.operations.CustomOperationResultVO;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationData;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.CRUDService;
import org.cyclos.utils.GwtIncompatible;

public interface CustomOperationService
extends CRUDService<CustomOperationDTO, CustomOperationData, Void> {
    @Transaction(value=TransactionLevel.READ_ONLY)
    public CredentialInputDTO getConfirmationPasswordInputForRun(RunCustomOperationDataParams var1);

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RunCustomOperationData getRunData(@NotNull RunCustomOperationDataParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForAd(BasicAdVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForContact(ContactVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForContactInfo(ContactInfoVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForRecord(RecordVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForSystem() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForTransfer(TransferVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RunnableCustomOperationVO> getRunnableOperationsForUser(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<CustomOperationResultVO> list() throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public RunCustomOperationResult run(@NotNull RunCustomOperationDTO var1) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public RunCustomOperationResult runExternalRedirectCallback(@NotNull RunExternalRedirectCallbackParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void saveOrder(@NotNull List<Long> var1) throws FrameworkException;
}

