/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryParams;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewData;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryData;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitDTO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountPermissionsData;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.AccountWithHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryData;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryQuery;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryVO;
import org.cyclos.model.banking.accounts.ArchivedTransferData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserAccountBalanceLimitData;
import org.cyclos.model.banking.accounts.UserAccountPaymentAmountLimitData;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceSearchData;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.Service;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface AccountService
extends Service {
    public static final int MAX_BALANCE_HISTORY_DATAPOINTS = 61;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportAccountBalanceLimitsOverview(@NotNull ExportFormatVO var1, @NotNull AccountBalanceLimitsOverviewQuery var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportAccountHistoriesOverview(@NotNull ExportFormatVO var1, @NotNull AccountHistoriesOverviewQuery var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportAccountHistory(@NotNull ExportFormatVO var1, @NotNull AccountHistoryQuery var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportAccountPaymentAmountLimitsOverview(@NotNull ExportFormatVO var1, @NotNull AccountPaymentAmountLimitsOverviewQuery var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportArchivedAccountHistory(@NotNull ExportFormatVO var1, @NotNull ArchivedAccountHistoryQuery var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportArchivedTransfer(@NotNull ExportFormatVO var1, @NotNull Long var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportUsersWithBalances(@NotNull ExportFormatVO var1, @NotNull UserWithBalanceQuery var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountBalanceHistoryVO getAccountBalanceHistory(@NotNull AccountBalanceHistoryParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountLimitsOverviewData getAccountBalanceLimitsOverviewData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountHistoriesOverviewData getAccountHistoriesOverviewData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountHistoriesOverviewStatusVO getAccountHistoriesOverviewStatus(@NotNull AccountHistoriesOverviewQuery var1);

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountHistoryData getAccountHistoryData(@NotNull AccountVO var1, RateVisibility var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountWithHistoryStatusVO getAccountHistoryStatus(@NotNull AccountHistoryQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountLimitsOverviewData getAccountPaymentAmountLimitsOverviewData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<AccountWithStatusVO> getAccountsSummary(@NotNull InternalAccountOwner var1, DateTime var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountStatusVO getAccountStatus(@NotNull AccountVO var1, DateTime var2, RateVisibility var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountWithStatusVO getAccountWithStatus(@NotNull AccountVO var1, DateTime var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ArchivedAccountHistoryData getArchivedAccountHistoryData(@NotNull AccountVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ArchivedTransferData getArchivedTransferData(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountPermissionsData getPermissions(@NotNull AccountVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserAccountBalanceLimitData getUserAccountBalanceLimitData(@NotNull AccountVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserAccountPaymentAmountLimitData getUserAccountPaymentAmountLimitData(@NotNull AccountVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<AccountBalanceLimitVO> getUserAccountsBalanceLimits(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<AccountPaymentAmountLimitVO> getUserAccountsPaymentAmountLimits(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UsersWithBalancesOverview getUsersWithBalancesOverview(@NotNull UserWithBalanceQuery var1) throws FrameworkException, QueryParseException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserWithBalanceSearchData getUserWithBalanceSearchData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public AccountWithCurrencyVO load(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<AccountBalanceLimitVO> searchAccountBalanceLimitsOverview(@NotNull AccountBalanceLimitsOverviewQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<AccountHistoryOverviewEntryVO> searchAccountHistoriesOverview(@NotNull AccountHistoriesOverviewQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<AccountHistoryEntryVO> searchAccountHistory(@NotNull AccountHistoryQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<AccountPaymentAmountLimitVO> searchAccountPaymentAmountLimitsOverview(@NotNull AccountPaymentAmountLimitsOverviewQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ArchivedAccountHistoryVO searchArchivedAccountHistory(@NotNull ArchivedAccountHistoryQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<UserWithBalanceVO> searchUsersWithBalances(@NotNull UserWithBalanceQuery var1) throws FrameworkException, QueryParseException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setBalanceLimit(@NotNull AccountBalanceLimitDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setPaymentAmountLimit(@NotNull AccountPaymentAmountLimitDTO var1) throws FrameworkException;
}

