/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.access;

import java.io.Serializable;
import org.cyclos.model.access.InvalidInvocationDataException;
import org.cyclos.model.access.RequestData;
import org.cyclos.services.Service;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public abstract class InvocationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String channel;
    private RequestData requestData;
    private Class<? extends Service> serviceInterface;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Object[] parameters;

    public final void checkConsistency() {
        if (!this.isConsistent()) {
            throw new InvalidInvocationDataException();
        }
    }

    public String getChannel() {
        return this.channel;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public Class<? extends Service> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public void setParameterTypes(Class<?>[] classArray) {
        this.parameterTypes = classArray;
    }

    public void setRequestData(RequestData requestData) {
        this.requestData = requestData;
    }

    public void setServiceInterface(Class<? extends Service> clazz) {
        this.serviceInterface = clazz;
    }

    protected boolean isConsistent() {
        return !ObjectHelper.anyIsNull((Object[])new Object[]{this.requestData, StringHelper.trimToNull((Object)this.channel), this.serviceInterface, StringHelper.trimToNull((Object)this.methodName)});
    }
}

