/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ParameterStorage;

public class ParameterStorageSerializer
extends StdSerializer<ParameterStorage> {
    private static final long serialVersionUID = 1L;

    protected ParameterStorageSerializer() {
        super(ParameterStorage.class);
    }

    public void serialize(ParameterStorage parameterStorage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartObject();
        for (String string : CollectionHelper.iterable(parameterStorage.getNames())) {
            List<String> list = parameterStorage.getStringList(string);
            if (CollectionHelper.isEmpty(list)) continue;
            if (list.size() == 1) {
                jsonGenerator.writeObjectField(string, (Object)list.get(0));
                continue;
            }
            jsonGenerator.writeObjectField(string, list);
        }
        jsonGenerator.writeEndObject();
    }
}

