/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Submodules;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.contentmanagement.translations.DataTranslationPropertyType;
import org.cyclos.model.contentmanagement.translations.IDataTranslationPropertyType;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.IEntityLogType;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.jackson.AccountOwnerDeserializer;
import org.cyclos.server.utils.jackson.BeanSerializer;
import org.cyclos.server.utils.jackson.BigDecimalSerializer;
import org.cyclos.server.utils.jackson.CustomAnnotationIntrospector;
import org.cyclos.server.utils.jackson.CustomObjectMapper;
import org.cyclos.server.utils.jackson.DateTimeDeserializer;
import org.cyclos.server.utils.jackson.EntityVODeserializer;
import org.cyclos.server.utils.jackson.ExternalAccountOwnerSerializer;
import org.cyclos.server.utils.jackson.ImportFieldDeserializer;
import org.cyclos.server.utils.jackson.ImportFieldSerializer;
import org.cyclos.server.utils.jackson.InternalAccountOwnerDeserializer;
import org.cyclos.server.utils.jackson.JsonValueContainer;
import org.cyclos.server.utils.jackson.JsonValueContainerSerializer;
import org.cyclos.server.utils.jackson.ParameterStorageDeserializer;
import org.cyclos.server.utils.jackson.ParameterStorageSerializer;
import org.cyclos.server.utils.jackson.PrefixedEnumDeSer;
import org.cyclos.server.utils.jackson.ProfileFieldDeserializer;
import org.cyclos.server.utils.jackson.SerializableInputStreamDeserializer;
import org.cyclos.server.utils.jackson.SerializableInputStreamSerializer;
import org.cyclos.server.utils.jackson.SystemAccountOwnerSerializer;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.PrefixedEnum;
import org.cyclos.utils.Submodule;
import org.springframework.stereotype.Component;

@Component(value="jacksonConfiguration")
public class JacksonConfiguration {
    private volatile ObjectMapper objectMapper;

    public void configure(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("Cyclos");
        this.configureModule(simpleModule);
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.addMixIn(Bean.class, BeanMixin.class);
        objectMapper.addMixIn(EntityDTO.class, EntityDTOMixin.class);
        objectMapper.addMixIn(ICredentialInputDTO.class, BeanMixin.class);
        objectMapper.addMixIn(Page.class, PageImplMixin.class);
        objectMapper.addMixIn(PageImpl.class, PageImplMixin.class);
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new CustomAnnotationIntrospector());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.enable(new MapperFeature[]{MapperFeature.USE_STD_BEAN_NAMING});
        SerializationConfig serializationConfig = objectMapper.getSerializationConfig().with(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN).without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).without(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setConfig(serializationConfig);
        DeserializationConfig deserializationConfig = objectMapper.getDeserializationConfig().with(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).with(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).without(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setConfig(deserializationConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            JacksonConfiguration jacksonConfiguration = this;
            synchronized (jacksonConfiguration) {
                if (this.objectMapper == null) {
                    this.objectMapper = this.createObjectMapper();
                }
            }
        }
        return this.objectMapper;
    }

    private void configureModule(SimpleModule simpleModule) {
        simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
                Class clazz = beanDescription.getBeanClass();
                if (EntityVO.class.isAssignableFrom(clazz)) {
                    return new EntityVODeserializer(jsonDeserializer, clazz);
                }
                return jsonDeserializer;
            }
        });
        simpleModule.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig serializationConfig, BeanDescription beanDescription, JsonSerializer<?> jsonSerializer) {
                Class clazz = beanDescription.getBeanClass();
                if (Bean.class.isAssignableFrom(clazz)) {
                    TypeSerializer typeSerializer;
                    try {
                        typeSerializer = JacksonConfiguration.this.objectMapper.getSerializerFactory().createTypeSerializer(serializationConfig, serializationConfig.constructType(clazz));
                    }
                    catch (JsonMappingException jsonMappingException) {
                        throw new IllegalStateException(jsonMappingException);
                    }
                    return new BeanSerializer(clazz, jsonSerializer, typeSerializer);
                }
                return jsonSerializer;
            }
        });
        SimpleDeserializers simpleDeserializers = new SimpleDeserializers();
        simpleDeserializers.addDeserializer(AccountOwner.class, (JsonDeserializer)new AccountOwnerDeserializer());
        simpleDeserializers.addDeserializer(ProfileField.class, (JsonDeserializer)new ProfileFieldDeserializer());
        simpleDeserializers.addDeserializer(InternalAccountOwner.class, (JsonDeserializer)new InternalAccountOwnerDeserializer());
        simpleDeserializers.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        simpleDeserializers.addDeserializer(SerializableInputStream.class, (JsonDeserializer)new SerializableInputStreamDeserializer());
        simpleDeserializers.addDeserializer(ParameterStorage.class, (JsonDeserializer)new ParameterStorageDeserializer());
        simpleDeserializers.addDeserializer(ImportField.class, (JsonDeserializer)new ImportFieldDeserializer());
        SimpleSerializers simpleSerializers = new SimpleSerializers();
        simpleSerializers.addSerializer(SystemAccountOwner.class, (JsonSerializer)new SystemAccountOwnerSerializer());
        simpleSerializers.addSerializer(ExternalAccountOwner.class, (JsonSerializer)new ExternalAccountOwnerSerializer());
        simpleSerializers.addSerializer(DateTime.class, (JsonSerializer)new ToStringSerializer(DateTime.class));
        simpleSerializers.addSerializer(SerializableInputStream.class, (JsonSerializer)new SerializableInputStreamSerializer());
        simpleSerializers.addSerializer(ParameterStorage.class, (JsonSerializer)new ParameterStorageSerializer());
        simpleSerializers.addSerializer(JsonValueContainer.class, (JsonSerializer)new JsonValueContainerSerializer());
        simpleSerializers.addSerializer(ImportField.class, (JsonSerializer)new ImportFieldSerializer());
        simpleSerializers.addSerializer(Long.class, (JsonSerializer)new ToStringSerializer(Long.class));
        simpleSerializers.addSerializer(Long.TYPE, (JsonSerializer)new ToStringSerializer(Long.TYPE));
        simpleSerializers.addSerializer(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer());
        this.registerPrefixedEnum(Submodules.getPrefixMapping(), Submodule.class, simpleDeserializers, simpleSerializers);
        this.registerPrefixedEnum(INotificationType.Mapping.get(), INotificationType.class, simpleDeserializers, simpleSerializers);
        this.registerPrefixedEnum(INotificationType.Mapping.get(), UserNotificationType.class, simpleDeserializers, simpleSerializers);
        this.registerPrefixedEnum(ImportField.Mapping.get(), ImportField.class, simpleDeserializers, simpleSerializers);
        this.registerPrefixedEnum(ScriptFunction.Mapping.get(), ScriptFunction.class, simpleDeserializers, simpleSerializers);
        simpleModule.addAbstractTypeMapping(Page.class, PageImpl.class);
        simpleModule.addAbstractTypeMapping(IDate.class, DateTime.class);
        simpleModule.addAbstractTypeMapping(ICredentialInputDTO.class, CredentialInputDTO.class);
        simpleModule.addAbstractTypeMapping(IEntityLogType.class, EntityLogType.class);
        simpleModule.addAbstractTypeMapping(IDataTranslationPropertyType.class, DataTranslationPropertyType.class);
        simpleModule.setDeserializers(simpleDeserializers);
        simpleModule.setSerializers(simpleSerializers);
    }

    private ObjectMapper createObjectMapper() {
        CustomObjectMapper customObjectMapper = new CustomObjectMapper();
        this.configure(customObjectMapper);
        return customObjectMapper;
    }

    private void registerPrefixedEnum(Map<String, Class<? extends PrefixedEnum>> map, Class<? extends PrefixedEnum> clazz, SimpleDeserializers simpleDeserializers, SimpleSerializers simpleSerializers) {
        PrefixedEnumDeSer prefixedEnumDeSer = new PrefixedEnumDeSer(map);
        simpleSerializers.addSerializer(clazz, prefixedEnumDeSer.createSerializer(clazz));
        simpleDeserializers.addDeserializer(clazz, prefixedEnumDeSer.createDeserializer(clazz));
        for (Class<? extends PrefixedEnum> clazz2 : prefixedEnumDeSer.getEnumClasses()) {
            simpleSerializers.addSerializer(clazz2, prefixedEnumDeSer.createSerializer(clazz2));
            simpleDeserializers.addDeserializer(clazz2, prefixedEnumDeSer.createDeserializer(clazz2));
        }
    }

    @JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="class", use=JsonTypeInfo.Id.CLASS)
    private static class BeanMixin {
        private BeanMixin() {
        }
    }

    private static class EntityDTOMixin {
        private EntityDTOMixin() {
        }

        @JsonIgnore
        public boolean isPersistent() {
            return false;
        }

        @JsonIgnore
        public boolean isTransient() {
            return false;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    private static class PageImplMixin<T>
    extends PageImpl<T> {
        private static final long serialVersionUID = 1L;
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
        private List<T> pageItems;

        private PageImplMixin() {
        }
    }
}

